/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.editorpart;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.Action;
import org.eclipse.ve.internal.cde.core.CDEPlugin;
import org.eclipse.ve.internal.java.codegen.editorpart.CodegenEditorPartMessages;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class ReloadAction
extends Action {
    public static final String RELOAD_ACTION_ID = "org.eclipse.ve.java.core.Reload";
    protected IReloadCallback reloadCallback;

    public ReloadAction(IReloadCallback reloadCallback) {
        super("", 2);
        this.setId(RELOAD_ACTION_ID);
        this.setEnabled(false);
        this.setChecked(false);
        this.setCorrectText();
        this.reloadCallback = reloadCallback;
    }

    public void run() {
        if (this.isChecked()) {
            this.setCorrectText();
            this.reloadCallback.pause();
        } else {
            this.setCorrectText();
            this.reloadCallback.reload();
        }
    }

    private void setCorrectText() {
        if (this.isChecked()) {
            this.setToolTipText(CodegenEditorPartMessages.getString("JVE_STATUS_MSG_RELOAD"));
            this.setText(this.getToolTipText());
            this.setHoverImageDescriptor(CDEPlugin.getImageDescriptorFromPlugin((Plugin)JavaVEPlugin.getPlugin(), (String)"icons/full/cview16/play.gif"));
        } else {
            this.setToolTipText(CodegenEditorPartMessages.getString("JVE_STATUS_MSG_PAUSE"));
            this.setText(this.getToolTipText());
            this.setHoverImageDescriptor(CDEPlugin.getImageDescriptorFromPlugin((Plugin)JavaVEPlugin.getPlugin(), (String)"icons/full/cview16/pause.gif"));
        }
    }

    public void parseError(boolean error) {
        if (error) {
            this.setToolTipText(CodegenEditorPartMessages.getString("JVE_STATUS_BAR_MSG_PARSE_ERROR_"));
            this.setText(CodegenEditorPartMessages.getString("JVE_STATUS_MSG_ERROR"));
            this.setHoverImageDescriptor(CDEPlugin.getImageDescriptorFromPlugin((Plugin)JavaVEPlugin.getPlugin(), (String)"icons/full/cview16/error_obj.gif"));
            this.setChecked(true);
        } else {
            this.setChecked(false);
            this.setCorrectText();
            this.setEnabled(false);
            this.setEnabled(true);
        }
    }

    public interface IReloadCallback {
        public void pause();

        public void reload();
    }
}

