/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ve.internal.cdm.Annotation;
import org.eclipse.ve.internal.cdm.CDMFactory;
import org.eclipse.ve.internal.cdm.CDMPackage;
import org.eclipse.ve.internal.cdm.VisualInfo;
import org.eclipse.ve.internal.cdm.impl.KeyedBooleanImpl;
import org.eclipse.ve.internal.java.codegen.core.IVEModelInstance;
import org.eclipse.ve.internal.java.codegen.java.IAnnotationDecoder;
import org.eclipse.ve.internal.java.codegen.java.ICodeGenAdapter;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.IBeanDeclModel;
import org.eclipse.ve.internal.java.codegen.util.CodeGenException;
import org.eclipse.ve.internal.java.codegen.util.CodeGenUtil;

public abstract class AbstractAnnotationDecoder
implements IAnnotationDecoder {
    IBeanDeclModel fModel = null;
    IVEModelInstance fCompositionModel = null;
    BeanPart fBeanpart = null;
    String fAnnotationKey = null;
    String fContent = null;

    public AbstractAnnotationDecoder(String key, BeanPart bean) {
        this.fAnnotationKey = key;
        this.fBeanpart = bean;
        if (bean != null) {
            this.fModel = bean.getModel();
            this.fCompositionModel = bean.getModel().getCompositionModel();
        }
    }

    public String getAnnotationKey() {
        return this.fAnnotationKey;
    }

    public void setBeanModel(IBeanDeclModel model) {
        this.fModel = model;
    }

    public IBeanDeclModel getBeanModel() {
        return this.fModel;
    }

    public void setCompositionModel(IVEModelInstance cm) {
        this.fCompositionModel = cm;
    }

    public IVEModelInstance getCompositionModel() {
        return this.fCompositionModel;
    }

    public void setBeanPart(BeanPart part) {
        this.fBeanpart = part;
    }

    public BeanPart getBeanPart() {
        return this.fBeanpart;
    }

    protected Object getAnnotationValue() throws CodeGenException {
        if (this.fAnnotationKey == null || this.fBeanpart == null) {
            throw new CodeGenException("not initialized");
        }
        Annotation a = CodeGenUtil.getAnnotation(this.fBeanpart.getEObject());
        if (a == null) {
            return null;
        }
        VisualInfo vi = a.getVisualInfo(this.fCompositionModel.getDiagram());
        if (vi == null) {
            return null;
        }
        return vi.getKeyedValues().get((Object)this.fAnnotationKey);
    }

    protected void setAnnotationValue(BasicEMap.Entry val) throws CodeGenException {
        if (this.fAnnotationKey == null || this.fBeanpart == null) {
            throw new CodeGenException("not initialized");
        }
        Annotation a = CodeGenUtil.getAnnotation(this.fBeanpart.getEObject());
        if (a == null) {
            throw new CodeGenException("not initialized");
        }
        VisualInfo vi = a.getVisualInfo(this.fCompositionModel.getDiagram());
        if (vi == null) {
            vi = CDMFactory.eINSTANCE.createVisualInfo();
            vi.setDiagram(this.fCompositionModel.getDiagram());
            a.getVisualInfos().add((Object)vi);
            ICodeGenAdapter adapter = (ICodeGenAdapter)EcoreUtil.getExistingAdapter((Notifier)a, (Object)ICodeGenAdapter.JVE_CODEGEN_ANNOTATION_ADAPTER);
            if (adapter == null) {
                throw new CodeGenException("No Adapter");
            }
            vi.eAdapters().add((Object)adapter);
        }
        val.setKey((Object)this.fAnnotationKey);
        if (vi.getKeyedValues().containsKey((Object)this.fAnnotationKey)) {
            vi.getKeyedValues().removeKey((Object)this.fAnnotationKey);
        }
        vi.getKeyedValues().add((Object)val);
    }

    public boolean isDeleted() throws CodeGenException {
        return this.getAnnotationValue() == null;
    }

    public void delete() {
    }

    protected void clearAnnotation() {
        VisualInfo vi;
        if (this.fAnnotationKey == null || this.fBeanpart == null) {
            return;
        }
        Annotation a = CodeGenUtil.getAnnotation(this.fBeanpart.getEObject());
        if (a == null) {
            return;
        }
        if (a.eContainer() != null) {
            ((EList)a.eContainer().eGet((EStructuralFeature)a.eContainmentFeature())).remove((Object)a);
        }
        if ((vi = a.getVisualInfo(this.fCompositionModel.getDiagram())) == null) {
            return;
        }
        ICodeGenAdapter adapter = (ICodeGenAdapter)EcoreUtil.getExistingAdapter((Notifier)a, (Object)ICodeGenAdapter.JVE_CODEGEN_ANNOTATION_ADAPTER);
        if (adapter != null) {
            vi.eAdapters().remove((Object)adapter);
        }
        vi.getKeyedValues().removeKey((Object)this.fAnnotationKey);
    }

    protected boolean noAnnotationInSource(boolean keepOnFreeForm) {
        boolean decoded = true;
        if (this.fAnnotationKey == null || this.fBeanpart == null) {
            return false;
        }
        Annotation a = CodeGenUtil.getAnnotation(this.fBeanpart.getEObject());
        if (a == null) {
            return false;
        }
        KeyedBooleanImpl c = (KeyedBooleanImpl)CDMFactory.eINSTANCE.create(CDMPackage.eINSTANCE.getKeyedBoolean());
        c.setValue((Object)new Boolean(!keepOnFreeForm));
        try {
            this.setAnnotationValue((BasicEMap.Entry)c);
        }
        catch (Exception exception) {
            decoded = false;
        }
        return decoded;
    }

    public void dispose() {
        this.clearAnnotation();
        this.fAnnotationKey = null;
        this.fModel = null;
    }

    public void deleteFromComposition() {
    }

    public String toString() {
        return String.valueOf(super.toString()) + ":" + this.fAnnotationKey + "\n\t" + this.fContent;
    }
}

