/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.util.logging.Level;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.ve.internal.java.codegen.core.IVEModelInstance;
import org.eclipse.ve.internal.java.codegen.java.IExpressionDecoder;
import org.eclipse.ve.internal.java.codegen.java.IExpressionDecoderHelper;
import org.eclipse.ve.internal.java.codegen.java.IJavaFeatureMapper;
import org.eclipse.ve.internal.java.codegen.java.SimpleAttributeDecoderHelper;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.CodeExpressionRef;
import org.eclipse.ve.internal.java.codegen.model.IBeanDeclModel;
import org.eclipse.ve.internal.java.codegen.util.CodeGenException;
import org.eclipse.ve.internal.java.codegen.util.CodeGenUtil;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public abstract class AbstractExpressionDecoder
implements IExpressionDecoder {
    protected Statement fExpr = null;
    protected CodeExpressionRef fExprRef = null;
    protected IJavaFeatureMapper fFeatureMapper = null;
    protected IExpressionDecoderHelper fhelper = null;
    protected IBeanDeclModel fBeanModel = null;
    protected IVEModelInstance fCompositonModel = null;
    protected BeanPart fbeanPart = null;
    protected IJavaFeatureMapper.VEexpressionPriority fPriority = null;

    public AbstractExpressionDecoder(CodeExpressionRef expr, IBeanDeclModel model, IVEModelInstance bldr, BeanPart part) {
        this.fExpr = expr.getExprStmt();
        this.fExprRef = expr;
        this.fExprRef.setDecoder(this);
        this.fBeanModel = model;
        this.fCompositonModel = bldr;
        this.fbeanPart = part;
    }

    public AbstractExpressionDecoder() {
    }

    protected abstract void initialFeatureMapper();

    protected abstract void initialFeatureMapper(EStructuralFeature var1);

    protected abstract void initialDecoderHelper();

    public IJavaFeatureMapper.VEexpressionPriority determinePriority() {
        if (!this.Initialize()) {
            return IJavaFeatureMapper.DEFAULTPriority;
        }
        if (this.fPriority == null || !this.isPriorityCacheable()) {
            this.fPriority = this.fhelper.getPriorityOfExpression();
        }
        return this.fPriority;
    }

    protected abstract boolean isPriorityCacheable();

    IExpressionDecoderHelper getHelper() {
        if (this.fhelper == null) {
            this.fPriority = null;
            this.initialDecoderHelper();
        }
        return this.fhelper;
    }

    protected synchronized boolean Initialize() {
        if (this.fFeatureMapper == null) {
            this.initialFeatureMapper();
        }
        this.fFeatureMapper.setRefObject((IJavaInstance)this.fbeanPart.getEObject());
        if (this.fFeatureMapper.getFeature(this.fExpr) == null && !this.fExprRef.isStateSet(4)) {
            CodeGenUtil.logParsingError(this.fExpr.toString(), this.fbeanPart.getInitMethod().getMethodName(), "Feature " + this.fFeatureMapper.getMethodName() + " not recognized.", false);
            return false;
        }
        if (this.getHelper() == null) {
            return false;
        }
        if (this.fExpr != null) {
            this.getHelper().setDecodingContent(this.fExpr);
        }
        return true;
    }

    protected boolean Initialize(EStructuralFeature sf) {
        if (this.fFeatureMapper == null) {
            this.initialFeatureMapper(sf);
        }
        this.initialDecoderHelper();
        return true;
    }

    public boolean decode() throws CodeGenException {
        boolean result;
        block8: {
            if (this.getExprRef().getExprStmt() != null && this.getExprRef().getExprStmt() != this.fExpr) {
                this.fExpr = this.getExprRef().getExprStmt();
            }
            if (this.fFeatureMapper != null && this.fFeatureMapper.getMethodName() == null) {
                this.fFeatureMapper = null;
            }
            if (this.fhelper != null && this.fhelper instanceof SimpleAttributeDecoderHelper) {
                this.fhelper = null;
            }
            if (!this.Initialize()) {
                return false;
            }
            result = false;
            try {
                result = this.fhelper.decode();
            }
            catch (Exception e) {
                if (!JavaVEPlugin.isLoggingLevel((Level)Level.FINEST)) break block8;
                JavaVEPlugin.log((Object)e.getMessage(), (Level)Level.FINEST);
            }
        }
        if (!result && !(this.fhelper instanceof SimpleAttributeDecoderHelper)) {
            this.fhelper = new SimpleAttributeDecoderHelper(this.fbeanPart, this.fExpr, this.fFeatureMapper, this);
            result = this.fhelper.decode();
            this.determinePriority();
        }
        if (result) {
            this.fExprRef.setState(1, true);
            this.fExprRef.setState(2, true);
            this.fhelper.adaptToCompositionModel(this);
            this.fbeanPart.getBadExpressions().remove(this);
        }
        return result;
    }

    public String generate(EStructuralFeature feature, Object[] args) throws CodeGenException {
        if (!this.Initialize(feature)) {
            return null;
        }
        if (this.isImplicit(args) && !this.fhelper.isGenerateOnImplicit()) {
            return null;
        }
        String result = null;
        try {
            result = this.fhelper.generate(args);
        }
        catch (CodeGenException codeGenException) {}
        if (this.fExprRef.isStateSet(8)) {
            this.fhelper.adaptToCompositionModel(this);
            return result;
        }
        if (result == null && !(this.fhelper instanceof SimpleAttributeDecoderHelper)) {
            this.fhelper = new SimpleAttributeDecoderHelper(this.fbeanPart, this.fExpr, this.fFeatureMapper, this);
            if (JavaVEPlugin.isLoggingLevel((Level)Level.FINE)) {
                JavaVEPlugin.log((Object)"generate():  *Defaulting* to a SimpleAttr. Helper", (Level)Level.FINE);
            }
            result = this.fhelper.generate(args);
        }
        if (result != null) {
            this.fExprRef.setState(1, true);
            this.fExprRef.setState(2, true);
            this.fhelper.adaptToCompositionModel(this);
        } else {
            this.fExprRef.dispose();
        }
        return result;
    }

    public void setExpression(CodeExpressionRef expr) {
        this.fExprRef = expr;
        this.fExpr = expr.getExprStmt();
        this.fExprRef.setDecoder(this);
        if (this.fhelper != null) {
            this.fhelper.setDecodingContent(this.fExpr);
        }
    }

    public void setBeanModel(IBeanDeclModel model) {
        this.fBeanModel = model;
    }

    public IBeanDeclModel getBeanModel() {
        return this.fBeanModel;
    }

    public void setCompositionModel(IVEModelInstance cm) {
        this.fCompositonModel = cm;
    }

    public IVEModelInstance getCompositionModel() {
        return this.fCompositonModel;
    }

    public void setBeanPart(BeanPart part) {
        this.fbeanPart = part;
    }

    protected void markExprAsDeleted() {
        this.fExprRef.clearState();
        this.fExprRef.setState(16, true);
    }

    public void deleteFromSrc() {
        this.fhelper.unadaptToCompositionModel();
        this.markExprAsDeleted();
        this.fExprRef.updateDocument(true);
    }

    public boolean isDeleted() {
        boolean result = false;
        result = this.getHelper().primIsDeleted();
        if (result) {
            this.fhelper.unadaptToCompositionModel();
        }
        return result;
    }

    public boolean isImplicit(Object[] args) {
        return false;
    }

    public String reflectExpression(String expSig) throws CodeGenException {
        if (!this.isDeleted()) {
            if (this.isImplicit(null)) {
                return null;
            }
            return this.fhelper.primRefreshFromComposition(expSig);
        }
        return null;
    }

    public void reflectMOFchange() {
        this.fExprRef.setState(2, false);
        if (!this.fExprRef.isAnyStateSet()) {
            return;
        }
        this.fExprRef.updateDocument(true);
    }

    public String getCurrentExpression() {
        if (!this.isDeleted()) {
            return this.fhelper.getCurrentExpression();
        }
        return null;
    }

    public EStructuralFeature getSF() {
        this.Initialize();
        EStructuralFeature sf = null;
        if (this.fFeatureMapper != null) {
            sf = this.fFeatureMapper.getFeature(null);
        }
        return sf;
    }

    public void setSF(EStructuralFeature sf) {
        this.Initialize();
        if (this.fFeatureMapper != null) {
            this.fFeatureMapper.setFeature(sf);
            this.Initialize();
        }
    }

    public BeanPart getBeanPart() {
        return this.fbeanPart;
    }

    public void dispose() {
        if (this.fhelper != null) {
            if (this.fBeanModel != null && !this.fBeanModel.isStateSet(16) && !this.isDeleted()) {
                this.deleteFromComposition();
            } else {
                this.fhelper.unadaptToCompositionModel();
            }
        }
        this.markExprAsDeleted();
        this.fFeatureMapper = null;
        this.fhelper = null;
    }

    public void deleteFromComposition() {
        this.fhelper.removeFromModel();
    }

    public Object[] getArgsHandles(Statement expr) throws CodeGenException {
        if (!this.Initialize()) {
            throw new CodeGenException("Can not Initialize");
        }
        return this.fhelper.getArgsHandles(expr);
    }

    public CodeExpressionRef getExprRef() {
        return this.fExprRef;
    }

    public String toString() {
        return String.valueOf(super.toString()) + ":" + this.fExprRef.toString();
    }

    public boolean isRelevantFeature(EStructuralFeature sf) {
        return this.fhelper.isRelevantFeature(sf);
    }

    public Object[] getAddedInstance() {
        if (this.fhelper != null) {
            return this.fhelper.getAddedInstance();
        }
        return new Object[0];
    }

    public boolean canReflectMOFChange() {
        if (this.getHelper() != null) {
            return this.getHelper().canRefreshFromComposition();
        }
        return true;
    }

    public void setStatement(Statement s) {
        this.fExpr = s;
        this.getHelper().setDecodingContent(s);
    }
}

