/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.LineComment;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringSavePreferences;
import org.eclipse.jdt.internal.ui.text.correction.LinkedNamesAssistProposal;
import org.eclipse.jdt.ui.refactoring.RenameSupport;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ve.internal.cde.core.CDEUtilities;
import org.eclipse.ve.internal.cdm.AnnotationEMF;
import org.eclipse.ve.internal.cdm.VisualInfo;
import org.eclipse.ve.internal.java.codegen.editorpart.JavaVisualEditorPart;
import org.eclipse.ve.internal.java.codegen.java.IAnnotationDecoder;
import org.eclipse.ve.internal.java.codegen.java.ICodeGenAdapter;
import org.eclipse.ve.internal.java.codegen.java.ICodeGenSourceRange;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.CodeMethodRef;
import org.eclipse.ve.internal.java.codegen.util.CodeGenException;
import org.eclipse.ve.internal.java.codegen.util.CodeGenUtil;
import org.eclipse.ve.internal.java.codegen.util.FreeFormAnnotationTemplate;
import org.eclipse.ve.internal.java.codegen.util.TypeResolver;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class AnnotationDecoderAdapter
implements ICodeGenAdapter {
    protected IAnnotationDecoder fDecoder = null;

    protected static boolean isValidMetaComment(LineComment comment, String source) {
        if (comment == null || source == null || source.length() < 1 || comment.getStartPosition() < 0 || comment.getStartPosition() + comment.getLength() > source.length()) {
            return false;
        }
        String commentSource = source.substring(comment.getStartPosition(), comment.getStartPosition() + comment.getLength());
        String annotationSource = FreeFormAnnotationTemplate.getCurrentAnnotation(commentSource);
        return annotationSource != null && annotationSource.indexOf("decl-index=") > -1;
    }

    public static boolean isDeclarationParseable(FieldDeclaration field) {
        try {
            CompilationUnit cuNode;
            Object val;
            FieldDeclaration node = field;
            while (node != null && !(node instanceof CompilationUnit)) {
                node = node.getParent();
            }
            String astSource = null;
            if (node instanceof CompilationUnit && (val = (cuNode = (CompilationUnit)node).getProperty("org.eclipse.ve.codegen.source")) instanceof String) {
                astSource = (String)val;
            }
            if (node != null) {
                cuNode = (CompilationUnit)node;
                int fieldLineNumber = cuNode.lineNumber(field.getType().getStartPosition());
                List comments = ((CompilationUnit)node).getCommentList();
                int cc = 0;
                while (cc < comments.size()) {
                    if (comments.get(cc) instanceof LineComment) {
                        LineComment lineComment = (LineComment)comments.get(cc);
                        int commentLine = cuNode.lineNumber(lineComment.getStartPosition());
                        if (commentLine == fieldLineNumber) {
                            return AnnotationDecoderAdapter.isValidMetaComment(lineComment, astSource);
                        }
                        if (commentLine == fieldLineNumber + 1 && AnnotationDecoderAdapter.isValidMetaComment(lineComment, astSource)) {
                            FieldDeclaration[] fields = ((TypeDeclaration)cuNode.types().get(0)).getFields();
                            int fc = 0;
                            while (fc < fields.length) {
                                if (!fields[fc].equals((Object)field) && cuNode.lineNumber(fields[fc].getType().getStartPosition()) == fieldLineNumber + 1) {
                                    return false;
                                }
                                ++fc;
                            }
                            return true;
                        }
                    }
                    ++cc;
                }
            }
        }
        catch (Throwable e) {
            JavaVEPlugin.log((Throwable)e, (Level)Level.FINE);
        }
        return false;
    }

    public static boolean isDeclarationParseable(VariableDeclarationStatement varDecl) {
        try {
            CompilationUnit cuNode;
            Object val;
            VariableDeclarationStatement node = varDecl;
            while (node != null && !(node instanceof CompilationUnit)) {
                node = node.getParent();
            }
            String astSource = null;
            if (node instanceof CompilationUnit && (val = (cuNode = (CompilationUnit)node).getProperty("org.eclipse.ve.codegen.source")) instanceof String) {
                astSource = (String)val;
            }
            if (node != null) {
                cuNode = (CompilationUnit)node;
                int fieldLineNumber = cuNode.lineNumber(varDecl.getStartPosition());
                List comments = ((CompilationUnit)node).getCommentList();
                int cc = 0;
                while (cc < comments.size()) {
                    if (comments.get(cc) instanceof LineComment) {
                        LineComment lineComment = (LineComment)comments.get(cc);
                        int commentLine = cuNode.lineNumber(lineComment.getStartPosition());
                        if (commentLine == fieldLineNumber) {
                            return AnnotationDecoderAdapter.isValidMetaComment(lineComment, astSource);
                        }
                        if (commentLine == fieldLineNumber + 1 && AnnotationDecoderAdapter.isValidMetaComment(lineComment, astSource)) {
                            if (varDecl.getParent() instanceof Block) {
                                Block block = (Block)varDecl.getParent();
                                int sc = 0;
                                while (sc < block.statements().size()) {
                                    Statement stmt = (Statement)block.statements().get(sc);
                                    if (!stmt.equals((Object)varDecl) && cuNode.lineNumber(stmt.getStartPosition()) == fieldLineNumber + 1) {
                                        return false;
                                    }
                                    ++sc;
                                }
                                return true;
                            }
                            return false;
                        }
                    }
                    ++cc;
                }
            }
        }
        catch (Throwable e) {
            JavaVEPlugin.log((Throwable)e, (Level)Level.FINE);
        }
        return false;
    }

    public static boolean isBeanVisible(String commentSource) {
        if (commentSource == null) {
            return true;
        }
        int index = commentSource.indexOf("@jve:", 0);
        if (index < 0) {
            return true;
        }
        return (index = commentSource.indexOf("visual-constraint", index)) > -1;
    }

    public AnnotationDecoderAdapter(IAnnotationDecoder decoder) {
        this.fDecoder = decoder;
    }

    public boolean isAdapterForType(Object type) {
        return ICodeGenAdapter.JVE_CODE_GEN_TYPE.equals(type) || ICodeGenAdapter.JVE_CODEGEN_ANNOTATION_ADAPTER.equals(type);
    }

    protected IField getField(ICompilationUnit cu, BeanPart bp) {
        IField field = null;
        if (bp.isInstanceVar() && cu.findPrimaryType() != null) {
            field = cu.findPrimaryType().getField(bp.getSimpleName());
        }
        return field;
    }

    protected IMethod getReturnMethod(ICompilationUnit cu, BeanPart bp) {
        IMethod returnMethod = null;
        if (bp.isInstanceVar() && bp.getReturnedMethod() != null && cu.findPrimaryType() != null) {
            try {
                TypeResolver resolver = bp.getModel().getResolver();
                IMethod[] methods = cu.findPrimaryType().getMethods();
                int mc = 0;
                while (mc < methods.length) {
                    TypeResolver.ResolvedType r;
                    String returnType = Signature.toString((String)methods[mc].getReturnType());
                    if (returnType != null && !returnType.equals("void") && bp.getReturnedMethod().getMethodName().equals(methods[mc].getElementName()) && (r = resolver.resolveType(returnType)) != null && bp.getType().equals(((TypeResolver.Resolved)r).getName())) {
                        returnMethod = methods[mc];
                        break;
                    }
                    ++mc;
                }
            }
            catch (IllegalArgumentException e) {
                JavaVEPlugin.log((Throwable)e, (Level)Level.FINE);
            }
            catch (JavaModelException e) {
                JavaVEPlugin.log((Throwable)e, (Level)Level.FINE);
            }
        }
        return returnMethod;
    }

    public static String getNameFromAST(Name name) {
        if (name.isQualifiedName()) {
            QualifiedName qn = (QualifiedName)name;
            return String.valueOf(AnnotationDecoderAdapter.getNameFromAST(qn.getQualifier())) + qn.getName().getIdentifier();
        }
        if (name.isSimpleName()) {
            return ((SimpleName)name).getIdentifier();
        }
        return new String();
    }

    public static String getTypeFromAST(Type type) {
        String t = new String();
        if (type.isArrayType()) {
            ArrayType at = (ArrayType)type;
            t = String.valueOf(AnnotationDecoderAdapter.getTypeFromAST(at.getComponentType())) + "[]";
        } else if (type.isPrimitiveType()) {
            t = ((PrimitiveType)type).getPrimitiveTypeCode().toString();
        } else if (type.isQualifiedType()) {
            QualifiedType qt = (QualifiedType)type;
            t = String.valueOf(AnnotationDecoderAdapter.getTypeFromAST(qt.getQualifier())) + qt.getName().getIdentifier();
        } else if (type.isSimpleType()) {
            t = AnnotationDecoderAdapter.getNameFromAST(((SimpleType)type).getName());
        }
        return t;
    }

    protected Object[] getInitMethodNameAndParamNames(ICompilationUnit cu, BeanPart bp) {
        String[] pTypes;
        String mName;
        block2: {
            CodeMethodRef initMethod;
            block3: {
                IMethod initMethodJDT;
                IType type;
                mName = null;
                pTypes = null;
                initMethod = bp.getInitMethod();
                if (initMethod == null || (type = CodeGenUtil.getMainType(cu)) == null) break block2;
                IMethod iMethod = initMethodJDT = initMethod.getMethodHandle() != null ? CodeGenUtil.getMethod(type, initMethod.getMethodHandle()) : null;
                if (initMethodJDT == null) break block3;
                mName = initMethodJDT.getElementName();
                String[] pTs = initMethodJDT.getParameterTypes();
                pTypes = new String[pTs.length];
                int pc = 0;
                while (pc < pTs.length) {
                    pTypes[pc] = Signature.toString((String)pTs[pc]);
                    ++pc;
                }
                break block2;
            }
            if (initMethod.getDeclMethod() == null) break block2;
            MethodDeclaration mDecl = initMethod.getDeclMethod();
            mName = mDecl.getName().getIdentifier();
            List ps = mDecl.parameters();
            pTypes = new String[ps.size()];
            int pc = 0;
            while (pc < mDecl.parameters().size()) {
                SingleVariableDeclaration param = (SingleVariableDeclaration)ps.get(pc);
                Type paramType = param.getType();
                pTypes[pc] = AnnotationDecoderAdapter.getTypeFromAST(paramType);
                ++pc;
            }
        }
        return new Object[]{mName, pTypes};
    }

    protected void performLocalRename(final ICompilationUnit cu, BeanPart nameChangedBP, final String newFieldName, IMethod bpRetMethod) {
        final String oldVarName = nameChangedBP.getSimpleName();
        Object[] ret = nameChangedBP.isInstanceVar() ? new Object[2] : this.getInitMethodNameAndParamNames(cu, nameChangedBP);
        final String methodName = (String)ret[0];
        final String[] paramNames = (String[])ret[1];
        ISourceViewer viewer = ((JavaVisualEditorPart)nameChangedBP.getModel().getDomain().getEditorPart()).getViewer();
        nameChangedBP.getModel().getDomain().getEditorPart().getEditorSite().getShell().getDisplay().asyncExec(new Runnable((ITextViewer)viewer, bpRetMethod){
            private final /* synthetic */ ITextViewer val$viewer;
            private final /* synthetic */ IMethod val$bpRetMethod;
            {
                this.val$viewer = iTextViewer;
                this.val$bpRetMethod = iMethod;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    block11: {
                        try {
                            AnnotationDecoderAdapter.this.fDecoder.getBeanModel().suspendSynchronizer();
                            ASTParser parser = ASTParser.newParser((int)2);
                            parser.setSource(cu);
                            CompilationUnit cuNode = (CompilationUnit)parser.createAST(null);
                            BPVarFinderVisitor visitor = new BPVarFinderVisitor(oldVarName, methodName, paramNames);
                            cuNode.accept((ASTVisitor)visitor);
                            if (visitor.getVariableName() == null) break block11;
                            LinkedNamesAssistProposal prop = new LinkedNamesAssistProposal(cu, visitor.getVariableName());
                            char triggerChar = newFieldName != null && newFieldName.length() > 0 ? newFieldName.charAt(newFieldName.length() - 1) : (char)'\u0000';
                            int triggerPosition = visitor.getVariableName().getStartPosition() + newFieldName.length() - 1;
                            prop.apply(this.val$viewer, triggerChar, 0, triggerPosition);
                            try {
                                cu.getBuffer().replace(visitor.getVariableName().getStartPosition(), visitor.getVariableName().getLength(), newFieldName.toCharArray());
                            }
                            catch (JavaModelException e) {
                                JavaVEPlugin.log((Throwable)e);
                            }
                            if (this.val$bpRetMethod == null) break block11;
                            String methodName2 = this.val$bpRetMethod.getElementName().toLowerCase(Locale.getDefault());
                            String varName = visitor.getVariableName().getIdentifier();
                            String varNameLower = varName.toLowerCase(Locale.getDefault());
                            if (!methodName2.startsWith("get") || methodName2.indexOf(varNameLower) != 3 || methodName2.length() != varNameLower.length() + 3) break block11;
                            String newMethodName = "get" + newFieldName.toUpperCase(Locale.getDefault()).charAt(0) + newFieldName.substring(1);
                            parser = ASTParser.newParser((int)2);
                            parser.setSource(cu);
                            cuNode = (CompilationUnit)parser.createAST(null);
                            String getterMethodName = this.val$bpRetMethod.getElementName();
                            String[] getterParamSigs = this.val$bpRetMethod.getParameterTypes();
                            String[] getterParamTypes = new String[getterParamSigs.length];
                            int pc = 0;
                            while (pc < getterParamSigs.length) {
                                getterParamTypes[pc] = Signature.toString((String)getterParamSigs[pc]);
                                ++pc;
                            }
                            MethodNameFinderVisitor mVisitor = new MethodNameFinderVisitor(getterMethodName, getterParamTypes);
                            cuNode.accept((ASTVisitor)mVisitor);
                            if (mVisitor.getMethodName() != null) {
                                prop = new LinkedNamesAssistProposal(cu, mVisitor.getMethodName());
                                triggerChar = newMethodName.charAt(newMethodName.length() - 1);
                                triggerPosition = mVisitor.getMethodName().getStartPosition() + newMethodName.length() - 1;
                                prop.apply(this.val$viewer, triggerChar, 0, triggerPosition);
                                try {
                                    cu.getBuffer().replace(mVisitor.getMethodName().getStartPosition(), mVisitor.getMethodName().getLength(), newMethodName);
                                }
                                catch (JavaModelException e) {
                                    JavaVEPlugin.log((Throwable)e);
                                }
                            }
                        }
                        catch (RuntimeException e) {
                            JavaVEPlugin.log((Throwable)e);
                        }
                    }
                    Object var16_21 = null;
                    AnnotationDecoderAdapter.this.fDecoder.getBeanModel().resumeSynchronizer();
                    return;
                }
                catch (Throwable throwable) {
                    Object var16_20 = null;
                    AnnotationDecoderAdapter.this.fDecoder.getBeanModel().resumeSynchronizer();
                    throw throwable;
                }
            }
        });
    }

    protected void performGlobalRename(BeanPart nameChangedBP, final IField bpField, final String newFieldName) {
        final IEditorSite es = nameChangedBP.getModel().getDomain().getEditorPart().getEditorSite();
        nameChangedBP.getModel().getDomain().getEditorPart().getEditorSite().getShell().getDisplay().asyncExec(new Runnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                boolean previousRefactoringSaveEditors = RefactoringSavePreferences.getSaveAllEditors();
                RefactoringSavePreferences.setSaveAllEditors((boolean)true);
                try {
                    try {
                        RenameSupport rename = RenameSupport.create((IField)bpField, (String)newFieldName, (int)113);
                        rename.perform(es.getShell(), (IRunnableContext)es.getWorkbenchWindow());
                    }
                    catch (CoreException e) {
                        JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (InvocationTargetException e) {
                        JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_6 = null;
                    RefactoringSavePreferences.setSaveAllEditors((boolean)previousRefactoringSaveEditors);
                    throw throwable;
                }
                {
                    Object var3_7 = null;
                }
                RefactoringSavePreferences.setSaveAllEditors((boolean)previousRefactoringSaveEditors);
            }
        });
    }

    protected void renameField(Notification msg) {
        Map.Entry entry = (Map.Entry)msg.getNewValue();
        String newFieldName = (String)entry.getValue();
        BeanPart nameChangedBP = this.fDecoder.getBeanPart();
        if (nameChangedBP == null) {
            EObject nameChangedbean = ((AnnotationEMF)msg.getNotifier()).getAnnotates();
            nameChangedBP = this.fDecoder.getBeanModel().getABean(nameChangedbean);
        }
        if (nameChangedBP != null) {
            ICompilationUnit cu = this.fDecoder.getBeanModel().getCompilationUnit();
            IField bpField = this.getField(cu, nameChangedBP);
            IMethod bpRetMethod = this.getReturnMethod(cu, nameChangedBP);
            boolean needLocalRename = true;
            try {
                boolean isFieldPrivate = bpField != null && Flags.isPrivate((int)bpField.getFlags());
                boolean isMethodPrivate = bpRetMethod != null && Flags.isPrivate((int)bpRetMethod.getFlags());
                needLocalRename = !(bpField != null && !isFieldPrivate || bpRetMethod != null && !isMethodPrivate);
            }
            catch (JavaModelException e1) {
                JavaVEPlugin.log((Throwable)e1, (Level)Level.FINE);
            }
            if (needLocalRename) {
                this.performLocalRename(cu, nameChangedBP, newFieldName, bpRetMethod);
            } else {
                this.performGlobalRename(nameChangedBP, bpField, newFieldName);
            }
        }
    }

    public void notifyChanged(Notification msg) {
        try {
            if (this.fDecoder.getBeanModel() == null || this.fDecoder.getBeanPart().getModel() == null || this.fDecoder.getBeanPart().getModel().isStateSet(4) || this.fDecoder.getBeanPart().getModel().isStateSet(8)) {
                return;
            }
            if (msg.getFeature() == null) {
                return;
            }
            String action = null;
            switch (msg.getEventType()) {
                case 1: {
                    if (!CDEUtilities.isUnset((Notification)msg)) {
                        action = msg.isTouch() ? "TOUCH" : "SET";
                        break;
                    }
                }
                case 2: {
                    action = "UNSET";
                    break;
                }
                case 3: {
                    action = "ADD";
                    break;
                }
                case 4: {
                    action = "REMOVE";
                    break;
                }
                case 8: {
                    action = "REMOVING_ADAPTER";
                }
            }
            if (JavaVEPlugin.isLoggingLevel((Level)Level.FINE)) {
                JavaVEPlugin.log((Object)(this + " action= " + action), (Level)Level.FINE);
                JavaVEPlugin.log((Object)("SourceRange =" + this.getJavaSourceRange()), (Level)Level.FINE);
            }
            switch (msg.getEventType()) {
                case 2: 
                case 4: {
                    if (msg.getOldValue() instanceof VisualInfo) {
                        ((Notifier)msg.getOldValue()).eAdapters().remove((Object)this);
                    }
                    this.fDecoder.reflectMOFchange();
                    break;
                }
                case 1: 
                case 3: {
                    Map.Entry entry;
                    if (msg.getOldValue() instanceof VisualInfo) {
                        ((Notifier)msg.getOldValue()).eAdapters().remove((Object)this);
                    }
                    if (msg.getNewValue() instanceof VisualInfo) {
                        ((EObject)msg.getNewValue()).eAdapters().add((Object)this);
                        return;
                    }
                    if (msg.getNewValue() instanceof Map.Entry && (entry = (Map.Entry)msg.getNewValue()).getKey() instanceof String && entry.getValue() instanceof String && ((String)entry.getKey()).equals("org.eclipse.ve.internal.cde.core.nameincomposition") && msg.getNotifier() instanceof AnnotationEMF) {
                        this.renameField(msg);
                    }
                }
                case 7: {
                    if (msg.getNewValue() instanceof BasicEMap.Entry && !((BasicEMap.Entry)msg.getNewValue()).getKey().equals("org.eclipse.ve.internal.cdm.model.visualconstraintkey")) {
                        return;
                    }
                    this.fDecoder.reflectMOFchange();
                }
            }
        }
        catch (Throwable t) {
            JavaVEPlugin.log((Throwable)t, (Level)Level.WARNING);
        }
    }

    public IAnnotationDecoder getDecoder() {
        return this.fDecoder;
    }

    public String toString() {
        return "\tAnnotationDecoderAdapter:" + this.fDecoder;
    }

    public ICodeGenSourceRange getJavaSourceRange() throws CodeGenException {
        return null;
    }

    public ICodeGenSourceRange getBDMSourceRange() throws CodeGenException {
        return null;
    }

    public ICodeGenSourceRange getHighlightSourceRange() throws CodeGenException {
        return this.getJavaSourceRange();
    }

    public Notifier getTarget() {
        return null;
    }

    public void setTarget(Notifier newTarget) {
    }

    static class BPVarFinderVisitor
    extends ASTVisitor {
        String varName = null;
        String methodName = null;
        String[] methodParamTypes = null;
        boolean isInValidMethod = false;
        boolean isInValidField = false;
        boolean isSimpleType = false;
        SimpleName variableName = null;

        public BPVarFinderVisitor(String varName, String methodName, String[] methodParamTypes) {
            this.varName = varName;
            this.methodName = methodName;
            this.methodParamTypes = methodParamTypes;
        }

        public boolean visit(FieldDeclaration node) {
            this.isInValidField = this.methodName == null || this.methodName.length() < 1;
            this.isSimpleType = node.getType().isSimpleType();
            return super.visit(node);
        }

        public void endVisit(FieldDeclaration node) {
            this.isInValidField = false;
            super.endVisit(node);
        }

        public boolean visit(MethodDeclaration node) {
            List params;
            if (this.methodName != null && this.methodName.length() > 0 && this.methodParamTypes != null && this.methodName.equals(node.getName().getIdentifier()) && (params = node.parameters()).size() == this.methodParamTypes.length) {
                boolean allParamsEqual = true;
                int pc = 0;
                while (pc < params.size()) {
                    SingleVariableDeclaration svd = (SingleVariableDeclaration)params.get(pc);
                    String type = AnnotationDecoderAdapter.getTypeFromAST(svd.getType());
                    if (!type.equals(this.methodParamTypes[pc])) {
                        allParamsEqual = false;
                        break;
                    }
                    ++pc;
                }
                this.isInValidMethod = allParamsEqual;
            }
            return super.visit(node);
        }

        public void endVisit(MethodDeclaration node) {
            this.isInValidMethod = false;
            super.endVisit(node);
        }

        public boolean visit(VariableDeclarationFragment node) {
            if (this.isSimpleType && (this.isInValidMethod || this.isInValidField) && this.variableName == null && node.getName().getIdentifier().equals(this.varName)) {
                this.variableName = node.getName();
            }
            return super.visit(node);
        }

        public boolean visit(VariableDeclarationStatement node) {
            if (this.isInValidMethod) {
                this.isSimpleType = node.getType().isSimpleType();
            }
            return super.visit(node);
        }

        public void endVisit(VariableDeclarationStatement node) {
            this.isSimpleType = false;
            super.endVisit(node);
        }

        public SimpleName getVariableName() {
            return this.variableName;
        }
    }

    static class MethodNameFinderVisitor
    extends ASTVisitor {
        SimpleName methodNameAST = null;
        String methodName = null;
        String[] methodParamTypes = null;

        public MethodNameFinderVisitor(String methodName, String[] methodParamTypes) {
            this.methodName = methodName;
            this.methodParamTypes = methodParamTypes;
        }

        public boolean visit(MethodDeclaration node) {
            List params;
            if (this.methodName != null && this.methodName.length() > 0 && this.methodParamTypes != null && this.methodName.equals(node.getName().getIdentifier()) && (params = node.parameters()).size() == this.methodParamTypes.length) {
                boolean allParamsEqual = true;
                int pc = 0;
                while (pc < params.size()) {
                    SingleVariableDeclaration svd = (SingleVariableDeclaration)params.get(pc);
                    String type = AnnotationDecoderAdapter.getTypeFromAST(svd.getType());
                    if (!type.equals(this.methodParamTypes[pc])) {
                        allParamsEqual = false;
                        break;
                    }
                    ++pc;
                }
                if (allParamsEqual) {
                    this.methodNameAST = node.getName();
                }
            }
            return super.visit(node);
        }

        public SimpleName getMethodName() {
            return this.methodNameAST;
        }
    }
}

