/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.internal.instantiation.InitStringAllocation;
import org.eclipse.jem.internal.instantiation.JavaAllocation;
import org.eclipse.jem.internal.instantiation.PTInstanceReference;
import org.eclipse.jem.internal.instantiation.ParseTreeAllocation;
import org.eclipse.jem.internal.instantiation.ParseVisitor;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.impl.NaiveExpressionFlattener;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.IBeanDeclModel;

public class CodeGenExpFlattener
extends NaiveExpressionFlattener {
    IBeanDeclModel fmodel;
    List fimportList;

    public CodeGenExpFlattener(IBeanDeclModel model) {
        this(model, null);
    }

    public CodeGenExpFlattener(IBeanDeclModel model, List importList) {
        this.fmodel = model;
        this.fimportList = importList;
        if (this.fimportList != null) {
            this.fimportList.clear();
        }
    }

    public boolean visit(PTInstanceReference node) {
        IJavaObjectInstance obj = node.getObject();
        BeanPart bp = this.fmodel.getABean((EObject)obj);
        if (bp != null) {
            this.getStringBuffer().append(bp.getSimpleName());
        } else if (obj.isSetAllocation()) {
            JavaAllocation alloc = obj.getAllocation();
            if (alloc instanceof InitStringAllocation) {
                this.getStringBuffer().append(((InitStringAllocation)alloc).getInitString());
            } else if (alloc instanceof ParseTreeAllocation) {
                ((ParseTreeAllocation)alloc).getExpression().accept((ParseVisitor)this);
            }
        } else {
            this.getStringBuffer().append("new ");
            this.getStringBuffer().append(this.handleQualifiedName(((JavaHelpers)obj).getJavaName()));
            this.getStringBuffer().append("()");
        }
        return false;
    }

    protected String handleQualifiedName(String qName) {
        if (this.fimportList != null) {
            JavaHelpers clazz = JavaRefFactory.eINSTANCE.reflectType(qName, (EObject)this.fmodel.getCompositionModel().getModelRoot());
            if (!this.fimportList.contains(clazz.getJavaName())) {
                this.fimportList.add(clazz.getJavaName());
            }
            return clazz.getName();
        }
        return qName;
    }
}

