/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.util.List;
import java.util.logging.Level;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jem.internal.beaninfo.BeanEvent;
import org.eclipse.jem.internal.beaninfo.EventSetDecorator;
import org.eclipse.ve.internal.java.codegen.java.EventInvocationHelper;
import org.eclipse.ve.internal.java.codegen.java.SourceVisitor;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.CodeEventRef;
import org.eclipse.ve.internal.java.codegen.model.CodeMethodRef;
import org.eclipse.ve.internal.java.codegen.model.IBeanDeclModel;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.jcm.AbstractEventInvocation;
import org.eclipse.ve.internal.jcm.EventInvocation;
import org.eclipse.ve.internal.jcm.JCMFactory;
import org.eclipse.ve.internal.jcm.PropertyChangeEventInvocation;

public class EventExpressionVisitor
extends SourceVisitor {
    CodeMethodRef fMethod;
    CodeEventRef fExpression;
    BeanPart fBean;
    CompilationUnit fastDom;
    List fEventSigs;

    EventExpressionVisitor(BeanPart b, Statement stmt, IBeanDeclModel model, List eSigs, CompilationUnit dom) {
        super((ASTNode)stmt, model, null);
        this.fMethod = b.getInitMethod();
        this.fBean = b;
        this.fExpression = new CodeEventRef(stmt, this.fMethod, dom);
        this.fastDom = dom;
        this.fEventSigs = eSigs;
    }

    EventExpressionVisitor(BeanPart b, CodeMethodRef mref, Statement stmt, IBeanDeclModel model, List eSigs, CompilationUnit dom) {
        super((ASTNode)stmt, model, null);
        this.fMethod = mref;
        this.fBean = b;
        this.fExpression = new CodeEventRef(stmt, this.fMethod, dom);
        this.fastDom = dom;
        this.fEventSigs = eSigs;
    }

    protected void processAMessageSend() {
        PropertyChangeEventInvocation ei;
        MethodInvocation stmt = (MethodInvocation)((ExpressionStatement)this.fExpression.getExprStmt()).getExpression();
        if (stmt == null) {
            return;
        }
        String selector = stmt.getName().getIdentifier();
        if (selector.equals("addPropertyChangeListener")) {
            ei = JCMFactory.eINSTANCE.createPropertyChangeEventInvocation();
        } else {
            EventSetDecorator ed = null;
            int i = 0;
            while (i < this.fEventSigs.size()) {
                try {
                    if (((EventSetDecorator)this.fEventSigs.get(i)).getAddListenerMethod().getName().equals(selector)) {
                        ed = (EventSetDecorator)this.fEventSigs.get(i);
                        break;
                    }
                }
                catch (NullPointerException nullPointerException) {}
                ++i;
            }
            if (ed == null) {
                return;
            }
            ei = EventInvocationHelper.getNewEventInvocation(this.fModel.getCompositionModel());
            BeanEvent be = (BeanEvent)ed.getEModelElement();
            ((EventInvocation)ei).setEvent(be);
        }
        this.fExpression.setBean(this.fBean);
        this.fExpression.setEventInvocation((AbstractEventInvocation)ei);
        this.fMethod.setModel(this.fModel);
    }

    public void visit() {
        this.getProgressMonitor().subTask(String.valueOf(this.fMethod.getTypeRef().getSimpleName()) + " : " + this.fMethod.getMethodName() + "()" + " : " + this.fExpression.getCodeContent());
        if (this.fExpression.getExprStmt() instanceof ExpressionStatement && ((ExpressionStatement)this.fExpression.getExprStmt()).getExpression() instanceof MethodInvocation) {
            this.processAMessageSend();
        } else if (JavaVEPlugin.isLoggingLevel((Level)Level.FINE)) {
            JavaVEPlugin.log((Object)("\t[Event] ExpressionVisitor: *** did not process Expression:" + this.fExpression), (Level)Level.FINE);
        }
    }

    public String toString() {
        return "EventExpression(" + this.fVisitedNode + ")";
    }
}

