/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.ve.internal.java.codegen.java.BeanDecoderAdapter;
import org.eclipse.ve.internal.java.codegen.java.ExpressionDecoderAdapter;
import org.eclipse.ve.internal.java.codegen.java.ICodeGenAdapter;
import org.eclipse.ve.internal.java.codegen.java.IExpressionDecoder;
import org.eclipse.ve.internal.java.codegen.java.IExpressionDecoderHelper;
import org.eclipse.ve.internal.java.codegen.java.IJavaFeatureMapper;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.util.CodeGenException;
import org.eclipse.ve.internal.java.codegen.util.ExpressionTemplate;
import org.eclipse.ve.internal.jcm.MemberContainer;

public abstract class ExpressionDecoderHelper
implements IExpressionDecoderHelper {
    protected IExpressionDecoder fOwner = null;
    protected IJavaFeatureMapper fFmapper = null;
    protected Statement fExpr;
    protected String fExprSig;
    protected BeanPart fbeanPart = null;
    protected ExpressionDecoderAdapter fexpAdapter = null;

    public ExpressionDecoderHelper(BeanPart bean, Statement exp, IJavaFeatureMapper fm, IExpressionDecoder owner) {
        this.fOwner = owner;
        this.fbeanPart = bean;
        this.fFmapper = fm;
        this.fExpr = exp;
    }

    public abstract boolean decode() throws CodeGenException;

    public abstract String generate(Object[] var1) throws CodeGenException;

    public abstract void removeFromModel();

    public abstract String primRefreshFromComposition(String var1) throws CodeGenException;

    public abstract boolean primIsDeleted();

    public String getCurrentExpression() {
        return this.fExprSig;
    }

    public boolean isGenerateOnImplicit() {
        return false;
    }

    public void adaptToCompositionModel(IExpressionDecoder decoder) {
        ExpressionDecoderAdapter adapter;
        this.unadaptToCompositionModel();
        BeanDecoderAdapter a = (BeanDecoderAdapter)EcoreUtil.getExistingAdapter((Notifier)this.fbeanPart.getEObject(), (Object)ICodeGenAdapter.JVE_CODEGEN_BEAN_PART_ADAPTER);
        this.fexpAdapter = adapter = new ExpressionDecoderAdapter(decoder);
        a.addSettingAdapter(this.fFmapper.getFeature(this.fExpr), adapter);
    }

    public void unadaptToCompositionModel() {
        BeanDecoderAdapter a = (BeanDecoderAdapter)EcoreUtil.getExistingAdapter((Notifier)this.fbeanPart.getEObject(), (Object)ICodeGenAdapter.JVE_CODEGEN_BEAN_PART_ADAPTER);
        a.removeSettingAdapter(this.fFmapper.getFeature(this.fExpr), this.fexpAdapter);
        this.fexpAdapter = null;
    }

    protected ExpressionTemplate getExpressionTemplate(String[] args) throws CodeGenException {
        String mtd = this.fFmapper.getDecorator().getWriteMethod().getName();
        String sel = this.fbeanPart.getSimpleName();
        ExpressionTemplate exp = new ExpressionTemplate(sel, mtd, args, null, 0);
        exp.setLineSeperator(this.fbeanPart.getModel().getLineSeperator());
        return exp;
    }

    protected int getSFPriority() {
        return 10000;
    }

    protected int getIndexPriority() {
        return 0;
    }

    public IJavaFeatureMapper.VEexpressionPriority getPriorityOfExpression() {
        IJavaFeatureMapper.VEexpressionPriority pri = new IJavaFeatureMapper.VEexpressionPriority(this.getSFPriority(), this.getIndexPriority());
        return pri;
    }

    public void setDecodingContent(Statement exp) {
        this.fExpr = exp;
    }

    public abstract Object[] getArgsHandles(Statement var1);

    public String toString() {
        return String.valueOf(super.toString()) + ":\n\t" + this.fExpr != null ? this.fExpr.toString() : "?";
    }

    public boolean isRelevantFeature(EStructuralFeature sf) {
        if (sf == null || this.fFmapper == null) {
            return false;
        }
        EStructuralFeature hSF = this.fFmapper.getFeature(null);
        if (hSF == null) {
            return false;
        }
        return hSF.equals(sf);
    }

    public Object[] getAddedInstance() {
        return new Object[0];
    }

    protected void cleanProperty(EObject obj) {
        if (obj == null) {
            return;
        }
        if (obj.eContainer() != null && obj.eContainer() instanceof MemberContainer) {
            ((MemberContainer)obj.eContainer()).getProperties().remove((Object)obj);
        }
    }

    public boolean canRefreshFromComposition() {
        return true;
    }

    protected Expression getExpression(Statement stmt) {
        if (stmt == null) {
            return null;
        }
        if (stmt instanceof ExpressionStatement) {
            return ((ExpressionStatement)stmt).getExpression();
        }
        if (stmt instanceof VariableDeclarationStatement) {
            VariableDeclaration vd = (VariableDeclaration)((VariableDeclarationStatement)stmt).fragments().get(0);
            return vd.getInitializer();
        }
        return null;
    }

    protected Expression getExpression() {
        return this.getExpression(this.fExpr);
    }
}

