/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jem.internal.beaninfo.PropertyDecorator;
import org.eclipse.jem.internal.instantiation.InstantiationFactory;
import org.eclipse.jem.internal.instantiation.JavaAllocation;
import org.eclipse.jem.internal.instantiation.ParseTreeAllocation;
import org.eclipse.jem.internal.instantiation.base.IJavaDataTypeInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.ve.internal.java.codegen.java.AbstractFeatureMapper;
import org.eclipse.ve.internal.java.codegen.java.ConstructorDecoderHelper;
import org.eclipse.ve.internal.java.codegen.java.ExpressionDecoderAdapter;
import org.eclipse.ve.internal.java.codegen.java.ExpressionDecoderHelper;
import org.eclipse.ve.internal.java.codegen.java.ICodeGenAdapter;
import org.eclipse.ve.internal.java.codegen.java.IExpressionDecoder;
import org.eclipse.ve.internal.java.codegen.java.IJavaFeatureMapper;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.CodeMethodRef;
import org.eclipse.ve.internal.java.codegen.util.CodeGenException;
import org.eclipse.ve.internal.java.codegen.util.CodeGenUtil;
import org.eclipse.ve.internal.java.codegen.util.ExpressionTemplate;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class SimpleAttributeDecoderHelper
extends ExpressionDecoderHelper {
    public static final String NULL_STRING = "null";
    String fInitString = null;
    String fUnresolveInitString = null;
    IJavaInstance fPropInstance = null;

    public SimpleAttributeDecoderHelper(BeanPart bean, Statement exp, IJavaFeatureMapper fm, IExpressionDecoder owner) {
        super(bean, exp, fm, owner);
    }

    public int getSFPriority() {
        if (this.fFmapper != null) {
            String methodName = null;
            if (this.fFmapper.getDecorator() != null) {
                methodName = this.fFmapper.getDecorator().getWriteMethod().getName();
            }
            if (methodName == null) {
                methodName = AbstractFeatureMapper.getWriteMethod(this.fExpr);
            }
            if (methodName != null) {
                return this.fFmapper.getFeaturePriority(methodName);
            }
        }
        return super.getSFPriority();
    }

    protected boolean isMethodType(String writeMethodName) {
        String method = null;
        if (this.fFmapper != null && this.fFmapper.getDecorator() != null) {
            method = this.fFmapper.getDecorator().getWriteMethod().getName();
        }
        if (method == null) {
            method = AbstractFeatureMapper.getWriteMethod(this.fExpr);
        }
        return method != null && method.equals(writeMethodName);
    }

    protected IJavaInstance createPropertyInstance(Expression arg, EClassifier argType) {
        if (arg instanceof NullLiteral) {
            return null;
        }
        CodeMethodRef expOfMethod = this.fOwner != null && this.fOwner.getExprRef() != null ? this.fOwner.getExprRef().getMethod() : null;
        ParseTreeAllocation alloc = InstantiationFactory.eINSTANCE.createParseTreeAllocation(ConstructorDecoderHelper.getParsedTree(arg, expOfMethod, this.fbeanPart.getModel(), null));
        EFactory fact = argType.getEPackage().getEFactoryInstance();
        IJavaInstance result = (IJavaInstance)fact.create((EClass)argType);
        result.setAllocation((JavaAllocation)alloc);
        return result;
    }

    protected boolean addFeature() throws CodeGenException {
        Object currentValue;
        String currentInitString;
        EStructuralFeature sf;
        if (this.fbeanPart.getEObject() == null) {
            throw new CodeGenException("null EObject:" + this.fExpr);
        }
        EClassifier argType = null;
        String newInitString = null;
        IJavaInstance newPropInstance = null;
        if (this.fFmapper.isFieldFeature()) {
            sf = this.fFmapper.getFeature(this.fExpr);
            if (sf == null) {
                throw new CodeGenException("Invalid SF");
            }
            argType = sf.getEType();
            newPropInstance = this.createPropertyInstance(((Assignment)this.getExpression()).getRightHandSide(), argType);
        } else {
            PropertyDecorator pd = this.fFmapper.getDecorator();
            if (pd == null) {
                throw new CodeGenException("Invalid PropertyDecorator");
            }
            argType = pd.getPropertyType();
            List argExpr = ((MethodInvocation)this.getExpression()).arguments();
            if (argExpr.size() != 1) {
                throw new CodeGenException("Expression has more than one argument");
            }
            newPropInstance = this.createPropertyInstance((Expression)argExpr.get(0), argType);
        }
        newInitString = newPropInstance != null ? CodeGenUtil.getInitString(newPropInstance, this.fOwner.getBeanModel(), null) : NULL_STRING;
        sf = this.fFmapper.getFeature(this.fExpr);
        EObject target = this.fbeanPart.getEObject();
        boolean currentValueSet = target.eIsSet(sf);
        if (currentValueSet && (currentInitString = (currentValue = target.eGet(sf)) != null ? CodeGenUtil.getInitString((IJavaInstance)currentValue, this.fOwner.getBeanModel(), null) : NULL_STRING).equals(newInitString)) {
            return true;
        }
        this.fPropInstance = newPropInstance;
        this.fInitString = newInitString;
        CodeGenUtil.propertyCleanup(target, sf);
        if (this.fPropInstance == null) {
            target.eSet(sf, null);
        } else {
            this.fbeanPart.getInitMethod().getCompMethod().getProperties().add((Object)this.fPropInstance);
            target.eSet(sf, (Object)this.fPropInstance);
        }
        return true;
    }

    protected String primGetInitString() {
        Object currentVal = this.fbeanPart.getEObject().eGet(this.fFmapper.getFeature(this.fExpr));
        if (currentVal == null || currentVal instanceof IJavaInstance) {
            this.fPropInstance = (IJavaInstance)currentVal;
            if (currentVal != null) {
                if (currentVal instanceof IJavaObjectInstance) {
                    return CodeGenUtil.getInitString((IJavaInstance)((IJavaObjectInstance)currentVal), this.fbeanPart.getModel(), this.fOwner.getExprRef().getReqImports());
                }
                if (currentVal instanceof IJavaDataTypeInstance) {
                    return CodeGenUtil.getInitString((IJavaInstance)((IJavaDataTypeInstance)currentVal), this.fbeanPart.getModel(), this.fOwner.getExprRef().getReqImports());
                }
            } else {
                EObject eobj = this.fbeanPart.getEObject();
                Iterator itr = ((JavaClass)eobj.eClass()).getAllProperties().iterator();
                while (itr.hasNext()) {
                    EStructuralFeature sf = (EStructuralFeature)itr.next();
                    if (!eobj.eIsSet(sf) || !sf.equals(this.fFmapper.getFeature(null))) continue;
                    return NULL_STRING;
                }
            }
        }
        return null;
    }

    public boolean primIsDeleted() {
        return this.primGetInitString() == null;
    }

    public boolean canRefreshFromComposition() {
        EObject obj = (EObject)this.fbeanPart.getEObject().eGet(this.fFmapper.getFeature(this.fExpr));
        if (obj != null && this.fOwner != null && this.fOwner.getExprRef() != null && this.fOwner.getExprRef().getBean() != null && this.fOwner.getExprRef().getBean().getModel() != null && this.fOwner.getExprRef().getBean().getModel().getABean(obj) != null) {
            return false;
        }
        return super.canRefreshFromComposition();
    }

    public String primRefreshFromComposition(String expSig) throws CodeGenException {
        if (this.fExprSig == null) {
            this.fExprSig = expSig;
        }
        int[] positions = CodeGenUtil.indexOfIgnoringSpace(this.fExprSig, "(" + this.fInitString + ")");
        if (this.fUnresolveInitString != null && (positions[0] < 0 || positions[1] < 0)) {
            positions = CodeGenUtil.indexOfIgnoringSpace(this.fExprSig, "(" + this.fUnresolveInitString + ")");
            if (positions[0] < 0 || positions[1] < 0) {
                if (JavaVEPlugin.isLoggingLevel((Level)Level.FINE)) {
                    JavaVEPlugin.log((Object)"SimpleAttr.DecoderHelper.primRefreshFromComposition(): Error", (Level)Level.FINE);
                }
                return this.generate(null);
            }
            positions[0] = positions[0] + 1;
            positions[1] = positions[1] - 1;
        } else {
            if (positions[0] < 0 || positions[1] < 0) {
                JavaVEPlugin.log((Object)"SimpleAttr.DecoderHelper.primRefreshFromComposition(): Error", (Level)Level.FINE);
                return this.generate(null);
            }
            positions[0] = positions[0] + 1;
            positions[1] = positions[1] - 1;
        }
        this.fInitString = this.primGetInitString();
        StringBuffer sb = new StringBuffer(expSig);
        sb.replace(positions[0], positions[1], this.fInitString);
        this.fExprSig = sb.toString();
        return this.fExprSig;
    }

    public boolean decode() throws CodeGenException {
        if (this.fFmapper.getFeature(this.fExpr) == null || this.fExpr == null) {
            CodeGenUtil.logParsingError(this.fExpr.toString(), this.fbeanPart.getInitMethod().getMethodName(), "Feature " + this.fFmapper.getMethodName() + " is not recognized.", false);
            throw new CodeGenException("null Feature:" + this.fExpr);
        }
        Expression exp = this.getExpression();
        if (exp instanceof Assignment || exp instanceof MethodInvocation && ((MethodInvocation)exp).arguments().size() == 1) {
            return this.addFeature();
        }
        CodeGenUtil.logParsingError(this.fExpr.toString(), this.fbeanPart.getInitMethod().getMethodName(), "Invalid Format", false);
        return false;
    }

    public void removeFromModel() {
        this.unadaptToCompositionModel();
        EStructuralFeature sf = this.fFmapper.getFeature(this.fExpr);
        IJavaObjectInstance parent = (IJavaObjectInstance)this.fbeanPart.getEObject();
        if (parent.eIsSet(sf)) {
            EObject setting = (EObject)parent.eGet(sf);
            parent.eUnset(sf);
            this.cleanProperty(setting);
        }
    }

    public String generate(Object[] noArgs) throws CodeGenException {
        String mtd;
        if (this.fFmapper.getFeature(null) == null) {
            throw new CodeGenException("null Feature");
        }
        this.fInitString = this.primGetInitString();
        if (this.fInitString == null) {
            this.fInitString = NULL_STRING;
        }
        if ((mtd = this.fFmapper.getMethodName()) == null) {
            if (JavaVEPlugin.isLoggingLevel((Level)Level.WARNING)) {
                JavaVEPlugin.log((Object)("No Write JCMMethod found for " + this.fFmapper.getFeature(null) + " on " + this.fbeanPart.getUniqueName()), (Level)Level.WARNING);
            }
            return null;
        }
        String sel = this.fbeanPart.getSimpleName();
        ExpressionTemplate exp = new ExpressionTemplate(sel, mtd, new String[]{this.fInitString}, null, 0);
        exp.setLineSeperator(this.fbeanPart.getModel().getLineSeperator());
        if (this.fFmapper.isFieldFeature()) {
            exp.setFieldAccess(true);
        }
        this.fExprSig = exp.toString();
        return this.fExprSig;
    }

    public boolean isImplicit(Object[] args) {
        return false;
    }

    public Object[] getArgsHandles(Statement expr) {
        return null;
    }

    public void adaptToCompositionModel(IExpressionDecoder decoder) {
        super.adaptToCompositionModel(decoder);
        if (this.fPropInstance == null) {
            this.fPropInstance = (IJavaInstance)this.fbeanPart.getEObject().eGet(this.fFmapper.getFeature(this.fExpr));
        }
        if (this.fPropInstance != null) {
            this.fPropInstance.eAdapters().add((Object)new ExpressionDecoderAdapter(decoder).getShadowSourceRangeAdapter());
        }
    }

    public void unadaptToCompositionModel() {
        ICodeGenAdapter a;
        Object o;
        super.unadaptToCompositionModel();
        if (this.fPropInstance == null && !this.fFmapper.getFeature(this.fExpr).isMany() && (o = this.fbeanPart.getEObject().eGet(this.fFmapper.getFeature(this.fExpr))) instanceof IJavaInstance) {
            this.fPropInstance = (IJavaInstance)o;
        }
        if (this.fPropInstance != null && (a = (ICodeGenAdapter)EcoreUtil.getExistingAdapter((Notifier)this.fPropInstance, (Object)ICodeGenAdapter.JVE_CODEGEN_EXPRESSION_SOURCE_RANGE)) != null) {
            this.fPropInstance.eAdapters().remove((Object)a);
        }
    }
}

