/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.ve.internal.java.codegen.java.BeanPartFactory;
import org.eclipse.ve.internal.java.codegen.java.MethodVisitor;
import org.eclipse.ve.internal.java.codegen.java.SourceVisitor;
import org.eclipse.ve.internal.java.codegen.java.rules.IInstanceVariableRule;
import org.eclipse.ve.internal.java.codegen.java.rules.IThisReferenceRule;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.CodeTypeRef;
import org.eclipse.ve.internal.java.codegen.model.IBeanDeclModel;
import org.eclipse.ve.internal.java.codegen.model.JavaElementInfo;
import org.eclipse.ve.internal.java.codegen.util.CodeGenUtil;
import org.eclipse.ve.internal.java.codegen.util.TypeResolver;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class TypeVisitor
extends SourceVisitor {
    CodeTypeRef fType = null;
    String[] methodHandles = null;
    boolean forceJDOMUsage = false;
    char[] content = null;
    Map fInstanceDeclaredBeans = new HashMap();
    JavaElementInfo[] JDTMethods = null;

    public TypeVisitor(TypeDeclaration node, IBeanDeclModel model, char[] content, String[] methodHandles, List reTryList, boolean forceJDOMUsage) {
        this(node, model, reTryList, forceJDOMUsage);
        this.methodHandles = methodHandles;
        this.content = content;
    }

    public TypeVisitor(TypeDeclaration node, IBeanDeclModel model, List reTryList, boolean forceJDOMUsage) {
        super((ASTNode)node, model, reTryList);
        this.forceJDOMUsage = forceJDOMUsage;
        this.fType = new CodeTypeRef(node, model);
        model.setTypeRef(this.fType);
    }

    public TypeVisitor(CodeTypeRef tr, TypeDeclaration node, IBeanDeclModel model, List reTryList, boolean forceJDOMUsage) {
        super((ASTNode)node, model, reTryList);
        this.forceJDOMUsage = forceJDOMUsage;
        this.fType = tr;
    }

    public static JavaElementInfo[] getCUMethods(MethodDeclaration[] aMethods, JavaElementInfo[] elements, IBeanDeclModel model) {
        ArrayList<JavaElementInfo> methods = new ArrayList<JavaElementInfo>();
        if (elements == null || elements.length == 0) {
            return null;
        }
        int i = 0;
        while (i < aMethods.length) {
            String Name2 = new String(aMethods[i].getName().getIdentifier());
            int Prev = 0;
            int dupCount = 0;
            i = 0;
            while (i < methods.size()) {
                if (methods.get(i) != null && ((JavaElementInfo)methods.get(i)).getName().equals(Name2)) {
                    ++dupCount;
                }
                ++i;
            }
            int j = Prev;
            while (j < elements.length) {
                if (Name2.equals(elements[j].getName()) && --dupCount < 0) break;
                ++j;
            }
            if (j >= elements.length) {
                methods.add(null);
            } else {
                methods.add(elements[j]);
                Prev = j + 1;
            }
            ++i;
        }
        return methods.toArray(new JavaElementInfo[elements.length]);
    }

    protected void createThisIfNecessary() {
        IThisReferenceRule thisRule = (IThisReferenceRule)CodeGenUtil.getEditorStyle(this.fModel).getRule("ruleIThisReference");
        TypeResolver.ResolvedType superResolved = null;
        if (this.fType.getTypeDecl().getSuperclass() != null) {
            superResolved = this.fModel.getResolver().resolveType(this.fType.getTypeDecl().getSuperclass());
        }
        ResourceSet rs = this.fModel.getCompositionModel().getModelResourceSet();
        if (superResolved != null && thisRule.useInheritance(((TypeResolver.Resolved)superResolved).getName(), rs) || thisRule.useInheritance(this.fType.getName(), rs)) {
            BeanPartFactory bpg = new BeanPartFactory(this.fType.getBeanModel(), null);
            bpg.createThisBeanPartIfNeeded(null);
        }
    }

    public void addFieldToMap(BeanPart bp, String method) {
        ArrayList<BeanPart> l = (ArrayList<BeanPart>)this.fInstanceDeclaredBeans.get(method);
        if (l == null) {
            l = new ArrayList<BeanPart>();
            this.fInstanceDeclaredBeans.put(method, l);
        }
        l.add(bp);
    }

    protected void visitAMethod(MethodDeclaration method, IBeanDeclModel model, List reTryList, CodeTypeRef typeRef, String methodHandle, ISourceRange range, String content) {
        String mName = method.getName().getIdentifier();
        MethodVisitor v = new MethodVisitor(method, model, reTryList, typeRef, methodHandle, range, content);
        v.setProgressMonitor(this.getProgressMonitor());
        if (this.fInstanceDeclaredBeans.get(mName) != null) {
            Iterator itr = ((List)this.fInstanceDeclaredBeans.get(mName)).iterator();
            while (itr.hasNext()) {
                v.setInitMethodFor((BeanPart)itr.next());
            }
        }
        v.visit();
    }

    public void visit() {
        this.getProgressMonitor().subTask(this.fType.getSimpleName());
        FieldDeclaration[] fields = this.fType.getTypeDecl().getFields();
        IInstanceVariableRule instVarRule = (IInstanceVariableRule)CodeGenUtil.getEditorStyle(this.fModel).getRule("ruleInstanceVariable");
        if (fields != null) {
            int i = 0;
            while (i < fields.length) {
                if (instVarRule == null || !instVarRule.ignoreVariable(fields[i], this.fModel.getResolver(), this.fModel.getCompositionModel())) {
                    BeanPart bp = new BeanPart(fields[i]);
                    this.fModel.addBean(bp);
                    String overidInitMethod = instVarRule.getDefaultInitializationMethod(fields[i], this.fModel.getResolver(), (TypeDeclaration)this.fVisitedNode);
                    if (overidInitMethod != null) {
                        this.addFieldToMap(bp, overidInitMethod);
                        bp.setInstanceInstantiation(true);
                    }
                }
                ++i;
            }
        }
        this.createThisIfNecessary();
        MethodDeclaration[] methods = this.fType.getTypeDecl().getMethods();
        if (this.forceJDOMUsage) {
            if (methods == null || methods.length == 0) {
                return;
            }
            int methodHandleUseCount = 0;
            int i = 0;
            while (i < methods.length) {
                try {
                    if (methods[i] != null && methods[i] instanceof MethodDeclaration && !methods[i].isConstructor()) {
                        String thisMethodHandle = "";
                        if (methods[i] instanceof MethodDeclaration) {
                            thisMethodHandle = this.methodHandles[methodHandleUseCount];
                            ++methodHandleUseCount;
                        }
                        this.visitAMethod(methods[i], this.fModel, this.fReTryLater, this.fType, thisMethodHandle, this.getSourceRange(methods[i].getStartPosition(), methods[i].getStartPosition() + methods[i].getLength()), String.copyValueOf(this.content, methods[i].getStartPosition(), methods[i].getLength()));
                    }
                }
                catch (Exception e) {
                    JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
                }
                ++i;
            }
        } else {
            JavaElementInfo[] cuMethods = TypeVisitor.getCUMethods(methods, this.JDTMethods, this.fModel);
            if (cuMethods == null || cuMethods.length < 1) {
                return;
            }
            if (cuMethods.length != methods.length) {
                throw new RuntimeException("methods length error");
            }
            int i = 0;
            while (i < methods.length) {
                block18: {
                    try {
                        if (cuMethods[i] != null && methods[i] instanceof MethodDeclaration) {
                            this.visitAMethod(methods[i], this.fModel, this.fReTryLater, this.fType, cuMethods[i].getHandle(), cuMethods[i].getSourceRange(), cuMethods[i].getContent());
                        }
                    }
                    catch (Exception e) {
                        if (!JavaVEPlugin.isLoggingLevel((Level)Level.WARNING)) break block18;
                        JavaVEPlugin.log((Object)("TypeVisitor.visit() could not visit" + String.valueOf(methods[i].getName().getIdentifier()) + " : " + e.getMessage()), (Level)Level.WARNING);
                    }
                }
                ++i;
            }
        }
    }

    protected ISourceRange getSourceRange(int start, int end) {
        final int offset = start;
        final int length = end - start + 1;
        return new ISourceRange(){

            public int getOffset() {
                return offset;
            }

            public int getLength() {
                return length;
            }
        };
    }

    public String toString() {
        return super.toString();
    }

    public void setJDTMethods(JavaElementInfo[] methods) {
        this.JDTMethods = methods;
    }
}

