/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java.rules;

import java.util.HashMap;
import java.util.logging.Level;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.ve.internal.cde.rules.IRuleRegistry;
import org.eclipse.ve.internal.java.codegen.core.IVEModelInstance;
import org.eclipse.ve.internal.java.codegen.java.AnnotationDecoderAdapter;
import org.eclipse.ve.internal.java.codegen.java.rules.IInstanceVariableRule;
import org.eclipse.ve.internal.java.codegen.java.rules.IMethodVariableRule;
import org.eclipse.ve.internal.java.codegen.java.rules.InstanceVariableCreationRule;
import org.eclipse.ve.internal.java.codegen.java.rules.VCEPrefContributor;
import org.eclipse.ve.internal.java.codegen.util.TypeResolver;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class InstanceVariableRule
implements IInstanceVariableRule,
IMethodVariableRule {
    static HashMap modelledBeansCache = new HashMap(200);
    String fInitMethod = null;
    boolean fInitMethodSet = false;

    public boolean ignoreVariable(FieldDeclaration field, TypeResolver resolver, IVEModelInstance di) {
        if (this.resolveType(field.getType(), resolver) == null) {
            return true;
        }
        if (this.isModelled(field.getType(), resolver, di)) {
            return false;
        }
        if (AnnotationDecoderAdapter.isDeclarationParseable(field)) {
            return false;
        }
        return this.ignoreVariable((VariableDeclaration)field.fragments().get(0), field.getType(), resolver, di);
    }

    public boolean ignoreVariable(VariableDeclarationStatement stmt, TypeResolver resolver, IVEModelInstance di) {
        if (this.resolveType(stmt.getType(), resolver) == null) {
            return true;
        }
        if (this.isModelled(stmt.getType(), resolver, di)) {
            return false;
        }
        if (AnnotationDecoderAdapter.isDeclarationParseable(stmt)) {
            return false;
        }
        return this.ignoreVariable((VariableDeclaration)stmt.fragments().get(0), stmt.getType(), resolver, di);
    }

    protected boolean ignoreVariable(VariableDeclaration decl, Type tp, TypeResolver resolver, IVEModelInstance di) {
        String name = decl.getName().getIdentifier();
        if (name.startsWith("ivj")) {
            if (name.startsWith("ivjConn")) {
                return true;
            }
            String type = this.resolveType(tp, resolver);
            if (type == null) {
                return true;
            }
            int firstInner = type.indexOf(36, type.lastIndexOf(46) + 1) + 1;
            return type.startsWith("Ivj", firstInner);
        }
        return true;
    }

    protected String resolveType(Type t, TypeResolver resolver) {
        TypeResolver.Resolved resolved = resolver.resolveType(t);
        return resolved != null ? resolved.getName() : null;
    }

    protected boolean isModelled(Type tp, TypeResolver resolver, IVEModelInstance di) {
        Boolean internal;
        String resolvedType = this.resolveType(tp, resolver);
        if (resolvedType == null) {
            return false;
        }
        if (modelledBeansCache == null) {
            modelledBeansCache = new HashMap(200);
        }
        if ((internal = (Boolean)modelledBeansCache.get(resolvedType)) != null) {
            return internal;
        }
        try {
            JavaHelpers iClass = JavaRefFactory.eINSTANCE.reflectType(resolvedType, di.getModelResourceSet());
            boolean result = InstanceVariableCreationRule.isModelled((EClassifier)iClass, iClass.eResource().getResourceSet());
            modelledBeansCache.put(resolvedType, result ? Boolean.TRUE : Boolean.FALSE);
            return result;
        }
        catch (Exception exception) {
            if (JavaVEPlugin.isLoggingLevel((Level)Level.FINE)) {
                JavaVEPlugin.log((Object)("InstanceVariableRule.isUtility(): Could not resolve - " + resolvedType), (Level)Level.FINE);
            }
            modelledBeansCache.put(resolvedType, Boolean.FALSE);
            return false;
        }
    }

    public static void clearCache() {
        modelledBeansCache.clear();
    }

    public String getDefaultInitializationMethod(FieldDeclaration f, TypeResolver resolver, TypeDeclaration typeDec) {
        Expression init = ((VariableDeclaration)f.fragments().get(0)).getInitializer();
        if (init != null && (init instanceof ClassInstanceCreation || init instanceof ArrayCreation)) {
            String[] methods = VCEPrefContributor.getMethodsFromStore();
            MethodDeclaration[] mDeclarations = typeDec.getMethods();
            if (methods == null || methods.length == 0 || mDeclarations == null || mDeclarations.length == 0) {
                return null;
            }
            int i = 0;
            while (i < methods.length) {
                int j = 0;
                while (j < mDeclarations.length) {
                    MethodDeclaration declaration;
                    if (mDeclarations[j] instanceof MethodDeclaration && methods[i].equals((declaration = mDeclarations[j]).getName().getIdentifier())) {
                        this.fInitMethod = methods[i];
                        this.fInitMethodSet = true;
                        return this.fInitMethod;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    public void setRegistry(IRuleRegistry registry) {
    }
}

