/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.ve.internal.cde.emf.InverseMaintenanceAdapter;
import org.eclipse.ve.internal.java.codegen.java.CodeGenSourceRange;
import org.eclipse.ve.internal.java.codegen.java.ExpressionRefFactory;
import org.eclipse.ve.internal.java.codegen.java.ICodeGenAdapter;
import org.eclipse.ve.internal.java.codegen.java.ICodeGenSourceRange;
import org.eclipse.ve.internal.java.codegen.java.IJavaFeatureMapper;
import org.eclipse.ve.internal.java.codegen.java.MemberDecoderAdapter;
import org.eclipse.ve.internal.java.codegen.model.AbstractCodeRef;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.CodeEventRef;
import org.eclipse.ve.internal.java.codegen.model.CodeExpressionRef;
import org.eclipse.ve.internal.java.codegen.model.CodeTypeRef;
import org.eclipse.ve.internal.java.codegen.model.IBeanDeclModel;
import org.eclipse.ve.internal.java.codegen.util.CodeGenException;
import org.eclipse.ve.internal.java.codegen.util.CodeGenUtil;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.jcm.JCMFactory;
import org.eclipse.ve.internal.jcm.JCMMethod;

public class CodeMethodRef
extends AbstractCodeRef {
    protected MethodDeclaration fdeclMethod = null;
    protected CodeTypeRef fTypeRef = null;
    protected ArrayList fExpressions = new ArrayList();
    protected ArrayList fEventExpressions = new ArrayList();
    protected String fMethodHandle = null;
    protected String fMethodName;
    protected Object fSync = this;
    protected IBeanDeclModel fModel = null;
    protected JCMMethod fcompMethod = null;
    protected boolean fgenerationRequired = false;
    protected boolean fStaleOffset = false;

    public CodeMethodRef(MethodDeclaration method, CodeTypeRef tRef, String methodHandle, ISourceRange range, String content) {
        super(range.getOffset(), range.getLength(), content);
        this.fTypeRef = tRef;
        this.setMethodHandle(methodHandle);
        this.setDeclMethod(method);
        tRef.addRefMethod(this);
    }

    public CodeMethodRef(CodeTypeRef tr, String mName) {
        this.fTypeRef = tr;
        tr.addRefMethod(this);
        this.fMethodName = mName;
    }

    public CodeMethodRef(CodeTypeRef tr, String mName, JCMMethod cMethod) {
        this(tr, mName);
        this.fcompMethod = cMethod;
    }

    protected void setDeclMethod(MethodDeclaration method) {
        this.fdeclMethod = method;
        if (this.fdeclMethod != null) {
            this.fMethodName = method.getName().getIdentifier();
        }
    }

    public String getMethodName() {
        return this.fMethodName;
    }

    public MethodDeclaration getDeclMethod() {
        return this.fdeclMethod;
    }

    public void setMethodHandle(String handle) {
        this.fMethodHandle = handle;
        if (this.fModel != null) {
            Collection beans = this.fModel.getBeansInitilizedByMethod(this);
            Iterator iter = beans.iterator();
            while (iter.hasNext()) {
                BeanPart bean = (BeanPart)iter.next();
                this.fModel.updateBeanNameChange(bean);
            }
        }
    }

    public String getMethodHandle() {
        return this.fMethodHandle;
    }

    public int isEquivalent(AbstractCodeRef code) {
        return -1;
    }

    public void addExpressionRef(CodeExpressionRef ref) {
        int offset = ref.getOffset();
        if (this.fExpressions == null) {
            this.fExpressions = new ArrayList();
        }
        if (ref.isStateSet(128) && offset > -1) {
            int index = 0;
            while (index < this.fExpressions.size()) {
                if (((CodeExpressionRef)this.fExpressions.get(index)).getOffset() > offset) break;
                ++index;
            }
            if (index == this.fExpressions.size()) {
                this.fExpressions.add(ref);
            } else {
                this.fExpressions.add(index, ref);
            }
        } else {
            this.fExpressions.add(ref);
        }
    }

    public void addEventExpressionRef(CodeEventRef ref) {
        int offset = ref.getOffset();
        if (this.fEventExpressions == null) {
            this.fEventExpressions = new ArrayList();
        }
        if (ref.isStateSet(128) && offset > -1) {
            int index = 0;
            while (index < this.fEventExpressions.size()) {
                if (((CodeEventRef)this.fEventExpressions.get(index)).getOffset() > offset) break;
                ++index;
            }
            if (index == this.fEventExpressions.size()) {
                this.fEventExpressions.add(ref);
            } else {
                this.fEventExpressions.add(index, ref);
            }
        } else {
            this.fEventExpressions.add(ref);
        }
    }

    public void removeExpressionRef(CodeExpressionRef ref) {
        if (ref instanceof CodeEventRef) {
            this.removeEventRef((CodeEventRef)ref);
        } else if (this.fExpressions != null) {
            this.fExpressions.remove(ref);
        }
    }

    public void removeEventRef(CodeEventRef ref) {
        if (this.fEventExpressions != null) {
            this.fEventExpressions.remove(ref);
        }
    }

    public Iterator getExpressions() {
        if (this.fExpressions == null) {
            this.fExpressions = new ArrayList();
        }
        return this.fExpressions.iterator();
    }

    public Iterator getEventExpressions() {
        if (this.fEventExpressions == null) {
            this.fEventExpressions = new ArrayList();
        }
        return this.fEventExpressions.iterator();
    }

    public Iterator getAllExpressions() {
        final Iterator exp = this.getExpressions();
        final Iterator events = this.getEventExpressions();
        return new Iterator(){
            boolean eventsFlag = false;

            public boolean hasNext() {
                return exp.hasNext() || events.hasNext();
            }

            public Object next() {
                if (exp.hasNext()) {
                    return exp.next();
                }
                this.eventsFlag = true;
                return events.next();
            }

            public void remove() {
                if (this.eventsFlag) {
                    events.remove();
                } else {
                    exp.remove();
                }
            }
        };
    }

    protected void resetExpressionPriorities() {
        CodeExpressionRef expression;
        int count = 0;
        while (count < this.fExpressions.size()) {
            expression = (CodeExpressionRef)this.fExpressions.get(count);
            try {
                if (!expression.isStateSet(4) && expression.isAnyStateSet() && !expression.isStateSet(16)) {
                    expression.setProprity(expression.primGetDecoder().determinePriority());
                } else {
                    expression.isStateSet(4096);
                }
            }
            catch (Exception e) {
                JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
            }
            ++count;
        }
        count = 0;
        while (count < this.fEventExpressions.size()) {
            expression = (CodeExpressionRef)this.fEventExpressions.get(count);
            try {
                if (!expression.isStateSet(4) && expression.isAnyStateSet() && !expression.isStateSet(16)) {
                    expression.setProprity(expression.primGetDecoder().determinePriority());
                } else {
                    expression.isStateSet(4096);
                }
            }
            catch (Exception e) {
                JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
            }
            ++count;
        }
    }

    protected Object[] getUsableOffsetAndFiller() throws CodeGenException {
        int offset = -1;
        String filler = null;
        ArrayList list = new ArrayList();
        list.addAll(this.fExpressions);
        list.addAll(this.fEventExpressions);
        int i = list.size() - 1;
        while (i >= 0) {
            CodeExpressionRef ce = (CodeExpressionRef)list.get(i);
            if (ce.isStateSet(128) && ce.getOffset() >= 0) {
                offset = ce.getOffset() + ce.getLen();
                filler = ce.getFillerContent();
                break;
            }
            --i;
        }
        if (offset != -1 && filler != null) {
            return new Object[]{new Integer(offset), filler};
        }
        IType mainType = CodeGenUtil.getMainType(this.fModel.getCompilationUnit());
        IMethod fMethod = CodeGenUtil.getMethod(mainType, this.getMethodHandle());
        if (fMethod != null) {
            ICodeGenSourceRange sr = ExpressionRefFactory.getOffsetForFirstExpression(fMethod);
            if (sr == null) {
                throw new CodeGenException("Could not find Offset");
            }
            offset = sr.getOffset();
            StringBuffer sb = new StringBuffer();
            int i2 = 0;
            while (i2 < sr.getLength()) {
                sb.append(' ');
                ++i2;
            }
            filler = sb.toString();
        }
        return new Object[]{new Integer(offset), filler};
    }

    protected int comparePriority(IJavaFeatureMapper.VEexpressionPriority p1, IJavaFeatureMapper.VEexpressionPriority p2) {
        if (p1.getProiority() == p2.getProiority()) {
            if (p1.getProiorityIndex() == p2.getProiorityIndex()) {
                return 0;
            }
            if (p1.getProiorityIndex() > p2.getProiorityIndex()) {
                return 1;
            }
            return -1;
        }
        if (p1.getProiority() > p2.getProiority()) {
            return 1;
        }
        return -1;
    }

    protected void addExpression(List l, CodeExpressionRef exp, int index) throws CodeGenException {
        String filler;
        int offset;
        if (l.size() == 0) {
            Object[] result = this.getUsableOffsetAndFiller();
            offset = (Integer)result[0];
            filler = (String)result[1];
        } else {
            CodeExpressionRef cExp;
            if (index == 0) {
                cExp = (CodeExpressionRef)l.get(index);
                offset = cExp.getOffset();
            } else {
                cExp = (CodeExpressionRef)l.get(index - 1);
                offset = cExp.getOffset() + cExp.getLen();
            }
            filler = cExp.getFillerContent();
        }
        exp.setFillerContent(filler);
        exp.setOffset(offset);
        exp.setState(128, true);
        l.add(index, exp);
    }

    protected void addExpressionToSortedList(List sortedList, CodeExpressionRef exp) throws CodeGenException {
        int index = -1;
        IJavaFeatureMapper.VEexpressionPriority expPriority = exp.getPriority();
        if (expPriority.equals(IJavaFeatureMapper.NOPriority)) {
            index = sortedList.size();
        } else {
            int first = -1;
            int last = -1;
            int i = sortedList.size() - 1;
            while (i >= 0 && first < 0) {
                CodeExpressionRef cExp = (CodeExpressionRef)sortedList.get(i);
                int compare = this.comparePriority(expPriority, cExp.getPriority());
                switch (compare) {
                    case -1: {
                        first = i + 1 >= sortedList.size() ? sortedList.size() : i + 1;
                        break;
                    }
                    case 0: {
                        if (last >= 0) break;
                        last = i + 1 >= sortedList.size() ? sortedList.size() : i + 1;
                    }
                }
                --i;
            }
            if (first >= 0) {
                if (last >= 0) {
                    index = last - 1;
                    while (index >= first) {
                        CodeExpressionRef cExp;
                        if (index < sortedList.size() && (cExp = (CodeExpressionRef)sortedList.get(index)).getBean().equals(exp.getBean())) {
                            index = index + 1 > sortedList.size() ? sortedList.size() : index + 1;
                            break;
                        }
                        --index;
                    }
                    if (index < first) {
                        index = last;
                    }
                } else {
                    index = first;
                }
            } else {
                index = 0;
            }
        }
        this.addExpression(sortedList, exp, index);
    }

    protected ArrayList sortExpressions(List list) throws CodeGenException {
        ArrayList<CodeExpressionRef> sortedList = new ArrayList<CodeExpressionRef>();
        ArrayList<CodeExpressionRef> needSorting = new ArrayList<CodeExpressionRef>();
        int i = 0;
        while (i < list.size()) {
            CodeExpressionRef exp = (CodeExpressionRef)list.get(i);
            if (!exp.isStateSet(128)) {
                needSorting.add(exp);
            } else {
                sortedList.add(exp);
                if (exp.getOffset() < 0) {
                    throw new CodeGenException("Invalid Offset: " + exp);
                }
            }
            ++i;
        }
        if (needSorting.size() > 1) {
            throw new CodeGenException("Limitation ... only one new expression is allowed");
        }
        i = 0;
        while (i < needSorting.size()) {
            this.addExpressionToSortedList(sortedList, (CodeExpressionRef)needSorting.get(i));
            ++i;
        }
        return sortedList;
    }

    public void updateExpressionOrder() throws CodeGenException {
        ArrayList sortedList;
        this.fExpressions = sortedList = this.sortExpressions(this.fExpressions);
        this.fEventExpressions = sortedList = this.sortExpressions(this.fEventExpressions);
    }

    protected static Enumeration determineBeanOrder(Enumeration beans) {
        TreeSet<BeanPart> beanSorter = new TreeSet<BeanPart>(CodeMethodRef.getDefaultBeanOrderComparator());
        while (beans.hasMoreElements()) {
            boolean added = beanSorter.add((BeanPart)beans.nextElement());
            if (added) continue;
            JavaVEPlugin.log((Object)"No addition to the treeset", (Level)Level.FINE);
        }
        Vector order = new Vector();
        Iterator sorted = beanSorter.iterator();
        while (sorted.hasNext()) {
            order.add(sorted.next());
        }
        return order.elements();
    }

    protected static Comparator getDefaultBeanOrderComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                int np2;
                BeanPart bp1 = (BeanPart)o1;
                BeanPart bp2 = (BeanPart)o2;
                int np1 = this.getImportanceCount(bp1, bp2);
                if (np1 < (np2 = this.getImportanceCount(bp2, bp1))) {
                    return 1;
                }
                if (np1 == np2) {
                    return -1;
                }
                return -1;
            }

            protected boolean isReferenced(BeanPart parent, BeanPart reference) {
                EReference[] sfs = InverseMaintenanceAdapter.getReferencesFrom((EObject)parent.getEObject(), (Notifier)reference.getEObject());
                return sfs != null && sfs.length > 0;
            }

            protected int getImportanceCount(BeanPart main, BeanPart subMain) {
                boolean sV;
                if (this.isAChildOf(main, subMain)) {
                    return Integer.MAX_VALUE;
                }
                if (this.isReferenced(main, subMain)) {
                    return Integer.MIN_VALUE;
                }
                boolean mV = main.isInstanceVar();
                boolean bl = sV = subMain.isInstanceVar();
                if (mV > sV) {
                    return Integer.MIN_VALUE;
                }
                if (mV < sV) {
                    return Integer.MAX_VALUE;
                }
                int parentCount = this.getParentCount(main);
                int hasChildren = this.getConstraintCount(main);
                return -hasChildren - parentCount;
            }

            protected boolean isAChildOf(BeanPart parent, BeanPart reference) {
                Iterator children = parent.getChildren();
                while (children.hasNext()) {
                    BeanPart child = (BeanPart)children.next();
                    if (child.getSimpleName().equals(reference.getSimpleName())) {
                        return true;
                    }
                    if (!this.isAChildOf(child, reference)) continue;
                    return true;
                }
                return false;
            }

            protected int getConstraintCount(BeanPart b) {
                EStructuralFeature sf = b.getEObject().eClass().getEStructuralFeature("components");
                if (sf != null) {
                    return 1;
                }
                if (CodeGenUtil.getConstraintFeature(b.getEObject()) != null) {
                    return 1;
                }
                return 0;
            }

            protected int getParentCount(BeanPart b) {
                int pc = 0;
                int safetyCount = 1000;
                BeanPart parent = b;
                while (parent != null && safetyCount > 0) {
                    parent = CodeGenUtil.determineParentBeanpart(parent);
                    ++pc;
                    --safetyCount;
                }
                return pc;
            }
        };
    }

    public void dispose() {
        Object[] tmp;
        if (this.fModel != null) {
            Iterator itr = this.fModel.getBeansInitilizedByMethod(this).iterator();
            while (itr.hasNext()) {
                BeanPart b = (BeanPart)itr.next();
                b.removeInitMethod(this);
                b.removeReturnMethod(this);
            }
        }
        if (this.fExpressions != null) {
            tmp = this.fExpressions.toArray();
            int i = 0;
            while (i < tmp.length) {
                ((CodeExpressionRef)tmp[i]).dispose();
                ++i;
            }
        }
        this.fExpressions = null;
        if (this.fEventExpressions != null) {
            tmp = this.fEventExpressions.toArray();
            int i = 0;
            while (i < tmp.length) {
                ((CodeEventRef)tmp[i]).dispose();
                ++i;
            }
        }
        this.fExpressions = null;
        if (this.fTypeRef != null) {
            this.fTypeRef.removeRefMethod(this);
        }
        if (this.fModel != null) {
            this.fModel.removeMethodRef(this);
        }
        this.fdeclMethod = null;
        if (this.fcompMethod != null) {
            this.fTypeRef.getBeanComposition().getMethods().remove((Object)this.fcompMethod);
        }
        this.fTypeRef = null;
        this.fcompMethod = null;
    }

    public ICodeGenSourceRange getTargetSourceRange() {
        if (this.fModel == null) {
            return null;
        }
        ISourceRange sr = this.fModel.getWorkingCopyProvider().getSourceRange(this.getMethodHandle());
        CodeGenSourceRange result = new CodeGenSourceRange(sr);
        if (sr != null) {
            result.setLineOffset(this.fModel.getWorkingCopyProvider().getLineNo(result.getOffset()));
        }
        return result;
    }

    public ICodeGenSourceRange getHighlightSourceRange() {
        if (this.fModel == null || this.fModel.getWorkingCopyProvider() == null) {
            return null;
        }
        try {
            IMethod mtd = (IMethod)this.fModel.getWorkingCopyProvider().getElement(this.getMethodHandle());
            if (mtd != null) {
                int start = mtd.getNameRange().getOffset();
                int end = mtd.getSourceRange().getOffset() + mtd.getSourceRange().getLength();
                start = this.fModel.getCompilationUnit().getSource().lastIndexOf(10, start) + 1;
                CodeGenSourceRange result = new CodeGenSourceRange(start, end - start);
                result.setLineOffset(this.fModel.getWorkingCopyProvider().getLineNo(result.getOffset()));
                return result;
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public void setModel(IBeanDeclModel model) {
        this.fModel = model;
    }

    public void refreshIMethod() {
        try {
            try {
                if (!this.fModel.getCompilationUnit().isConsistent()) {
                    this.fModel.getCompilationUnit().reconcile(0, false, null, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (JavaModelException javaModelException) {}
            IType mainType = CodeGenUtil.getMainType(this.fModel.getCompilationUnit());
            IMethod m = CodeGenUtil.getMethod(mainType, this.getMethodHandle());
            this.refreshIMethod(m);
        }
        catch (Exception e) {
            JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
        }
    }

    public void refreshIMethod(IMethod m) {
        try {
            if (m != null) {
                this.setOffset(m.getSourceRange().getOffset());
            }
        }
        catch (JavaModelException e) {
            JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
        }
    }

    public String _debugExpressions() {
        StringBuffer sb = new StringBuffer();
        int mOffset = this.getOffset();
        String doc = this.fModel.getDocumentBuffer().getContents();
        Iterator itr = this.getExpressions();
        while (itr.hasNext()) {
            CodeExpressionRef exp = (CodeExpressionRef)itr.next();
            sb.append(String.valueOf(exp.toString()) + "\n\"");
            if (!exp.isStateSet(16)) {
                sb.append(doc.substring(mOffset + exp.getOffset(), mOffset + exp.getOffset() + exp.getLen()));
            } else {
                sb.append("STATE_NOT_EXISTANT");
            }
            sb.append("\"\n");
        }
        return sb.toString();
    }

    public JCMMethod getCompMethod() {
        if (this.fcompMethod == null) {
            this.fcompMethod = JCMFactory.eINSTANCE.createJCMMethod();
            this.fTypeRef.getBeanComposition().getMethods().add((Object)this.fcompMethod);
            this.fcompMethod.setName(this.getMethodName());
            MemberDecoderAdapter a = new MemberDecoderAdapter(this.fModel);
            a.setMethodRef(this);
            a.setTarget((Notifier)this.fcompMethod);
            this.fcompMethod.eAdapters().add((Object)a);
        }
        return this.fcompMethod;
    }

    public void setCompMethod(JCMMethod m) throws CodeGenException {
        if (this.fcompMethod != null) {
            throw new CodeGenException("Already initialized");
        }
        this.fcompMethod = m;
        MemberDecoderAdapter ma = (MemberDecoderAdapter)EcoreUtil.getExistingAdapter((Notifier)m, (Object)ICodeGenAdapter.JVE_MEMBER_ADAPTER);
        ma.setMethodRef(this);
        m.setName(this.getMethodName());
    }

    public boolean isGenerationRequired() {
        return this.fgenerationRequired;
    }

    public void setGenerationRequired(boolean enerationRequired) {
        this.fgenerationRequired = enerationRequired;
    }

    public CodeTypeRef getTypeRef() {
        return this.fTypeRef;
    }

    public String toString() {
        return this.fStaleOffset ? "***StaleOffset***\n" + super.toString() : super.toString();
    }

    public void setOffset(int off) {
        super.setOffset(off);
        this.fStaleOffset = false;
    }

    public void setContent(String content) {
        super.setContent(content);
        this.fStaleOffset = false;
    }

    public void updateExpressionsOffset(int offset, int delta) {
        Iterator itr = this.getAllExpressions();
        while (itr.hasNext()) {
            CodeExpressionRef exp = (CodeExpressionRef)itr.next();
            if (exp.isStateSet(64) || exp.isStateSet(16) || exp.getOffset() + this.getOffset() < offset) continue;
            exp.setOffset(exp.getOffset() + delta);
        }
    }
}

