/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.model;

import java.util.Iterator;
import java.util.logging.Level;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.CodeEventRef;
import org.eclipse.ve.internal.java.codegen.model.CodeMethodRef;
import org.eclipse.ve.internal.java.codegen.util.CodeGenException;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.jcm.AbstractEventInvocation;
import org.eclipse.ve.internal.jcm.Listener;

public class EventRefFactory {
    BeanPart fBeanPart;
    CodeEventRef fExpr = null;
    AbstractEventInvocation fEi;

    public EventRefFactory(BeanPart bean, AbstractEventInvocation ei) {
        this.fBeanPart = bean;
        this.fEi = ei;
    }

    protected boolean areEqual(Object a, Object b) {
        if (a instanceof Object[]) {
            if (b instanceof Object[]) {
                Object[] aa = (Object[])a;
                Object[] ba = (Object[])b;
                if (aa.length != ba.length) {
                    return false;
                }
                int i = 0;
                while (i < ba.length) {
                    if (!this.areEqual(aa[i], ba[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }
        if (b instanceof Object[]) {
            return false;
        }
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return a.equals(b);
    }

    public CodeEventRef getExistingExpression(Object[] args) {
        if (this.fExpr != null) {
            return this.fExpr;
        }
        Iterator itr = this.fBeanPart.getRefEventExpressions().iterator();
        while (itr.hasNext()) {
            CodeEventRef exp = (CodeEventRef)itr.next();
            if (exp.getEventDecoder() == null || !this.areEqual(exp.getEventDecoder().getEventInvocation(), this.fEi) || !this.areEqual(exp.getArgs(), args)) continue;
            this.fExpr = exp;
            break;
        }
        return this.fExpr;
    }

    public CodeEventRef createFromJVEModel() throws CodeGenException {
        Listener l = this.fEi.getListener();
        Object[] args = new Object[]{this.fEi, l};
        if (this.fExpr == null) {
            if (this.getExistingExpression(args) != null) {
                throw new CodeGenException("Expression already exists");
            }
            CodeMethodRef mr = this.fBeanPart.getEventInitMethod();
            CodeEventRef exp = new CodeEventRef(mr, this.fBeanPart);
            exp.setArguments(args);
            exp.clearState();
            exp.setState(1, true);
            exp.generateSource(this.fEi);
            if (!exp.isAnyStateSet() || exp.isStateSet(16)) {
                return null;
            }
            this.fExpr = exp;
            try {
                mr.updateExpressionOrder();
            }
            catch (Throwable e) {
                JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
                return this.fExpr;
            }
        }
        return this.fExpr;
    }
}

