/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.internal.instantiation.InitStringAllocation;
import org.eclipse.jem.internal.instantiation.InstantiationFactory;
import org.eclipse.jem.internal.instantiation.JavaAllocation;
import org.eclipse.jem.internal.instantiation.PTExpression;
import org.eclipse.jem.internal.instantiation.PTInstanceReference;
import org.eclipse.jem.internal.instantiation.ParseTreeAllocation;
import org.eclipse.jem.internal.instantiation.ParseVisitor;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.impl.NaiveExpressionFlattener;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.ve.internal.cde.core.CDEUtilities;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.emf.InverseMaintenanceAdapter;
import org.eclipse.ve.internal.cdm.Annotation;
import org.eclipse.ve.internal.cdm.AnnotationEMF;
import org.eclipse.ve.internal.cdm.CDMFactory;
import org.eclipse.ve.internal.java.codegen.core.IVEModelInstance;
import org.eclipse.ve.internal.java.codegen.java.BeanDecoderAdapter;
import org.eclipse.ve.internal.java.codegen.java.CodeGenExpFlattener;
import org.eclipse.ve.internal.java.codegen.java.ExpressionDecoderFactory;
import org.eclipse.ve.internal.java.codegen.java.ICodeGenAdapter;
import org.eclipse.ve.internal.java.codegen.java.IExpressionDecoder;
import org.eclipse.ve.internal.java.codegen.java.MethodGeneratorFactory;
import org.eclipse.ve.internal.java.codegen.java.PropertyFeatureMapper;
import org.eclipse.ve.internal.java.codegen.java.ThisBeanDecoderAdapter;
import org.eclipse.ve.internal.java.codegen.java.rules.InstanceVariableCreationRule;
import org.eclipse.ve.internal.java.codegen.java.rules.InstanceVariableRule;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.CodeMethodRef;
import org.eclipse.ve.internal.java.codegen.model.IBeanDeclModel;
import org.eclipse.ve.internal.java.codegen.model.JavaElementInfo;
import org.eclipse.ve.internal.java.codegen.util.CodeGenException;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.java.vce.rules.IEditorStyle;
import org.eclipse.ve.internal.java.vce.rules.VCEPostSetCommand;
import org.eclipse.ve.internal.jcm.MemberContainer;

public class CodeGenUtil {
    public static boolean isExactlyPresent(String main, String target) {
        if (main == null || target == null) {
            return false;
        }
        int index = main.indexOf(target);
        if (index < 0) {
            return false;
        }
        if ((index += target.length()) >= main.length()) {
            return true;
        }
        return !Character.isJavaIdentifierPart(main.charAt(index));
    }

    public static String tokensToString(char[][] tokens) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < tokens.length) {
            if (i > 0 && buf.length() > 0) {
                buf.append(".");
            }
            buf.append(tokens[i]);
            ++i;
        }
        return buf.toString();
    }

    public static IJavaInstance createInstance(String instanceType, ResourceSet rs) throws CodeGenException {
        JavaHelpers iClass = JavaRefFactory.eINSTANCE.reflectType(instanceType, rs);
        IJavaInstance inst = (IJavaInstance)iClass.getEPackage().getEFactoryInstance().create((EClass)iClass);
        return inst;
    }

    public static IJavaInstance createInstance(String instanceType, IVEModelInstance cm) throws CodeGenException {
        if (cm.getModelResourceSet() == null) {
            throw new CodeGenException("MOF is not set up");
        }
        if (JavaVEPlugin.isLoggingLevel((Level)Level.FINE)) {
            JavaVEPlugin.log((Object)("CodeGenUtil.createInstance(" + instanceType + ")"), (Level)Level.FINE);
        }
        return CodeGenUtil.createInstance(instanceType, cm.getModelResourceSet());
    }

    public static EClassifier getMetaClass(String qualifiedName, IVEModelInstance cm) {
        if (cm.getModelResourceSet() == null || qualifiedName == null) {
            return null;
        }
        return JavaRefFactory.eINSTANCE.reflectType(qualifiedName, cm.getModelResourceSet());
    }

    public static void addAnnotatedName(Annotation a, String name) {
        if (a != null) {
            EStringToStringMapEntryImpl sentry = (EStringToStringMapEntryImpl)EcoreFactory.eINSTANCE.create(EcorePackage.eINSTANCE.getEStringToStringMapEntry());
            sentry.setKey((Object)"org.eclipse.ve.internal.cde.core.nameincomposition");
            if (name != null && name.length() > 0) {
                sentry.setValue((Object)name);
            }
            CDEUtilities.putEMapEntry((EMap)a.getKeyedValues(), (Map.Entry)sentry);
        }
    }

    public static EStructuralFeature getConstraintFeature(EObject componentConstraint) {
        return componentConstraint.eClass().getEStructuralFeature("constraint");
    }

    public static void addConstraintString(MemberContainer pOwner, EObject target, String initVal, EStructuralFeature sf, IVEModelInstance cm) throws Exception {
        IJavaInstance value = null;
        CodeGenUtil.propertyCleanup(target, sf);
        if (initVal != null) {
            value = CodeGenUtil.createInstance("java.lang.String", cm);
            value.setAllocation((JavaAllocation)InstantiationFactory.eINSTANCE.createInitStringAllocation(initVal));
            pOwner.getProperties().add((Object)value);
        }
        target.eSet(sf, (Object)value);
    }

    public static void addConstraintInstance(EObject target, IJavaObjectInstance val, EStructuralFeature sf) throws Exception {
        target.eSet(sf, (Object)val);
    }

    public static EStructuralFeature getComponentFeature(EObject target) {
        return target.eClass().getEStructuralFeature("components");
    }

    public static EStructuralFeature getParentContainerFeature(EObject target) {
        return target.eClass().getEStructuralFeature("parentContainer");
    }

    public static IType getMainType(ICompilationUnit cu) {
        if (cu == null) {
            return null;
        }
        try {
            IType[] types = cu.getTypes();
            return types.length > 0 ? types[0] : null;
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public static IType getType(ICompilationUnit cu, String name) {
        if (cu == null) {
            return null;
        }
        IType[] elements = null;
        IType main = CodeGenUtil.getMainType(cu);
        try {
            if (main != null) {
                elements = main.getTypes();
                int i = 0;
                while (i < elements.length) {
                    if (elements[i].getElementName().equals(name)) {
                        return elements[i];
                    }
                    ++i;
                }
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public static IMethod[] getMethods(ICompilationUnit cu) {
        if (cu == null) {
            return null;
        }
        IType mt = CodeGenUtil.getMainType(cu);
        try {
            if (mt != null) {
                return mt.getMethods();
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public static JavaElementInfo[] getMethodsInfo(ICompilationUnit cu) {
        IMethod[] mtds = CodeGenUtil.getMethods(cu);
        if (mtds != null) {
            JavaElementInfo[] info = new JavaElementInfo[mtds.length];
            int i = 0;
            while (i < mtds.length) {
                info[i] = new JavaElementInfo((IJavaElement)mtds[i]);
                ++i;
            }
            return info;
        }
        return null;
    }

    public static IMethod[] getMethods(ICompilationUnit cu, String typeName) {
        if (cu == null) {
            return null;
        }
        IType mt = CodeGenUtil.getType(cu, typeName);
        try {
            if (mt != null) {
                return mt.getMethods();
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public static JavaElementInfo[] getMethodsInfo(ICompilationUnit cu, String typeName) {
        if (cu == null) {
            return null;
        }
        IMethod[] mtds = CodeGenUtil.getMethods(cu, typeName);
        if (mtds != null) {
            JavaElementInfo[] info = new JavaElementInfo[mtds.length];
            int i = 0;
            while (i < mtds.length) {
                info[i] = new JavaElementInfo((IJavaElement)mtds[i]);
                ++i;
            }
            return info;
        }
        return null;
    }

    public static IMethod refreshMethod(IMethod method) {
        if (method == null) {
            return method;
        }
        ICompilationUnit cu = method.getCompilationUnit();
        try {
            if (!cu.isConsistent()) {
                cu.reconcile(0, false, null, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (JavaModelException javaModelException) {}
        IType t = CodeGenUtil.getMainType(cu);
        return CodeGenUtil.getMethod(t, method);
    }

    public static IMethod refreshMethod(String handle, ICompilationUnit cu) {
        if (handle == null) {
            return null;
        }
        try {
            if (!cu.isConsistent()) {
                cu.reconcile(0, false, null, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (JavaModelException javaModelException) {}
        return CodeGenUtil.getMethod(CodeGenUtil.getMainType(cu), handle);
    }

    public static IField getField(String handle, ICompilationUnit cu) {
        if (handle == null) {
            return null;
        }
        try {
            if (!cu.isConsistent()) {
                cu.reconcile(0, false, null, (IProgressMonitor)new NullProgressMonitor());
            }
            IType t = CodeGenUtil.getMainType(cu);
            IField[] flds = t.getFields();
            int i = 0;
            while (i < flds.length) {
                IField iField = flds[i];
                if (iField.getHandleIdentifier().equals(handle)) {
                    return iField;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public static IField getFieldByName(String name, ICompilationUnit cu) {
        if (name == null || cu == null) {
            return null;
        }
        try {
            if (!cu.isConsistent()) {
                cu.reconcile(0, false, null, (IProgressMonitor)new NullProgressMonitor());
            }
            IType t = CodeGenUtil.getMainType(cu);
            IField[] flds = t.getFields();
            int i = 0;
            while (i < flds.length) {
                IField iField = flds[i];
                if (iField.getElementName().equals(name)) {
                    return iField;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public static IMethod getMethod(IType t, String handle) {
        if (t == null) {
            return null;
        }
        try {
            IMethod[] mt = t.getMethods();
            int index = 0;
            while (index < mt.length) {
                if (mt[index].getHandleIdentifier().equals(handle)) {
                    return mt[index];
                }
                ++index;
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public static IMethod getMethod(IType t, IMethod old) {
        try {
            IMethod[] mt = t.getMethods();
            int index = 0;
            while (index < mt.length) {
                if (mt[index].isSimilar(old)) {
                    return mt[index];
                }
                ++index;
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public static void refreshMethodOffsets(IType t, IBeanDeclModel model) throws CodeGenException {
        try {
            IMethod[] methods = t.getMethods();
            int i = 0;
            while (i < methods.length) {
                CodeMethodRef mr = model.getMethodInitializingABean(methods[i].getHandleIdentifier());
                if (mr != null) {
                    mr.setOffset(methods[i].getSourceRange().getOffset());
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            throw new CodeGenException(e);
        }
    }

    private static boolean isComponentContained(IBeanDeclModel m, EObject component, EObject parent) throws CodeGenException {
        if (parent == null || component == null) {
            return false;
        }
        if (component.equals(parent)) {
            return true;
        }
        IExpressionDecoder decoder = CodeGenUtil.getDecoderFactory(m).getExpDecoder((IJavaInstance)((IJavaObjectInstance)parent));
        Iterator itr = decoder.getChildren((IJavaObjectInstance)parent).iterator();
        while (itr.hasNext()) {
            EObject child = (EObject)itr.next();
            itr.next();
            if (!CodeGenUtil.isComponentContained(m, component, child)) continue;
            return true;
        }
        return false;
    }

    public static boolean isComponentInComposition(IBeanDeclModel m, EObject component, IVEModelInstance model) throws CodeGenException {
        Iterator itr = model.getModelRoot().getComponents().iterator();
        while (itr.hasNext()) {
            if (!CodeGenUtil.isComponentContained(m, component, (EObject)itr.next())) continue;
            return true;
        }
        return false;
    }

    private static IJavaObjectInstance getParent(IBeanDeclModel model, IJavaObjectInstance child, IJavaObjectInstance parent) throws CodeGenException {
        if (parent == null || child == null) {
            return null;
        }
        if (parent.equals(child)) {
            return null;
        }
        IExpressionDecoder decoder = CodeGenUtil.getDecoderFactory(model).getExpDecoder((IJavaInstance)parent);
        Iterator itr = decoder.getChildren(parent).iterator();
        while (itr.hasNext()) {
            IJavaObjectInstance c = (IJavaObjectInstance)itr.next();
            itr.next();
            if (c.equals(child)) {
                return parent;
            }
            IJavaObjectInstance p = CodeGenUtil.getParent(model, child, c);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    public static IJavaObjectInstance getParent(IBeanDeclModel bmodel, IJavaObjectInstance child, IVEModelInstance model) throws CodeGenException {
        Iterator itr = model.getModelRoot().getComponents().iterator();
        while (itr.hasNext()) {
            IJavaObjectInstance p = CodeGenUtil.getParent(bmodel, child, (IJavaObjectInstance)itr.next());
            if (p == null) continue;
            return p;
        }
        return null;
    }

    public static boolean isContainerHasLayoutManager(EObject container) {
        if (container == null) {
            return false;
        }
        EStructuralFeature sf = container.eClass().getEStructuralFeature("layout");
        return !container.eIsSet(sf) || container.eGet(sf) != null;
    }

    public static List getChildrenComponents(EObject parent) {
        if (parent == null) {
            return null;
        }
        List compList = null;
        EStructuralFeature sf = CodeGenUtil.getComponentFeature(parent);
        if (sf != null) {
            try {
                compList = (List)parent.eGet(CodeGenUtil.getComponentFeature(parent));
            }
            catch (Exception exception) {}
        }
        if (compList != null && compList.size() == 0) {
            return null;
        }
        return compList;
    }

    public static EObject getParentComponent(EObject child) {
        if (child == null) {
            return null;
        }
        return null;
    }

    public static IJavaObjectInstance getCCcomponent(EObject constraintComponent) {
        IJavaObjectInstance comp = (IJavaObjectInstance)constraintComponent.eGet(constraintComponent.eClass().getEStructuralFeature("component"));
        return comp;
    }

    public static IJavaObjectInstance getCCconstraint(EObject constraintComponent) {
        try {
            IJavaObjectInstance cons = (IJavaObjectInstance)constraintComponent.eGet(constraintComponent.eClass().getEStructuralFeature("constraint"));
            return cons;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static EStructuralFeature getAllocationFeature(EObject target) {
        return target.eClass().getEStructuralFeature("allocation");
    }

    public static int getExactJavaIndex(String searchIn, String seachFor) {
        int index = -1;
        int indexEnd = -1;
        while (searchIn.indexOf(seachFor, indexEnd) > -1) {
            boolean endAllright;
            index = searchIn.indexOf(seachFor, indexEnd);
            indexEnd = index + seachFor.length();
            boolean startAllright = index == 0 || index > 0 && !Character.isJavaIdentifierPart(searchIn.charAt(index - 1));
            boolean bl = endAllright = indexEnd == searchIn.length() || indexEnd < searchIn.length() && !Character.isJavaIdentifierPart(searchIn.charAt(indexEnd + 1));
            if (!startAllright || !endAllright) continue;
            return index;
        }
        return -1;
    }

    public static String getInitString(IJavaInstance javaInstance, IBeanDeclModel model, List importList) {
        JavaAllocation alloc = javaInstance.getAllocation();
        if (alloc instanceof InitStringAllocation) {
            return ((InitStringAllocation)alloc).getInitString();
        }
        if (alloc instanceof ParseTreeAllocation) {
            PTExpression e = ((ParseTreeAllocation)javaInstance.getAllocation()).getExpression();
            CodeGenExpFlattener f = new CodeGenExpFlattener(model, importList);
            e.accept((ParseVisitor)f);
            return f.getResult();
        }
        JavaHelpers jc = javaInstance.getJavaType();
        if (!jc.isPrimitive()) {
            String qn;
            if (importList != null) {
                if (!importList.contains(jc.getQualifiedName())) {
                    importList.add(jc.getQualifiedName());
                }
                qn = jc.getSimpleName();
            } else {
                qn = jc.getQualifiedName();
            }
            return "new " + qn + "()";
        }
        return "";
    }

    public static boolean isConstraintComponentValue(Object val) {
        return val != null && val instanceof EObject && ((EObject)val).eClass().getName().equals("ConstraintComponent");
    }

    public static boolean isTabPaneComponentValue(Object val) {
        return val != null && val instanceof EObject && ((EObject)val).eClass().getName().equals("JTabComponent");
    }

    public static boolean isThisPart(EObject model) {
        BeanDecoderAdapter beanDecoderAdapter = (BeanDecoderAdapter)EcoreUtil.getExistingAdapter((Notifier)model, (Object)ICodeGenAdapter.JVE_CODEGEN_BEAN_PART_ADAPTER);
        return beanDecoderAdapter instanceof ThisBeanDecoderAdapter;
    }

    public static boolean isSpecialRootComponent(Object val) {
        boolean result = false;
        if (val instanceof EObject) {
            result = CodeGenUtil.isConstraintComponentValue(val) || CodeGenUtil.isTabPaneComponentValue(val);
        }
        return result;
    }

    public static Annotation getAnnotation(EObject obj) {
        if (obj == null) {
            return null;
        }
        AnnotationEMF.ParentAdapter a = (AnnotationEMF.ParentAdapter)EcoreUtil.getExistingAdapter((Notifier)obj, (Object)AnnotationEMF.ParentAdapter.PARENT_ANNOTATION_ADAPTER_KEY);
        return a != null ? a.getParentAnnotation() : null;
    }

    public static Annotation addAnnotation(EObject obj) {
        AnnotationEMF annotation = CDMFactory.eINSTANCE.createAnnotationEMF();
        annotation.setAnnotates(obj);
        return annotation;
    }

    public static void snoozeAlarm(EObject obj, ResourceSet rs, HashMap history) {
        if (obj != null && obj.eContainer() != null) {
            history.put(obj, obj);
            InverseMaintenanceAdapter ai = (InverseMaintenanceAdapter)EcoreUtil.getExistingAdapter((Notifier)obj, (Object)InverseMaintenanceAdapter.ADAPTER_KEY);
            if (ai != null) {
                EReference[] refs = ai.getFeatures();
                int sfIdx = 0;
                while (sfIdx < refs.length) {
                    EReference sf = refs[sfIdx];
                    if (!(sf.isContainment() || VCEPostSetCommand.isChildRelationShip((EReference)sf) || sf.getName().equals("initializes") || sf.getName().equals("return"))) {
                        EObject[] list = ai.getReferencedBy(sf);
                        int i = 0;
                        while (i < list.length) {
                            EObject parent = list[i];
                            if (sf.isMany()) {
                                List elements = (List)parent.eGet((EStructuralFeature)sf);
                                elements.set(elements.indexOf(obj), obj);
                            } else {
                                parent.eSet((EStructuralFeature)sf, (Object)obj);
                            }
                            if (history.get(parent) == null) {
                                CodeGenUtil.snoozeAlarm(parent, rs, history);
                            }
                            ++i;
                        }
                    }
                    ++sfIdx;
                }
            }
        }
    }

    public static void eSet(EObject obj, EStructuralFeature sf, EObject val, int index) {
        if (sf.isMany()) {
            List elements = (List)obj.eGet(sf);
            if (index >= 0) {
                if (elements.contains(val)) {
                    elements.set(index, val);
                } else {
                    elements.add(index, val);
                }
            } else {
                elements.add(val);
            }
        } else {
            obj.eSet(sf, (Object)val);
        }
    }

    public static void clearCache() {
        PropertyFeatureMapper.clearCache();
        InstanceVariableCreationRule.clearCache();
        InstanceVariableRule.clearCache();
    }

    public static IEditorStyle getEditorStyle(IBeanDeclModel beanModel) {
        return (IEditorStyle)beanModel.getDomain().getRuleRegistry();
    }

    public static ExpressionDecoderFactory getDecoderFactory(IBeanDeclModel beanModel) {
        EditDomain d = beanModel.getDomain();
        return (ExpressionDecoderFactory)d.getData((Object)"org.eclipse.ve.internal.java.codegen.java.ExpressionDecoderFactory");
    }

    public static MethodGeneratorFactory getMethodTextFactory(IBeanDeclModel beanModel) {
        EditDomain d = beanModel.getDomain();
        return (MethodGeneratorFactory)d.getData((Object)"org.eclipse.ve.internal.java.codegen.java.MethodGeneratorFactory");
    }

    public static boolean propertyCleanup(EObject target, EStructuralFeature sf) {
        EObject p;
        boolean result = false;
        if (target.eIsSet(sf) && (p = (EObject)target.eGet(sf)) != null && p.eContainer() instanceof MemberContainer) {
            MemberContainer c = (MemberContainer)p.eContainer();
            result = c.getProperties().contains((Object)p);
            c.getProperties().remove((Object)p);
        }
        return result;
    }

    public static void logParsingError(String exp, String method, String msg, boolean event) {
        if (JavaVEPlugin.isLoggingLevel((Level)Level.FINE)) {
            String context = event ? "as an event registration" : "as a property setting";
            JavaVEPlugin.log((Object)("\n/**\n Could not parse the following expression " + context + ":\n\t" + method + "(): " + exp + "\n\treason: " + msg + "\n**/\n"), (Level)Level.FINE);
        }
    }

    public static int[] indexOfIgnoringSpace(String main, String find) {
        if (main == null || main.length() < 1 || find == null || find.length() < 1) {
            return new int[]{-1, -1};
        }
        char[] mainTokens = main.toCharArray();
        StringTokenizer tokenizer = new StringTokenizer(find, " \t", false);
        String findS = new String();
        while (tokenizer.hasMoreTokens()) {
            findS = findS.concat(tokenizer.nextToken());
        }
        char[] findTokens = findS.toCharArray();
        int tokenFindStart = -1;
        int tokenFindEnd = -1;
        int mc = 0;
        while (mc < mainTokens.length) {
            if (!Character.isWhitespace(mainTokens[mc])) {
                tokenFindStart = -1;
                tokenFindEnd = -1;
                if (mainTokens[mc] == findTokens[0]) {
                    tokenFindStart = mc;
                    int fc = 0;
                    int nc = 0;
                    nc = mc;
                    while (fc < findTokens.length && nc < mainTokens.length) {
                        if (!Character.isWhitespace(mainTokens[nc])) {
                            if (mainTokens[nc] != findTokens[fc]) break;
                            ++fc;
                        }
                        ++nc;
                    }
                    if (fc == findTokens.length) {
                        tokenFindEnd = nc - 1;
                        break;
                    }
                }
            }
            ++mc;
        }
        if (tokenFindStart > -1 && tokenFindEnd > -1 && tokenFindStart <= tokenFindEnd) {
            return new int[]{tokenFindStart, tokenFindEnd + 1};
        }
        return new int[]{-1, -1};
    }

    public static BeanPart determineParentBeanpart(final BeanPart child) {
        IJavaObjectInstance jo;
        JavaAllocation ja;
        BeanPart[] brefs = child.getBackRefs();
        if (brefs != null) {
            int i = 0;
            while (i < brefs.length) {
                if (brefs[i] != null) {
                    Iterator children = brefs[i].getChildren();
                    while (children.hasNext()) {
                        BeanPart child1 = (BeanPart)children.next();
                        if (!child.equals(child1)) continue;
                        return brefs[i];
                    }
                }
                ++i;
            }
        }
        if (child.getEObject() != null && child.getEObject() instanceof IJavaObjectInstance && (ja = (jo = (IJavaObjectInstance)child.getEObject()).getAllocation()) instanceof ParseTreeAllocation) {
            ParseTreeAllocation pta = (ParseTreeAllocation)ja;
            PTExpression expression = pta.getExpression();
            final BeanPart[] bps = new BeanPart[1];
            NaiveExpressionFlattener bpFinder = new NaiveExpressionFlattener(){

                public boolean visit(PTInstanceReference node) {
                    JavaAllocation alloc;
                    IJavaObjectInstance obj = node.getObject();
                    BeanPart bp = child.getModel().getABean((EObject)obj);
                    if (bp != null) {
                        bps[0] = bp;
                    } else if (obj.isSetAllocation() && (alloc = obj.getAllocation()) instanceof ParseTreeAllocation) {
                        ((ParseTreeAllocation)alloc).getExpression().accept((ParseVisitor)this);
                    }
                    return super.visit(node);
                }
            };
            expression.accept((ParseVisitor)bpFinder);
            if (bps[0] != null) {
                return bps[0];
            }
        }
        return null;
    }
}

