/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeHierarchyChangedListener;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jem.internal.adapters.jdom.JavaModelListener;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class TypeResolver {
    private static final Object MAIN_TYPE = new Object();
    private static final Object SUPER_TYPE = new Object();
    private static final Map STANDARD = new HashMap();
    protected List importDecls;
    protected Map namesToResolvedTypes = new HashMap(STANDARD);
    private ITypeHierarchy mainTypeHierarchy;
    private ResolvedType resolvedMain;
    protected IType mainType;
    private static final IType[] EMPTY_ALL_SUPER_TYPES;
    private IType[] allSuperTypes;
    protected String mainPackageName;
    protected IJavaProject javaProject;
    protected ITypeHierarchyChangedListener hierarchyChangedListener = new ITypeHierarchyChangedListener(){

        public void typeHierarchyChanged(ITypeHierarchy typeHierarchy) {
            TypeResolver.this.markRefreshHierarchyNeeded();
        }
    };
    protected JavaModelListener modelListener;
    private boolean[] triedHierarchyCreate = new boolean[1];
    private boolean needHierarchyRefresh = true;
    private static final String[] EMPTY_FIELD_ACCESSORS;

    static {
        STANDARD.put("int", new ResolvedType(null, "int"));
        STANDARD.put("float", new ResolvedType(null, "float"));
        STANDARD.put("double", new ResolvedType(null, "double"));
        STANDARD.put("short", new ResolvedType(null, "short"));
        STANDARD.put("long", new ResolvedType(null, "long"));
        STANDARD.put("boolean", new ResolvedType(null, "boolean"));
        STANDARD.put("byte", new ResolvedType(null, "byte"));
        STANDARD.put("char", new ResolvedType(null, "char"));
        STANDARD.put("void", new ResolvedType(null, "void"));
        EMPTY_ALL_SUPER_TYPES = new IType[0];
        EMPTY_FIELD_ACCESSORS = new String[0];
    }

    private void markRefreshHierarchyNeeded() {
        boolean[] blArray = this.triedHierarchyCreate;
        synchronized (this.triedHierarchyCreate) {
            this.needHierarchyRefresh = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public TypeResolver(IImportDeclaration[] importDecls, IType mainType) {
        this(mainType);
        this.importDecls = new ArrayList(importDecls.length + 1);
        boolean javalangExists = false;
        int i = 0;
        while (i < importDecls.length) {
            if (importDecls[i].getElementName().equals("java.lang.*")) {
                javalangExists = true;
            }
            this.importDecls.add(new ImportDecl(importDecls[i], this.javaProject));
            ++i;
        }
        if (!javalangExists) {
            this.importDecls.add(new ImportDecl("java.lang"));
        }
    }

    public TypeResolver(List importDecls, IType mainType) {
        this(mainType);
        int size = importDecls.size();
        this.importDecls = new ArrayList(size + 1);
        boolean javalangExists = false;
        int i = 0;
        while (i < size) {
            ImportDeclaration importDeclaration = (ImportDeclaration)importDecls.get(i);
            if (importDeclaration.isOnDemand() && importDeclaration.getName().getFullyQualifiedName().equals("java.lang")) {
                javalangExists = true;
            }
            this.importDecls.add(new ImportDecl(importDeclaration, this.javaProject));
            ++i;
        }
        if (!javalangExists) {
            this.importDecls.add(new ImportDecl("java.lang"));
        }
    }

    protected TypeResolver(IType mainType) {
        this.mainType = mainType;
        this.resolvedMain = new ResolvedType(mainType, mainType.getFullyQualifiedName());
        this.namesToResolvedTypes.put(mainType.getElementName(), this.resolvedMain);
        this.mainPackageName = mainType.getPackageFragment().getElementName();
        this.javaProject = mainType.getJavaProject();
        this.modelListener = new JavaModelListener(5){
            private ThreadLocal blastAll = new ThreadLocal();
            private ThreadLocal removedElements = new ThreadLocal();
            private ThreadLocal removedImportDecls = new ThreadLocal();

            protected IJavaProject getJavaProject() {
                return TypeResolver.this.javaProject;
            }

            public void processDelta(IJavaElementDelta delta) {
                IJavaElement element = delta.getElement();
                switch (element.getElementType()) {
                    case 12: {
                        this.processJavaElementChanged((IImportContainer)element, delta);
                        break;
                    }
                    case 13: {
                        this.processJavaElementChanged((IImportDeclaration)element, delta);
                        break;
                    }
                    default: {
                        super.processDelta(delta);
                    }
                }
            }

            protected void processJavaElementChanged(IImportContainer element, IJavaElementDelta delta) {
                switch (delta.getKind()) {
                    case 2: {
                        TypeResolver.this.clearAllImports();
                        break;
                    }
                    case 1: {
                        TypeResolver.this.refreshImportContainer();
                        break;
                    }
                    case 4: {
                        this.processChildren((IJavaElement)element, delta);
                    }
                }
            }

            protected void processJavaElementChanged(IImportDeclaration element, IJavaElementDelta delta) {
                switch (delta.getKind()) {
                    case 2: {
                        this.getRemovedImportDecls().add(element);
                        break;
                    }
                    case 1: {
                        TypeResolver.this.addImport(element);
                        break;
                    }
                }
            }

            protected void processJavaElementChanged(ICompilationUnit element, IJavaElementDelta delta) {
                switch (delta.getKind()) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        this.getRemovedElements().add((IJavaElement)element);
                        break;
                    }
                    case 4: {
                        if ((delta.getFlags() & 8) > 0) {
                            this.processChildren((IJavaElement)element, delta);
                            break;
                        }
                        if ((delta.getFlags() & 0x4001) != 1) break;
                        this.getRemovedElements().add((IJavaElement)element);
                        if (!element.equals(TypeResolver.this.mainType.getCompilationUnit())) break;
                        TypeResolver.this.markRefreshHierarchyNeeded();
                        TypeResolver.this.refreshImportContainer();
                    }
                }
            }

            protected void processJavaElementChanged(IJavaProject element, IJavaElementDelta delta) {
                if (this.isBlastAll()) {
                    return;
                }
                if (this.isInClasspath(element)) {
                    switch (delta.getKind()) {
                        case 2: {
                            this.setBlastAll();
                            return;
                        }
                        case 4: {
                            if ((delta.getFlags() & 0x400) != 0) {
                                this.setBlastAll();
                                return;
                            }
                            if (this.isClasspathResourceChange(delta)) {
                                this.setBlastAll();
                                return;
                            }
                            this.processChildren((IJavaElement)element, delta);
                            break;
                        }
                        case 1: {
                            return;
                        }
                    }
                }
            }

            protected void processJavaElementChanged(IPackageFragmentRoot element, IJavaElementDelta delta) {
                switch (delta.getKind()) {
                    case 4: {
                        if ((delta.getFlags() & 0x8000) != 0) {
                            this.getRemovedElements().add((IJavaElement)element);
                            break;
                        }
                        this.processChildren((IJavaElement)element, delta);
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        this.setBlastAll();
                    }
                }
            }

            protected void processJavaElementChanged(IPackageFragment element, IJavaElementDelta delta) {
                switch (delta.getKind()) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        this.getRemovedElements().add((IJavaElement)element);
                        break;
                    }
                    case 4: {
                        this.processChildren((IJavaElement)element, delta);
                    }
                }
            }

            protected void processJavaElementChanged(IClassFile element, IJavaElementDelta delta) {
                switch (delta.getKind()) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        this.getRemovedElements().add((IJavaElement)element);
                        break;
                    }
                    case 4: {
                        this.processChildren((IJavaElement)element, delta);
                    }
                }
            }

            protected void processJavaElementChanged(IType element, IJavaElementDelta delta) {
                switch (delta.getKind()) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        this.getRemovedElements().add((IJavaElement)element);
                        break;
                    }
                    case 4: {
                        if ((delta.getFlags() & 0x800) != 0 && element.equals(TypeResolver.this.mainType)) {
                            TypeResolver.this.markRefreshHierarchyNeeded();
                        }
                        this.processChildren((IJavaElement)element, delta);
                    }
                }
            }

            private boolean isBlastAll() {
                return this.blastAll.get() != null;
            }

            private void setBlastAll() {
                this.blastAll.set(Boolean.TRUE);
                this.removedElements.set(null);
            }

            private IRegion getRemovedElements() {
                IRegion region = (IRegion)this.removedElements.get();
                if (region == null) {
                    region = JavaCore.newRegion();
                    this.removedElements.set(region);
                }
                return region;
            }

            private List getRemovedImportDecls() {
                ArrayList removed = (ArrayList)this.removedImportDecls.get();
                if (removed == null) {
                    removed = new ArrayList(1);
                    this.removedImportDecls.set(removed);
                }
                return removed;
            }

            public void elementChanged(ElementChangedEvent event) {
                this.blastAll.set(null);
                this.removedElements.set(null);
                this.removedImportDecls.set(null);
                super.elementChanged(event);
                if (this.isBlastAll()) {
                    TypeResolver.this.clearAllResolved();
                } else {
                    if (this.removedElements.get() != null) {
                        TypeResolver.this.clearRegion((IRegion)this.removedElements.get());
                    }
                    if (this.removedImportDecls.get() != null) {
                        TypeResolver.this.processRemovedImports(this.getRemovedImportDecls());
                    }
                }
                this.blastAll.set(null);
                this.removedElements.set(null);
                this.removedImportDecls.set(null);
            }
        };
    }

    private synchronized void addImport(IImportDeclaration iid) {
        String importName;
        String string = importName = iid.isOnDemand() ? iid.getElementName().substring(0, iid.getElementName().length() - 2) : iid.getElementName();
        if (iid.isOnDemand() && importName.equals("java.lang")) {
            return;
        }
        int i = 0;
        while (i < this.importDecls.size()) {
            ImportDecl id = (ImportDecl)this.importDecls.get(i);
            if (iid.isOnDemand() == id.isOnDemand() && id.getFullyQualifiedName().equals(importName)) {
                return;
            }
            ++i;
        }
        this.importDecls.add(new ImportDecl(iid, this.javaProject));
    }

    public synchronized void addImport(String importName, boolean onDemand) {
        if (onDemand && importName.equals("java.lang")) {
            return;
        }
        int i = 0;
        while (i < this.importDecls.size()) {
            ImportDecl id = (ImportDecl)this.importDecls.get(i);
            if (onDemand == id.isOnDemand() && id.getFullyQualifiedName().equals(importName)) {
                return;
            }
            ++i;
        }
        this.importDecls.add(new ImportDecl(importName, onDemand, this.javaProject));
    }

    private synchronized void clearAllResolved() {
        this.namesToResolvedTypes.clear();
        this.namesToResolvedTypes.putAll(STANDARD);
        int i = 0;
        while (i < this.importDecls.size()) {
            ImportDecl id = (ImportDecl)this.importDecls.get(i);
            if (id.isResolved()) {
                id.clearResolved();
            }
            ++i;
        }
    }

    private synchronized void clearRegion(IRegion region) {
        Iterator itr = this.namesToResolvedTypes.values().iterator();
        while (itr.hasNext()) {
            ResolvedType rt = (ResolvedType)itr.next();
            if (rt.type == null || !region.contains((IJavaElement)rt.type)) continue;
            itr.remove();
        }
        int i = 0;
        while (i < this.importDecls.size()) {
            ImportDecl id = (ImportDecl)this.importDecls.get(i);
            if (id.isResolved() && id.getResolvedType() != null && region.contains((IJavaElement)id.getResolvedType())) {
                id.clearResolved();
            }
            ++i;
        }
    }

    private synchronized void refreshImportContainer() {
        IImportContainer ic = this.mainType.getCompilationUnit().getImportContainer();
        if (!ic.exists()) {
            this.clearAllImports();
        } else {
            try {
                IJavaElement[] imports = ic.getChildren();
                ArrayList<ImportDecl> newContainer = new ArrayList<ImportDecl>(imports.length + 1);
                boolean javalangExists = false;
                int i = 0;
                while (i < imports.length) {
                    String importName;
                    IImportDeclaration iid = (IImportDeclaration)imports[i];
                    String string = importName = iid.isOnDemand() ? iid.getElementName().substring(0, iid.getElementName().length() - 2) : iid.getElementName();
                    if (iid.isOnDemand() && importName.equals("java.lang")) {
                        javalangExists = true;
                    }
                    boolean movedit = false;
                    int j = 0;
                    while (j < this.importDecls.size()) {
                        ImportDecl id = (ImportDecl)this.importDecls.get(j);
                        if (iid.isOnDemand() == id.isOnDemand() && importName.equals(id.getFullyQualifiedName())) {
                            newContainer.add(id);
                            this.importDecls.remove(j);
                            movedit = true;
                            break;
                        }
                        ++j;
                    }
                    if (!movedit) {
                        newContainer.add(new ImportDecl(iid, this.javaProject));
                    }
                    ++i;
                }
                if (!javalangExists) {
                    i = 0;
                    while (i < this.importDecls.size()) {
                        ImportDecl id = (ImportDecl)this.importDecls.get(i);
                        if (id.isOnDemand() && id.getFullyQualifiedName().equals("java.lang")) {
                            newContainer.add(id);
                            this.importDecls.remove(i);
                            break;
                        }
                        ++i;
                    }
                }
                if (!this.importDecls.isEmpty()) {
                    this.clearSpecificImports(this.importDecls);
                }
                this.importDecls = newContainer;
            }
            catch (JavaModelException e) {
                JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
                this.clearAllImports();
            }
        }
    }

    private synchronized void processRemovedImports(List removedImports) {
        ArrayList<ImportDecl> toClear = new ArrayList<ImportDecl>(removedImports.size());
        Iterator itr = this.importDecls.iterator();
        block0: while (itr.hasNext() && !removedImports.isEmpty()) {
            ImportDecl id = (ImportDecl)itr.next();
            Iterator itrr = removedImports.iterator();
            while (itrr.hasNext()) {
                IImportDeclaration iid = (IImportDeclaration)itrr.next();
                if (id.isOnDemand() != iid.isOnDemand()) continue;
                boolean foundit = false;
                if (id.isOnDemand()) {
                    if (id.getFullyQualifiedName().equals(iid.getElementName().substring(0, iid.getElementName().length() - 2))) {
                        foundit = true;
                    }
                } else if (id.getFullyQualifiedName().equals(iid.getElementName())) {
                    foundit = true;
                }
                if (!foundit) continue;
                toClear.add(id);
                itr.remove();
                itrr.remove();
                continue block0;
            }
        }
        this.clearSpecificImports(toClear);
    }

    private void clearSpecificImports(List toClear) {
        Iterator itr = this.namesToResolvedTypes.values().iterator();
        while (itr.hasNext()) {
            ResolvedType rt = (ResolvedType)itr.next();
            if (!(rt.resolvedThru instanceof ImportDecl) || !toClear.contains(rt.resolvedThru)) continue;
            itr.remove();
        }
    }

    private void clearAllImports() {
        Iterator itr = this.namesToResolvedTypes.values().iterator();
        while (itr.hasNext()) {
            ResolvedType rt = (ResolvedType)itr.next();
            if (!(rt.resolvedThru instanceof ImportDecl) || ((ImportDecl)rt.resolvedThru).getFullyQualifiedName().equals("java.lang")) continue;
            itr.remove();
        }
        ImportDecl jl = null;
        int i = 0;
        while (i < this.importDecls.size()) {
            if (((ImportDecl)this.importDecls.get(i)).getFullyQualifiedName().equals("java.lang")) {
                jl = (ImportDecl)this.importDecls.get(i);
                break;
            }
            ++i;
        }
        this.importDecls.clear();
        this.importDecls.add(jl);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public synchronized ITypeHierarchy getMainTypeHierarchy() {
        doRefresh = false;
        var2_2 = this.triedHierarchyCreate;
        // MONITORENTER : this.triedHierarchyCreate
        doRefresh = this.needHierarchyRefresh;
        this.needHierarchyRefresh = false;
        // MONITOREXIT : var2_2
        if (true) ** GOTO lbl47
        do {
            this.allSuperTypes = TypeResolver.EMPTY_ALL_SUPER_TYPES;
            if (!this.triedHierarchyCreate[0]) {
                try {
                    this.triedHierarchyCreate[0] = true;
                    this.mainTypeHierarchy = this.mainType.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                    this.mainTypeHierarchy.addTypeHierarchyChangedListener(this.hierarchyChangedListener);
                    this.allSuperTypes = this.mainTypeHierarchy.getAllSupertypes(this.mainType);
                }
                catch (JavaModelException e) {
                    JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
                }
            } else if (this.mainTypeHierarchy != null) {
                try {
                    this.mainTypeHierarchy.refresh((IProgressMonitor)new NullProgressMonitor());
                    this.allSuperTypes = this.mainTypeHierarchy.getAllSupertypes(this.mainType);
                    resolvedItr = this.namesToResolvedTypes.values().iterator();
                    while (resolvedItr.hasNext()) {
                        rt = (ResolvedType)resolvedItr.next();
                        if (rt.resolvedThru != TypeResolver.SUPER_TYPE) continue;
                        resolvedItr.remove();
                    }
                }
                catch (JavaModelException e) {
                    JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
                }
            }
            var2_2 = this.triedHierarchyCreate;
            // MONITORENTER : this.triedHierarchyCreate
            doRefresh = this.needHierarchyRefresh;
            this.needHierarchyRefresh = false;
            // MONITOREXIT : var2_2
lbl47:
            // 2 sources

        } while (doRefresh);
        return this.mainTypeHierarchy;
    }

    public void dispose() {
        if (this.mainTypeHierarchy != null) {
            this.mainTypeHierarchy.removeTypeHierarchyChangedListener(this.hierarchyChangedListener);
            this.mainTypeHierarchy = null;
        }
        if (this.modelListener != null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this.modelListener);
        }
    }

    protected ResolvedType resolveSimpleType(String simpleName) {
        try {
            ResolvedType resolved = (ResolvedType)this.namesToResolvedTypes.get(simpleName);
            if (resolved != null) {
                return resolved;
            }
            if (this.getMainTypeHierarchy() == null) {
                return null;
            }
            IType innerClass = this.findType(this.mainType, simpleName);
            if (innerClass != null) {
                return this.addToResolvedMain(simpleName, innerClass);
            }
            IType[] lclAllSuperTypes = this.getAllSuperTypes();
            int i = 0;
            while (i < lclAllSuperTypes.length) {
                innerClass = this.findType(lclAllSuperTypes[i], simpleName);
                if (innerClass != null) {
                    return this.addToResolvedSuperList(simpleName, innerClass);
                }
                ++i;
            }
            int s = this.importDecls.size();
            int i2 = 0;
            while (i2 < s) {
                ImportDecl id = (ImportDecl)this.importDecls.get(i2);
                if (!id.isOnDemand() && id.getLastQualifier().equals(simpleName)) {
                    IType resolvedType = this.javaProject.findType(id.getFullyQualifiedName());
                    return resolvedType != null ? this.addToResolved(id, id.getLastQualifier(), resolvedType) : null;
                }
                ++i2;
            }
            IType type = this.javaProject.findType(this.mainPackageName, simpleName);
            if (type != null) {
                return this.addToResolved(simpleName, type);
            }
            int i3 = 0;
            while (i3 < s) {
                ImportDecl id = (ImportDecl)this.importDecls.get(i3);
                if (id.isOnDemand()) {
                    IType resolver;
                    if (!id.isResolved()) {
                        id.resolveIt(this.javaProject);
                    }
                    if (!((resolver = id.getResolvedType()) != null ? (type = this.findType(resolver, simpleName)) == null : (type = this.javaProject.findType(id.getFullyQualifiedName(), simpleName)) == null)) {
                        return this.addToResolved(id, simpleName, type);
                    }
                }
                ++i3;
            }
            return null;
        }
        catch (JavaModelException e) {
            JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
            return null;
        }
    }

    private IType findType(IType outerType, String innerTypeName) throws JavaModelException {
        IJavaElement[] children = outerType.getChildren();
        int i = 0;
        while (i < children.length) {
            IType t;
            if (children[i].getElementType() == 7 && (t = (IType)children[i]).getElementName().equals(innerTypeName)) {
                return t;
            }
            ++i;
        }
        return null;
    }

    private ResolvedType addToResolved(String simpleName, IType resolvedType) {
        ResolvedType result = new ResolvedType(resolvedType);
        this.namesToResolvedTypes.put(simpleName, result);
        return result;
    }

    private ResolvedType addToResolved(NamesList namesList, IType resolvedType) {
        ResolvedType result = new ResolvedType(resolvedType);
        this.namesToResolvedTypes.put(new NamesList(namesList), result);
        return result;
    }

    private ResolvedType addToResolved(ImportDecl importDecl, String simpleName, IType resolvedType) {
        ResolvedType rt = this.addToResolved(simpleName, resolvedType);
        rt.resolvedThru = importDecl;
        return rt;
    }

    private ResolvedType addToResolved(ResolvedType resolvedFrom, NamesList namesList, IType resolvedType) {
        ResolvedType rt = this.addToResolved(namesList, resolvedType);
        rt.resolvedThru = resolvedFrom.resolvedThru;
        return rt;
    }

    private ResolvedType addToResolvedMain(String simpleName, IType type) {
        ResolvedType rt = this.addToResolved(simpleName, type);
        rt.resolvedThru = MAIN_TYPE;
        return rt;
    }

    private ResolvedType addToResolvedSuperList(String simpleName, IType type) {
        ResolvedType rt = this.addToResolved(simpleName, type);
        rt.resolvedThru = SUPER_TYPE;
        return rt;
    }

    public FieldResolvedType resolveWithPossibleField(Name name) {
        this.getMainTypeHierarchy();
        if (name.isSimpleName()) {
            ResolvedType rt = this.resolveSimpleType(((SimpleName)name).getIdentifier());
            return rt != null ? new FieldResolvedType(rt, EMPTY_FIELD_ACCESSORS) : null;
        }
        ResolvedType rt = (ResolvedType)this.namesToResolvedTypes.get(name.getFullyQualifiedName());
        if (rt != null) {
            return new FieldResolvedType(rt, EMPTY_FIELD_ACCESSORS);
        }
        NamesList names = this.decomposeName(name);
        return this.resolveWithPossibleField(names);
    }

    public FieldResolvedType resolveWithPossibleField(String name) {
        this.getMainTypeHierarchy();
        if (name.indexOf(46) == -1) {
            ResolvedType rt = this.resolveSimpleType(name);
            return rt != null ? new FieldResolvedType(rt, EMPTY_FIELD_ACCESSORS) : null;
        }
        ResolvedType rt = (ResolvedType)this.namesToResolvedTypes.get(name);
        if (rt != null) {
            return new FieldResolvedType(rt, EMPTY_FIELD_ACCESSORS);
        }
        NamesList names = this.decomposeName(name);
        return this.resolveWithPossibleField(names);
    }

    private FieldResolvedType resolveWithPossibleField(NamesList names) {
        ResolvedType rt = this.resolve(names);
        String[] fieldAccessors = EMPTY_FIELD_ACCESSORS;
        if (rt != null && names.getTestSize() != names.size()) {
            fieldAccessors = new String[names.size() - names.getTestSize()];
            int fromIndex = fieldAccessors.length;
            int i = 0;
            while (i < fieldAccessors.length) {
                fieldAccessors[i] = (String)names.get(--fromIndex);
                ++i;
            }
        }
        return rt != null ? new FieldResolvedType(rt, fieldAccessors) : null;
    }

    private NamesList decomposeName(Name name) {
        NamesList names = new NamesList(3);
        return this.decomposeName(name, names);
    }

    private NamesList decomposeName(Name name, NamesList names) {
        while (true) {
            if (name.isSimpleName()) break;
            QualifiedName qn = (QualifiedName)name;
            names.add(qn.getName().getIdentifier());
            name = qn.getQualifier();
        }
        names.add(((SimpleName)name).getIdentifier());
        names.setTestSize(names.size());
        return names;
    }

    private NamesList decomposeName(String name) {
        StringTokenizer st = new StringTokenizer(name, ".");
        NamesList names = new NamesList(st.countTokens());
        while (st.hasMoreTokens()) {
            names.add(0, st.nextToken());
        }
        names.setTestSize(names.size());
        return names;
    }

    private NamesList decomposeType(QualifiedType qtype) {
        NamesList names = new NamesList(3);
        QualifiedType type = qtype;
        while (true) {
            if (type.isSimpleType()) break;
            if (!type.isQualifiedType()) continue;
            QualifiedType qt = type;
            names.add(qt.getName().getIdentifier());
            type = qt.getQualifier();
        }
        this.decomposeName(((SimpleType)type).getName(), names);
        names.setTestSize(names.size());
        return names;
    }

    public ResolvedType resolveType(Name name) {
        this.getMainTypeHierarchy();
        if (name.isSimpleName()) {
            return this.resolveSimpleType(((SimpleName)name).getIdentifier());
        }
        ResolvedType rt = (ResolvedType)this.namesToResolvedTypes.get(name.getFullyQualifiedName());
        if (rt != null) {
            return rt;
        }
        NamesList names = this.decomposeName(name);
        return this.resolveType(names);
    }

    public Resolved resolveType(Type type) {
        this.getMainTypeHierarchy();
        if (type.isSimpleType()) {
            return this.resolveType(((SimpleType)type).getName());
        }
        if (type.isPrimitiveType()) {
            return this.resolveSimpleType(((PrimitiveType)type).getPrimitiveTypeCode().toString());
        }
        if (type.isArrayType()) {
            int dims;
            ArrayType at = (ArrayType)type;
            ResolvedType finalType = (ResolvedType)this.resolveType(at.getElementType());
            if (finalType == null) {
                return null;
            }
            StringBuffer st = new StringBuffer(finalType.getName());
            int rdims = dims = at.getDimensions();
            while (dims-- > 0) {
                st.append("[]");
            }
            return new ResolvedArrayType(finalType, rdims, st.toString());
        }
        if (type.isQualifiedType()) {
            return this.resolveType(this.decomposeType((QualifiedType)type));
        }
        return null;
    }

    public ResolvedType resolveType(String name) {
        this.getMainTypeHierarchy();
        if (name.indexOf(46) == -1) {
            return this.resolveSimpleType(name);
        }
        ResolvedType rt = (ResolvedType)this.namesToResolvedTypes.get(name);
        if (rt != null) {
            return rt;
        }
        NamesList names = this.decomposeName(name);
        return this.resolveType(names);
    }

    private ResolvedType resolveType(NamesList names) {
        ResolvedType rt = this.resolve(names);
        if (rt != null && names.getTestSize() != names.size()) {
            return null;
        }
        return rt;
    }

    /*
     * Unable to fully structure code
     */
    private ResolvedType resolve(NamesList names) {
        try {
            tSize = namesSize = names.size();
            names.setTestSize(tSize);
            rt = (ResolvedType)this.namesToResolvedTypes.get(names);
            if (rt == null) ** GOTO lbl9
            return rt;
lbl-1000:
            // 1 sources

            {
                names.setTestSize(tSize);
                rt = (ResolvedType)this.namesToResolvedTypes.get(names);
lbl9:
                // 2 sources

                ** while (rt == null && --tSize > 1)
            }
lbl10:
            // 1 sources

            if (rt == null) {
                namesIndex = namesSize - 1;
                names.setTestSize(1);
                rt = this.resolveSimpleType((String)names.get(namesIndex));
                if (rt == null) {
                    pkgBuild = new StringBuffer();
                    namesTestSize = 1;
                    while (namesIndex >= 1) {
                        pkgBuild.append((String)names.get(namesIndex));
                        type = this.javaProject.findType(pkgBuild.toString(), (String)names.get(--namesIndex));
                        ++namesTestSize;
                        if (type != null) {
                            names.setTestSize(namesTestSize);
                            rt = this.addToResolved(names, type);
                            break;
                        }
                        pkgBuild.append('.');
                    }
                    if (rt == null) {
                        return null;
                    }
                }
            }
            namesTestSize = names.getTestSize();
            namesIndex = namesSize - namesTestSize - 1;
            while (namesIndex >= 0) {
                typeName = (String)names.get(namesIndex);
                type = this.findType(ResolvedType.access$0(rt), typeName);
                if (type == null) break;
                names.setTestSize(++namesTestSize);
                rt = this.addToResolved(rt, names, type);
                --namesIndex;
            }
            return rt;
        }
        catch (JavaModelException e) {
            JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
            return null;
        }
    }

    public ResolvedType resolveMain() {
        return this.resolvedMain;
    }

    protected IType[] getAllSuperTypes() {
        this.getMainTypeHierarchy();
        return this.allSuperTypes;
    }

    public static abstract class Resolved {
        public abstract String getName();
    }

    public static class ResolvedType
    extends Resolved {
        private final IType type;
        private final String name;
        Object resolvedThru;

        ResolvedType(IType type, String name) {
            this.type = type;
            this.name = name;
        }

        ResolvedType(IType type) {
            this.type = type;
            this.name = type.getFullyQualifiedName();
        }

        public final String getName() {
            return this.name;
        }

        public final IType getIType() {
            return this.type;
        }
    }

    public static class ResolvedArrayType
    extends Resolved {
        private final ResolvedType finalType;
        private final String name;
        private final int dimensions;

        ResolvedArrayType(ResolvedType finalType, int dimensions, String name) {
            this.finalType = finalType;
            this.dimensions = dimensions;
            this.name = name;
        }

        public final String getName() {
            return this.name;
        }

        public final ResolvedType getFinalType() {
            return this.finalType;
        }

        public final int getDimensions() {
            return this.dimensions;
        }
    }

    private static class ImportDecl {
        private final String fullyQualifiedName;
        private final String lastQualifier;
        private IType resolvedType;
        private boolean hasResolved;

        public ImportDecl(IImportDeclaration importDecl, IJavaProject javaproject) {
            String fq = importDecl.getElementName();
            if (importDecl.isOnDemand()) {
                this.fullyQualifiedName = fq.substring(0, fq.length() - 2);
                this.lastQualifier = null;
                this.resolveIt(javaproject);
            } else {
                this.fullyQualifiedName = fq;
                int ndx = fq.lastIndexOf(46);
                this.lastQualifier = fq.substring(ndx + 1);
            }
        }

        public ImportDecl(ImportDeclaration importDecl, IJavaProject javaProject) {
            this.fullyQualifiedName = importDecl.getName().getFullyQualifiedName();
            if (importDecl.isOnDemand()) {
                this.lastQualifier = null;
                this.resolveIt(javaProject);
            } else {
                this.lastQualifier = ((QualifiedName)importDecl.getName()).getName().getIdentifier();
            }
        }

        ImportDecl(String fullyQualified) {
            this(fullyQualified, true, null);
        }

        ImportDecl(String fullyQualified, boolean onDemand, IJavaProject javaProject) {
            this.fullyQualifiedName = fullyQualified;
            if (onDemand) {
                this.lastQualifier = null;
                if (javaProject != null) {
                    this.resolveIt(javaProject);
                }
            } else {
                int ndx = fullyQualified.lastIndexOf(46);
                this.lastQualifier = fullyQualified.substring(ndx + 1);
            }
        }

        public boolean isOnDemand() {
            return this.lastQualifier == null;
        }

        public String getFullyQualifiedName() {
            return this.fullyQualifiedName;
        }

        public String getLastQualifier() {
            return this.lastQualifier;
        }

        public void resolveIt(IJavaProject javaProject) {
            try {
                this.hasResolved = true;
                IType type = javaProject.findType(this.fullyQualifiedName);
                if (type != null) {
                    this.resolvedType = type;
                }
            }
            catch (JavaModelException e) {
                JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
            }
        }

        public void clearResolved() {
            this.resolvedType = null;
            this.hasResolved = false;
        }

        public boolean isResolved() {
            return this.hasResolved;
        }

        public IType getResolvedType() {
            return this.resolvedType;
        }
    }

    public static class FieldResolvedType {
        public final ResolvedType resolvedType;
        public final String[] fieldAccessors;

        FieldResolvedType(ResolvedType resolvedType, String[] fieldAccessors) {
            this.resolvedType = resolvedType;
            this.fieldAccessors = fieldAccessors;
        }
    }

    private static class NamesList
    extends ArrayList {
        int testSize;

        public NamesList(int initialCapacity) {
            super(initialCapacity);
        }

        public NamesList(NamesList c) {
            super(c.getTestSize());
            int size = c.size();
            int index = size - c.getTestSize();
            while (index < size) {
                this.add(c.get(index));
                ++index;
            }
            this.setTestSize(c.getTestSize());
        }

        /*
         * Unable to fully structure code
         */
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NamesList)) {
                return super.equals(o);
            }
            other = (NamesList)o;
            if (this.testSize != other.testSize) {
                return false;
            }
            thisIndex = this.size();
            thisStop = thisIndex - this.testSize;
            otherIndex = other.size();
            if (thisStop >= 0 && other.testSize <= otherIndex) ** GOTO lbl15
            return false;
lbl-1000:
            // 1 sources

            {
                if (this.get(thisIndex).equals(other.get(--otherIndex))) continue;
                return false;
lbl15:
                // 2 sources

                ** while (--thisIndex >= thisStop)
            }
lbl16:
            // 1 sources

            return true;
        }

        public int hashCode() {
            int hashCode = 1;
            int testIndex = this.size();
            int testStop = testIndex - this.testSize;
            if (testStop < 0) {
                testStop = 0;
            }
            while (--testIndex >= testStop) {
                hashCode = 31 * hashCode + this.get(testIndex).hashCode();
            }
            return hashCode;
        }

        public int getTestSize() {
            return this.testSize;
        }

        public void setTestSize(int testSize) {
            this.testSize = testSize;
        }
    }
}

