/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.choosebean;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredList;
import org.eclipse.ve.internal.java.choosebean.ChooseBeanMessages;
import org.eclipse.ve.internal.java.choosebean.IChooseBeanContributor;
import org.eclipse.ve.internal.java.choosebean.TypeFilterMatcher;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class YesNoListChooseBeanContributor
implements IChooseBeanContributor {
    private String name = null;
    private String[] yesTypes = null;
    private String[] noTypes = null;
    private List yesTypeFQNs = null;
    private List noTypeFQNs = null;
    private IJavaProject javaProject = null;
    private FilteredList.FilterMatcher filter = null;

    public YesNoListChooseBeanContributor(String name, String[] yesTypes, String[] noTypes) {
        this.name = name;
        this.yesTypes = yesTypes;
        this.noTypes = noTypes;
    }

    public String getName() {
        return this.name;
    }

    public FilteredList.FilterMatcher getFilter(IJavaProject javaProject) {
        if (this.filter == null) {
            this.setJavaProject(javaProject);
            this.setFilter(this.createFilterMatcher());
        }
        return this.filter;
    }

    protected FilteredList.FilterMatcher createFilterMatcher() {
        return new TypeFilterMatcher(this.getYesTypeFQNs(), this.getNoTypeFQNs());
    }

    public List getNoTypeFQNs() {
        if (this.noTypeFQNs == null) {
            this.noTypeFQNs = this.getSubTypes(this.noTypes);
        }
        return this.noTypeFQNs;
    }

    public void setNoFQNs(List noTypeFQNs) {
        this.noTypeFQNs = noTypeFQNs;
    }

    protected List getSubTypes(final String[] types) {
        if (types == null) {
            return Collections.EMPTY_LIST;
        }
        final ArrayList subTypesList = new ArrayList();
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor pm) throws InterruptedException {
                    pm.beginTask(ChooseBeanMessages.getString("YesNoListChooseBeanContributor.0"), 100 * (types.length / 2));
                    int c = 0;
                    while (c < types.length) {
                        if (pm.isCanceled()) {
                            throw new InterruptedException();
                        }
                        try {
                            IType baseClass = YesNoListChooseBeanContributor.this.getJavaProject().findType(types[c], types[c + 1]);
                            if (baseClass != null) {
                                int stc;
                                ITypeHierarchy th = baseClass.newTypeHierarchy(YesNoListChooseBeanContributor.this.getJavaProject(), (IProgressMonitor)new SubProgressMonitor(pm, 100));
                                IType[] subTypes = null;
                                if (baseClass.isClass()) {
                                    subTypes = th.getAllSubtypes(baseClass);
                                } else if (baseClass.isInterface()) {
                                    subTypes = th.getAllSubtypes(baseClass);
                                    stc = 0;
                                    while (stc < subTypes.length) {
                                        subTypesList.add(subTypes[stc].getFullyQualifiedName());
                                        ++stc;
                                    }
                                    int i = 0;
                                    while (i < subTypes.length) {
                                        IType[] implementors = th.getAllSubtypes(subTypes[i]);
                                        int stc2 = 0;
                                        while (stc2 < implementors.length) {
                                            subTypesList.add(implementors[stc2].getFullyQualifiedName());
                                            ++stc2;
                                        }
                                        ++i;
                                    }
                                }
                                subTypesList.add(baseClass.getFullyQualifiedName());
                                stc = 0;
                                while (stc < subTypes.length) {
                                    subTypesList.add(subTypes[stc].getFullyQualifiedName());
                                    ++stc;
                                }
                            }
                        }
                        catch (JavaModelException e) {
                            JavaVEPlugin.log(e, Level.WARNING);
                        }
                        c += 2;
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            JavaVEPlugin.log(e.getCause(), Level.WARNING);
        }
        catch (InterruptedException interruptedException) {}
        return subTypesList;
    }

    public List getYesTypeFQNs() {
        if (this.yesTypeFQNs == null) {
            this.yesTypeFQNs = this.getSubTypes(this.yesTypes);
        }
        return this.yesTypeFQNs;
    }

    public void setYesTypeFQNs(List yesTypeFQNs) {
        this.yesTypeFQNs = yesTypeFQNs;
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public void setJavaProject(IJavaProject javaProject) {
        this.javaProject = javaProject;
    }

    public void setFilter(FilteredList.FilterMatcher filter) {
        this.filter = filter;
    }
}

