/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.core;

import java.text.MessageFormat;
import java.util.logging.Level;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jem.internal.instantiation.ImplicitAllocation;
import org.eclipse.jem.internal.instantiation.InitStringAllocation;
import org.eclipse.jem.internal.instantiation.InstantiationPackage;
import org.eclipse.jem.internal.instantiation.JavaAllocation;
import org.eclipse.jem.internal.instantiation.PTExpression;
import org.eclipse.jem.internal.instantiation.PTInstanceReference;
import org.eclipse.jem.internal.instantiation.PTMethodInvocation;
import org.eclipse.jem.internal.instantiation.PTThisLiteral;
import org.eclipse.jem.internal.instantiation.ParseTreeAllocation;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.ParseTreeAllocationInstantiationVisitor;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.initParser.tree.IExpressionConstants;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.IAllocationProcesser;
import org.eclipse.ve.internal.java.core.IBeanProxyDomain;
import org.eclipse.ve.internal.java.core.IBeanProxyHost;
import org.eclipse.ve.internal.java.core.JavaMessages;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class BasicAllocationProcesser
implements IAllocationProcesser {
    protected IBeanProxyDomain domain;

    public IBeanProxy allocate(JavaAllocation allocation) throws IAllocationProcesser.AllocationException {
        EClass allocClass = allocation.eClass();
        if (allocClass == InstantiationPackage.eINSTANCE.getParseTreeAllocation()) {
            return this.allocate((ParseTreeAllocation)allocation);
        }
        if (allocClass == InstantiationPackage.eINSTANCE.getInitStringAllocation()) {
            return this.allocate((InitStringAllocation)allocation);
        }
        if (allocClass == InstantiationPackage.eINSTANCE.getImplicitAllocation()) {
            return this.allocate((ImplicitAllocation)allocation);
        }
        throw new IllegalArgumentException(MessageFormat.format(JavaMessages.getString("BasicAllocationProcesser.InvalidAllocationClass_EXC_"), allocClass.toString()));
    }

    protected IBeanProxy allocate(ParseTreeAllocation allocation) throws IAllocationProcesser.AllocationException {
        return BasicAllocationProcesser.instantiateWithExpression(allocation.getExpression(), this.domain);
    }

    protected IBeanProxy allocate(InitStringAllocation initString) throws IAllocationProcesser.AllocationException {
        String qualifiedClassName = ((IJavaInstance)initString.eContainer()).getJavaType().getQualifiedNameForReflection();
        return BasicAllocationProcesser.instantiateWithString(initString.getInitString(), this.domain.getProxyFactoryRegistry().getBeanTypeProxyFactory().getBeanTypeProxy(qualifiedClassName));
    }

    protected IBeanProxy allocate(ImplicitAllocation implicit) {
        EObject source = implicit.getParent();
        IBeanProxyHost proxyhost = (IBeanProxyHost)EcoreUtil.getExistingAdapter((Notifier)source, (Object)IBeanProxyHost.BEAN_PROXY_TYPE);
        return proxyhost.getBeanPropertyProxyValue(implicit.getFeature());
    }

    public static IBeanProxy instantiateWithExpression(PTExpression expression, IBeanProxyDomain domain) throws IAllocationProcesser.AllocationException {
        ParseAllocation allocator = new ParseAllocation(domain.getThisType());
        try {
            return allocator.getBeanProxy(expression, domain.getProxyFactoryRegistry());
        }
        catch (ParseTreeAllocationInstantiationVisitor.ProcessingException e) {
            throw new IAllocationProcesser.AllocationException(e.getCause());
        }
        catch (ThrowableProxy e) {
            throw new IAllocationProcesser.AllocationException(e);
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            throw new IAllocationProcesser.AllocationException(e);
        }
        catch (RuntimeException e) {
            throw new IAllocationProcesser.AllocationException(e);
        }
    }

    public static IBeanProxy instantiateWithString(String initializationString, IBeanTypeProxy targetClass) throws IAllocationProcesser.AllocationException {
        if (targetClass == null || targetClass.getInitializationError() != null) {
            ExceptionInInitializerError exc = new ExceptionInInitializerError(targetClass != null ? targetClass.getInitializationError() : MessageFormat.format(JavaMessages.getString("Proxy_Class_has_Errors_ERROR_"), JavaMessages.getString("BasicAllocationProcesser.unknown_ERROR_")));
            if (JavaVEPlugin.isLoggingLevel(Level.WARNING)) {
                JavaVEPlugin.log("Could not instantiate " + (targetClass != null ? targetClass.getTypeName() : "unknown") + " with initialization string=" + initializationString, Level.WARNING);
                JavaVEPlugin.log(exc, Level.WARNING);
            }
            throw new IAllocationProcesser.AllocationException(exc);
        }
        try {
            return initializationString != null ? targetClass.newInstance(initializationString) : targetClass.newInstance();
        }
        catch (ThrowableProxy exc) {
            if (JavaVEPlugin.isLoggingLevel(Level.WARNING)) {
                JavaVEPlugin.log("Could not instantiate " + targetClass.getTypeName() + " with initialization string=" + initializationString, Level.WARNING);
                JavaVEPlugin.log(exc, Level.WARNING);
            }
            throw new IAllocationProcesser.AllocationException(exc);
        }
        catch (InstantiationException exc) {
            if (JavaVEPlugin.isLoggingLevel(Level.WARNING)) {
                JavaVEPlugin.log("Could not instantiate " + targetClass.getTypeName() + " with initialization string=" + initializationString, Level.WARNING);
                JavaVEPlugin.log(exc, Level.WARNING);
            }
            throw new IAllocationProcesser.AllocationException(exc);
        }
        catch (ClassCastException exc) {
            if (JavaVEPlugin.isLoggingLevel(Level.WARNING)) {
                JavaVEPlugin.log("Could not instantiate " + targetClass.getTypeName() + " with initialization string=" + initializationString, Level.WARNING);
                JavaVEPlugin.log(exc, Level.WARNING);
            }
            throw new IAllocationProcesser.AllocationException(exc);
        }
    }

    public void setBeanProxyDomain(IBeanProxyDomain domain) {
        this.domain = domain;
    }

    private static class ParseAllocation
    extends ParseTreeAllocationInstantiationVisitor {
        private IBeanTypeProxy thisType;

        public ParseAllocation(IBeanTypeProxy thisType) {
            this.thisType = thisType;
        }

        public boolean visit(PTInstanceReference node) {
            try {
                IBeanProxy reference = BeanProxyUtilities.getBeanProxy((IJavaInstance)node.getObject());
                this.getExpression().createProxyExpression(this.getNextExpression(), reference);
            }
            catch (ThrowableProxy e) {
                throw new ParseTreeAllocationInstantiationVisitor.ProcessingException((Throwable)e);
            }
            catch (IExpressionConstants.NoExpressionValueException e) {
                throw new ParseTreeAllocationInstantiationVisitor.ProcessingException((Throwable)e);
            }
            return false;
        }

        public boolean visit(PTMethodInvocation node) {
            if ("getClass".equals(node.getName()) && (node.getReceiver() == null || node.getReceiver() instanceof PTThisLiteral)) {
                if (this.thisType == null) {
                    throw new IllegalArgumentException(JavaMessages.getString("BasicAllocationProcesser.ThisTypeNotFoundOrInvalid_EXC_"));
                }
                try {
                    this.getExpression().createProxyExpression(this.getNextExpression(), (IBeanProxy)this.thisType);
                }
                catch (IllegalStateException e) {
                    throw new ParseTreeAllocationInstantiationVisitor.ProcessingException((Throwable)e);
                }
                catch (ThrowableProxy e) {
                    throw new ParseTreeAllocationInstantiationVisitor.ProcessingException((Throwable)e);
                }
                catch (IExpressionConstants.NoExpressionValueException e) {
                    throw new ParseTreeAllocationInstantiationVisitor.ProcessingException((Throwable)e);
                }
                return false;
            }
            return super.visit(node);
        }
    }
}

