/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.core;

import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.commands.Command;
import org.eclipse.jem.internal.instantiation.InstantiationFactory;
import org.eclipse.jem.internal.instantiation.JavaAllocation;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ve.internal.cde.core.AnnotationPolicy;
import org.eclipse.ve.internal.cde.core.CDEUtilities;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.core.VisualInfoPolicy;
import org.eclipse.ve.internal.cde.emf.ClassDescriptorDecoratorPolicy;
import org.eclipse.ve.internal.cdm.Annotation;
import org.eclipse.ve.internal.cdm.AnnotationEMF;
import org.eclipse.ve.internal.cdm.CDMFactory;
import org.eclipse.ve.internal.cdm.CDMPackage;
import org.eclipse.ve.internal.cdm.Diagram;
import org.eclipse.ve.internal.cdm.VisualInfo;
import org.eclipse.ve.internal.cdm.impl.KeyedBooleanImpl;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.IBeanProxyHost;

public class BeanUtilities {
    public static IJavaInstance createJavaObject(String qualifiedClassName, ResourceSet aResourceSet, String initString) {
        return BeanUtilities.createJavaObject(JavaRefFactory.eINSTANCE.reflectType(qualifiedClassName, aResourceSet), aResourceSet, initString != null ? InstantiationFactory.eINSTANCE.createInitStringAllocation(initString) : null);
    }

    public static IJavaInstance createJavaObject(String qualifiedClassName, ResourceSet aResourceSet, JavaAllocation allocation) {
        return BeanUtilities.createJavaObject(JavaRefFactory.eINSTANCE.reflectType(qualifiedClassName, aResourceSet), aResourceSet, allocation);
    }

    public static IJavaInstance createJavaObject(JavaHelpers javaHelpers, ResourceSet aResourceSet, String initString) {
        return BeanUtilities.createJavaObject(javaHelpers, aResourceSet, initString != null ? InstantiationFactory.eINSTANCE.createInitStringAllocation(initString) : null);
    }

    public static IJavaInstance createJavaObject(JavaHelpers javaHelpers, ResourceSet aResourceSet, JavaAllocation allocation) {
        IJavaInstance result = null;
        result = (IJavaInstance)javaHelpers.getEPackage().getEFactoryInstance().create((EClass)javaHelpers);
        result.setAllocation(allocation);
        if (aResourceSet != null) {
            BeanProxyUtilities.getBeanProxyHost(result, aResourceSet);
        }
        return result;
    }

    public static IJavaObjectInstance createString(ResourceSet aResourceSet, String unquotedInitializationString) {
        return (IJavaObjectInstance)BeanUtilities.createJavaObject("java.lang.String", aResourceSet, BeanUtilities.createStringInitString(unquotedInitializationString));
    }

    public static String createStringInitString(String value) {
        StringBuffer sb = new StringBuffer(value.length());
        sb.append('\"');
        int sl = value.length();
        int i = 0;
        while (i < sl) {
            char c = value.charAt(i);
            if (c == '\"' || c == '\\') {
                sb.append('\\');
            }
            sb.append(c);
            ++i;
        }
        sb.append('\"');
        return sb.toString();
    }

    public static void setBeanName(IJavaInstance newJavaBean, String name) {
        CDMFactory fact = CDMFactory.eINSTANCE;
        AnnotationEMF an = fact.createAnnotationEMF();
        if (an != null) {
            EStringToStringMapEntryImpl sentry = (EStringToStringMapEntryImpl)EcoreFactory.eINSTANCE.create(EcorePackage.eINSTANCE.getEStringToStringMapEntry());
            sentry.setKey((Object)"org.eclipse.ve.internal.cde.core.nameincomposition");
            sentry.setValue((Object)name);
            CDEUtilities.putEMapEntry((EMap)an.getKeyedValues(), (Map.Entry)sentry);
            an.setAnnotates((EObject)newJavaBean);
        }
    }

    protected static BasicEMap.Entry getMapEntry(Annotation annotation, Object key) {
        int keyPos = annotation.getKeyedValues().indexOfKey(key);
        return keyPos != -1 ? (BasicEMap.Entry)annotation.getKeyedValues().get(keyPos) : null;
    }

    public static Command getSetBeanNameCommand(IJavaInstance newJavaBean, String name, EditDomain domain) {
        BasicEMap.Entry oldkv;
        Annotation annotation = domain.getAnnotationLinkagePolicy().getAnnotation((Object)newJavaBean);
        if (annotation != null && (oldkv = BeanUtilities.getMapEntry(annotation, "org.eclipse.ve.internal.cde.core.nameincomposition")) != null && name.equals(oldkv.getValue())) {
            return null;
        }
        EStringToStringMapEntryImpl sentry = (EStringToStringMapEntryImpl)EcoreFactory.eINSTANCE.create(EcorePackage.eINSTANCE.getEStringToStringMapEntry());
        sentry.setKey((Object)"org.eclipse.ve.internal.cde.core.nameincomposition");
        sentry.setValue((Object)name);
        return AnnotationPolicy.applyAnnotationSetting((Object)newJavaBean, (BasicEMap.Entry)sentry, (EditDomain)domain);
    }

    public static void setEmptyVisualContraints(IJavaInstance newJavaBean, EditDomain ed, boolean hideFF) {
        AnnotationEMF an;
        CDMFactory fact = CDMFactory.eINSTANCE;
        AnnotationEMF.ParentAdapter a = (AnnotationEMF.ParentAdapter)EcoreUtil.getExistingAdapter((Notifier)newJavaBean, (Object)AnnotationEMF.ParentAdapter.PARENT_ANNOTATION_ADAPTER_KEY);
        AnnotationEMF annotationEMF = an = a != null ? (AnnotationEMF)a.getParentAnnotation() : null;
        if (an == null) {
            an = fact.createAnnotationEMF();
            an.setAnnotates((EObject)newJavaBean);
        }
        Diagram d = null;
        int i = 0;
        while (i < ed.getDiagramData().getDiagrams().size()) {
            Diagram di = (Diagram)ed.getDiagramData().getDiagrams().get(i);
            if ("org.eclipse.ve.internal.cdm.primarydiagram".equals(di.getId())) {
                d = di;
                break;
            }
            ++i;
        }
        KeyedBooleanImpl key = (KeyedBooleanImpl)CDMFactory.eINSTANCE.create(CDMPackage.eINSTANCE.getKeyedBoolean());
        if (hideFF) {
            key.setValue((Object)Boolean.TRUE);
        } else {
            key.setValue((Object)Boolean.FALSE);
        }
        key.setKey((Object)"org.eclipse.ve.internal.cdm.model.visualconstraintkey");
        VisualInfo vi = an.getVisualInfo(d);
        if (vi == null) {
            vi = CDMFactory.eINSTANCE.createVisualInfo();
            vi.setDiagram(d);
        }
        if (vi.getKeyedValues().containsKey((Object)"org.eclipse.ve.internal.cdm.model.visualconstraintkey")) {
            vi.getKeyedValues().removeKey((Object)"org.eclipse.ve.internal.cdm.model.visualconstraintkey");
        }
        vi.getKeyedValues().add((Object)key);
        an.getVisualInfos().add((Object)vi);
    }

    public static Command getSetEmptyVisualContraintsCommand(IJavaInstance newJavaBean, boolean hideFF, EditDomain domain) {
        KeyedBooleanImpl key = (KeyedBooleanImpl)CDMFactory.eINSTANCE.create(CDMPackage.eINSTANCE.getKeyedBoolean());
        key.setKey((Object)"org.eclipse.ve.internal.cdm.model.visualconstraintkey");
        if (hideFF) {
            key.setValue((Object)Boolean.TRUE);
        } else {
            key.setValue((Object)Boolean.FALSE);
        }
        Diagram d = null;
        int i = 0;
        while (i < domain.getDiagramData().getDiagrams().size()) {
            Diagram di = (Diagram)domain.getDiagramData().getDiagrams().get(i);
            if ("org.eclipse.ve.internal.cdm.primarydiagram".equals(di.getId())) {
                d = di;
                break;
            }
            ++i;
        }
        return VisualInfoPolicy.applyVisualInfoSetting((Object)newJavaBean, (Object)key, (EditDomain)domain, d);
    }

    public static boolean isThisPart(IJavaObjectInstance aBean) {
        EReference containerSF = aBean.eContainmentFeature();
        return containerSF.getName().equals("thisPart");
    }

    public static IJavaInstance getFeatureValue(IJavaInstance javaObject, String featureName) {
        EStructuralFeature feature = javaObject.eClass().getEStructuralFeature(featureName);
        if (feature == null) {
            return null;
        }
        return BeanUtilities.getFeatureValue(javaObject, feature);
    }

    public static IJavaInstance getFeatureValue(IJavaInstance javaObject, EStructuralFeature feature) {
        Object featureValue = javaObject.eGet(feature);
        if (featureValue != null) {
            return (IJavaInstance)featureValue;
        }
        IBeanProxyHost beanProxyHost = BeanProxyUtilities.getBeanProxyHost(javaObject);
        if (!beanProxyHost.isBeanProxyInstantiated()) {
            beanProxyHost.instantiateBeanProxy();
        }
        return beanProxyHost.getBeanPropertyValue(feature);
    }

    public static String getLabel(IJavaInstance component, EditDomain editDomain) {
        ILabelProvider labelProvider = ClassDescriptorDecoratorPolicy.getPolicy((EditDomain)editDomain).getLabelProvider((EClassifier)component.eClass());
        if (labelProvider != null) {
            return labelProvider.getText((Object)component);
        }
        return BeanProxyUtilities.getBeanProxy(component).toBeanString();
    }
}

