/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.core;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.internal.instantiation.base.IJavaDataTypeInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.ICharacterBeanProxy;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.BeanUtilities;
import org.eclipse.ve.internal.java.core.IJavaCellEditor;
import org.eclipse.ve.internal.java.core.JavaEditDomainHelper;
import org.eclipse.ve.internal.java.core.JavaMessages;
import org.eclipse.ve.internal.propertysheet.INeedData;
import org.eclipse.ve.internal.propertysheet.ObjectCellEditor;
import org.eclipse.ve.internal.propertysheet.PropertysheetMessages;

public class CharJavaCellEditor
extends ObjectCellEditor
implements IExecutableExtension,
INeedData,
IJavaCellEditor {
    protected JavaHelpers fDataType;
    protected ResourceSet fResourceSet;
    protected EditDomain fEditDomain;
    protected boolean fIsCharacterClass = false;

    public CharJavaCellEditor(Composite parent) {
        super(parent);
    }

    public void setInitializationData(IConfigurationElement ce, String pName, Object initData) {
        this.fIsCharacterClass = initData != null && initData instanceof String && "class".equalsIgnoreCase((String)initData);
    }

    public Object doGetObject(String aString) {
        char charEntered = aString.charAt(0);
        String initString = charEntered == '\'' || charEntered == '\\' ? "'\\" + charEntered + "'" : (charEntered == '0' && aString.length() > 1 ? "(char) " + aString.substring(1) : "'" + charEntered + "'");
        if (!this.fIsCharacterClass) {
            return BeanUtilities.createJavaObject(this.fDataType, this.fResourceSet, initString);
        }
        initString = "new Character(" + initString + ")";
        return BeanUtilities.createJavaObject(this.fDataType, this.fResourceSet, initString);
    }

    public String doGetString(Object anObject) {
        if (anObject == null) {
            return "";
        }
        if (anObject instanceof IJavaInstance) {
            return ((ICharacterBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)anObject, this.fResourceSet)).characterValue().toString();
        }
        return CharJavaCellEditor.getCharacterLabel((IJavaDataTypeInstance)anObject, this.fEditDomain);
    }

    public String isCorrectString(String aString) {
        if (aString.length() == 0) {
            return JavaMessages.getString("CellEditor.CharJava.ErrMsg_ERROR_");
        }
        if (aString == null) {
            return JavaMessages.getString("CellEditor.CharJava.InvalidMsg_ERROR_");
        }
        if (aString.length() > 1) {
            if (aString.charAt(0) != '0') {
                return JavaMessages.getString("CellEditor.CharJava.InvalidMsg_ERROR_");
            }
            try {
                int num = Integer.parseInt(aString.substring(1));
                if (num > 65535 || num < 0) {
                    return JavaMessages.getString("CellEditor.CharJava.InvalidMsg_ERROR_");
                }
            }
            catch (NumberFormatException numberFormatException) {
                return JavaMessages.getString("CellEditor.CharJava.InvalidMsg_ERROR_");
            }
        }
        return null;
    }

    public String isCorrectObject(Object value) {
        if (value == null) {
            if (!this.fIsCharacterClass) {
                return PropertysheetMessages.getString((String)"null_invalid_WARN_");
            }
            return null;
        }
        if (this.fDataType.isInstance(value)) {
            return null;
        }
        return JavaMessages.getString("CellEditor.CharJava.InvalidMsg_ERROR_");
    }

    public void setData(Object data) {
        this.fEditDomain = (EditDomain)data;
        this.fResourceSet = JavaEditDomainHelper.getResourceSet((EditDomain)this.fEditDomain);
        this.fDataType = this.fIsCharacterClass ? JavaRefFactory.eINSTANCE.reflectType("java.lang.Character", this.fResourceSet) : JavaRefFactory.eINSTANCE.reflectType("char", this.fResourceSet);
    }

    public String getJavaInitializationString() {
        if (this.getValue() == null) {
            return null;
        }
        if (!this.fIsCharacterClass) {
            String label = CharJavaCellEditor.getCharacterLabel((IJavaDataTypeInstance)this.getValue(), this.fEditDomain);
            return "'" + label + "'";
        }
        String label = CharJavaCellEditor.getCharacterLabel((IJavaDataTypeInstance)this.getValue(), this.fEditDomain);
        return "new Character(" + label + ")";
    }

    public static String getCharacterLabel(IJavaDataTypeInstance intOrCharInstance, EditDomain editDomain) {
        IBeanProxy intOrCharProxy = BeanProxyUtilities.getBeanProxy((IJavaInstance)intOrCharInstance, JavaEditDomainHelper.getResourceSet((EditDomain)editDomain));
        if (intOrCharProxy instanceof IIntegerBeanProxy) {
            int intValue = ((IIntegerBeanProxy)intOrCharProxy).intValue();
            if (Character.isLetterOrDigit((char)intValue)) {
                return new Character((char)intValue).toString();
            }
            if (intValue <= 255 && !Character.isISOControl((char)intValue)) {
                return new Character((char)intValue).toString();
            }
            if (intValue >= 0 && intValue <= 9) {
                return "0" + new Integer(intValue).toString();
            }
            return new Integer(intValue).toString();
        }
        if (intOrCharProxy instanceof ICharacterBeanProxy) {
            char charValue = ((ICharacterBeanProxy)intOrCharProxy).charValue();
            if (charValue <= '\u00ff' && !Character.isISOControl(charValue)) {
                return new Character(charValue).toString();
            }
            return "0" + new Integer(charValue).toString();
        }
        return "";
    }
}

