/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.jem.internal.beaninfo.PropertyDecorator;
import org.eclipse.jem.internal.beaninfo.core.Utilities;
import org.eclipse.jem.internal.instantiation.InstantiationFactory;
import org.eclipse.jem.internal.instantiation.JavaAllocation;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IConstructorProxy;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ve.internal.cde.commands.CancelAttributeSettingCommand;
import org.eclipse.ve.internal.cde.core.CDEPlugin;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.properties.AbstractPropertyDescriptorAdapter;
import org.eclipse.ve.internal.java.core.ApplyCustomizedValueCommand;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.CustomizeAction;
import org.eclipse.ve.internal.java.core.IBeanProxyHost;
import org.eclipse.ve.internal.java.core.IJavaCellEditor;
import org.eclipse.ve.internal.java.core.JavaMessages;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.java.core.WindowLauncher;
import org.eclipse.ve.internal.propertysheet.INeedData;
import org.eclipse.ve.internal.propertysheet.common.commands.CompoundCommand;

public class CustomizeJavaBeanAction
extends CustomizeAction {
    protected EditDomain fEditDomain;
    static final int NONE = 0;
    static final int NEWVALUE = 2;
    static final int CHANGED = 3;
    static final int CANCELED = 4;
    public static final String ACTION_ID = "jcm.javabean.CUSTOMIZE";

    public CustomizeJavaBeanAction(IWorkbenchPart anEditorPart, EditDomain anEditDomain) {
        super(anEditorPart);
        this.fEditDomain = anEditDomain;
        this.setId(ACTION_ID);
        this.setText(JavaMessages.getString("Action.CustomizeJavaBean.Text"));
        this.setToolTipText(JavaMessages.getString("Action.CustomizeJavaBean.ToolTipText"));
        this.setImageDescriptor(CDEPlugin.getImageDescriptorFromPlugin((Plugin)JavaVEPlugin.getPlugin(), (String)"icons/full/elcl16/customizebean_co.gif"));
        this.setHoverImageDescriptor(this.getImageDescriptor());
        this.setDisabledImageDescriptor(CDEPlugin.getImageDescriptorFromPlugin((Plugin)JavaVEPlugin.getPlugin(), (String)"icons/full/dlcl16/customizebean_co.gif"));
    }

    public void run() {
        try {
            EditPart editPart = (EditPart)this.getSelectedObjects().get(0);
            ProxyFactoryRegistry registry = BeanProxyUtilities.getProxyFactoryRegistry(editPart);
            IBeanTypeProxy customizerTypeProxy = registry.getBeanTypeProxyFactory().getBeanTypeProxy(this.getCustomizerClassName());
            IJavaObjectInstance bean = (IJavaObjectInstance)editPart.getModel();
            IBeanProxy customizerProxy = customizerTypeProxy.newInstance();
            final IBeanProxyHost beanProxyHost = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)bean);
            IBeanProxy beanProxy = beanProxyHost.getBeanProxy();
            IMethodProxy setObjectMethod = customizerProxy.getTypeProxy().getMethodProxy("setObject", new String[]{"java.lang.Object"});
            setObjectMethod.invoke(customizerProxy, new IBeanProxy[]{beanProxy});
            Iterator propertyDecorators = Utilities.getPropertiesIterator((EList)((JavaClass)bean.eClass()).getAllProperties());
            HashMap<EStructuralFeature, IBeanProxy> oldValues = new HashMap<EStructuralFeature, IBeanProxy>();
            while (propertyDecorators.hasNext()) {
                PropertyDecorator propDecor = (PropertyDecorator)propertyDecorators.next();
                EStructuralFeature sf = (EStructuralFeature)propDecor.getEModelElement();
                if (!sf.isChangeable()) continue;
                IBeanProxy existingValue = beanProxyHost.getBeanPropertyProxyValue(sf);
                oldValues.put(sf, existingValue);
            }
            IBeanTypeProxy windowLauncherType = registry.getBeanTypeProxyFactory().getBeanTypeProxy("org.eclipse.ve.internal.java.remotevm.WindowLauncher");
            IConstructorProxy ctor = windowLauncherType.getConstructorProxy(new String[]{"java.awt.Component"});
            IBeanProxy windowLauncherProxy = ctor.newInstance(new IBeanProxy[]{customizerProxy});
            final Display display = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay();
            WindowLauncher launcher = new WindowLauncher(windowLauncherProxy, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            launcher.addListener(new WindowLauncher.Listener(){

                public void propertyChange(String eventName) {
                    display.asyncExec(new Runnable(this, beanProxyHost){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ IBeanProxyHost val$beanProxyHost;
                        {
                            this.this$1 = var1_1;
                            this.val$beanProxyHost = iBeanProxyHost;
                        }

                        public void run() {
                            this.val$beanProxyHost.revalidateBeanProxy();
                        }
                    });
                }
            });
            launcher.waitUntilWindowCloses();
            switch (launcher.getWindowState()) {
                case 2: 
                case 4: {
                    this.customizerCancel(oldValues, beanProxyHost, bean);
                    break;
                }
                case 3: {
                    this.customizerOK(oldValues, beanProxyHost, bean);
                    break;
                }
            }
            launcher.dispose();
            windowLauncherProxy = null;
            launcher = null;
        }
        catch (Exception exc) {
            JavaVEPlugin.log(exc, Level.WARNING);
        }
    }

    protected void customizerCancel(Map oldValues, IBeanProxyHost aBeanProxyHost, IJavaObjectInstance aBean) {
        Iterator keys = oldValues.keySet().iterator();
        while (keys.hasNext()) {
            EStructuralFeature sf = (EStructuralFeature)keys.next();
            IBeanProxy oldValue = (IBeanProxy)oldValues.get(sf);
            IBeanProxy currentValue = aBeanProxyHost.getBeanPropertyProxyValue(sf);
            int changeType = 0;
            if (oldValue == currentValue) {
                changeType = 0;
            } else if (oldValue == null || !oldValue.equals((Object)currentValue)) {
                changeType = 3;
            }
            switch (changeType) {
                case 3: {
                    aBeanProxyHost.applyBeanPropertyProxyValue(sf, oldValue);
                }
            }
        }
        aBeanProxyHost.revalidateBeanProxy();
    }

    protected void customizerOK(Map oldValues, IBeanProxyHost aBeanProxyHost, IJavaObjectInstance aBean) {
        Iterator keys = oldValues.keySet().iterator();
        CompoundCommand cmd = new CompoundCommand();
        Shell shell = new Shell();
        Map originalSettings = aBeanProxyHost.getOriginalSettingsTable();
        while (keys.hasNext()) {
            EStructuralFeature sf = (EStructuralFeature)keys.next();
            IBeanProxy oldValue = (IBeanProxy)oldValues.get(sf);
            IBeanProxy currentValue = aBeanProxyHost.getBeanPropertyProxyValue(sf);
            int changeType = 0;
            if (oldValue == currentValue) {
                changeType = 0;
            } else if (oldValue == null || !oldValue.equals((Object)currentValue)) {
                IBeanProxy origValue;
                changeType = aBean.eIsSet(sf) && originalSettings.containsKey(sf) ? ((origValue = (IBeanProxy)originalSettings.get(sf)) == currentValue ? 4 : (origValue == null || !origValue.equals((Object)currentValue) ? 3 : 4)) : 3;
            }
            switch (changeType) {
                case 3: {
                    IJavaInstance newBean = BeanProxyUtilities.wrapperBeanProxy(currentValue, aBean.eResource().getResourceSet(), null, true);
                    PropertyDecorator propDecor = Utilities.getPropertyDecorator((EModelElement)sf);
                    IPropertyDescriptor propertySheetDescriptor = (IPropertyDescriptor)EcoreUtil.getRegisteredAdapter((EObject)propDecor.getEModelElement(), (Object)AbstractPropertyDescriptorAdapter.IPROPERTYDESCRIPTOR_TYPE);
                    CellEditor cellEditor = propertySheetDescriptor.createPropertyEditor((Composite)shell);
                    if (cellEditor instanceof INeedData) {
                        ((INeedData)cellEditor).setData((Object)this.fEditDomain);
                        cellEditor.setValue((Object)newBean);
                        String initString = ((IJavaCellEditor)cellEditor).getJavaInitializationString();
                        newBean.setAllocation((JavaAllocation)InstantiationFactory.eINSTANCE.createInitStringAllocation(initString));
                    }
                    ApplyCustomizedValueCommand applyCmd = new ApplyCustomizedValueCommand();
                    applyCmd.setTarget(aBean);
                    applyCmd.setValue(newBean);
                    applyCmd.setFeature(sf);
                    applyCmd.setOldBeanProxy(oldValue);
                    cmd.append((Command)applyCmd);
                    break;
                }
                case 4: {
                    CancelAttributeSettingCommand cancelCmd = new CancelAttributeSettingCommand();
                    cancelCmd.setTarget((EObject)aBean);
                    cancelCmd.setAttribute(sf);
                    cmd.append((Command)cancelCmd);
                }
            }
        }
        shell.dispose();
        this.execute((Command)cmd);
    }
}

