/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.core;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ve.internal.propertysheet.common.commands.AbstractCommand;

public class ModifyAttributesCommand
extends AbstractCommand {
    protected EAttribute feature = null;
    protected EObject target = null;
    protected Object data = null;
    protected Object oldData = null;
    protected byte operation = 0;
    public static byte FEATURE_MODIFY = (byte)11;
    public static byte FEATURE_REMOVE = (byte)22;
    public static byte FEATURE_ADD = (byte)33;

    public ModifyAttributesCommand(String label) {
        super(label);
    }

    public ModifyAttributesCommand(String label, String description) {
        super(label, description);
    }

    public boolean canExecute() {
        if ((this.operation == FEATURE_MODIFY || this.operation == FEATURE_ADD) && this.target != null && this.feature != null && this.data != null) {
            return true;
        }
        return this.operation == FEATURE_REMOVE && this.target != null && this.feature != null;
    }

    public void execute() {
        if (this.operation == FEATURE_REMOVE) {
            this.oldData = this.target.eGet((EStructuralFeature)this.feature);
            this.target.eUnset((EStructuralFeature)this.feature);
        }
        if (this.operation == FEATURE_MODIFY) {
            this.oldData = this.target.eGet((EStructuralFeature)this.feature);
            this.target.eSet((EStructuralFeature)this.feature, this.data);
        }
        if (this.operation == FEATURE_ADD) {
            this.target.eSet((EStructuralFeature)this.feature, this.data);
        }
    }

    public void undo() {
        if (this.operation == FEATURE_REMOVE) {
            this.target.eSet((EStructuralFeature)this.feature, this.oldData);
        }
        if (this.operation == FEATURE_MODIFY) {
            this.target.eSet((EStructuralFeature)this.feature, this.oldData);
        }
        if (this.operation == FEATURE_ADD) {
            this.target.eUnset((EStructuralFeature)this.feature);
        }
    }

    public void redo() {
        this.execute();
    }

    public void setOperation(byte operation) {
        this.operation = operation;
    }

    public void setTarget(EObject target) {
        this.target = target;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public void setFeature(EAttribute feature) {
        this.feature = feature;
    }
}

