/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.rules;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ve.internal.cde.commands.CommandBuilder;
import org.eclipse.ve.internal.cde.commands.NoOpCommand;
import org.eclipse.ve.internal.cde.core.AnnotationPolicy;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cdm.Annotation;
import org.eclipse.ve.internal.jcm.JCMPackage;
import org.eclipse.ve.internal.jcm.MemberContainer;
import org.eclipse.ve.internal.propertysheet.common.commands.CommandWrapper;

public class DefaultPreSetCommand
extends CommandWrapper {
    protected EditDomain domain;
    protected EObject target;
    protected EObject newValue;
    protected boolean containment;
    protected List annotations;

    protected DefaultPreSetCommand(EditDomain domain, EObject target, EObject newValue, EReference feature) {
        this.domain = domain;
        this.target = target;
        this.newValue = newValue;
        this.containment = feature != null ? feature.isContainment() : false;
    }

    protected boolean prepare() {
        return this.target != null && this.domain != null;
    }

    public void execute() {
        MemberContainer mc = this.findMemberContainer();
        CommandBuilder cbld = new CommandBuilder();
        cbld.setExecuteAndAppend(true);
        this.handleValue(cbld, mc, this.newValue, this.containment);
        if (this.annotations != null) {
            cbld.append(AnnotationPolicy.getDefaultAddAnnotationsCommand((List)this.annotations, (EditDomain)this.domain));
        }
        this.command = !cbld.isEmpty() ? cbld.getCommand() : NoOpCommand.INSTANCE;
    }

    protected MemberContainer findMemberContainer() {
        EObject parent = null;
        if (!this.containment && this.newValue.eContainer() instanceof MemberContainer) {
            parent = this.newValue.eContainer();
        } else {
            parent = this.target.eContainer();
            while (parent != null && !(parent instanceof MemberContainer)) {
                parent = parent.eContainer();
            }
        }
        if (parent == null) {
            parent = this.domain.getDiagramData();
        }
        return (MemberContainer)parent;
    }

    protected void handleValue(CommandBuilder cbld, MemberContainer mc, EObject value, boolean containment) {
        if (!containment && value.eContainer() == null) {
            cbld.applyAttributeSetting((EObject)mc, (EStructuralFeature)JCMPackage.eINSTANCE.getMemberContainer_Properties(), (Object)value);
            this.handleAnnotation(value);
        } else if (containment) {
            this.handleAnnotation(value);
        }
        Iterator refs = value.eClass().getEAllReferences().iterator();
        while (refs.hasNext()) {
            EReference ref = (EReference)refs.next();
            if (!value.eIsSet((EStructuralFeature)ref)) continue;
            if (ref.isMany()) {
                Iterator kids = ((List)value.eGet((EStructuralFeature)ref)).iterator();
                while (kids.hasNext()) {
                    Object kid = kids.next();
                    if (!(kid instanceof EObject)) continue;
                    this.handleValue(cbld, mc, (EObject)kid, ref.isContainment());
                }
                continue;
            }
            Object kid = value.eGet((EStructuralFeature)ref);
            if (!(kid instanceof EObject)) continue;
            this.handleValue(cbld, mc, (EObject)kid, ref.isContainment());
        }
    }

    protected void handleAnnotation(EObject child) {
        Annotation annotation = this.domain.getAnnotationLinkagePolicy().getAnnotation((Object)child);
        if (annotation != null && annotation.eContainmentFeature() == null) {
            if (this.annotations == null) {
                this.annotations = new ArrayList();
            }
            this.annotations.add(annotation);
        }
    }
}

