/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.vce;

import java.util.ArrayList;
import javax.swing.UIManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ve.internal.cde.core.CDEPlugin;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.java.vce.LookAndFeelDialog;
import org.eclipse.ve.internal.java.vce.VCEMessages;
import org.eclipse.ve.internal.java.vce.VCEPreferences;
import org.eclipse.ve.internal.java.vce.rules.IEditorStyle;
import org.eclipse.ve.internal.java.vce.rules.IEditorStylePrefUI;
import org.eclipse.ve.internal.java.vce.rules.IStyleRegistry;
import org.eclipse.ve.internal.java.vce.rules.JVEStyleRegistry;
import org.eclipse.ve.internal.propertysheet.PropertysheetMessages;
import org.osgi.framework.Bundle;

public class VCEPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String USER_ITEM = "USER_ITEM";
    public static final String DEFAULT_ITEM = "DEFAULT_ITEM";
    public static final String PROGRAM_ITEM = "PROGRAM_ITEM";
    public static final String PLUGIN_ITEM = "PLUGIN_ITEM";
    public static final String LnF_DEFAULT = VCEMessages.getString("PreferencePage.LookAndFeel.Default");
    protected Preferences fStore;
    protected TabFolder tabFolder;
    protected TabItem appearanceTab;
    protected TabItem codeGenTab;
    protected TabItem stylesTab;
    protected SourceViewer fSourceViewer;
    protected Label lookAndFeelLabel;
    protected Table lookAndFeelTable;
    protected ArrayList fLookAndFeelClasses = new ArrayList(4);
    protected Button showWindowCheckBox;
    protected Button showXMLTextCheckBox;
    protected Button splitRadioButton;
    protected Button notebookRadioButton;
    protected Button generateExpressionComment;
    protected Table stylesTable;
    protected StackLayout stylesContributorAreaLayout;
    protected Composite styleContributorArea;
    protected Button generateTryCatchBlock;
    protected Text sourceToVisual;
    protected Group sourceSyncGrp;
    protected Image fJavaBeansToSourceImage;
    protected Image fSourceToJavaBeansImage;
    protected Image fJavaBeansViewImage;
    protected Image fPropertiesViewImage;
    protected int fLookAndFeelSelected;
    private Button openPropertiesViewIfRequired;
    private Button openJavaBeansViewIfRequired;
    private TableItem currentLookAndFeelItem;
    private String fStyleID = null;

    protected Label createLabel(Composite group, String aLabelString, Image aLabelImage) {
        Label label = new Label(group, 16384);
        if (aLabelImage != null) {
            label.setImage(aLabelImage);
        } else {
            label.setText(aLabelString);
        }
        GridData data = new GridData();
        label.setLayoutData((Object)data);
        return label;
    }

    private Button createCheckBox(Composite group, String label, int indent) {
        Button button = new Button(group, 16416);
        button.setText(label);
        GridData data = new GridData();
        data.horizontalIndent = indent;
        button.setLayoutData((Object)data);
        return button;
    }

    protected Group createGroup(Composite aParent, String title, int numColumns) {
        Group group = new Group(aParent, 0);
        group.setText(title);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = numColumns;
        group.setLayout((Layout)gridLayout);
        GridData data = new GridData();
        data.verticalAlignment = 1040;
        data.horizontalAlignment = 768;
        data.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)data);
        return group;
    }

    protected List createList(Composite group, int heightHint) {
        List list = new List(group, 2560);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        data.heightHint = heightHint;
        list.setLayoutData((Object)data);
        return list;
    }

    protected Button createRadioButton(Composite parent, String label) {
        Button button = new Button(parent, 16400);
        button.setText(label);
        GridData data = new GridData();
        button.setData((Object)data);
        return button;
    }

    protected Text createText(Composite parent, int noCharacters, int span) {
        Text text = new Text(parent, 2052);
        GridData data = new GridData(2);
        data.widthHint = this.convertWidthInCharsToPixels(noCharacters);
        data.horizontalSpan = span;
        text.setLayoutData((Object)data);
        return text;
    }

    protected Text createLabelText(Composite parent, String label, int noCharacters) {
        Composite c = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 2;
        c.setLayoutData((Object)new GridData());
        c.setLayout((Layout)gridLayout);
        Label l = this.createLabel(c, label, null);
        l.setLayoutData((Object)new GridData(4));
        Text text = new Text(c, 2052);
        GridData data = new GridData(2);
        data.widthHint = this.convertWidthInCharsToPixels(noCharacters);
        text.setLayoutData((Object)data);
        return text;
    }

    protected Control createContents(Composite parent) {
        this.tabFolder = new TabFolder(parent, 0);
        this.createAppearanceTab();
        this.createCodeGenerationTab();
        this.createStylesTab();
        this.initializeGUIControlsFromStore();
        this.applyDialogFont((Composite)this.tabFolder);
        return this.tabFolder;
    }

    protected void createAppearanceTab() {
        this.appearanceTab = new TabItem(this.tabFolder, 0);
        this.appearanceTab.setText(VCEMessages.getString("VCEPreferencePage.Tab.Appearance.Text"));
        Composite appearanceComposite = new Composite((Composite)this.tabFolder, 0);
        appearanceComposite.setLayout((Layout)new GridLayout());
        appearanceComposite.setLayoutData((Object)new GridData(272));
        this.appearanceTab.setControl((Control)appearanceComposite);
        Group group = this.createGroup(appearanceComposite, VCEMessages.getString("PreferencePage.EditorGroup.Title"), 2);
        this.splitRadioButton = this.createRadioButton((Composite)group, VCEMessages.getString("PreferencePage.EditorGroup.SplitPaneOrientation"));
        this.notebookRadioButton = this.createRadioButton((Composite)group, VCEMessages.getString("PreferencePage.EditorGroup.UseNoteBook"));
        Composite openComposite = new Composite(appearanceComposite, 0);
        openComposite.setLayout((Layout)new GridLayout(2, false));
        this.openPropertiesViewIfRequired = this.createCheckBox(openComposite, VCEMessages.getString("PreferencePage.OpenView.Properties"), 0);
        this.fPropertiesViewImage = CDEPlugin.getImageFromBundle((Bundle)Platform.getBundle((String)"org.eclipse.ui"), (String)"icons/full/eview16/prop_ps.gif");
        this.createLabel(openComposite, null, this.fPropertiesViewImage);
        this.openJavaBeansViewIfRequired = this.createCheckBox(openComposite, VCEMessages.getString("PreferencePage.OpenView.JavaBeans"), 0);
        this.fJavaBeansViewImage = CDEPlugin.getImageFromPlugin((Plugin)JavaVEPlugin.getPlugin(), (String)"icons/full/ctool16/javavisualeditor_co.gif");
        this.createLabel(openComposite, null, this.fJavaBeansViewImage);
        this.lookAndFeelLabel = this.createLabel(appearanceComposite, VCEMessages.getString("PreferencePage.LookAndFeel.Title"), null);
        Composite lookAndFeelComposite = new Composite(appearanceComposite, 0);
        lookAndFeelComposite.setLayout((Layout)new GridLayout(2, false));
        GridData lfData = new GridData(768);
        lookAndFeelComposite.setLayoutData((Object)lfData);
        this.lookAndFeelTable = this.createTable(lookAndFeelComposite, 2848, new String[]{VCEMessages.getString("VCEPreferencePage.Tab.Appearance.Table.LookAndFeel.Name"), VCEMessages.getString("VCEPreferencePage.Tab.Appearance.Table.LookAndFeel.Class")});
        GridData listData = new GridData(768);
        this.lookAndFeelTable.setLayoutData((Object)listData);
        listData.heightHint = 100;
        listData.widthHint = 200;
        Composite lookAndFeelButtons = new Composite(lookAndFeelComposite, 0);
        lookAndFeelButtons.setLayout((Layout)new GridLayout(1, true));
        GridData lfButtonData = new GridData();
        lfButtonData.horizontalAlignment = 3;
        lookAndFeelButtons.setLayoutData((Object)lfButtonData);
        Button bAdd = new Button(lookAndFeelButtons, 8);
        bAdd.setText(VCEMessages.getString("VCEPreferencePage.Tab.Appearance.Button.New"));
        GridData addData = new GridData();
        addData.horizontalAlignment = 4;
        addData.widthHint = this.getButtonWidthHint(bAdd);
        bAdd.setLayoutData((Object)addData);
        bAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VCEPreferencePage.this.addLookAndFeel();
            }
        });
        final Button bEdit = new Button(lookAndFeelButtons, 8);
        bEdit.setText(VCEMessages.getString("VCEPreferencePage.Tab.Appearance.Button.Edit"));
        GridData editData = new GridData();
        editData.horizontalAlignment = 4;
        editData.widthHint = this.getButtonWidthHint(bEdit);
        bEdit.setLayoutData((Object)editData);
        bEdit.setEnabled(false);
        bEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (VCEPreferencePage.this.lookAndFeelTable.getSelectionCount() == 1 && VCEPreferencePage.USER_ITEM.equals(VCEPreferencePage.this.lookAndFeelTable.getSelection()[0].getData())) {
                    VCEPreferencePage.this.editLookAndFeel();
                }
            }
        });
        final Button bRemove = new Button(lookAndFeelButtons, 8);
        bRemove.setText(VCEMessages.getString("VCEPreferencePage.Tab.Appearance.Button.Remove"));
        GridData removeData = new GridData();
        removeData.horizontalAlignment = 4;
        removeData.widthHint = this.getButtonWidthHint(bRemove);
        bRemove.setLayoutData((Object)removeData);
        bRemove.setEnabled(false);
        bRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (VCEPreferencePage.this.lookAndFeelTable.getSelectionCount() == 1 && VCEPreferencePage.USER_ITEM.equals(VCEPreferencePage.this.lookAndFeelTable.getSelection()[0].getData())) {
                    VCEPreferencePage.this.removeLookAndFeel();
                }
            }
        });
        Listener tableListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.detail) {
                    case 32: {
                        TableItem item = (TableItem)event.item;
                        if (item.getChecked()) {
                            if (VCEPreferencePage.this.currentLookAndFeelItem != null) {
                                VCEPreferencePage.this.currentLookAndFeelItem.setChecked(false);
                            }
                            VCEPreferencePage.this.currentLookAndFeelItem = item;
                            break;
                        }
                        item.setChecked(true);
                        break;
                    }
                    default: {
                        if (VCEPreferencePage.this.lookAndFeelTable.getSelectionCount() != -1 && VCEPreferencePage.USER_ITEM.equals(VCEPreferencePage.this.lookAndFeelTable.getSelection()[0].getData())) {
                            bRemove.setEnabled(true);
                            bEdit.setEnabled(true);
                            break;
                        }
                        bRemove.setEnabled(false);
                        bEdit.setEnabled(false);
                    }
                }
            }
        };
        this.lookAndFeelTable.addListener(13, tableListener);
        this.showWindowCheckBox = this.createCheckBox(appearanceComposite, VCEMessages.getString("PreferencePage.ShowLiveWindow"), 15);
        this.showXMLTextCheckBox = this.createCheckBox(appearanceComposite, VCEMessages.getString("PreferencePage.ShowXMLText"), 15);
        if (!VCEPreferences.isLiveWindow()) {
            this.showWindowCheckBox.setVisible(false);
        }
        if (!VCEPreferences.isXMLText()) {
            this.showXMLTextCheckBox.setVisible(false);
        }
    }

    protected int getButtonWidthHint(Button aButton) {
        GC fGC = new GC((Drawable)aButton);
        fGC.setFont(aButton.getFont());
        int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fGC.getFontMetrics(), (int)aButton.getText().length());
        fGC.dispose();
        return Math.max(widthHint, aButton.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    protected void addLookAndFeel() {
        Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        LookAndFeelDialog dialog = new LookAndFeelDialog(parent);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            TableItem item = new TableItem(this.lookAndFeelTable, 0);
            item.setText(0, dialog.fName);
            item.setText(1, dialog.fClass);
            item.setData((Object)USER_ITEM);
        }
    }

    protected void editLookAndFeel() {
        Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        LookAndFeelDialog dialog = new LookAndFeelDialog(parent);
        TableItem selectedItem = this.lookAndFeelTable.getSelection()[0];
        String oldName = selectedItem.getText(0);
        String oldClass = selectedItem.getText(1);
        dialog.fName = oldName;
        dialog.fClass = oldClass;
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            TableItem item = this.lookAndFeelTable.getSelection()[0];
            item.setText(0, dialog.fName);
            item.setText(1, dialog.fClass);
        }
    }

    protected void removeLookAndFeel() {
        TableItem selectedItem = this.lookAndFeelTable.getSelection()[0];
        selectedItem.dispose();
        if (this.currentLookAndFeelItem == selectedItem) {
            this.currentLookAndFeelItem = this.lookAndFeelTable.getItem(0);
            this.currentLookAndFeelItem.setChecked(true);
        }
    }

    protected void createCodeGenerationTab() {
        this.codeGenTab = new TabItem(this.tabFolder, 0);
        this.codeGenTab.setText(VCEMessages.getString("VCEPreferencePage.Tab.CodeGeneration.Text"));
        Composite codeGenComposite = new Composite((Composite)this.tabFolder, 0);
        codeGenComposite.setLayout((Layout)new GridLayout());
        codeGenComposite.setLayoutData((Object)new GridData(272));
        this.codeGenTab.setControl((Control)codeGenComposite);
        Group codeGenGroup_Gen = this.createGroup(codeGenComposite, VCEMessages.getString("PreferencePage.CodeGen.ParsingGeneration_Style_1"), 1);
        this.generateExpressionComment = this.createCheckBox((Composite)codeGenGroup_Gen, VCEMessages.getString("PreferencePage.NewExpressionCommentPrompt"), 0);
        this.generateTryCatchBlock = this.createCheckBox((Composite)codeGenGroup_Gen, VCEMessages.getString("PreferencePage.GenerateTryCatchBlock"), 0);
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VCEPreferencePage.this.validateFields();
            }
        };
        this.sourceSyncGrp = this.createGroup(codeGenComposite, VCEMessages.getString("PreferencePage.CodeGen.Source_Synchronization_Delay"), 6);
        this.createLabel((Composite)this.sourceSyncGrp, VCEMessages.getString("PreferencePage.CodeGen.SourceToJavaBeans"), null);
        this.sourceToVisual = this.createText((Composite)this.sourceSyncGrp, 11, 1);
        this.sourceToVisual.addModifyListener(modifyListener);
        this.sourceToVisual.setTextLimit(9);
        Label spacer = new Label((Composite)this.sourceSyncGrp, 0);
        spacer.setLayoutData((Object)new GridData(768));
    }

    protected Table createTable(Composite parent, int Style2, String[] headers) {
        Table result = new Table(parent, Style2);
        TableLayout tl = new TableLayout();
        result.setLayout((Layout)tl);
        result.setHeaderVisible(true);
        result.setLinesVisible(true);
        int i = 0;
        while (i < headers.length) {
            TableColumn nameColumn = new TableColumn(result, 0);
            nameColumn.setText(headers[i]);
            ++i;
        }
        if (result.getColumnCount() == 1) {
            tl.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        }
        return result;
    }

    protected void addStylesTableItems(Table t, String[] columns) {
        int i = 0;
        while (i < columns.length) {
            TableItem item = new TableItem(t, 0);
            item.setText(0, columns[i]);
            item.setData((Object)new StylesTableItem(columns[i]));
            ++i;
        }
    }

    protected IStyleRegistry getRulesRegistry() {
        return JVEStyleRegistry.getJVEStyleRegistry();
    }

    protected void createContributorUI(StylesTableItem itemData, Composite parent) {
        if (itemData.styleUI != null) {
            itemData.styleContributor = itemData.styleUI.createUI(parent);
        }
    }

    protected void populateStylesTable(final Table sTable, final Label info, final String currentStyle) {
        IStyleRegistry reg = this.getRulesRegistry();
        String[] styles = reg.getStyleIDs();
        int cIndex = 0;
        this.addStylesTableItems(sTable, styles);
        int i = 0;
        while (i < styles.length) {
            if (styles[i].equals(currentStyle)) {
                cIndex = i;
                break;
            }
            ++i;
        }
        final int defaultIndex = cIndex;
        sTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean checked;
                TableItem item = (TableItem)e.item;
                TableItem[] items = sTable.getItems();
                boolean bl = checked = e.detail == 32;
                if (checked) {
                    int i = 0;
                    while (i < items.length) {
                        if (items[i] != item && items[i].getChecked()) {
                            items[i].setChecked(false);
                        }
                        ++i;
                    }
                }
                StylesTableItem itemData = (StylesTableItem)item.getData();
                if (checked) {
                    if (item.getChecked()) {
                        VCEPreferencePage.this.fStyleID = itemData.styleID;
                    } else {
                        items[defaultIndex].setChecked(true);
                        VCEPreferencePage.this.fStyleID = currentStyle;
                    }
                } else {
                    VCEPreferencePage.this.styleSelected(itemData, info);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        sTable.select(cIndex);
        TableItem currentItem = sTable.getItem(cIndex);
        currentItem.setChecked(true);
        this.styleSelected((StylesTableItem)currentItem.getData(), info);
    }

    private void restoreDefaultStyle() {
        this.fStyleID = this.getStore().getDefaultString("JVA_PATTERN_STYLE_ID");
        TableItem[] items = this.stylesTable.getItems();
        TableItem defaultItem = items[0];
        int i = 0;
        while (i < items.length) {
            TableItem item = items[i];
            StylesTableItem itemData = (StylesTableItem)item.getData();
            if (this.fStyleID.equals(itemData.styleID)) {
                defaultItem = item;
            } else if (item.getChecked()) {
                item.setChecked(false);
            }
            if (itemData.styleUI != null) {
                itemData.styleUI.restoreDefaults();
            }
            ++i;
        }
        defaultItem.setChecked(true);
    }

    private void styleSelected(StylesTableItem itemData, Label info) {
        IStyleRegistry reg = this.getRulesRegistry();
        IEditorStyle style = reg.getStyle(itemData.styleID);
        if (!itemData.activated) {
            itemData.activated = true;
            itemData.styleUI = style.getPrefUI();
            this.createContributorUI(itemData, this.styleContributorArea);
        }
        info.setText(style.getDescription());
        this.stylesContributorAreaLayout.topControl = itemData.styleContributor;
        this.styleContributorArea.layout();
    }

    protected void createStylesTab() {
        this.stylesTab = new TabItem(this.tabFolder, 0);
        this.stylesTab.setText(VCEMessages.getString("VCEPreferencePage.Tab.Styles.Text"));
        Composite stylesComposite = new Composite((Composite)this.tabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 1;
        gridLayout.horizontalSpacing = 1;
        gridLayout.marginHeight = 1;
        stylesComposite.setLayout((Layout)gridLayout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        this.stylesTab.setControl((Control)stylesComposite);
        this.stylesTable = this.createTable(stylesComposite, 2852, new String[]{VCEMessages.getString("VCEPreferencePage.Tab.Styles.Table.Styles")});
        Label filler = this.createLabel(stylesComposite, "", null);
        GridData lData = new GridData();
        lData.heightHint = 55;
        lData.widthHint = 200;
        this.stylesTable.setLayoutData((Object)lData);
        GridData rData = new GridData(768);
        filler.setLayoutData((Object)rData);
        Label styleInfo = this.createLabel(stylesComposite, "", null);
        GridData styleInfoData = (GridData)styleInfo.getLayoutData();
        styleInfoData.heightHint = this.convertHeightInCharsToPixels(1);
        styleInfoData.widthHint = this.convertWidthInCharsToPixels(40);
        styleInfoData.grabExcessVerticalSpace = false;
        styleInfoData.horizontalAlignment = 4;
        styleInfoData.horizontalSpan = 2;
        this.styleContributorArea = new Composite(stylesComposite, 0);
        this.stylesContributorAreaLayout = new StackLayout();
        this.stylesContributorAreaLayout.marginHeight = 1;
        this.styleContributorArea.setLayout((Layout)this.stylesContributorAreaLayout);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.styleContributorArea.setLayoutData((Object)gd);
        this.fStyleID = VCEPreferences.getStyleID();
        this.populateStylesTable(this.stylesTable, styleInfo, this.fStyleID);
    }

    public static void initializeBasicLookAndFeelItems(Table table) {
        TableItem tableItem = new TableItem(table, 0);
        tableItem.setText(0, LnF_DEFAULT);
        tableItem.setData((Object)DEFAULT_ITEM);
        UIManager.LookAndFeelInfo[] lnfs = UIManager.getInstalledLookAndFeels();
        int i = 0;
        while (i < lnfs.length) {
            if (!lnfs[i].getClassName().equals("com.sun.java.swing.plaf.windows.WindowsLookAndFeel") || Platform.getOS().equals("win32")) {
                tableItem = new TableItem(table, 0);
                tableItem.setText(0, lnfs[i].getName());
                tableItem.setText(1, lnfs[i].getClassName());
                tableItem.setData((Object)PROGRAM_ITEM);
            }
            ++i;
        }
    }

    public static void addLookAndFeelClassesToTable(Table aTable, String[][] lookAndFeelClasses, String itemType) {
        int i = 0;
        while (i < lookAndFeelClasses.length) {
            String[] lfNameClass = lookAndFeelClasses[i];
            TableItem item = new TableItem(aTable, 0);
            item.setText(0, lfNameClass[0]);
            item.setText(1, lfNameClass[1]);
            item.setData((Object)itemType);
            ++i;
        }
    }

    protected Preferences getStore() {
        if (this.fStore != null) {
            return this.fStore;
        }
        this.fStore = VCEPreferences.getPlugin().getPluginPreferences();
        return this.fStore;
    }

    protected void initializeGUIControlsFromStore() {
        this.getStore();
        VCEPreferencePage.initializeBasicLookAndFeelItems(this.lookAndFeelTable);
        String lookAndFeelClass = this.fStore.getString("SWING_LOOKANDFEEL");
        VCEPreferencePage.addLookAndFeelClassesToTable(this.lookAndFeelTable, VCEPreferences.getPluginLookAndFeelClasses(), PLUGIN_ITEM);
        VCEPreferencePage.addLookAndFeelClassesToTable(this.lookAndFeelTable, VCEPreferences.getUserLookAndFeelClasses(), USER_ITEM);
        TableColumn[] columns = this.lookAndFeelTable.getColumns();
        int i = 0;
        while (i < columns.length) {
            columns[i].pack();
            ++i;
        }
        if (lookAndFeelClass == null | lookAndFeelClass.length() == 0) {
            this.currentLookAndFeelItem = this.lookAndFeelTable.getItem(0);
            this.lookAndFeelTable.getItem(0).setChecked(true);
        } else {
            i = 1;
            while (i < this.lookAndFeelTable.getItemCount()) {
                TableItem item = this.lookAndFeelTable.getItem(i);
                if (lookAndFeelClass.equals(item.getText(1))) {
                    this.currentLookAndFeelItem = item;
                    this.currentLookAndFeelItem.setChecked(true);
                    break;
                }
                ++i;
            }
        }
        this.openPropertiesViewIfRequired.setSelection(this.fStore.getBoolean("OPEN_PROPERTIES_VIEW"));
        this.openJavaBeansViewIfRequired.setSelection(this.fStore.getBoolean("OPEN_JAVABEANS_VIEW"));
        this.showWindowCheckBox.setSelection(this.fStore.getBoolean("SHOW_LIVE_WINDOW"));
        this.showXMLTextCheckBox.setSelection(CDEPlugin.getPlugin().getPluginPreferences().getBoolean("SHOW_XML"));
        boolean showAsNotebook = this.fStore.getBoolean("NOTEBOOK_PAGE");
        this.splitRadioButton.setSelection(!showAsNotebook);
        this.notebookRadioButton.setSelection(showAsNotebook);
        this.generateExpressionComment.setSelection(this.fStore.getBoolean("GENERATE_EXPRESSION_COMMENT"));
        this.generateTryCatchBlock.setSelection(this.fStore.getBoolean("GENERATE_TRY_CATCH_BLOCK"));
        this.sourceToVisual.setText(this.fStore.getString("SOURCE_SYNC_DELAY_NEW"));
        this.calculateTotalSourceToVisualTime();
    }

    protected void validateFields() {
        boolean isValid = true;
        try {
            int val = Integer.parseInt(this.sourceToVisual.getText());
            if (val < 1000) {
                isValid = false;
                this.setErrorMessage(VCEMessages.getString("PreferencePage.CodeGen.Error.DelayTimeMinimum_ERROR_"));
                this.setValid(false);
            }
        }
        catch (NumberFormatException numberFormatException) {
            isValid = false;
            this.setErrorMessage(VCEMessages.getString("PreferencePage.CodeGen.Error.DelayTimeMustBeInteger_ERROR_"));
            this.setValid(false);
        }
        if (isValid) {
            boolean isValidTotalTime = this.calculateTotalSourceToVisualTime();
            if (isValidTotalTime) {
                this.setValid(true);
                this.setErrorMessage(null);
            } else {
                this.setValid(false);
            }
        }
    }

    protected boolean calculateTotalSourceToVisualTime() {
        try {
            int total = Integer.parseInt(this.sourceToVisual.getText());
            if (total < 0 || total > Integer.MAX_VALUE) {
                this.setErrorMessage(PropertysheetMessages.getString((String)"not_integer_WARN_"));
                return false;
            }
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public boolean performOk() {
        String existingLookAndFeelClass;
        String lookAndFeelClass = "";
        if (this.currentLookAndFeelItem != null) {
            lookAndFeelClass = this.currentLookAndFeelItem.getText(1);
        }
        if (lookAndFeelClass == null) {
            lookAndFeelClass = "";
        }
        if (!lookAndFeelClass.equals(existingLookAndFeelClass = this.fStore.getString("SWING_LOOKANDFEEL"))) {
            this.fStore.setValue("SWING_LOOKANDFEEL", lookAndFeelClass);
        }
        ArrayList<String[]> userClasses = new ArrayList<String[]>(1);
        int i = 0;
        while (i < this.lookAndFeelTable.getItemCount()) {
            TableItem item = this.lookAndFeelTable.getItem(i);
            if (USER_ITEM.equals(item.getData())) {
                userClasses.add(new String[]{item.getText(0), item.getText(1)});
            }
            ++i;
        }
        if (userClasses.size() > 0) {
            VCEPreferences.setUserLookAndFeelClasses((String[][])userClasses.toArray((T[])new String[userClasses.size()][]));
        } else {
            VCEPreferences.setUserLookAndFeelClasses(null);
        }
        this.fStore.setValue("SHOW_LIVE_WINDOW", this.showWindowCheckBox.getSelection());
        this.fStore.setValue("NOTEBOOK_PAGE", this.notebookRadioButton.getSelection());
        this.fStore.setValue("OPEN_PROPERTIES_VIEW", this.openPropertiesViewIfRequired.getSelection());
        this.fStore.setValue("OPEN_JAVABEANS_VIEW", this.openJavaBeansViewIfRequired.getSelection());
        this.fStore.setValue("GENERATE_EXPRESSION_COMMENT", this.generateExpressionComment.getSelection());
        this.fStore.setValue("GENERATE_TRY_CATCH_BLOCK", this.generateTryCatchBlock.getSelection());
        this.fStore.setValue("SOURCE_SYNC_DELAY_NEW", Integer.parseInt(this.sourceToVisual.getText()));
        this.fStore.setValue("SOURCE_DELAY_FACTOR_NEW", 1);
        this.fStore.setValue("JVA_PATTERN_STYLE_ID", this.fStyleID);
        this.saveContributorSettings();
        VCEPreferences.getPlugin().savePluginPreferences();
        Preferences cdePreferenceStore = CDEPlugin.getPlugin().getPluginPreferences();
        boolean existingShowXMLText = cdePreferenceStore.getBoolean("SHOW_XML");
        if (existingShowXMLText != this.showXMLTextCheckBox.getSelection()) {
            cdePreferenceStore.setValue("SHOW_XML", this.showXMLTextCheckBox.getSelection());
        }
        CDEPlugin.getPlugin().savePluginPreferences();
        return true;
    }

    protected void saveContributorSettings() {
        TableItem[] items = this.stylesTable.getItems();
        int i = 0;
        while (i < items.length) {
            StylesTableItem data = (StylesTableItem)items[i].getData();
            if (data.styleContributor != null) {
                data.styleUI.storeUI();
            }
            ++i;
        }
    }

    protected void performDefaults() {
        Preferences store = VCEPreferences.getPlugin().getPluginPreferences();
        this.showXMLTextCheckBox.setSelection(store.getDefaultBoolean("SELECT_SOURCE"));
        this.showWindowCheckBox.setSelection(store.getDefaultBoolean("SHOW_LIVE_WINDOW"));
        TableItem[] items = this.lookAndFeelTable.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].setChecked(false);
            if (USER_ITEM.equals(items[i].getData())) {
                items[i].dispose();
            }
            ++i;
        }
        this.currentLookAndFeelItem = this.lookAndFeelTable.getItem(0);
        this.currentLookAndFeelItem.setChecked(true);
        this.notebookRadioButton.setSelection(store.getDefaultBoolean("NOTEBOOK_PAGE"));
        this.generateExpressionComment.setSelection(store.getDefaultBoolean("GENERATE_EXPRESSION_COMMENT"));
        this.generateTryCatchBlock.setSelection(store.getDefaultBoolean("GENERATE_TRY_CATCH_BLOCK"));
        this.splitRadioButton.setSelection(!store.getDefaultBoolean("NOTEBOOK_PAGE"));
        this.sourceToVisual.setText(Integer.toString(1000));
        this.openPropertiesViewIfRequired.setSelection(true);
        this.openJavaBeansViewIfRequired.setSelection(true);
        this.restoreDefaultStyle();
    }

    public void init(IWorkbench aWorkbench) {
    }

    public void dispose() {
        super.dispose();
        if (this.fJavaBeansViewImage != null) {
            this.fJavaBeansViewImage.dispose();
        }
        if (this.fPropertiesViewImage != null) {
            this.fPropertiesViewImage.dispose();
        }
        if (this.fJavaBeansToSourceImage != null) {
            this.fJavaBeansToSourceImage.dispose();
        }
        if (this.fSourceToJavaBeansImage != null) {
            this.fSourceToJavaBeansImage.dispose();
        }
    }

    private static class StylesTableItem {
        public boolean activated;
        public String styleID;
        public IEditorStylePrefUI styleUI;
        public Control styleContributor;

        public StylesTableItem(String styleID) {
            this.styleID = styleID;
        }
    }
}

