/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.vce.launcher;

import java.io.File;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.java.vce.VCEPreferences;
import org.eclipse.ve.internal.java.vce.launcher.VCELauncherMessages;

public class JavaBeanLaunchConfigurationDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    static String LAUNCHER_TYPE_NAME = "org.eclipse.ve.internal.java.vce.launcher.remotevm.JavaBeansLauncher";
    static String JFC_LAUNCHER_TYPE_NAME = "org.eclipse.ve.internal.java.vce.launcher.remotevm.JFCLauncher";
    static String SWT_LAUNCHER_TYPE_NAME = "org.eclipse.ve.internal.java.vce.launcher.remotevm.SWTLauncher";
    static String PACK = " PACK";
    static String LOCALE = "LOCALE";
    static String APPLET_PARMS_NUMBER = "APPLET_PARMS_NUMBER";
    static String APPLET_PARM_NAME = "APPLET_PARM_NAME";
    static String APPLET_PARM_VALUE = "APPLET_PARM_VALUE";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(VCELauncherMessages.getString("LaunchConfigurationDelegate.Msg.Launching"), -1);
        if (monitor.isCanceled()) {
            return;
        }
        String javaBeanName = this.verifyMainTypeName(configuration);
        IVMInstall vm = this.verifyVMInstall(configuration);
        IVMRunner runner = vm.getVMRunner(mode);
        if (runner == null) {
            this.abort(MessageFormat.format(VCELauncherMessages.getString("Launcher.jreerror.msg_ERROR_"), vm.getId()), null, 106);
        }
        File workingDir = this.verifyWorkingDirectory(configuration);
        String workingDirName = null;
        if (workingDir != null) {
            workingDirName = workingDir.getAbsolutePath();
        }
        String pgmArgs = this.getProgramArguments(configuration);
        String vmArgs = this.getVMArguments(configuration, javaBeanName);
        ExecutionArguments execArgs = new ExecutionArguments(vmArgs, pgmArgs);
        Map vmAttributesMap = this.getVMSpecificAttributesMap(configuration);
        String[] classpath = this.getClasspath(configuration);
        String[] remoteVMLocations = ProxyPlugin.getPlugin().localizeFromBundleAndFragments(JavaVEPlugin.getPlugin().getBundle(), "vm/vcelauncher.jar");
        String[] newClassPath = new String[classpath.length + remoteVMLocations.length];
        System.arraycopy(remoteVMLocations, 0, newClassPath, 0, remoteVMLocations.length);
        System.arraycopy(classpath, 0, newClassPath, remoteVMLocations.length, classpath.length);
        VMRunnerConfiguration runConfig = new VMRunnerConfiguration(LAUNCHER_TYPE_NAME, newClassPath);
        runConfig.setProgramArguments(execArgs.getProgramArgumentsArray());
        runConfig.setVMArguments(execArgs.getVMArgumentsArray());
        runConfig.setWorkingDirectory(workingDirName);
        runConfig.setVMSpecificAttributesMap(vmAttributesMap);
        String[] bootpath = this.getBootpath(configuration);
        runConfig.setBootClassPath(bootpath);
        if (monitor.isCanceled()) {
            return;
        }
        runner.run(runConfig, launch, monitor);
        if (monitor.isCanceled()) {
            return;
        }
        this.setDefaultSourceLocator(launch, configuration);
        monitor.done();
    }

    public String getVMArguments(ILaunchConfiguration configuration, String javaBeanName) throws CoreException {
        String numberOfAppletParmsString;
        boolean pack;
        String locale;
        String swtLib;
        StringBuffer args = new StringBuffer(super.getVMArguments(configuration));
        String launchersList = JFC_LAUNCHER_TYPE_NAME;
        if (configuration.getAttribute("isSWT", false) && !args.toString().matches(".*java.library.path=.*swt.*os.*") && (swtLib = ProxyPlugin.getPlugin().localizeFromBundle(Platform.getBundle((String)"org.eclipse.swt"), "$os$")) != null) {
            if (Platform.getOS().equals("win32") && swtLib.charAt(0) == '/') {
                swtLib = swtLib.substring(1);
            }
            args.append(" -Djava.library.path=\"" + swtLib + "\"");
            launchersList = String.valueOf(launchersList) + "," + SWT_LAUNCHER_TYPE_NAME;
        }
        args.append(" -Dvce.launchers=\"" + launchersList + "\"");
        args.append(" -Dvce.launcher.class=" + javaBeanName);
        String lookAndFeelClass = configuration.getAttribute("SWING_LOOKANDFEEL", "");
        if (lookAndFeelClass.equals("")) {
            lookAndFeelClass = VCEPreferences.getPlugin().getPluginPreferences().getString("SWING_LOOKANDFEEL");
        }
        if (!lookAndFeelClass.equals("")) {
            args.append(" -Dvce.launcher.lookandfeel=" + lookAndFeelClass);
        }
        if (!(locale = configuration.getAttribute(LOCALE, "")).equals("")) {
            args.append(" -Dlocale=" + locale);
        }
        if (pack = configuration.getAttribute(PACK, false)) {
            args.append(" -Dpack=true");
        }
        if (!(numberOfAppletParmsString = configuration.getAttribute(APPLET_PARMS_NUMBER, "")).equals("")) {
            int numberOfAppletParms = Integer.parseInt(numberOfAppletParmsString);
            args.append(" -Dappletparmsnumber=" + numberOfAppletParmsString);
            int i = 1;
            while (i <= numberOfAppletParms) {
                String name = configuration.getAttribute(String.valueOf(APPLET_PARM_NAME) + i, "");
                args.append(" -Dappletparmname" + i + "=\"" + name + "\"");
                String value = configuration.getAttribute(String.valueOf(APPLET_PARM_VALUE) + i, "");
                args.append(" -Dappletparmvalue" + i + "=\"" + value + "\"");
                ++i;
            }
        }
        return args.toString();
    }
}

