/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.wizard;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.java.wizard.InternalMessages;

public class RegisteredClasspathContainerWizardPage
extends WizardPage
implements IClasspathContainerPage,
IExecutableExtension {
    protected IClasspathEntry fContainerEntry;
    protected String containerid;
    protected IConfigurationElement configData;
    protected static Image fVariableImage;
    protected static Image fExternalJarImage;
    protected static Image fExternalJarWithSourceImage;

    public RegisteredClasspathContainerWizardPage() {
        super(InternalMessages.getString("ClasspathWizardPage.PageName"));
        this.setImageDescriptor(JavaVEPlugin.getWizardTitleImageDescriptor());
    }

    public void createControl(Composite parent) {
        Composite c = new Composite(parent, 0);
        this.setControl((Control)c);
        GridLayout layout = new GridLayout(2, false);
        c.setLayout((Layout)layout);
        if (this.configData == null) {
            this.setErrorMessage(MessageFormat.format(InternalMessages.getString("ClasspathWizardPage.NoConfigData.ErrorMessage_ERROR_"), this.containerid));
            new Label(c, 0).setText(MessageFormat.format(InternalMessages.getString("ClasspathWizardPage.NoConfigData.Label.ErrorMessage_ERROR_"), this.containerid));
            this.setControl((Control)c);
            return;
        }
        Group g = this.createGroup(c, 2);
        g.setText(InternalMessages.getString("ClasspathWizardPage.Group.Buildpath.Includes"));
        if (fExternalJarImage == null) {
            fExternalJarImage = JavaPlugin.getDefault().getImageRegistry().get("org.eclipse.jdt.ui.jar_l_obj.gif");
        }
        if (fExternalJarWithSourceImage == null) {
            fExternalJarWithSourceImage = JavaPlugin.getDefault().getImageRegistry().get("org.eclipse.jdt.ui.jar_lsrc_obj.gif");
        }
        IConfigurationElement[] libraries = this.configData.getChildren("library");
        int i = 0;
        while (i < libraries.length) {
            IConfigurationElement library = libraries[i];
            String runtime = library.getAttributeAsIs("runtime");
            String source = library.getAttributeAsIs("source");
            if (source == null) {
                new Label((Composite)g, 0).setImage(fExternalJarImage);
            } else {
                new Label((Composite)g, 0).setImage(fExternalJarWithSourceImage);
            }
            new Label((Composite)g, 0).setText(String.valueOf(this.containerid) + "/" + runtime);
            if (source != null) {
                this.createSpacer((Composite)g, 1);
                Label l = this.createIndentedLabel((Composite)g);
                l.setText(MessageFormat.format(InternalMessages.getString("ClasspathWizardPage.BuildPath.SourceAttachments.Message"), String.valueOf(this.containerid) + "/" + source));
            }
            ++i;
        }
    }

    public boolean finish() {
        Path path = new Path(this.containerid);
        this.setSelection(JavaCore.newContainerEntry((IPath)path));
        return true;
    }

    public IClasspathEntry getSelection() {
        return this.fContainerEntry;
    }

    protected Label createIndentedLabel(Composite c) {
        Label result = new Label(c, 0);
        GridData indentData = new GridData();
        indentData.horizontalIndent = 30;
        result.setLayoutData((Object)indentData);
        return result;
    }

    protected Group createGroup(Composite c, int rows) {
        Group g = new Group(c, 0);
        g.setLayout((Layout)new GridLayout(rows, false));
        GridData gData = new GridData(768);
        gData.horizontalSpan = 2;
        g.setLayoutData((Object)gData);
        return g;
    }

    protected void createSpacer(Composite c, int span) {
        Label label = new Label(c, 0);
        if (span > 1) {
            GridData data = new GridData();
            data.horizontalSpan = 2;
            label.setLayoutData((Object)data);
        }
    }

    public void setSelection(IClasspathEntry containerEntry) {
        this.fContainerEntry = containerEntry;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.containerid = config.getAttributeAsIs("id");
        String name = config.getAttribute("name");
        IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor(JavaVEPlugin.getPlugin().getBundle().getSymbolicName(), "registrations");
        int i = 0;
        while (i < configs.length) {
            String ctrid = configs[i].getAttributeAsIs("container");
            if (this.containerid.equals(ctrid)) {
                this.configData = configs[i];
                this.setTitle(MessageFormat.format(InternalMessages.getString("RegisteredClasspathContainerWizardPage.Title"), name, this.containerid));
                break;
            }
            ++i;
        }
    }
}

