/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.core;

import java.text.MessageFormat;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.internal.proxy.core.IArrayBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBooleanBeanProxy;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jem.internal.proxy.core.IteratorBeanProxyWrapper;
import org.eclipse.jem.internal.proxy.core.JavaStandardBeanProxyConstants;
import org.eclipse.jem.internal.proxy.core.ProxyMessages;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;

public class CollectionBeanProxyWrapper {
    protected final IBeanProxy fCollection;
    protected final JavaStandardBeanProxyConstants fConstants;

    public CollectionBeanProxyWrapper(IBeanProxy aCollectionProxy) {
        if (!aCollectionProxy.getTypeProxy().isKindOf(aCollectionProxy.getProxyFactoryRegistry().getBeanTypeProxyFactory().getBeanTypeProxy("java.util.Collection"))) {
            throw new ClassCastException(MessageFormat.format(ProxyMessages.getString("ClassCast_EXC_.IncorrectType"), aCollectionProxy.getTypeProxy().getTypeName(), "java.util.Collection"));
        }
        this.fCollection = aCollectionProxy;
        this.fConstants = JavaStandardBeanProxyConstants.getConstants(aCollectionProxy.getProxyFactoryRegistry());
    }

    public IBeanProxy getBeanProxy() {
        return this.fCollection;
    }

    public boolean equals(Object object) {
        return this.fCollection.equals(object);
    }

    public int hashCode() {
        return this.fCollection.hashCode();
    }

    public boolean add(IBeanProxy object) throws ThrowableProxy {
        return ((IBooleanBeanProxy)this.fConstants.getCollectionAdd().invoke(this.fCollection, object)).booleanValue();
    }

    public boolean addAll(IBeanProxy collection) throws ThrowableProxy {
        return ((IBooleanBeanProxy)this.fConstants.getCollectionAddAll().invoke(this.fCollection, collection)).booleanValue();
    }

    public void clear() throws ThrowableProxy {
        this.fConstants.getCollectionClear().invoke(this.fCollection);
    }

    public boolean contains(IBeanProxy object) {
        try {
            return ((IBooleanBeanProxy)this.fConstants.getCollectionContains().invoke(this.fCollection, object)).booleanValue();
        }
        catch (ThrowableProxy e) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(4, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, ProxyMessages.getString("UnexpectedException_EXC_"), (Throwable)e));
            return false;
        }
    }

    public boolean containsAll(IBeanProxy collection) {
        try {
            return ((IBooleanBeanProxy)this.fConstants.getCollectionContainsAll().invoke(this.fCollection, collection)).booleanValue();
        }
        catch (ThrowableProxy e) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(4, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, ProxyMessages.getString("UnexpectedException_EXC_"), (Throwable)e));
            return false;
        }
    }

    public boolean isEmpty() {
        try {
            return ((IBooleanBeanProxy)this.fConstants.getCollectionIsEmpty().invoke(this.fCollection)).booleanValue();
        }
        catch (ThrowableProxy e) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(4, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, ProxyMessages.getString("UnexpectedException_EXC_"), (Throwable)e));
            return true;
        }
    }

    public IteratorBeanProxyWrapper iterator() {
        try {
            IBeanProxy itr = this.fConstants.getCollectionIterator().invoke(this.fCollection);
            if (itr != null) {
                return new IteratorBeanProxyWrapper(itr);
            }
            return null;
        }
        catch (ThrowableProxy e) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(4, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, ProxyMessages.getString("UnexpectedException_EXC_"), (Throwable)e));
            return null;
        }
    }

    public boolean remove(IBeanProxy object) throws ThrowableProxy {
        return ((IBooleanBeanProxy)this.fConstants.getCollectionRemove().invoke(this.fCollection, object)).booleanValue();
    }

    public boolean removeAll(IBeanProxy collection) throws ThrowableProxy {
        return ((IBooleanBeanProxy)this.fConstants.getCollectionRemoveAll().invoke(this.fCollection, collection)).booleanValue();
    }

    public boolean retainAll(IBeanProxy collection) throws ThrowableProxy {
        return ((IBooleanBeanProxy)this.fConstants.getCollectionRetainAll().invoke(this.fCollection, collection)).booleanValue();
    }

    public int size() {
        try {
            return ((IIntegerBeanProxy)this.fConstants.getCollectionSize().invoke(this.fCollection)).intValue();
        }
        catch (ThrowableProxy e) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(4, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, ProxyMessages.getString("UnexpectedException_EXC_"), (Throwable)e));
            return 0;
        }
    }

    public IArrayBeanProxy toArray() throws ThrowableProxy {
        return (IArrayBeanProxy)this.fConstants.getCollectionToArray().invoke(this.fCollection);
    }

    public IArrayBeanProxy toArray(IArrayBeanProxy array) throws ThrowableProxy {
        return (IArrayBeanProxy)this.fConstants.getCollectionToArrayWithArray().invoke(this.fCollection, array);
    }
}

