/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import java.net.Socket;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.ICallback;
import org.eclipse.jem.internal.proxy.core.ICallbackRegistry;
import org.eclipse.jem.internal.proxy.remote.IREMBeanProxy;
import org.eclipse.jem.internal.proxy.remote.IREMBeanTypeProxy;
import org.eclipse.jem.internal.proxy.remote.IREMMethodProxy;
import org.eclipse.jem.internal.proxy.remote.REMCallbackThread;
import org.eclipse.jem.internal.proxy.remote.REMInterfaceBeanTypeProxy;
import org.eclipse.jem.internal.proxy.remote.REMMethodProxyFactory;
import org.eclipse.jem.internal.proxy.remote.REMProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanProxyFactory;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanTypeProxyFactory;

class REMCallbackRegistry
implements ICallbackRegistry {
    final REMProxyFactoryRegistry fFactory;
    final String fNamePostfix;
    List fThreads = Collections.synchronizedList(new LinkedList());
    HashMap fIdToCallback = new HashMap(5);
    HashSet fRegisteredCallbackProxies = new HashSet(5);
    IREMMethodProxy fInitializeCallback;
    IREMBeanProxy fRemoteServer;
    boolean registryOpen = true;

    public REMCallbackRegistry(String name, REMProxyFactoryRegistry aFactory) {
        this.fFactory = aFactory;
        this.fNamePostfix = name;
        REMStandardBeanTypeProxyFactory typeFactory = (REMStandardBeanTypeProxyFactory)this.fFactory.getBeanTypeProxyFactory();
        REMInterfaceBeanTypeProxy vmserverType = new REMInterfaceBeanTypeProxy(this.fFactory, new Integer(29), "org.eclipse.jem.internal.proxy.vm.remote.IVMServer");
        REMInterfaceBeanTypeProxy callbackType = new REMInterfaceBeanTypeProxy(this.fFactory, new Integer(30), "org.eclipse.jem.internal.proxy.vm.remote.ICallback");
        IREMBeanTypeProxy serverType = typeFactory.objectClass.newBeanTypeForClass(new Integer(32), "org.eclipse.jem.internal.proxy.vm.remote.RemoteVMServerThread", false);
        this.fInitializeCallback = (IREMMethodProxy)((REMMethodProxyFactory)this.fFactory.getMethodProxyFactory()).methodType.newBeanProxy(new Integer(33));
        this.fRemoteServer = serverType.newBeanProxy(new Integer(31));
        ((REMStandardBeanProxyFactory)this.fFactory.getBeanProxyFactory()).registerProxy(vmserverType);
        ((REMStandardBeanProxyFactory)this.fFactory.getBeanProxyFactory()).registerProxy(callbackType);
        ((REMStandardBeanProxyFactory)this.fFactory.getBeanProxyFactory()).registerProxy(this.fInitializeCallback);
        ((REMStandardBeanProxyFactory)this.fFactory.getBeanProxyFactory()).registerProxy(this.fRemoteServer);
    }

    public boolean createCallback(Socket incoming) {
        if (this.registryOpen) {
            REMCallbackThread st = new REMCallbackThread(incoming, this, "Callback Thread-" + this.fNamePostfix, this.fFactory, this.fFactory.fNoTimeouts);
            this.fThreads.add(st);
            st.start();
            return true;
        }
        return false;
    }

    public boolean requestShutdown() {
        if (!this.registryOpen) {
            return false;
        }
        this.shutdown();
        return true;
    }

    public void removeCallbackThread(REMCallbackThread thread) {
        this.fThreads.remove(thread);
    }

    private void shutdown() {
        REMCallbackThread[] threadsArray = this.fThreads.toArray(new REMCallbackThread[this.fThreads.size()]);
        int i = 0;
        while (i < threadsArray.length) {
            threadsArray[i].close();
            ++i;
        }
        i = 0;
        while (i < threadsArray.length) {
            try {
                threadsArray[i].join(10000L);
            }
            catch (InterruptedException interruptedException) {}
            ++i;
        }
        this.fThreads.clear();
        this.fIdToCallback.clear();
        this.fRegisteredCallbackProxies.clear();
        this.fInitializeCallback = null;
        this.fRemoteServer = null;
    }

    public ICallback getRegisteredCallback(int id) {
        HashMap hashMap = this.fIdToCallback;
        synchronized (hashMap) {
            return (ICallback)this.fIdToCallback.get(new Integer(id));
        }
    }

    public void registerCallback(IBeanProxy callbackProxy, ICallback cb) {
        HashMap hashMap = this.fIdToCallback;
        synchronized (hashMap) {
            this.fIdToCallback.put(((IREMBeanProxy)callbackProxy).getID(), cb);
            this.fRegisteredCallbackProxies.add(callbackProxy);
            this.fInitializeCallback.invokeCatchThrowableExceptions(callbackProxy, new IBeanProxy[]{this.fRemoteServer, this.fFactory.getBeanProxyFactory().createBeanProxyWith(((IREMBeanProxy)callbackProxy).getID().intValue())});
        }
    }

    public void deregisterCallback(IBeanProxy callbackProxy) {
        HashMap hashMap = this.fIdToCallback;
        synchronized (hashMap) {
            this.fIdToCallback.remove(((IREMBeanProxy)callbackProxy).getID());
            this.fRegisteredCallbackProxies.remove(callbackProxy);
        }
    }
}

