/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.ide;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IConstructorProxy;
import org.eclipse.jem.internal.proxy.core.IFieldProxy;
import org.eclipse.jem.internal.proxy.core.IInvokable;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.internal.proxy.ide.IDEBeanProxy;
import org.eclipse.jem.internal.proxy.ide.IDEMethodProxyFactory;
import org.eclipse.jem.internal.proxy.ide.IDEObjectBeanProxy;
import org.eclipse.jem.internal.proxy.ide.IDEProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.ide.IDEStandardBeanProxyFactory;
import org.eclipse.jem.internal.proxy.ide.IDEStandardBeanTypeProxyFactory;
import org.eclipse.jem.internal.proxy.ide.IIDEBeanProxy;

public class IDEBeanTypeProxy
extends IDEBeanProxy
implements IBeanTypeProxy {
    protected IDEProxyFactoryRegistry fProxyFactoryRegistry;
    Class fClass;

    protected IDEBeanTypeProxy(IDEProxyFactoryRegistry aRegistry, Class aClass) {
        super(aRegistry, aClass);
        this.fProxyFactoryRegistry = aRegistry;
        this.fClass = aClass;
    }

    public IBeanTypeProxy getTypeProxy() {
        return ((IDEStandardBeanTypeProxyFactory)this.fProxyFactoryRegistry.getBeanTypeProxyFactory()).classClass;
    }

    public Class getTypeClass() {
        return this.fClass;
    }

    public String toBeanString() {
        return this.fClass.toString();
    }

    public ProxyFactoryRegistry getProxyFactoryRegistry() {
        return this.fProxyFactoryRegistry;
    }

    public String getTypeName() {
        return this.fClass.getName();
    }

    public boolean isKindOf(IBeanTypeProxy aBeanTypeProxy) {
        return ((IDEBeanTypeProxy)aBeanTypeProxy).fClass.isAssignableFrom(this.fClass);
    }

    public boolean isInterface() {
        return this.fClass.isInterface();
    }

    public boolean isPrimitive() {
        return this.fClass.isPrimitive();
    }

    public boolean isArray() {
        return this.fClass.isArray();
    }

    public IMethodProxy getMethodProxy(String methodName) {
        try {
            Method aMethod = this.fClass.getMethod(methodName, new Class[0]);
            return ((IDEMethodProxyFactory)this.fProxyFactoryRegistry.getMethodProxyFactory()).getMethodProxy(aMethod);
        }
        catch (Exception exc) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)exc));
            return null;
        }
    }

    public IMethodProxy getMethodProxy(String methodName, String[] argumentClassNames) {
        return ((IDEMethodProxyFactory)this.fProxyFactoryRegistry.getMethodProxyFactory()).getMethodProxy(this, methodName, argumentClassNames);
    }

    public IMethodProxy getMethodProxy(String methodName, String firstArgClass) {
        return this.getMethodProxy(methodName, new String[]{firstArgClass});
    }

    public IMethodProxy getMethodProxy(String methodName, IBeanTypeProxy[] args) {
        Class[] argClasses = new Class[args.length];
        int i = 0;
        while (i < args.length) {
            argClasses[i] = ((IDEBeanTypeProxy)args[i]).fClass;
            ++i;
        }
        return ((IDEMethodProxyFactory)this.fProxyFactoryRegistry.getMethodProxyFactory()).getMethodProxy(this.fClass, methodName, argClasses);
    }

    public IInvokable getInvokable(String methodName, IBeanTypeProxy[] argumentTypes) {
        return this.getMethodProxy(methodName, argumentTypes);
    }

    public IInvokable getInvokable(String methodName, String argumentClassName) {
        return this.getMethodProxy(methodName, argumentClassName);
    }

    public IInvokable getInvokable(String methodName, String[] argumentClassNames) {
        return this.getMethodProxy(methodName, argumentClassNames);
    }

    public IInvokable getInvokable(String methodName) {
        return this.getMethodProxy(methodName);
    }

    public IConstructorProxy getConstructorProxy(String[] argTypeNames) {
        Class[] argClasses = new Class[argTypeNames.length];
        try {
            int i = 0;
            while (i < argTypeNames.length) {
                argClasses[i] = Class.forName(argTypeNames[i]);
                ++i;
            }
        }
        catch (ClassNotFoundException exc) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "Constructor not found - " + this.fClass.getName() + " args=" + argTypeNames, (Throwable)exc));
            return null;
        }
        return ((IDEMethodProxyFactory)this.fProxyFactoryRegistry.getMethodProxyFactory()).getConstructorProxy(this.fClass, argClasses);
    }

    public IConstructorProxy getConstructorProxy(IBeanTypeProxy[] args) {
        Class[] argClasses = new Class[args.length];
        int i = 0;
        while (i < args.length) {
            argClasses[i] = ((IDEBeanTypeProxy)args[i]).fClass;
            ++i;
        }
        return ((IDEMethodProxyFactory)this.fProxyFactoryRegistry.getMethodProxyFactory()).getConstructorProxy(this.fClass, argClasses);
    }

    public IBeanTypeProxy getSuperBeanTypeProxy() {
        if (this.fClass.isInterface()) {
            return null;
        }
        return this.fProxyFactoryRegistry.getBeanTypeProxyFactory().getBeanTypeProxy(this.fClass.getSuperclass().getName());
    }

    public IFieldProxy getFieldProxy(String fieldName) {
        try {
            Field field = this.fClass.getField(fieldName);
            return ((IDEMethodProxyFactory)this.fProxyFactoryRegistry.getMethodProxyFactory()).getFieldProxy(field);
        }
        catch (NoSuchFieldException exc) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "Field not found " + this.fClass.getName() + " - " + fieldName, (Throwable)exc));
            return null;
        }
    }

    public IFieldProxy getDeclaredFieldProxy(String fieldName) {
        try {
            Field field = this.fClass.getDeclaredField(fieldName);
            return ((IDEMethodProxyFactory)this.fProxyFactoryRegistry.getMethodProxyFactory()).getFieldProxy(field);
        }
        catch (NoSuchFieldException exc) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "Field not found " + this.fClass.getName() + " - " + fieldName, (Throwable)exc));
            return null;
        }
    }

    IConstructorProxy getConstructorProxy(Class[] parameterTypes) {
        Constructor aConstructor = null;
        try {
            aConstructor = this.fClass.getConstructor(parameterTypes);
        }
        catch (Exception e) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
        }
        if (aConstructor != null) {
            return this.getNewConstructorProxy(aConstructor);
        }
        return null;
    }

    protected IConstructorProxy getNewConstructorProxy(Constructor aConstructor) {
        return ((IDEMethodProxyFactory)this.fProxyFactoryRegistry.getMethodProxyFactory()).getConstructorProxy(aConstructor);
    }

    public IConstructorProxy getNullConstructorProxy() {
        Constructor aConstructor = null;
        try {
            aConstructor = this.fClass.getConstructor(null);
            return ((IDEMethodProxyFactory)this.fProxyFactoryRegistry.getMethodProxyFactory()).getConstructorProxy(aConstructor);
        }
        catch (Exception e) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
            return null;
        }
    }

    public IBeanProxy newInstance(String initializationString) {
        return ((IDEStandardBeanProxyFactory)this.fProxyFactoryRegistry.getBeanProxyFactory()).createBeanProxy(this, initializationString);
    }

    public IBeanProxy newInstance() {
        return ((IDEStandardBeanProxyFactory)this.fProxyFactoryRegistry.getBeanProxyFactory()).createBeanProxy(this);
    }

    protected IIDEBeanProxy newBeanProxy(Object anObject) {
        return new IDEObjectBeanProxy(this.fProxyFactoryRegistry, anObject, this);
    }

    public IDEBeanTypeProxy newBeanTypeForClass(Class type) {
        return new IDEBeanTypeProxy(this.fProxyFactoryRegistry, type);
    }

    public String getFormalTypeName() {
        return this.getTypeName();
    }

    public String getInitializationError() {
        return null;
    }
}

