/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.ConstrainedLayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jem.internal.proxy.core.IStringBeanProxy;
import org.eclipse.ve.internal.cde.commands.NoOpCommand;
import org.eclipse.ve.internal.cde.emf.InverseMaintenanceAdapter;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.visual.VisualContainerPolicy;
import org.eclipse.ve.internal.jfc.core.BorderLayoutFeedback;
import org.eclipse.ve.internal.jfc.core.BorderLayoutPolicyHelper;
import org.eclipse.ve.internal.jfc.core.BorderLayoutRegionFeedback;
import org.eclipse.ve.internal.jfc.core.ContainerPolicy;
import org.eclipse.ve.internal.jfc.core.JFCConstants;

public class BorderLayoutEditPolicy
extends ConstrainedLayoutEditPolicy {
    protected VisualContainerPolicy fPolicy;
    protected BorderLayoutPolicyHelper fLayoutPolicyHelper = new BorderLayoutPolicyHelper();
    protected BorderLayoutFeedback fBorderLayoutFeedback = null;
    protected BorderLayoutRegionFeedback fRegionFeedback = null;
    protected Rectangle fCurrentRectangle = null;

    public BorderLayoutEditPolicy(VisualContainerPolicy aContainerPolicy) {
        this.fLayoutPolicyHelper.setContainerPolicy(aContainerPolicy);
        this.fPolicy = aContainerPolicy;
    }

    public void activate() {
        super.activate();
        this.fPolicy.setContainer(this.getHost().getModel());
    }

    public void deactivate() {
        super.deactivate();
        this.fPolicy.setContainer(null);
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        return new NonResizableEditPolicy();
    }

    protected Point getLocationFromRequest(Request request) {
        if (request instanceof CreateRequest) {
            return ((CreateRequest)request).getLocation();
        }
        if (request instanceof ChangeBoundsRequest) {
            return ((ChangeBoundsRequest)request).getLocation();
        }
        return null;
    }

    private void addRegionFeedback(Request request) {
        Point position = this.getLocationFromRequest(request).getCopy();
        this.getHostFigure().translateToRelative((Translatable)position);
        String str = this.fBorderLayoutFeedback.getCurrentConstraint(position);
        if (this.fLayoutPolicyHelper.isRegionAvailable(str)) {
            Rectangle r = this.fBorderLayoutFeedback.getCurrentRectangle(position);
            if (!(r == null || this.fCurrentRectangle != null && r.equals((Object)this.fCurrentRectangle))) {
                if (this.fRegionFeedback != null) {
                    this.removeFeedback((IFigure)this.fRegionFeedback);
                }
                this.fCurrentRectangle = r;
                BorderLayoutRegionFeedback rf = new BorderLayoutRegionFeedback();
                rf.setLabel(BorderLayoutFeedback.getDisplayConstraint(str));
                this.fRegionFeedback = rf;
                this.fRegionFeedback.setBounds(r);
                this.addFeedback((IFigure)this.fRegionFeedback);
            }
        } else if (this.fRegionFeedback != null) {
            this.removeFeedback((IFigure)this.fRegionFeedback);
            this.fRegionFeedback = null;
            this.fCurrentRectangle = null;
        }
    }

    protected Command createAddCommand(EditPart childEditPart, Object constraint) {
        if (constraint == null || !(constraint instanceof String)) {
            return UnexecutableCommand.INSTANCE;
        }
        ArrayList<IJavaObjectInstance> children = new ArrayList<IJavaObjectInstance>(1);
        IJavaObjectInstance child = (IJavaObjectInstance)childEditPart.getModel();
        children.add(child);
        UnexecutableCommand addCmd = UnexecutableCommand.INSTANCE;
        if (this.fLayoutPolicyHelper.isRegionAvailable((String)constraint)) {
            addCmd = this.fLayoutPolicyHelper.getAddChildrenCommand(children, Collections.singletonList(constraint), null);
        }
        return addCmd;
    }

    protected Command createChangeConstraintCommand(EditPart childEditPart, Object constraint) {
        return this.fLayoutPolicyHelper.getChangeConstraintCommand(Collections.singletonList(childEditPart.getModel()), Collections.singletonList(constraint));
    }

    protected Command createCreateCommand(Object child, String aConstraint) {
        UnexecutableCommand addCmd = UnexecutableCommand.INSTANCE;
        if (this.fLayoutPolicyHelper.isRegionAvailable(aConstraint)) {
            addCmd = this.fLayoutPolicyHelper.getCreateChildCommand(child, aConstraint, null);
        }
        return addCmd;
    }

    protected void eraseLayoutTargetFeedback(Request request) {
        if (this.fBorderLayoutFeedback != null) {
            this.removeFeedback((IFigure)this.fBorderLayoutFeedback);
            this.fBorderLayoutFeedback = null;
        }
        if (this.fRegionFeedback != null) {
            this.removeFeedback((IFigure)this.fRegionFeedback);
            this.fRegionFeedback = null;
            this.fCurrentRectangle = null;
        }
    }

    protected Command getAddCommand(Request request) {
        ChangeBoundsRequest cbReq = (ChangeBoundsRequest)request;
        if (cbReq.getEditParts().size() > 1) {
            return UnexecutableCommand.INSTANCE;
        }
        EditPart child = (EditPart)cbReq.getEditParts().get(0);
        Point p = cbReq.getLocation().getCopy();
        this.getHostFigure().translateToRelative((Translatable)p);
        String constraint = null;
        if (this.fBorderLayoutFeedback != null) {
            constraint = this.fBorderLayoutFeedback.getCurrentConstraint(p);
        }
        if (constraint != null) {
            return this.createAddCommand(child, constraint);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command getAlignmentChildCommand(Request request) {
        return null;
    }

    private Figure getBorderLayoutFeedback(Request request) {
        if (this.fBorderLayoutFeedback == null) {
            BorderLayoutFeedback bf = new BorderLayoutFeedback();
            bf.setLineStyle(3);
            this.fBorderLayoutFeedback = bf;
            IFigure f = ((GraphicalEditPart)this.getHost()).getFigure();
            Rectangle r = f.getBounds().getCopy();
            r.shrink(2, 2);
            this.fBorderLayoutFeedback.setBounds(r);
            if (request.getType() != "move") {
                this.fBorderLayoutFeedback.setFilledRegions(this.fLayoutPolicyHelper.getFilledRegions());
            } else {
                this.fBorderLayoutFeedback.setFilledRegions(null);
            }
            this.addFeedback((IFigure)this.fBorderLayoutFeedback);
        }
        this.addRegionFeedback(request);
        return this.fBorderLayoutFeedback;
    }

    protected Object getConstraintFor(Point point) {
        if (this.fBorderLayoutFeedback != null) {
            Point relativePoint = point.getCopy();
            this.getHostFigure().translateToRelative((Translatable)relativePoint);
            return this.fBorderLayoutFeedback.getCurrentConstraint(relativePoint);
        }
        return null;
    }

    protected Object getConstraintFor(Rectangle rect) {
        return null;
    }

    protected String getConstraintFromViewObject(EditPart anEditPart) {
        IJavaObjectInstance component = (IJavaObjectInstance)anEditPart.getModel();
        EObject borderComponent = InverseMaintenanceAdapter.getFirstReferencedBy((Notifier)component, (EReference)JavaInstantiation.getReference((IJavaObjectInstance)component, (URI)JFCConstants.SF_CONSTRAINT_COMPONENT));
        IJavaObjectInstance javaStringConstraint = (IJavaObjectInstance)borderComponent.eGet(JavaInstantiation.getSFeature((IJavaObjectInstance)component, (URI)JFCConstants.SF_CONSTRAINT_CONSTRAINT));
        String stringConstraint = ((IStringBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)javaStringConstraint)).stringValue();
        return stringConstraint;
    }

    protected Command getCreateCommand(CreateRequest request) {
        Point p = request.getLocation().getCopy();
        this.getHostFigure().translateToRelative((Translatable)p);
        String constraint = null;
        if (this.fBorderLayoutFeedback != null) {
            constraint = this.fBorderLayoutFeedback.getCurrentConstraint(p);
        }
        if (constraint != null) {
            return this.createCreateCommand(request.getNewObject(), constraint);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command getDeleteDependantCommand(Request aRequest) {
        Command deleteContributionCmd = this.fPolicy.getCommand(aRequest);
        if (deleteContributionCmd == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return deleteContributionCmd;
    }

    protected Command getDistributeChildCommand(Request request) {
        return null;
    }

    protected Command getMoveChildrenCommand(Request generic) {
        Command tgtCmd;
        ChangeBoundsRequest request = (ChangeBoundsRequest)generic;
        List sources = request.getEditParts();
        if (sources.size() > 1) {
            return null;
        }
        EditPart source = (EditPart)sources.iterator().next();
        String sourceConstraint = this.getConstraintFromViewObject(source);
        String targetConstraint = (String)this.getConstraintFor(request.getLocation());
        EditPart target = null;
        List children = this.getHost().getChildren();
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            String cons;
            EditPart aVO = (EditPart)iter.next();
            if (aVO.equals(source) || (cons = this.getConstraintFromViewObject(aVO)) == null || !cons.equals(targetConstraint)) continue;
            target = aVO;
            break;
        }
        CompoundCommand cmpCmd = new CompoundCommand("Move_Child");
        if (target != null && (tgtCmd = this.createChangeConstraintCommand(target, sourceConstraint)) != null) {
            cmpCmd.add(tgtCmd);
        }
        if (targetConstraint != null && !targetConstraint.equals(sourceConstraint)) {
            Command srcCmd = this.createChangeConstraintCommand(source, targetConstraint);
            if (srcCmd != null) {
                cmpCmd.add(srcCmd);
            }
        } else {
            return NoOpCommand.INSTANCE;
        }
        return cmpCmd;
    }

    protected Command getOrphanChildrenCommand(Request aRequest) {
        return this.fLayoutPolicyHelper.getOrphanChildrenCommand(ContainerPolicy.getChildren((GroupRequest)((GroupRequest)aRequest)));
    }

    protected void showLayoutTargetFeedback(Request request) {
        this.getBorderLayoutFeedback(request);
    }
}

