/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.ve.internal.jfc.core.BorderLayoutPolicyHelper;

public class BorderLayoutFeedback
extends RectangleFigure {
    protected int fLineWidth = 1;
    protected int fLineStyle = 4;
    private String[] filledRegions;

    public void fillShape(Graphics g) {
        Rectangle r = this.getBounds().getCopy();
        if (this.getFilledRegions() != null) {
            Rectangle nRect = new Rectangle(r.x, r.y, r.width, r.height / 3);
            Rectangle wRect = new Rectangle(r.x, r.y + r.height / 3, r.width / 3, r.height / 3);
            Rectangle cRect = new Rectangle(r.x + r.width / 3, r.y + r.height / 3, r.width / 3, r.height / 3);
            Rectangle eRect = new Rectangle(r.x + 2 * r.width / 3, r.y + r.height / 3, r.width / 3, r.height / 3);
            Rectangle sRect = new Rectangle(r.x, r.y + 2 * r.height / 3, r.width, r.height / 3);
            g.setBackgroundColor(ColorConstants.gray);
            g.setXORMode(true);
            int i = 0;
            while (i < this.getFilledRegions().length) {
                if (this.getFilledRegions()[i].equals(BorderLayoutPolicyHelper.REAL_INTERNAL_TAGS.get(0))) {
                    g.fillRectangle(nRect);
                }
                if (this.getFilledRegions()[i].equals(BorderLayoutPolicyHelper.REAL_INTERNAL_TAGS.get(4))) {
                    g.fillRectangle(sRect);
                }
                if (this.getFilledRegions()[i].equals(BorderLayoutPolicyHelper.REAL_INTERNAL_TAGS.get(1))) {
                    g.fillRectangle(eRect);
                }
                if (this.getFilledRegions()[i].equals(BorderLayoutPolicyHelper.REAL_INTERNAL_TAGS.get(2))) {
                    g.fillRectangle(wRect);
                }
                if (this.getFilledRegions()[i].equals(BorderLayoutPolicyHelper.REAL_INTERNAL_TAGS.get(3))) {
                    g.fillRectangle(cRect);
                }
                ++i;
            }
        }
        g.setForegroundColor(ColorConstants.green);
        g.drawRectangle(r.x, r.y, r.width - 1, r.height - 1);
        g.drawLine(r.x, r.y + r.height / 3, r.x + r.width - 1, r.y + r.height / 3);
        g.drawLine(r.x, r.y + 2 * r.height / 3, r.x + r.width - 1, r.y + 2 * r.height / 3);
        g.drawLine(r.x + r.width / 3, r.y + r.height / 3, r.x + r.width / 3, r.y + 2 * r.height / 3);
        g.drawLine(r.x + 2 * r.width / 3, r.y + r.height / 3, r.x + 2 * r.width / 3, r.y + 2 * r.height / 3);
    }

    public String getCurrentConstraint(Point p) {
        if (p == null) {
            return null;
        }
        Rectangle r = this.getBounds().getCopy();
        Rectangle nRect = new Rectangle(r.x, r.y, r.width, r.height / 3);
        Rectangle wRect = new Rectangle(r.x, r.y + r.height / 3, r.width / 3, r.height / 3);
        Rectangle cRect = new Rectangle(r.x + r.width / 3, r.y + r.height / 3, r.width / 3, r.height / 3);
        Rectangle sRect = new Rectangle(r.x, r.y + 2 * r.height / 3, r.width, r.height / 3);
        Rectangle eRect = new Rectangle(r.x + 2 * r.width / 3, r.y + r.height / 3, r.width / 3, r.height / 3);
        if (nRect.contains(p)) {
            return (String)BorderLayoutPolicyHelper.REAL_INTERNAL_TAGS.get(0);
        }
        if (wRect.contains(p)) {
            return (String)BorderLayoutPolicyHelper.REAL_INTERNAL_TAGS.get(2);
        }
        if (cRect.contains(p)) {
            return (String)BorderLayoutPolicyHelper.REAL_INTERNAL_TAGS.get(3);
        }
        if (eRect.contains(p)) {
            return (String)BorderLayoutPolicyHelper.REAL_INTERNAL_TAGS.get(1);
        }
        if (sRect.contains(p)) {
            return (String)BorderLayoutPolicyHelper.REAL_INTERNAL_TAGS.get(4);
        }
        return null;
    }

    public Rectangle getCurrentRectangle(Point p) {
        if (p == null) {
            return null;
        }
        Rectangle r = this.getBounds().getCopy();
        Rectangle nRect = new Rectangle(r.x, r.y, r.width, r.height / 3);
        Rectangle wRect = new Rectangle(r.x, r.y + r.height / 3, r.width / 3, r.height / 3);
        Rectangle cRect = new Rectangle(r.x + r.width / 3, r.y + r.height / 3, r.width / 3, r.height / 3);
        Rectangle sRect = new Rectangle(r.x, r.y + 2 * r.height / 3, r.width, r.height / 3);
        Rectangle eRect = new Rectangle(r.x + 2 * r.width / 3, r.y + r.height / 3, r.width / 3, r.height / 3);
        if (nRect.contains(p)) {
            return nRect;
        }
        if (wRect.contains(p)) {
            return wRect;
        }
        if (cRect.contains(p)) {
            return cRect;
        }
        if (eRect.contains(p)) {
            return eRect;
        }
        if (sRect.contains(p)) {
            return sRect;
        }
        return null;
    }

    public static String getDisplayConstraint(String constraint) {
        int ndx = BorderLayoutPolicyHelper.REAL_INTERNAL_TAGS.indexOf(constraint);
        return ndx > -1 ? (String)BorderLayoutPolicyHelper.DISPLAY_TAGS.get(ndx) : "";
    }

    protected String[] getFilledRegions() {
        return this.filledRegions;
    }

    public int getLineWidth() {
        return this.fLineWidth;
    }

    public void setFilledRegions(String[] newFilledRegions) {
        this.filledRegions = newFilledRegions;
        this.invalidate();
    }

    public void setLineStyle(int newLineStyle) {
        this.fLineStyle = newLineStyle;
    }

    public void setLineWidth(int newLineWidth) {
        this.fLineWidth = newLineWidth;
    }
}

