/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import java.io.InputStream;
import java.util.logging.Level;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jem.internal.proxy.awt.IDimensionBeanProxy;
import org.eclipse.jem.internal.proxy.core.IArrayBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.ICallback;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.ve.internal.cde.core.IVisualComponentListener;
import org.eclipse.ve.internal.cde.core.VisualComponentSupport;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.jfc.core.BeanAwtUtilities;

public class ComponentManager
implements ICallback {
    protected VisualComponentSupport vcSupport = new VisualComponentSupport();
    protected IBeanProxy fComponentManagerProxy;
    protected IBeanProxy fComponentBeanProxy;

    public void addComponentListener(IVisualComponentListener aListener) {
        this.vcSupport.addComponentListener(aListener);
    }

    public void removeComponentListener(IVisualComponentListener aListener) {
        this.vcSupport.removeComponentListener(aListener);
    }

    public void setComponentBeanProxy(IBeanProxy aComponentBeanProxy) {
        if (this.fComponentBeanProxy != null) {
            BeanAwtUtilities.invoke_set_ComponentBean_Manager(this.fComponentManagerProxy, null);
        }
        this.fComponentBeanProxy = aComponentBeanProxy;
        if (this.fComponentBeanProxy != null) {
            try {
                if (this.fComponentManagerProxy == null) {
                    IBeanTypeProxy componentManagerType = this.fComponentBeanProxy.getProxyFactoryRegistry().getBeanTypeProxyFactory().getBeanTypeProxy("org.eclipse.ve.internal.jfc.vm.ComponentManager");
                    this.fComponentManagerProxy = componentManagerType.newInstance();
                    aComponentBeanProxy.getProxyFactoryRegistry().getCallbackRegistry().registerCallback(this.fComponentManagerProxy, (ICallback)this);
                }
                BeanAwtUtilities.invoke_set_ComponentBean_Manager(this.fComponentManagerProxy, this.fComponentBeanProxy);
            }
            catch (ThrowableProxy e) {
                JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
            }
        }
    }

    public void setRelativeParentComponentBeanProxy(IBeanProxy aContainerBeanProxy) {
        BeanAwtUtilities.invoke_set_RelativeParent_Manager(this.fComponentManagerProxy, aContainerBeanProxy);
    }

    public Object calledBack(int msgID, Object parm) {
        switch (msgID) {
            case 0: {
                this.componentHidden();
                break;
            }
            case 1: {
                this.componentShown();
                break;
            }
            case 4: {
                this.fireComponentRefresh();
            }
        }
        return null;
    }

    public Object calledBack(int msgID, IBeanProxy parm) {
        throw new RuntimeException("A component listener has been called back incorrectly");
    }

    public void calledBackStream(int msgID, InputStream is) {
        throw new RuntimeException("A component listener has been called back incorrectly");
    }

    public Object calledBack(int msgID, Object[] parms) {
        switch (msgID) {
            case 2: {
                this.componentResized(((IIntegerBeanProxy)parms[0]).intValue(), ((IIntegerBeanProxy)parms[1]).intValue());
                break;
            }
            case 3: {
                this.componentMoved(((IIntegerBeanProxy)parms[0]).intValue(), ((IIntegerBeanProxy)parms[1]).intValue());
            }
        }
        return null;
    }

    protected void componentResized(int width, int height) {
        this.vcSupport.fireComponentResized(width, height);
    }

    protected void componentMoved(int x, int y) {
        this.vcSupport.fireComponentMoved(x, y);
    }

    protected void componentHidden() {
        this.vcSupport.fireComponentHidden();
    }

    protected void componentShown() {
        this.vcSupport.fireComponentShown();
    }

    public void fireComponentRefresh() {
        this.vcSupport.fireComponentRefreshed();
    }

    public void dispose() {
        if (this.fComponentManagerProxy != null) {
            if (this.fComponentManagerProxy.isValid()) {
                BeanAwtUtilities.invoke_set_ComponentBean_Manager(this.fComponentManagerProxy, null);
                this.fComponentManagerProxy.getProxyFactoryRegistry().getCallbackRegistry().deregisterCallback(this.fComponentManagerProxy);
                this.fComponentManagerProxy.getProxyFactoryRegistry().releaseProxy(this.fComponentManagerProxy);
            }
            this.fComponentManagerProxy = null;
        }
    }

    public Rectangle getBounds() {
        return new Rectangle(this.getLocation(), this.getSize());
    }

    public Point getLocation() {
        try {
            IArrayBeanProxy locProxy = BeanAwtUtilities.invoke_get_Location_Manager(this.fComponentManagerProxy);
            return new Point(((IIntegerBeanProxy)locProxy.get(0)).intValue(), ((IIntegerBeanProxy)locProxy.get(1)).intValue());
        }
        catch (ThrowableProxy throwableProxy) {
            return new Point();
        }
    }

    public Dimension getSize() {
        IDimensionBeanProxy sizeProxy = BeanAwtUtilities.invoke_getSize(this.fComponentBeanProxy);
        return new Dimension(sizeProxy.getWidth(), sizeProxy.getHeight());
    }
}

