/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.TypeKind;
import org.eclipse.ve.internal.cde.core.CDEUtilities;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.emf.InverseMaintenanceAdapter;
import org.eclipse.ve.internal.java.core.BeanProxyAdapter;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.IBeanProxyDomain;
import org.eclipse.ve.internal.java.core.IBeanProxyHost;
import org.eclipse.ve.internal.java.core.IErrorHolder;
import org.eclipse.ve.internal.java.core.IHoldProcessing;
import org.eclipse.ve.internal.java.core.JavaEditDomainHelper;
import org.eclipse.ve.internal.jfc.core.BeanAwtUtilities;
import org.eclipse.ve.internal.jfc.core.ComponentProxyAdapter;
import org.eclipse.ve.internal.jfc.core.IComponentProxyHost;
import org.eclipse.ve.internal.jfc.core.JFCConstants;
import org.eclipse.ve.internal.jfc.core.VisualMessages;

public class ContainerProxyAdapter
extends ComponentProxyAdapter
implements IHoldProcessing {
    protected EReference sfConstraintConstraint;
    protected EReference sfContainerComponents;
    protected EReference sfConstraintComponent;
    protected EReference sfName;
    private int holdCount = 0;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ContainerProxyAdapter(IBeanProxyDomain domain) {
        super(domain);
        ResourceSet rset = JavaEditDomainHelper.getResourceSet((EditDomain)domain.getEditDomain());
        this.sfConstraintConstraint = JavaInstantiation.getReference((ResourceSet)rset, (URI)JFCConstants.SF_CONSTRAINT_CONSTRAINT);
        this.sfContainerComponents = JavaInstantiation.getReference((ResourceSet)rset, (URI)JFCConstants.SF_CONTAINER_COMPONENTS);
        this.sfConstraintComponent = JavaInstantiation.getReference((ResourceSet)rset, (URI)JFCConstants.SF_CONSTRAINT_COMPONENT);
        this.sfName = JavaInstantiation.getReference((ResourceSet)rset, (URI)JFCConstants.SF_COMPONENT_NAME);
    }

    protected void applied(EStructuralFeature as, Object newValue, int position) {
        if (as == this.sfContainerComponents) {
            if (!this.holding()) {
                this.addComponent((EObject)newValue, position);
            }
        } else {
            super.applied(as, newValue, position);
        }
    }

    protected void canceled(EStructuralFeature sf, Object oldValue, int position) {
        if (sf == this.sfContainerComponents) {
            if (!this.holding()) {
                this.removeComponent((EObject)oldValue);
            }
        } else {
            super.canceled(sf, oldValue, position);
        }
    }

    public void releaseBeanProxy() {
        if ((this.isBeanProxyInstantiated() || this.getErrorStatus() == 3) && ((JavaClass)this.getEObject().eClass()).getKind() != TypeKind.UNDEFINED_LITERAL) {
            IJavaInstance layoutValue;
            if (this.getEObject().eIsSet((EStructuralFeature)this.sfContainerComponents)) {
                Iterator itr = ((List)this.getEObject().eGet((EStructuralFeature)this.sfContainerComponents)).iterator();
                while (itr.hasNext()) {
                    EObject ip = (EObject)itr.next();
                    Iterator settings = new BeanProxyUtilities.JavaSettingsEList(ip, false).basicIterator();
                    while (settings.hasNext()) {
                        IBeanProxyHost value = (IBeanProxyHost)EcoreUtil.getExistingAdapter((Notifier)((Notifier)settings.next()), (Object)IBeanProxyHost.BEAN_PROXY_TYPE);
                        if (value == null) continue;
                        value.releaseBeanProxy();
                    }
                }
            }
            if ((layoutValue = (IJavaInstance)this.getEObject().eGet(this.getEObject().eClass().getEStructuralFeature("layout"))) != null) {
                IBeanProxyHost layoutProxyHost = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)layoutValue);
                layoutProxyHost.releaseBeanProxy();
            }
        }
        super.releaseBeanProxy();
    }

    public void reinstantiateChild(IBeanProxyHost aChildBeanProxy) {
        IJavaObjectInstance component = (IJavaObjectInstance)aChildBeanProxy.getTarget();
        EObject constraintComponent = InverseMaintenanceAdapter.getIntermediateReference((EObject)this.getEObject(), (EReference)this.sfContainerComponents, (EReference)this.sfConstraintComponent, (Notifier)component);
        if (constraintComponent != null) {
            List components = (List)this.getEObject().eGet((EStructuralFeature)this.sfContainerComponents);
            int cndx = components.indexOf(constraintComponent);
            this.removeComponent(constraintComponent);
            this.addComponent(constraintComponent, cndx);
        } else {
            super.reinstantiateChild(aChildBeanProxy);
        }
    }

    protected void removingAdapter() {
        if (this.getEObject().eIsSet((EStructuralFeature)this.sfContainerComponents)) {
            Iterator itr = ((List)this.getEObject().eGet((EStructuralFeature)this.sfContainerComponents)).iterator();
            while (itr.hasNext()) {
                Notifier n = (Notifier)itr.next();
                this.removeAdapters(n);
            }
        }
        super.removingAdapter();
    }

    protected void removeAdapters(Notifier n) {
        Adapter a;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ve.internal.jfc.core.ContainerProxyAdapter$ComponentConstraintAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((a = EcoreUtil.getExistingAdapter((Notifier)n, (Object)clazz)) != null) {
            n.eAdapters().remove((Object)a);
        }
        Notifier notifier = n = ((EObject)n).eIsSet((EStructuralFeature)this.sfConstraintComponent) ? (Notifier)((EObject)n).eGet((EStructuralFeature)this.sfConstraintComponent) : null;
        if (n != null) {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.ve.internal.jfc.core.ContainerProxyAdapter$ComponentNameAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((a = EcoreUtil.getExistingAdapter((Notifier)n, (Object)clazz2)) != null) {
                n.eAdapters().remove((Object)a);
            }
        }
    }

    protected void removeComponent(EObject aConstraintComponent) {
        this.removeAdapters((Notifier)aConstraintComponent);
        this.clearError((EStructuralFeature)this.sfContainerComponents, aConstraintComponent);
        IJavaInstance component = (IJavaInstance)aConstraintComponent.eGet((EStructuralFeature)this.sfConstraintComponent);
        IBeanProxyHost aComponentBeanProxyHost = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)component);
        if (aComponentBeanProxyHost != null) {
            ((ComponentProxyAdapter)aComponentBeanProxyHost).clearError((EStructuralFeature)this.sfContainerComponents, aConstraintComponent);
            if (aComponentBeanProxyHost.isBeanProxyInstantiated() && aComponentBeanProxyHost.getErrorStatus() != 3 && this.isBeanProxyInstantiated() && this.getErrorStatus() != 3) {
                BeanAwtUtilities.invoke_remove_Component(this.getBeanProxy(), aComponentBeanProxyHost.getBeanProxy());
                this.revalidateBeanProxy();
                ((ComponentProxyAdapter)aComponentBeanProxyHost).reapplyVisibility();
            }
        }
    }

    protected void addComponent(EObject aConstraintComponent, int position) throws BeanProxyAdapter.ReinstantiationNeeded {
        Object a;
        Class<?> clazz;
        IJavaInstance constraintAttributeValue = null;
        boolean constraintIsSet = false;
        if (aConstraintComponent.eIsSet((EStructuralFeature)this.sfConstraintConstraint)) {
            constraintAttributeValue = (IJavaInstance)aConstraintComponent.eGet((EStructuralFeature)this.sfConstraintConstraint);
            constraintIsSet = true;
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ve.internal.jfc.core.ContainerProxyAdapter$ComponentConstraintAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((a = EcoreUtil.getExistingAdapter((Notifier)aConstraintComponent, (Object)clazz)) != null) {
            aConstraintComponent.eAdapters().remove(a);
        }
        a = new ComponentConstraintAdapter();
        aConstraintComponent.eAdapters().add(a);
        this.addComponentWithConstraint(aConstraintComponent, constraintAttributeValue, position, constraintIsSet);
    }

    protected IBeanProxy getBeanProxyAt(int position) {
        List components = (List)((EObject)this.getTarget()).eGet((EStructuralFeature)this.sfContainerComponents);
        int i = position;
        while (i < components.size()) {
            EObject componentConstraint = (EObject)components.get(i);
            IBeanProxyHost componentProxyHost = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)((IJavaInstance)componentConstraint.eGet((EStructuralFeature)this.sfConstraintComponent)));
            if (componentProxyHost.isBeanProxyInstantiated()) {
                return componentProxyHost.getBeanProxy();
            }
            ++i;
        }
        return null;
    }

    protected void addComponentWithConstraint(EObject aConstraintComponent, IJavaInstance constraintAttributeValue, int position, boolean constraintIsSet) throws BeanProxyAdapter.ReinstantiationNeeded {
        Object a;
        IJavaInstance component = (IJavaInstance)aConstraintComponent.eGet((EStructuralFeature)this.sfConstraintComponent);
        if (component == null) {
            this.processError((EStructuralFeature)this.sfContainerComponents, new IllegalAccessException(VisualMessages.getString("Container.moved._WARN_")), aConstraintComponent);
        }
        IBeanProxyHost componentProxyHost = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)component);
        IComponentProxyHost componentAdapter = (IComponentProxyHost)componentProxyHost;
        componentProxyHost.instantiateBeanProxy();
        if (componentProxyHost.getErrorStatus() == 3 || this.getErrorStatus() == 3) {
            return;
        }
        if (!constraintIsSet) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ve.internal.jfc.core.ContainerProxyAdapter$ComponentNameAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((a = EcoreUtil.getExistingAdapter((Notifier)component, (Object)clazz)) != null) {
                component.eAdapters().remove(a);
            }
            a = new ComponentNameAdapter();
            component.eAdapters().add(a);
            constraintAttributeValue = componentProxyHost.getBeanPropertyValue((EStructuralFeature)this.sfName);
        } else {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ve.internal.jfc.core.ContainerProxyAdapter$ComponentNameAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((a = EcoreUtil.getExistingAdapter((Notifier)component, (Object)clazz)) != null) {
                component.eAdapters().remove(a);
            }
        }
        IBeanProxy componentBeanProxy = componentProxyHost.getBeanProxy();
        IBeanProxy beforeBeanProxy = null;
        if (position != -1) {
            beforeBeanProxy = this.getBeanProxyAt(position + 1);
        }
        IBeanProxy constraintBeanProxy = null;
        if (constraintAttributeValue != null) {
            IBeanProxyHost constraintHost = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)constraintAttributeValue);
            constraintBeanProxy = constraintHost.instantiateBeanProxy();
            if (constraintHost.getErrorStatus() == 3) {
                ((ComponentProxyAdapter)componentProxyHost).processError((EStructuralFeature)this.sfContainerComponents, ((IErrorHolder.ExceptionError)constraintHost.getErrors().get((int)0)).error, aConstraintComponent);
            }
        }
        try {
            if (constraintBeanProxy == null) {
                if (beforeBeanProxy != null) {
                    BeanAwtUtilities.invoke_add_Component_before(this.getBeanProxy(), componentBeanProxy, beforeBeanProxy);
                } else {
                    BeanAwtUtilities.invoke_add_Component(this.getBeanProxy(), componentBeanProxy);
                }
            } else if (beforeBeanProxy != null) {
                BeanAwtUtilities.invoke_add_Component_Object_before(this.getBeanProxy(), componentBeanProxy, constraintBeanProxy, beforeBeanProxy);
            } else {
                BeanAwtUtilities.invoke_add_Component_Object(this.getBeanProxy(), componentBeanProxy, constraintBeanProxy);
            }
            if (BeanAwtUtilities.invoke_getLayout(this.getBeanProxy()) == null) {
                componentAdapter.applyNullLayoutConstraints();
            }
        }
        catch (ThrowableProxy e) {
            ((ComponentProxyAdapter)componentProxyHost).processError((EStructuralFeature)this.sfContainerComponents, e, aConstraintComponent);
        }
        componentAdapter.setParentComponentProxyHost(this);
        this.revalidateBeanProxy();
        this.clearError((EStructuralFeature)this.sfContainerComponents, aConstraintComponent);
        ((ComponentProxyAdapter)componentProxyHost).clearError((EStructuralFeature)this.sfContainerComponents, aConstraintComponent);
    }

    protected boolean isValidFeature(EStructuralFeature sf, Object object) {
        IJavaInstance component;
        if (sf == this.sfContainerComponents && (component = (IJavaInstance)((EObject)object).eGet((EStructuralFeature)this.sfConstraintComponent)) != null) {
            ComponentProxyAdapter componentProxyHost = (ComponentProxyAdapter)BeanProxyUtilities.getBeanProxyHost((IJavaInstance)component);
            return componentProxyHost.isTrulyValidFeature(sf, object);
        }
        return super.isValidFeature(sf, object);
    }

    protected final boolean holding() {
        return this.holdCount > 0;
    }

    public final void holdProcessing() {
        if (this.holdCount++ == 0) {
            this.holdStarted();
        }
    }

    protected void holdStarted() {
        List components = (List)this.getEObject().eGet((EStructuralFeature)this.sfContainerComponents);
        int i = components.size() - 1;
        while (i >= 0) {
            this.removeComponent((EObject)components.get(i));
            --i;
        }
    }

    public final void resumeProcessing() {
        if (--this.holdCount == 0) {
            this.holdEnded();
        } else if (this.holdCount < 0) {
            this.holdCount = 0;
        }
    }

    protected void holdEnded() {
        List components = (List)this.getEObject().eGet((EStructuralFeature)this.sfContainerComponents);
        int i = 0;
        while (i < components.size()) {
            this.addComponent((EObject)components.get(i), i);
            ++i;
        }
    }

    private class ComponentConstraintAdapter
    extends AdapterImpl {
        static /* synthetic */ Class class$0;

        public boolean isAdapterForType(Object type) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ve.internal.jfc.core.ContainerProxyAdapter$ComponentConstraintAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return type == clazz;
        }

        public void notifyChanged(Notification msg) {
            if (msg.getFeature() == ContainerProxyAdapter.this.sfConstraintConstraint) {
                try {
                    switch (msg.getEventType()) {
                        case 1: {
                            if (!CDEUtilities.isUnset((Notification)msg)) {
                                int componentPos = ((List)((EObject)ContainerProxyAdapter.this.getTarget()).eGet((EStructuralFeature)ContainerProxyAdapter.this.sfContainerComponents)).indexOf(this.getTarget());
                                ContainerProxyAdapter.this.addComponentWithConstraint((EObject)this.getTarget(), (IJavaInstance)msg.getNewValue(), componentPos, true);
                                break;
                            }
                        }
                        case 2: {
                            int componentPos = ((List)((EObject)ContainerProxyAdapter.this.getTarget()).eGet((EStructuralFeature)ContainerProxyAdapter.this.sfContainerComponents)).indexOf(this.getTarget());
                            ContainerProxyAdapter.this.addComponentWithConstraint((EObject)this.getTarget(), null, componentPos, false);
                        }
                    }
                }
                catch (BeanProxyAdapter.ReinstantiationNeeded reinstantiationNeeded) {
                    ContainerProxyAdapter.this.reinstantiateBeanProxy();
                }
            }
        }
    }

    private class ComponentNameAdapter
    extends AdapterImpl {
        static /* synthetic */ Class class$0;

        public boolean isAdapterForType(Object type) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ve.internal.jfc.core.ContainerProxyAdapter$ComponentNameAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return type == clazz;
        }

        public void notifyChanged(Notification msg) {
            if (msg.getFeature() == ContainerProxyAdapter.this.sfName) {
                try {
                    switch (msg.getEventType()) {
                        case 1: {
                            if (!CDEUtilities.isUnset((Notification)msg)) {
                                EObject constraintComponent = InverseMaintenanceAdapter.getFirstReferencedBy((Notifier)this.getTarget(), (EReference)ContainerProxyAdapter.this.sfConstraintComponent);
                                int componentPos = ((List)((EObject)ContainerProxyAdapter.this.getTarget()).eGet((EStructuralFeature)ContainerProxyAdapter.this.sfContainerComponents)).indexOf(constraintComponent);
                                ContainerProxyAdapter.this.addComponentWithConstraint(constraintComponent, null, componentPos, false);
                                break;
                            }
                        }
                        case 2: {
                            EObject constraintComponent = InverseMaintenanceAdapter.getFirstReferencedBy((Notifier)this.getTarget(), (EReference)ContainerProxyAdapter.this.sfConstraintComponent);
                            int componentPos = ((List)((EObject)ContainerProxyAdapter.this.getTarget()).eGet((EStructuralFeature)ContainerProxyAdapter.this.sfContainerComponents)).indexOf(constraintComponent);
                            ContainerProxyAdapter.this.addComponentWithConstraint(constraintComponent, null, componentPos, false);
                        }
                    }
                }
                catch (BeanProxyAdapter.ReinstantiationNeeded reinstantiationNeeded) {
                    ContainerProxyAdapter.this.reinstantiateBeanProxy();
                }
            }
        }
    }
}

