/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import java.util.Collections;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.jem.internal.instantiation.InstantiationFactory;
import org.eclipse.jem.internal.instantiation.PTClassInstanceCreation;
import org.eclipse.jem.internal.instantiation.PTExpression;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.java.JavaVisibilityKind;
import org.eclipse.jem.java.Method;
import org.eclipse.ve.internal.cde.commands.ApplyAttributeSettingCommand;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.emf.EMFCreationTool;
import org.eclipse.ve.internal.propertysheet.common.commands.CommandWrapper;
import org.eclipse.ve.internal.propertysheet.common.commands.CompoundCommand;

public class FrameConstructorCreationPolicy
implements EMFCreationTool.CreationPolicy {
    public Command getCommand(Command aCommand, EditDomain domain, final CreateRequest aCreateRequest) {
        IJavaObjectInstance newJavaObject = (IJavaObjectInstance)aCreateRequest.getNewObject();
        if (newJavaObject.getAllocation() != null) {
            return aCommand;
        }
        CommandWrapper setAllocationCommand = new CommandWrapper(){

            public void execute() {
                JavaClass javaClass = (JavaClass)aCreateRequest.getNewObjectType();
                JavaClass frameClass = (JavaClass)JavaRefFactory.eINSTANCE.reflectType("java.awt.Frame", (EObject)javaClass);
                Iterator methods = javaClass.getMethods().iterator();
                boolean hasNullConstructor = false;
                while (methods.hasNext()) {
                    JavaParameter inputParm;
                    JavaHelpers type;
                    Method javaMethod = (Method)methods.next();
                    if (!javaMethod.isConstructor() || JavaVisibilityKind.PUBLIC_LITERAL != javaMethod.getJavaVisibility()) continue;
                    EList methodInputParms = javaMethod.getParameters();
                    if (methodInputParms.isEmpty()) {
                        hasNullConstructor = true;
                        break;
                    }
                    if (methodInputParms.size() == 1 && (type = (inputParm = (JavaParameter)methodInputParms.iterator().next()).getJavaType()).isAssignableFrom((EClassifier)frameClass)) break;
                }
                if (hasNullConstructor) {
                    return;
                }
                PTClassInstanceCreation newFrame = InstantiationFactory.eINSTANCE.createPTClassInstanceCreation("java.awt.Frame", null);
                PTClassInstanceCreation newExpr = InstantiationFactory.eINSTANCE.createPTClassInstanceCreation(javaClass.getQualifiedNameForReflection(), Collections.singletonList(newFrame));
                IJavaObjectInstance newJavaObject = (IJavaObjectInstance)aCreateRequest.getNewObject();
                ApplyAttributeSettingCommand applycommand = new ApplyAttributeSettingCommand();
                applycommand.setTarget((EObject)newJavaObject);
                applycommand.setAttribute((EStructuralFeature)JavaInstantiation.getAllocationFeature((IJavaInstance)newJavaObject));
                applycommand.setAttributeSettingValue((Object)InstantiationFactory.eINSTANCE.createParseTreeAllocation((PTExpression)newExpr));
                this.command = applycommand;
                this.command.execute();
            }

            public boolean canExecute() {
                return true;
            }
        };
        CompoundCommand result = new CompoundCommand(aCommand.getLabel());
        result.append((Command)setAllocationCommand);
        result.append(aCommand);
        return result;
    }

    public String getDefaultSuperString(EClass superClass) {
        if (superClass instanceof JavaClass) {
            Iterator methods = ((JavaClass)superClass).getMethods().iterator();
            boolean hasNullConstructor = false;
            boolean hasAnyConstructors = false;
            while (methods.hasNext()) {
                Method javaMethod = (Method)methods.next();
                JavaVisibilityKind visibility = javaMethod.getJavaVisibility();
                if (!javaMethod.isConstructor() || visibility != JavaVisibilityKind.PROTECTED_LITERAL && visibility != JavaVisibilityKind.PUBLIC_LITERAL) continue;
                hasAnyConstructors = true;
                EList methodInputParms = javaMethod.getParameters();
                if (!methodInputParms.isEmpty()) continue;
                hasNullConstructor = true;
                break;
            }
            if (!hasNullConstructor) {
                if (!hasAnyConstructors && ((JavaClass)superClass).getSupertype() != null) {
                    return this.getDefaultSuperString((EClass)((JavaClass)superClass).getSupertype());
                }
                return "super(new java.awt.Frame())";
            }
        }
        return "super()";
    }
}

