/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.ConstrainedLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jem.internal.instantiation.base.JavaObjectInstance;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ve.internal.cde.commands.CommandBuilder;
import org.eclipse.ve.internal.cde.commands.NoOpCommand;
import org.eclipse.ve.internal.cde.core.AnnotationLinkagePolicy;
import org.eclipse.ve.internal.cde.core.CDERequest;
import org.eclipse.ve.internal.cde.core.CustomizeLayoutWindowAction;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.core.GridController;
import org.eclipse.ve.internal.cde.core.IGridListener;
import org.eclipse.ve.internal.cde.core.IImageListener;
import org.eclipse.ve.internal.cde.emf.InverseMaintenanceAdapter;
import org.eclipse.ve.internal.cdm.Annotation;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.BeanUtilities;
import org.eclipse.ve.internal.java.rules.RuledCommandBuilder;
import org.eclipse.ve.internal.java.visual.VisualContainerPolicy;
import org.eclipse.ve.internal.jfc.core.ComponentProxyAdapter;
import org.eclipse.ve.internal.jfc.core.ContainerPolicy;
import org.eclipse.ve.internal.jfc.core.GridBagConstraint;
import org.eclipse.ve.internal.jfc.core.GridBagLayoutCursorHelper;
import org.eclipse.ve.internal.jfc.core.GridBagLayoutFeedbackFigure;
import org.eclipse.ve.internal.jfc.core.GridBagLayoutGridFigure;
import org.eclipse.ve.internal.jfc.core.GridBagLayoutPolicyHelper;
import org.eclipse.ve.internal.jfc.core.GridBagSpanHandle;
import org.eclipse.ve.internal.jfc.core.JFCConstants;
import org.eclipse.ve.internal.jfc.core.NonResizableSpannableEditPolicy;

public class GridBagLayoutEditPolicy
extends ConstrainedLayoutEditPolicy
implements IGridListener,
IActionFilter {
    public static final String LAYOUT_ID = "java.awt.GridBagLayout";
    public static final String REQ_GRIDBAGLAYOUT_SPAN = "GridBagLayout span cells";
    protected GridBagLayoutGridFigure fGridBagLayoutGridFigure = null;
    protected GridBagLayoutFeedbackFigure fGridBagLayoutCellFigure = null;
    protected Cursor currentFeedbackCursor;
    protected IFigure fCursorFigure = null;
    protected Label xCursorLabel = null;
    protected Label yCursorLabel = null;
    protected GridBagLayoutCursorHelper fCursorHelper = null;
    protected RectangleFigure fColumnFigure = null;
    protected RectangleFigure fRowFigure = null;
    protected GridBagLayoutPolicyHelper helper = new GridBagLayoutPolicyHelper();
    protected ContainerPolicy containerPolicy;
    protected GridController gridController;
    protected boolean fShowgrid = false;
    protected EStructuralFeature sfGridX;
    protected EStructuralFeature sfGridY;
    protected EReference sfComponents;
    protected EReference sfConstraintComponent;
    protected EReference sfConstraintConstraint;
    protected GridBagImageListener fGridBagImageListener = null;
    protected boolean insertNewColumn = false;
    protected boolean insertNewRow = false;
    protected ResourceSet rset;
    protected FigureListener hostFigureListener = new FigureListener(){

        public void figureMoved(IFigure source) {
            GridBagLayoutEditPolicy.this.refreshGridFigure();
            GridBagLayoutEditPolicy.this.helper.refresh();
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public GridBagLayoutEditPolicy(VisualContainerPolicy containerPolicy) {
        this.containerPolicy = (ContainerPolicy)containerPolicy;
        this.helper.setContainerPolicy(containerPolicy);
    }

    public void activate() {
        this.gridController = new GridController();
        if (this.gridController != null) {
            this.gridController.addGridListener((IGridListener)this);
            GridController.registerEditPart((EditPart)this.getHost(), (GridController)this.gridController);
            this.initializeGrid();
        }
        super.activate();
        this.containerPolicy.setContainer(this.getHost().getModel());
        this.rset = ((IJavaObjectInstance)this.getHost().getModel()).eResource().getResourceSet();
        this.sfConstraintConstraint = JavaInstantiation.getReference((ResourceSet)this.rset, (URI)JFCConstants.SF_CONSTRAINT_CONSTRAINT);
        this.sfComponents = JavaInstantiation.getReference((ResourceSet)this.rset, (URI)JFCConstants.SF_CONTAINER_COMPONENTS);
        this.sfConstraintComponent = JavaInstantiation.getReference((ResourceSet)this.rset, (URI)JFCConstants.SF_CONSTRAINT_COMPONENT);
        this.sfGridX = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)JFCConstants.SF_GRIDBAGCONSTRAINTS_GRIDX);
        this.sfGridY = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)JFCConstants.SF_GRIDBAGCONSTRAINTS_GRIDY);
        ComponentProxyAdapter beanProxy = (ComponentProxyAdapter)BeanProxyUtilities.getBeanProxyHost((IJavaInstance)((IJavaObjectInstance)this.getHost().getModel()));
        if (beanProxy != null) {
            beanProxy.addImageListener(this.getGrigBagImageListener());
        }
        this.getHostFigure().addFigureListener(this.hostFigureListener);
        EditPartViewer editPartViewer = this.getHost().getViewer();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ve.internal.jfc.core.GridBagComponentPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CustomizeLayoutWindowAction.addComponentCustomizationPage((EditPartViewer)editPartViewer, (Class)clazz);
    }

    protected void initializeGrid() {
        AnnotationLinkagePolicy policy;
        Annotation ann;
        EditDomain domain = EditDomain.getEditDomain((EditPart)this.getHost());
        HashSet gridStateData = (HashSet)domain.getData((Object)"org.eclipse.ve.internal.cde.core.gridstatekey");
        if (gridStateData != null && (ann = (policy = domain.getAnnotationLinkagePolicy()).getAnnotation(this.getHost().getModel())) != null) {
            String name = (String)ann.getKeyedValues().get((Object)"org.eclipse.ve.internal.cde.core.nameincomposition");
            if (name == null) {
                name = "THIS_PART";
            }
            if (gridStateData.contains(name) && this.gridController != null) {
                this.gridController.setGridShowing(true);
            }
        }
    }

    public void deactivate() {
        ComponentProxyAdapter beanProxy;
        this.containerPolicy.setContainer(null);
        GridController gridController = GridController.getGridController((EditPart)this.getHost());
        this.eraseGridFigure();
        if (gridController != null) {
            gridController.removeGridListener((IGridListener)this);
            GridController.unregisterEditPart((EditPart)this.getHost());
        }
        if ((beanProxy = (ComponentProxyAdapter)BeanProxyUtilities.getBeanProxyHost((IJavaInstance)((IJavaObjectInstance)this.getHost().getModel()))) != null) {
            beanProxy.removeImageListener(this.getGrigBagImageListener());
        }
        this.getHostFigure().removeFigureListener(this.hostFigureListener);
        super.deactivate();
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        return new NonResizableSpannableEditPolicy(this);
    }

    protected Command getCreateCommand(CreateRequest request) {
        Object child = request.getNewObject();
        Point position = this.getLocationFromRequest((Request)request).getCopy();
        this.getHostFigure().translateToRelative((Translatable)position);
        Point cellLocation = this.getGridBagLayoutGridFigure().getCellLocation(position.x, position.y);
        if (!(this.fGridBagLayoutGridFigure.isPointerNearAColumn(position.x) || this.fGridBagLayoutGridFigure.isPointerNearARow(position.y) || this.helper.isCellEmpty(cellLocation.x, cellLocation.y))) {
            return UnexecutableCommand.INSTANCE;
        }
        boolean nearAColumn = false;
        boolean nearARow = false;
        if (this.fGridBagLayoutGridFigure.isPointerNearAColumn(position.x)) {
            nearAColumn = true;
        }
        if (this.fGridBagLayoutGridFigure.isPointerNearARow(position.y)) {
            nearARow = true;
        }
        cellLocation = this.getGridBagLayoutGridFigure().getCellLocation(position.x, position.y, nearAColumn, nearARow);
        GridBagConstraint gridbagconstraint = this.helper.getConstraint((IJavaObjectInstance)child, cellLocation.x, cellLocation.y);
        if (gridbagconstraint != null) {
            CommandBuilder cb = new CommandBuilder();
            cb.append(this.helper.getCreateChildCommand(child, gridbagconstraint, null));
            cb.append(this.getAdjustConstraintsCommand(child, position, cellLocation));
            return cb.getCommand();
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command getAdjustConstraintsCommand(Object child, Point position, Point cellLocation) {
        this.insertNewColumn = false;
        this.insertNewRow = false;
        if (this.fGridBagLayoutGridFigure.isPointerNearAColumn(position.x) && !this.fGridBagLayoutGridFigure.isColumnHidden(cellLocation.x)) {
            this.insertNewColumn = true;
        }
        if (this.fGridBagLayoutGridFigure.isPointerNearARow(position.y) && !this.fGridBagLayoutGridFigure.isRowHidden(cellLocation.y)) {
            this.insertNewRow = true;
        }
        if (this.insertNewColumn || this.insertNewRow) {
            return this.helper.adjustConstraintsCommand((IJavaObjectInstance)child, cellLocation, this.insertNewColumn, this.insertNewRow);
        }
        return null;
    }

    protected Command getDeleteDependantCommand(Request aRequest) {
        Command deleteContributionCmd = this.containerPolicy.getCommand(aRequest);
        if (deleteContributionCmd == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return deleteContributionCmd;
    }

    protected Point getLocationFromRequest(Request request) {
        if (request instanceof CreateRequest) {
            return ((CreateRequest)request).getLocation();
        }
        if (request instanceof ChangeBoundsRequest) {
            return ((ChangeBoundsRequest)request).getLocation();
        }
        return null;
    }

    protected Command getMoveChildrenCommand(Request request) {
        if (!(request instanceof ChangeBoundsRequest)) {
            return null;
        }
        ChangeBoundsRequest req = (ChangeBoundsRequest)request;
        List editparts = req.getEditParts();
        if (editparts.size() > 1) {
            return null;
        }
        EditPart ep = (EditPart)editparts.iterator().next();
        Point position = req.getLocation();
        this.getHostFigure().translateToRelative((Translatable)position);
        return this.getConstraintCommands(ep, position);
    }

    protected Command getConstraintCommands(EditPart ep, Point position) {
        JavaObjectInstance constraintObject;
        Point cellLocation = this.getGridBagLayoutGridFigure().getCellLocation(position.x, position.y);
        Point childPosition = ((GraphicalEditPart)ep).getFigure().getBounds().getLocation();
        Point childCellLocation = this.getGridBagLayoutGridFigure().getCellLocation(childPosition.x, childPosition.y);
        IJavaObjectInstance component = (IJavaObjectInstance)ep.getModel();
        EObject constraintComponent = InverseMaintenanceAdapter.getIntermediateReference((EObject)component, (EReference)this.sfComponents, (EReference)this.sfConstraintComponent, (Notifier)component);
        if (!(this.fGridBagLayoutGridFigure.isPointerNearAColumn(position.x) || this.fGridBagLayoutGridFigure.isPointerNearARow(position.y) || childCellLocation != cellLocation && this.helper.isCellValidForMove(cellLocation, constraintComponent))) {
            return UnexecutableCommand.INSTANCE;
        }
        boolean nearAColumn = false;
        boolean nearARow = false;
        if (this.fGridBagLayoutGridFigure.isPointerNearAColumn(position.x)) {
            nearAColumn = true;
        }
        if (this.fGridBagLayoutGridFigure.isPointerNearARow(position.y)) {
            nearARow = true;
        }
        cellLocation = this.getGridBagLayoutGridFigure().getCellLocation(position.x, position.y, nearAColumn, nearARow);
        CommandBuilder cb = new CommandBuilder();
        if (constraintComponent != null && (constraintObject = (JavaObjectInstance)constraintComponent.eGet((EStructuralFeature)this.sfConstraintConstraint)) != null && constraintObject.getJavaType().getJavaName().equals("java.awt.GridBagConstraints")) {
            RuledCommandBuilder componentCB = new RuledCommandBuilder(EditDomain.getEditDomain((EditPart)ep), null, false);
            IJavaInstance intObject = BeanUtilities.createJavaObject((String)"int", (ResourceSet)this.rset, (String)String.valueOf(cellLocation.x));
            componentCB.applyAttributeSetting((EObject)constraintObject, this.sfGridX, (Object)intObject);
            intObject = BeanUtilities.createJavaObject((String)"int", (ResourceSet)this.rset, (String)String.valueOf(cellLocation.y));
            componentCB.applyAttributeSetting((EObject)constraintObject, this.sfGridY, (Object)intObject);
            componentCB.applyAttributeSetting(constraintComponent, (EStructuralFeature)this.sfConstraintConstraint, (Object)constraintObject);
            cb.append(componentCB.getCommand());
        }
        if (cb.isEmpty()) {
            GridBagConstraint gridbagconstraint = this.helper.getConstraint(component, cellLocation.x, cellLocation.y);
            cb.append(this.helper.getCreateChildCommand(component, gridbagconstraint, null));
        }
        cb.append(this.getAdjustConstraintsCommand(component, position, cellLocation));
        return cb.getCommand();
    }

    protected Command getOrphanChildrenCommand(Request aRequest) {
        return this.helper.getOrphanChildrenCommand(ContainerPolicy.getChildren((GroupRequest)((GroupRequest)aRequest)));
    }

    protected Command createAddCommand(EditPart childEditPart, Object cellLocation) {
        Object child = childEditPart.getModel();
        GridBagConstraint gridbagconst = this.helper.getConstraint((IJavaObjectInstance)child, ((Point)cellLocation).x, ((Point)cellLocation).y);
        return this.helper.getAddChildrenCommand(Collections.singletonList(child), Collections.singletonList(gridbagconst), null);
    }

    protected Command createChangeConstraintCommand(EditPart childEditPart, Object constraint) {
        return this.helper.getChangeConstraintCommand(Collections.singletonList(childEditPart.getModel()), Collections.singletonList(constraint));
    }

    protected Object getConstraintFor(Point p1) {
        return null;
    }

    protected Object getConstraintFor(Rectangle p1) {
        return p1;
    }

    protected GridBagLayoutGridFigure getGridBagLayoutGridFigure() {
        if (this.fGridBagLayoutGridFigure == null) {
            IFigure f = ((GraphicalEditPart)this.getHost()).getFigure();
            int[][] layoutDimensions = null;
            Point layoutOrigin = null;
            if (this.helper.isContainerEmpty()) {
                layoutDimensions = new int[2][0];
                layoutDimensions[0] = new int[0];
                layoutDimensions[1] = new int[0];
                layoutOrigin = new Point();
            } else {
                layoutDimensions = this.helper.getContainerLayoutDimensions();
                layoutOrigin = this.helper.getContainerLayoutOrigin();
            }
            this.fGridBagLayoutGridFigure = new GridBagLayoutGridFigure(f.getBounds().getCopy(), layoutDimensions, layoutOrigin);
        }
        return this.fGridBagLayoutGridFigure;
    }

    protected void eraseGridFigure() {
        this.fShowgrid = false;
        if (this.fGridBagLayoutGridFigure != null) {
            this.removeFeedback((IFigure)this.fGridBagLayoutGridFigure);
            this.fGridBagLayoutGridFigure = null;
        }
    }

    protected void refreshGridFigure() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (GridBagLayoutEditPolicy.this.fShowgrid) {
                    GridBagLayoutEditPolicy.this.eraseGridFigure();
                    GridBagLayoutEditPolicy.this.showGridFigure();
                } else {
                    GridBagLayoutEditPolicy.this.fGridBagLayoutGridFigure = null;
                }
            }
        });
    }

    protected void showGridFigure() {
        this.fShowgrid = true;
        this.addFeedback((IFigure)this.getGridBagLayoutGridFigure());
    }

    public void eraseTargetFeedback(Request request) {
        if (!this.fShowgrid && this.fGridBagLayoutGridFigure != null && this.fGridBagLayoutGridFigure.getParent() != null) {
            this.removeFeedback((IFigure)this.fGridBagLayoutGridFigure);
            this.fGridBagLayoutGridFigure = null;
        }
        if (this.xCursorLabel != null) {
            this.xCursorLabel = null;
        }
        if (this.yCursorLabel != null) {
            this.yCursorLabel = null;
        }
        if (this.fCursorFigure != null) {
            this.fCursorFigure = null;
        }
        if (this.fCursorHelper != null) {
            this.fCursorHelper.dispose();
            this.fCursorHelper = null;
        }
        if (this.fGridBagLayoutCellFigure != null) {
            this.removeFeedback((IFigure)this.fGridBagLayoutCellFigure);
            this.fGridBagLayoutCellFigure = null;
        }
        if (this.fColumnFigure != null) {
            this.removeFeedback((IFigure)this.fColumnFigure);
            this.fColumnFigure = null;
        }
        if (this.fRowFigure != null) {
            this.removeFeedback((IFigure)this.fRowFigure);
            this.fRowFigure = null;
        }
        if (this.currentFeedbackCursor != null && request instanceof CDERequest) {
            CDERequest cDERequest = (CDERequest)request;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.swt.graphics.Cursor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            cDERequest.put((Object)clazz, null);
        }
    }

    protected void showLayoutTargetFeedback(Request request) {
        Point position = this.getLocationFromRequest(request).getCopy();
        this.getHostFigure().translateToRelative((Translatable)position);
        Rectangle rect = null;
        Point cellLocation = this.getGridBagLayoutGridFigure().getCellLocation(position.x, position.y, true, true);
        if (!this.fShowgrid) {
            this.addFeedback((IFigure)this.getGridBagLayoutGridFigure());
        }
        if (this.fGridBagLayoutGridFigure.isPointerNearARow(position.y)) {
            if (!this.fGridBagLayoutGridFigure.isRowHidden(cellLocation.y)) {
                this.hightlightRowHeaders(position);
            } else {
                this.resetHightlightedRowHeaders();
            }
            this.showNewRowFeedBack(position);
        } else if (this.fRowFigure != null) {
            this.resetHightlightedRowHeaders();
            this.removeFeedback((IFigure)this.fRowFigure);
            this.fRowFigure = null;
        }
        if (this.getGridBagLayoutGridFigure().isPointerNearAColumn(position.x)) {
            if (!this.getGridBagLayoutGridFigure().isColumnHidden(cellLocation.x)) {
                this.hightlightColumnHeaders(position);
            } else {
                this.resetHightlightedColumnHeaders();
            }
            this.showNewColumnFeedBack(position);
        } else if (this.fColumnFigure != null) {
            this.resetHightlightedColumnHeaders();
            this.removeFeedback((IFigure)this.fColumnFigure);
            this.fColumnFigure = null;
        }
        if (this.fColumnFigure == null && this.fRowFigure == null) {
            if (this.fGridBagLayoutCellFigure == null) {
                GridBagLayoutFeedbackFigure gf;
                this.fGridBagLayoutCellFigure = gf = new GridBagLayoutFeedbackFigure();
            }
            rect = this.getGridBagLayoutGridFigure().getCellBounds(position.x, position.y);
            this.fGridBagLayoutCellFigure.setBounds(rect);
            this.addFeedback((IFigure)this.fGridBagLayoutCellFigure);
        } else if (this.fGridBagLayoutCellFigure != null) {
            this.removeFeedback((IFigure)this.fGridBagLayoutCellFigure);
            this.fGridBagLayoutCellFigure = null;
        }
        this.showCursorFeedback(position, request);
    }

    protected void showCursorFeedback(Point position, Request aRequest) {
        boolean includeEmptyColumns = this.fColumnFigure != null;
        boolean includeEmptyRows = this.fRowFigure != null;
        Point cellLocation = this.getGridBagLayoutGridFigure().getCellLocation(position.x, position.y, includeEmptyColumns, includeEmptyRows);
        this.getHostFigure().translateToAbsolute((Translatable)position);
        org.eclipse.swt.graphics.Point absolutePosition = this.getHost().getViewer().getControl().toDisplay(position.x, position.y);
        absolutePosition.x += 8;
        absolutePosition.y += 19;
        if (this.xCursorLabel == null) {
            this.xCursorLabel = new Label();
            this.xCursorLabel.setOpaque(true);
            this.xCursorLabel.setBorder((Border)new MarginBorder(new Insets(0, 2, 0, 0)));
        }
        this.xCursorLabel.setText(String.valueOf(cellLocation.x));
        if (this.fColumnFigure != null) {
            this.xCursorLabel.setBackgroundColor(ColorConstants.yellow);
        } else {
            this.xCursorLabel.setBackgroundColor(ColorConstants.cyan);
        }
        if (this.yCursorLabel == null) {
            this.yCursorLabel = new Label();
            this.yCursorLabel.setOpaque(true);
            this.yCursorLabel.setBorder((Border)new MarginBorder(new Insets(0, 2, 0, 0)));
        }
        this.yCursorLabel.setText(String.valueOf(cellLocation.y));
        if (this.fRowFigure != null) {
            this.yCursorLabel.setBackgroundColor(ColorConstants.yellow);
        } else {
            this.yCursorLabel.setBackgroundColor(ColorConstants.cyan);
        }
        if (this.fCursorFigure == null) {
            this.fCursorFigure = new Figure();
            FlowLayout fl = new FlowLayout();
            fl.setMinorSpacing(1);
            this.fCursorFigure.setLayoutManager((LayoutManager)fl);
            this.fCursorFigure.setBorder((Border)new LineBorder());
            this.fCursorFigure.setOpaque(true);
            this.fCursorFigure.setBackgroundColor(ColorConstants.black);
        }
        this.fCursorFigure.add((IFigure)this.xCursorLabel);
        this.fCursorFigure.add((IFigure)this.yCursorLabel);
        if (this.fCursorHelper == null) {
            this.fCursorHelper = new GridBagLayoutCursorHelper(this.getHost().getViewer().getControl());
        }
        this.fCursorHelper.showCursorFigure(this.fCursorFigure, absolutePosition.x, absolutePosition.y);
        if (aRequest instanceof CDERequest) {
            CDERequest cDERequest = (CDERequest)aRequest;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.swt.graphics.Cursor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (cDERequest.get((Object)clazz) == null) {
                Cursor defaultCursor = new Cursor((Device)this.getHost().getViewer().getControl().getDisplay(), 0);
                CDERequest cDERequest2 = (CDERequest)aRequest;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.swt.graphics.Cursor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                cDERequest2.put((Object)clazz2, (Object)defaultCursor);
                this.currentFeedbackCursor = defaultCursor;
            }
        }
    }

    protected void hightlightColumnHeaders(Point position) {
        Point cellLocation = this.fGridBagLayoutGridFigure.getCellLocation(position.x, position.y);
        this.fGridBagLayoutGridFigure.highlightColumnHeadersFromColumn(cellLocation.x);
        this.addFeedback((IFigure)this.fGridBagLayoutGridFigure);
    }

    protected void resetHightlightedColumnHeaders() {
        this.fGridBagLayoutGridFigure.resetHighlightedColumnHeaders();
        this.addFeedback((IFigure)this.fGridBagLayoutGridFigure);
    }

    protected void showNewColumnFeedBack(Point position) {
        if (this.fColumnFigure == null) {
            this.fColumnFigure = new RectangleFigure();
        }
        Point colStart = this.fGridBagLayoutGridFigure.getColumnStartPosition(position.x);
        Point colEnd = this.fGridBagLayoutGridFigure.getColumnEndPosition(position.x);
        this.fColumnFigure.setBounds(new Rectangle(colStart.x - 2, colStart.y, 10, colEnd.y - colStart.y));
        this.fColumnFigure.setBackgroundColor(ColorConstants.yellow);
        this.addFeedback((IFigure)this.fColumnFigure);
    }

    protected void hightlightRowHeaders(Point position) {
        Point cellLocation = this.fGridBagLayoutGridFigure.getCellLocation(position.x, position.y);
        this.fGridBagLayoutGridFigure.highlightRowHeadersFromRow(cellLocation.y);
        this.addFeedback((IFigure)this.fGridBagLayoutGridFigure);
    }

    protected void resetHightlightedRowHeaders() {
        this.fGridBagLayoutGridFigure.resetHighlightedRowHeaders();
        this.addFeedback((IFigure)this.fGridBagLayoutGridFigure);
    }

    protected void showNewRowFeedBack(Point position) {
        if (this.fRowFigure == null) {
            this.fRowFigure = new RectangleFigure();
        }
        Point rowStart = this.fGridBagLayoutGridFigure.getRowStartPosition(position.y);
        Point rowEnd = this.fGridBagLayoutGridFigure.getRowEndPosition(position.y);
        this.fRowFigure.setBounds(new Rectangle(rowStart.x, rowStart.y - 2, rowEnd.x - rowStart.x, 10));
        this.fRowFigure.setBackgroundColor(ColorConstants.yellow);
        this.addFeedback((IFigure)this.fRowFigure);
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (name.startsWith("showgrid") && value.equals("false") && !this.fShowgrid) {
            return true;
        }
        if (name.startsWith("showgrid") && value.equals("true") && this.fShowgrid) {
            return true;
        }
        return name.startsWith("LAYOUTPOLICY") && value.equals(LAYOUT_ID);
    }

    public void gridHeightChanged(int gridHeight, int oldGridHeight) {
    }

    public void gridMarginChanged(int gridMargin, int oldGridMargin) {
    }

    public void gridVisibilityChanged(boolean showGrid) {
        if (showGrid) {
            this.showGridFigure();
        } else {
            this.eraseGridFigure();
        }
    }

    public void gridWidthChanged(int gridWidth, int oldGridWidth) {
    }

    protected IImageListener getGrigBagImageListener() {
        if (this.fGridBagImageListener == null) {
            this.fGridBagImageListener = new GridBagImageListener();
        }
        return this.fGridBagImageListener;
    }

    public Command getCommand(Request request) {
        if (REQ_GRIDBAGLAYOUT_SPAN.equals(request.getType())) {
            return this.getSpanChildrenCommand((Request)((ChangeBoundsRequest)request));
        }
        return super.getCommand(request);
    }

    protected Command getAddCommand(Request generic) {
        ChangeBoundsRequest request = (ChangeBoundsRequest)generic;
        List editParts = request.getEditParts();
        if (editParts.isEmpty() || editParts.size() > 1) {
            return UnexecutableCommand.INSTANCE;
        }
        Point position = this.getLocationFromRequest((Request)request).getCopy();
        this.getHostFigure().translateToRelative((Translatable)position);
        Point cellLocation = this.getGridBagLayoutGridFigure().getCellLocation(position.x, position.y);
        if (!(this.fGridBagLayoutGridFigure.isPointerNearAColumn(position.x) || this.fGridBagLayoutGridFigure.isPointerNearARow(position.y) || this.helper.isCellEmpty(cellLocation.x, cellLocation.y))) {
            return UnexecutableCommand.INSTANCE;
        }
        boolean nearAColumn = false;
        boolean nearARow = false;
        if (this.fGridBagLayoutGridFigure.isPointerNearAColumn(position.x)) {
            nearAColumn = true;
        }
        if (this.fGridBagLayoutGridFigure.isPointerNearARow(position.y)) {
            nearARow = true;
        }
        cellLocation = this.getGridBagLayoutGridFigure().getCellLocation(position.x, position.y, nearAColumn, nearARow);
        CommandBuilder cb = new CommandBuilder();
        cb.append(this.createAddCommand((EditPart)editParts.get(0), cellLocation));
        cb.append(this.getAdjustConstraintsCommand((IJavaObjectInstance)((EditPart)editParts.get(0)).getModel(), position, cellLocation));
        return cb.getCommand();
    }

    protected Command getSpanChildrenCommand(Request generic) {
        ChangeBoundsRequest request = (ChangeBoundsRequest)generic;
        List editParts = request.getEditParts();
        if (editParts.isEmpty() || editParts.size() > 1) {
            return UnexecutableCommand.INSTANCE;
        }
        Point spanToPosition = this.getLocationFromRequest((Request)request).getCopy();
        this.getHostFigure().translateToRelative((Translatable)spanToPosition);
        Point spanToCellLocation = this.getGridBagLayoutGridFigure().getCellLocation(spanToPosition.x, spanToPosition.y);
        Dimension dim = request.getSizeDelta();
        int handleSizeOffset = GridBagSpanHandle.HANDLE_SIZE / 2;
        Point startPosition = new Point(spanToPosition.x - dim.width - handleSizeOffset, spanToPosition.y - dim.height - handleSizeOffset);
        GraphicalEditPart ep = (GraphicalEditPart)editParts.get(0);
        Point childPosition = ep.getFigure().getBounds().getLocation();
        Point childCellLocation = this.getGridBagLayoutGridFigure().getCellLocation(childPosition.x, childPosition.y);
        Point startCellLocation = this.getGridBagLayoutGridFigure().getCellLocation(startPosition.x, startPosition.y);
        if (spanToCellLocation.x >= childCellLocation.x && spanToCellLocation.y >= childCellLocation.y && (spanToCellLocation.x != startCellLocation.x || spanToCellLocation.y != startCellLocation.y)) {
            return this.helper.getSpanChildrenCommand((EditPart)editParts.get(0), childCellLocation, spanToCellLocation, request.getResizeDirection());
        }
        return NoOpCommand.INSTANCE;
    }

    public void showSpanTargetFeedback(ChangeBoundsRequest request) {
        if (!this.fShowgrid) {
            this.addFeedback((IFigure)this.getGridBagLayoutGridFigure());
        }
        Point spanToPosition = request.getLocation().getCopy();
        this.getHostFigure().translateToRelative((Translatable)spanToPosition);
        GraphicalEditPart ep = (GraphicalEditPart)request.getEditParts().get(0);
        Point childPosition = ep.getFigure().getBounds().getLocation();
        Rectangle startCellBounds = this.getGridBagLayoutGridFigure().getCellBounds(childPosition.x, childPosition.y);
        Rectangle endCellBounds = this.getGridBagLayoutGridFigure().getCellBounds(spanToPosition.x, spanToPosition.y);
        Rectangle spanrect = new Rectangle(startCellBounds.x, startCellBounds.y, endCellBounds.x + endCellBounds.width - startCellBounds.x, endCellBounds.y + endCellBounds.height - startCellBounds.y);
        if (this.fGridBagLayoutCellFigure == null) {
            this.fGridBagLayoutCellFigure = new GridBagLayoutFeedbackFigure();
        }
        this.fGridBagLayoutCellFigure.setBounds(spanrect);
        this.addFeedback((IFigure)this.fGridBagLayoutCellFigure);
        this.showCursorFeedback(spanToPosition, (Request)request);
    }

    private class GridBagImageListener
    implements IImageListener {
        GridBagImageListener() {
        }

        public void imageChanged(ImageData data) {
            GridBagLayoutEditPolicy.this.refreshGridFigure();
            GridBagLayoutEditPolicy.this.helper.refresh();
        }
    }
}

