/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class GridBagLayoutGridFigure
extends Figure {
    Point layoutOrigin = new Point(0, 0);
    Point mousePosition = null;
    int[] columnWidths = null;
    int[] rowHeights = null;
    int[] columnPositions = null;
    int[] rowPositions = null;
    Point[] rowHeaderPositions = null;
    Point[] rowStartPositions = null;
    Point[] rowEndPositions = null;
    Point[] columnHeaderPositions = null;
    Point[] columnStartPositions = null;
    Point[] columnEndPositions = null;
    int highlightColumnStart = 9999;
    int highlightRowStart = 9999;

    public GridBagLayoutGridFigure(Rectangle bounds, int[][] layoutDimensions, Point gridBagLayoutOrigin) {
        this.setBounds(bounds);
        this.layoutOrigin = gridBagLayoutOrigin;
        if (layoutDimensions != null) {
            this.columnWidths = layoutDimensions[0];
            this.rowHeights = layoutDimensions[1];
            this.calculateColumnDividers();
            this.calculateRowDividers();
        }
    }

    protected void paintFigure(Graphics g) {
        Color orgColor = g.getForegroundColor();
        g.setForegroundColor(ColorConstants.red);
        g.setLineStyle(3);
        this.drawColumnDividers(g);
        this.drawRowDividers(g);
        g.setLineStyle(1);
        g.setForegroundColor(orgColor);
        this.drawColumnHeaders(g);
        this.drawRowHeaders(g);
    }

    protected void calculateColumnDividers() {
        if (this.rowHeights == null || this.columnWidths == null || this.layoutOrigin == null) {
            return;
        }
        Rectangle r = this.getBounds();
        int containerHeight = 0;
        this.columnPositions = new int[this.columnWidths.length + 1];
        this.columnStartPositions = new Point[this.columnWidths.length + 1];
        this.columnEndPositions = new Point[this.columnWidths.length + 1];
        int i = 0;
        while (i < this.rowHeights.length) {
            containerHeight += this.rowHeights[i];
            ++i;
        }
        int xPos = r.x + this.layoutOrigin.x;
        int yMin = r.y + this.layoutOrigin.y;
        int yMax = r.y + this.layoutOrigin.y + containerHeight;
        int colHeaderPos = 0;
        this.columnHeaderPositions = new Point[this.columnWidths.length];
        this.columnPositions[0] = xPos;
        this.columnStartPositions[0] = new Point(xPos, yMin);
        this.columnEndPositions[0] = new Point(xPos, yMax);
        int i2 = 0;
        while (i2 < this.columnWidths.length) {
            if (this.columnWidths[i2] > 0) {
                colHeaderPos = xPos + this.columnWidths[i2] / 2;
                this.columnHeaderPositions[i2] = new Point(colHeaderPos, Math.max(r.y, yMin - 8));
            }
            if ((xPos += this.columnWidths[i2]) >= r.x + r.width) {
                xPos = r.x + r.width - 1;
            }
            Point startPoint = new Point(xPos, yMin);
            Point endPoint = new Point(xPos, yMax);
            this.columnPositions[i2 + 1] = xPos;
            this.columnStartPositions[i2 + 1] = startPoint;
            this.columnEndPositions[i2 + 1] = endPoint;
            ++i2;
        }
    }

    protected void drawColumnDividers(Graphics g) {
        if (this.columnStartPositions == null && this.columnEndPositions == null) {
            return;
        }
        int i = 0;
        while (i < this.columnStartPositions.length) {
            g.drawLine(this.columnStartPositions[i], this.columnEndPositions[i]);
            ++i;
        }
    }

    protected void drawColumnHeaders(Graphics g) {
        Color orgColor = g.getBackgroundColor();
        int i = 0;
        while (i < this.columnHeaderPositions.length) {
            Point p = this.columnHeaderPositions[i];
            int columnNumber = 0;
            if (i < this.highlightColumnStart) {
                g.setBackgroundColor(ColorConstants.cyan);
                columnNumber = i;
            } else {
                g.setBackgroundColor(ColorConstants.yellow);
                columnNumber = i + 1;
            }
            this.drawColumnHeader(g, columnNumber, p);
            ++i;
        }
        g.setBackgroundColor(orgColor);
    }

    protected void drawColumnHeader(Graphics g, int colNumber, Point p) {
        if (p != null) {
            String colname = Integer.toString(colNumber);
            int charwidth = g.getFontMetrics().getAverageCharWidth();
            int charheight = g.getFontMetrics().getHeight();
            g.fillOval(new Rectangle(p.x - 4, p.y - 1, colname.length() * charwidth + 8, charheight + 2));
            g.drawOval(new Rectangle(p.x - 4, p.y - 1, colname.length() * charwidth + 8, charheight + 2));
            g.drawText(Integer.toString(colNumber), p);
        }
    }

    public void highlightColumnHeadersFromColumn(int colNumber) {
        this.highlightColumnStart = colNumber;
    }

    public void resetHighlightedColumnHeaders() {
        this.highlightColumnStart = 9999;
    }

    protected void calculateRowDividers() {
        if (this.rowHeights == null || this.columnWidths == null || this.layoutOrigin == null) {
            return;
        }
        Rectangle r = this.getBounds();
        int containerWidth = 0;
        this.rowPositions = new int[this.rowHeights.length + 1];
        this.rowStartPositions = new Point[this.rowHeights.length + 1];
        this.rowEndPositions = new Point[this.rowHeights.length + 1];
        int i = 0;
        while (i < this.columnWidths.length) {
            containerWidth += this.columnWidths[i];
            ++i;
        }
        int yPos = r.y + this.layoutOrigin.y;
        int xMin = r.x + this.layoutOrigin.x;
        int xMax = r.x + this.layoutOrigin.x + containerWidth;
        int rowHeaderPos = 0;
        this.rowHeaderPositions = new Point[this.rowHeights.length];
        this.rowPositions[0] = yPos;
        this.rowStartPositions[0] = new Point(xMin, yPos);
        this.rowEndPositions[0] = new Point(xMax, yPos);
        int i2 = 0;
        while (i2 < this.rowHeights.length) {
            if (this.rowHeights[i2] > 0) {
                rowHeaderPos = yPos + this.rowHeights[i2] / 2;
                this.rowHeaderPositions[i2] = new Point(Math.max(xMin - 8, r.x), rowHeaderPos - 5);
            }
            if ((yPos += this.rowHeights[i2]) >= r.y + r.height) {
                yPos = r.y + r.height - 1;
            }
            Point startPoint = new Point(xMin, yPos);
            Point endPoint = new Point(xMax, yPos);
            this.rowPositions[i2 + 1] = yPos;
            this.rowStartPositions[i2 + 1] = startPoint;
            this.rowEndPositions[i2 + 1] = endPoint;
            ++i2;
        }
    }

    protected void drawRowDividers(Graphics g) {
        if (this.rowStartPositions == null && this.rowEndPositions == null) {
            return;
        }
        int i = 0;
        while (i < this.rowStartPositions.length) {
            g.drawLine(this.rowStartPositions[i], this.rowEndPositions[i]);
            ++i;
        }
    }

    protected void drawRowHeaders(Graphics g) {
        Color orgColor = g.getBackgroundColor();
        int i = 0;
        while (i < this.rowHeaderPositions.length) {
            Point p = this.rowHeaderPositions[i];
            int rowNumber = 0;
            if (i < this.highlightRowStart) {
                g.setBackgroundColor(ColorConstants.cyan);
                rowNumber = i;
            } else {
                g.setBackgroundColor(ColorConstants.yellow);
                rowNumber = i + 1;
            }
            this.drawRowHeader(g, rowNumber, p);
            ++i;
        }
        g.setBackgroundColor(orgColor);
    }

    protected void drawRowHeader(Graphics g, int rowNumber, Point p) {
        if (p != null) {
            String rowname = Integer.toString(rowNumber);
            int charwidth = g.getFontMetrics().getAverageCharWidth();
            int charheight = g.getFontMetrics().getHeight();
            g.fillOval(new Rectangle(p.x, p.y - 1, rowname.length() * charwidth + 8, charheight + 2));
            g.drawOval(new Rectangle(p.x, p.y - 1, rowname.length() * charwidth + 8, charheight + 2));
            g.drawText(Integer.toString(rowNumber), new Point(p.x + 4, p.y));
        }
    }

    public void highlightRowHeadersFromRow(int rowNumber) {
        this.highlightRowStart = rowNumber;
    }

    public void resetHighlightedRowHeaders() {
        this.highlightRowStart = 9999;
    }

    public Point getCellLocation(int x, int y) {
        return this.getCellLocation(x, y, false, false);
    }

    public Point getCellLocation(int x, int y, boolean includeEmptyColumns, boolean includeEmptyRows) {
        int j;
        if (this.rowPositions == null || this.columnPositions == null) {
            return new Point(0, 0);
        }
        int gridx = 0;
        int gridy = 0;
        boolean foundx = false;
        boolean foundy = false;
        int i = 0;
        while (i < this.columnPositions.length - 1) {
            int xpos = this.columnPositions[i];
            if (x >= xpos && x < this.columnPositions[i + 1]) {
                gridx = i;
                if (includeEmptyColumns) {
                    j = i;
                    while (j >= 0 && this.columnPositions[i] == this.columnPositions[j]) {
                        --j;
                    }
                    gridx = j + 1;
                }
                foundx = true;
                break;
            }
            ++i;
        }
        i = 0;
        while (i < this.rowPositions.length - 1) {
            int ypos = this.rowPositions[i];
            if (y >= ypos && y < this.rowPositions[i + 1]) {
                gridy = i;
                if (includeEmptyRows) {
                    j = i;
                    while (j >= 0 && this.rowPositions[i] == this.rowPositions[j]) {
                        --j;
                    }
                    gridy = j + 1;
                }
                foundy = true;
                break;
            }
            ++i;
        }
        if (!foundx && x >= this.columnPositions[this.columnPositions.length - 1]) {
            gridx = this.columnPositions.length - 1;
        }
        if (!foundy && y >= this.rowPositions[this.rowPositions.length - 1]) {
            gridy = this.rowPositions.length - 1;
        }
        return new Point(gridx, gridy);
    }

    public Rectangle getCellBounds(int x, int y) {
        if (this.rowPositions == null || this.columnPositions == null) {
            return new Rectangle();
        }
        int cellxpos = 0;
        int cellypos = 0;
        int cellwidth = 0;
        int cellheight = 0;
        int i = 0;
        while (i < this.columnPositions.length - 1) {
            int xpos = this.columnPositions[i];
            if (x >= xpos && x < this.columnPositions[i + 1]) {
                cellxpos = xpos;
                cellwidth = this.columnPositions[i + 1] - xpos;
                break;
            }
            ++i;
        }
        i = 0;
        while (i < this.rowPositions.length - 1) {
            int ypos = this.rowPositions[i];
            if (y >= ypos && y < this.rowPositions[i + 1]) {
                cellypos = ypos;
                cellheight = this.rowPositions[i + 1] - ypos;
                break;
            }
            ++i;
        }
        return new Rectangle(cellxpos, cellypos, cellwidth, cellheight);
    }

    public Point getColumnStartPosition(int x) {
        if (this.columnStartPositions != null) {
            int i = 0;
            while (i < this.columnPositions.length) {
                int xpos = this.columnPositions[i];
                if (xpos <= x && x <= xpos + 3) {
                    return this.columnStartPositions[i];
                }
                ++i;
            }
        }
        return new Point(0, 0);
    }

    public Point getColumnEndPosition(int x) {
        if (this.columnEndPositions != null) {
            int i = 0;
            while (i < this.columnPositions.length) {
                int xpos = this.columnPositions[i];
                if (xpos <= x && x <= xpos + 3) {
                    return this.columnEndPositions[i];
                }
                ++i;
            }
        }
        return new Point(0, 0);
    }

    public Point getRowStartPosition(int y) {
        if (this.rowStartPositions != null) {
            int i = 0;
            while (i < this.rowPositions.length) {
                int ypos = this.rowPositions[i];
                if (ypos <= y && y < ypos + 3) {
                    return this.rowStartPositions[i];
                }
                ++i;
            }
        }
        return new Point(0, 0);
    }

    public Point getRowEndPosition(int y) {
        if (this.rowStartPositions != null) {
            int i = 0;
            while (i < this.rowPositions.length) {
                int ypos = this.rowPositions[i];
                if (ypos <= y && y < ypos + 3) {
                    return this.rowEndPositions[i];
                }
                ++i;
            }
        }
        return new Point(0, 0);
    }

    public boolean isPointerNearAColumn(int x) {
        if (this.columnPositions == null) {
            return false;
        }
        int i = 0;
        while (i < this.columnPositions.length) {
            int xpos = this.columnPositions[i];
            if (xpos <= x && x <= xpos + 3) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isPointerNearARow(int y) {
        if (this.rowPositions == null) {
            return false;
        }
        int i = 0;
        while (i < this.rowPositions.length) {
            int ypos = this.rowPositions[i];
            if (ypos <= y && y < ypos + 3) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isColumnHidden(int x) {
        if (this.columnHeaderPositions != null && x < this.columnHeaderPositions.length - 1) {
            return this.columnHeaderPositions[x] == null;
        }
        return false;
    }

    public boolean isRowHidden(int y) {
        if (this.rowHeaderPositions != null && y < this.rowHeaderPositions.length - 1) {
            return this.rowHeaderPositions[y] == null;
        }
        return false;
    }

    public void setLayoutDimensions(int[][] dim) {
        if (dim == null) {
            return;
        }
        this.columnWidths = dim[0];
        this.rowHeights = dim[1];
        this.calculateColumnDividers();
        this.calculateRowDividers();
        this.invalidate();
    }
}

