/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.jem.internal.beaninfo.core.Utilities;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.ve.internal.cde.commands.CommandBuilder;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.emf.InverseMaintenanceAdapter;
import org.eclipse.ve.internal.java.core.AbstractJavaContainerPolicy;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.IBeanProxyHost;
import org.eclipse.ve.internal.java.core.JavaEditDomainHelper;
import org.eclipse.ve.internal.java.rules.RuledCommandBuilder;
import org.eclipse.ve.internal.jfc.core.JFCConstants;

public class JSplitPaneContainerPolicy
extends AbstractJavaContainerPolicy {
    public static final int VERTICAL_SPLIT = 0;
    public static final int HORIZONTAL_SPLIT = 1;
    protected JavaClass classComponent;
    protected EReference sfLeftComponent;
    protected EReference sfRightComponent;
    protected EReference sfTopComponent;
    protected EReference sfBottomComponent;
    protected EReference sf_constraintComponent;
    protected EReference sf_constraintConstraint;
    protected EReference sf_containerComponents;
    protected static final int LEFT_COMP = 0;
    protected static final int RIGHT_COMP = 1;
    protected static final int TOP_COMP = 2;
    protected static final int BOTTOM_COMP = 3;

    public JSplitPaneContainerPolicy(EditDomain domain) {
        super(domain);
        ResourceSet rset = JavaEditDomainHelper.getResourceSet((EditDomain)domain);
        this.sfLeftComponent = JavaInstantiation.getReference((ResourceSet)rset, (URI)JFCConstants.SF_JSPLITPANE_LEFTCOMPONENT);
        this.sfRightComponent = JavaInstantiation.getReference((ResourceSet)rset, (URI)JFCConstants.SF_JSPLITPANE_RIGHTCOMPONENT);
        this.sfBottomComponent = JavaInstantiation.getReference((ResourceSet)rset, (URI)JFCConstants.SF_JSPLITPANE_BOTTOMCOMPONENT);
        this.sfTopComponent = JavaInstantiation.getReference((ResourceSet)rset, (URI)JFCConstants.SF_JSPLITPANE_TOPCOMPONENT);
        this.sf_constraintComponent = JavaInstantiation.getReference((ResourceSet)rset, (URI)JFCConstants.SF_CONSTRAINT_COMPONENT);
        this.sf_constraintConstraint = JavaInstantiation.getReference((ResourceSet)rset, (URI)JFCConstants.SF_CONSTRAINT_CONSTRAINT);
        this.sf_containerComponents = JavaInstantiation.getReference((ResourceSet)rset, (URI)JFCConstants.SF_CONTAINER_COMPONENTS);
        this.classComponent = (JavaClass)Utilities.getJavaClass((String)"java.awt.Component", (ResourceSet)rset);
    }

    protected EObject[] determineSplitpaneOccupants() {
        EObject[] result = new EObject[]{(EObject)((EObject)this.container).eGet((EStructuralFeature)this.sfLeftComponent), (EObject)((EObject)this.container).eGet((EStructuralFeature)this.sfRightComponent), (EObject)((EObject)this.container).eGet((EStructuralFeature)this.sfTopComponent), (EObject)((EObject)this.container).eGet((EStructuralFeature)this.sfBottomComponent)};
        List constraintChildren = (List)((EObject)this.container).eGet((EStructuralFeature)this.sf_containerComponents);
        Iterator itr = constraintChildren.iterator();
        while (itr.hasNext()) {
            IJavaObjectInstance constraintString;
            String constraint;
            EObject constraintComponent = (EObject)itr.next();
            EObject component = (EObject)constraintComponent.eGet((EStructuralFeature)this.sf_constraintComponent);
            if (BeanProxyUtilities.getBeanProxyHost((IJavaInstance)((IJavaInstance)component)).getErrorStatus() == 3 || (constraint = BeanProxyUtilities.getBeanProxy((IJavaInstance)(constraintString = (IJavaObjectInstance)constraintComponent.eGet((EStructuralFeature)this.sf_constraintConstraint))).toBeanString()) == null) continue;
            if (constraint.equals("left")) {
                result[0] = component;
                continue;
            }
            if (constraint.equals("top")) {
                result[2] = component;
                continue;
            }
            if (constraint.equals("right")) {
                result[1] = component;
                continue;
            }
            if (!constraint.equals("bottom")) continue;
            result[3] = component;
        }
        return result;
    }

    public Command getAddCommand(List children, Object positionBeforeChild) {
        CommandBuilder cBldr;
        if (children == null || children.isEmpty() || children.size() > 1) {
            return UnexecutableCommand.INSTANCE;
        }
        Object child = children.get(0);
        EStructuralFeature containmentSF = this.getStructuralFeature(child, positionBeforeChild, cBldr = new CommandBuilder());
        if (containmentSF != null) {
            cBldr.append(this.primAddCommand(children, positionBeforeChild, containmentSF));
        }
        return cBldr.getCommand();
    }

    public Command getCreateCommand(Object child, Object positionBeforeChild) {
        CommandBuilder cBldr = new CommandBuilder();
        EStructuralFeature containmentSF = this.getStructuralFeature(child, positionBeforeChild, cBldr);
        if (containmentSF != null) {
            cBldr.append(this.primCreateCommand(child, positionBeforeChild, containmentSF));
        }
        return cBldr.getCommand();
    }

    protected EStructuralFeature getStructuralFeature(Object child, Object positionBeforeChild, CommandBuilder cmdbldr) {
        EReference rightBottomSF;
        EReference leftTopSF;
        if (!this.isValidChild(child, null) || !this.isParentAcceptable(child)) {
            cmdbldr.append((Command)UnexecutableCommand.INSTANCE);
            return null;
        }
        EObject[] components = this.determineSplitpaneOccupants();
        if (!(components[0] == null && components[2] == null || components[1] == null && components[3] == null)) {
            cmdbldr.append((Command)UnexecutableCommand.INSTANCE);
            return null;
        }
        IBeanProxyHost proxyHost = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)((IJavaObjectInstance)this.container));
        IIntegerBeanProxy intProxy = (IIntegerBeanProxy)BeanProxyUtilities.invoke((IBeanProxy)proxyHost.getBeanProxy(), (String)"getOrientation");
        int orientation = intProxy.intValue();
        if (orientation == 1) {
            leftTopSF = this.sfLeftComponent;
            rightBottomSF = this.sfRightComponent;
        } else {
            leftTopSF = this.sfTopComponent;
            rightBottomSF = this.sfBottomComponent;
        }
        if (components[0] == null && components[2] == null && components[1] == null && components[3] == null) {
            return leftTopSF;
        }
        if (positionBeforeChild == null) {
            if (components[0] != null || components[2] != null) {
                return rightBottomSF;
            }
            if (components[0] == null && components[2] == null && (components[1] != null || components[3] != null)) {
                EReference containmentSF;
                EObject component = null;
                if (components[1] != null) {
                    containmentSF = this.sfRightComponent;
                    component = components[1];
                } else {
                    containmentSF = this.sfBottomComponent;
                    component = components[3];
                }
                this.cancelComponent(cmdbldr, (EStructuralFeature)containmentSF, component);
                cmdbldr.applyAttributeSetting((EObject)this.container, (EStructuralFeature)leftTopSF, (Object)component);
                return rightBottomSF;
            }
        } else {
            if (components[0] == null && components[2] == null && (components[1] != null || components[3] != null)) {
                return leftTopSF;
            }
            if (components[1] == null && components[3] == null && (components[0] != null || components[2] != null)) {
                EReference containmentSF;
                EObject component = null;
                if (components[0] != null) {
                    containmentSF = this.sfLeftComponent;
                    component = components[0];
                } else {
                    containmentSF = this.sfTopComponent;
                    component = components[2];
                }
                this.cancelComponent(cmdbldr, (EStructuralFeature)containmentSF, component);
                cmdbldr.applyAttributeSetting((EObject)this.container, (EStructuralFeature)rightBottomSF, (Object)component);
                return leftTopSF;
            }
        }
        return null;
    }

    protected void cancelComponent(CommandBuilder cmdbldr, EStructuralFeature containmentSF, EObject component) {
        EObject constraintComponent = InverseMaintenanceAdapter.getIntermediateReference((EObject)((EObject)this.container), (EReference)this.sf_containerComponents, (EReference)this.sf_constraintComponent, (Notifier)component);
        if (constraintComponent != null) {
            RuledCommandBuilder rcb = new RuledCommandBuilder(this.domain);
            rcb.cancelAttributeSetting((EObject)this.container, (EStructuralFeature)this.sf_containerComponents, (Object)constraintComponent);
            rcb.setApplyRules(false);
            rcb.cancelAttributeSetting(constraintComponent, (EStructuralFeature)this.sf_constraintComponent);
            cmdbldr.append(rcb.getCommand());
        } else {
            cmdbldr.cancelAttributeSetting((EObject)this.container, containmentSF, (Object)component);
        }
    }

    public Command getDeleteDependentCommand(Object child) {
        EObject constraintComponent = InverseMaintenanceAdapter.getIntermediateReference((EObject)((EObject)this.container), (EReference)this.sf_containerComponents, (EReference)this.sf_constraintComponent, (Notifier)((EObject)child));
        if (constraintComponent != null) {
            return super.getDeleteDependentCommand((Object)constraintComponent, (EStructuralFeature)this.sf_containerComponents);
        }
        EReference delReference = this.containmentSF((EObject)child);
        if (delReference != null) {
            return super.getDeleteDependentCommand(child, (EStructuralFeature)delReference);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected EReference containmentSF(EObject child) {
        EReference[] referencedBy = InverseMaintenanceAdapter.getReferencesFrom((EObject)((EObject)this.container), (Notifier)child);
        if (referencedBy != null) {
            List<EReference> rby = Arrays.asList(referencedBy);
            if (rby.contains(this.sfLeftComponent)) {
                return this.sfLeftComponent;
            }
            if (rby.contains(this.sfRightComponent)) {
                return this.sfRightComponent;
            }
            if (rby.contains(this.sfTopComponent)) {
                return this.sfTopComponent;
            }
            if (rby.contains(this.sfBottomComponent)) {
                return this.sfBottomComponent;
            }
        }
        return null;
    }

    public Command getMoveChildrenCommand(List children, Object positionBeforeChild) {
        EReference rightBottomSF;
        EReference leftTopSF;
        if (children.size() > 1) {
            return UnexecutableCommand.INSTANCE;
        }
        Object child = children.get(0);
        if (positionBeforeChild != null && positionBeforeChild == child) {
            return UnexecutableCommand.INSTANCE;
        }
        EObject[] components = this.determineSplitpaneOccupants();
        IBeanProxyHost proxyHost = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)((IJavaObjectInstance)this.container));
        IIntegerBeanProxy intProxy = (IIntegerBeanProxy)BeanProxyUtilities.invoke((IBeanProxy)proxyHost.getBeanProxy(), (String)"getOrientation");
        int orientation = intProxy.intValue();
        if (orientation == 1) {
            leftTopSF = this.sfLeftComponent;
            rightBottomSF = this.sfRightComponent;
        } else {
            leftTopSF = this.sfTopComponent;
            rightBottomSF = this.sfBottomComponent;
        }
        if (positionBeforeChild == null && (components[1] == child || components[3] == child)) {
            return UnexecutableCommand.INSTANCE;
        }
        if (!(components[0] == null && components[2] == null || components[1] == null && components[3] == null)) {
            EObject leftTopComp;
            EReference containmentSF;
            CommandBuilder cmdbldr = new CommandBuilder("Move children");
            EObject rightBottomComp = null;
            if (components[0] != null) {
                containmentSF = this.sfLeftComponent;
                leftTopComp = components[0];
            } else {
                containmentSF = this.sfTopComponent;
                leftTopComp = components[2];
            }
            this.cancelComponent(cmdbldr, (EStructuralFeature)containmentSF, leftTopComp);
            if (components[1] != null) {
                containmentSF = this.sfRightComponent;
                rightBottomComp = components[1];
            } else {
                containmentSF = this.sfBottomComponent;
                rightBottomComp = components[3];
            }
            this.cancelComponent(cmdbldr, (EStructuralFeature)containmentSF, rightBottomComp);
            cmdbldr.applyAttributeSetting((EObject)this.container, (EStructuralFeature)leftTopSF, (Object)rightBottomComp);
            cmdbldr.applyAttributeSetting((EObject)this.container, (EStructuralFeature)rightBottomSF, (Object)leftTopComp);
            return cmdbldr.getCommand();
        }
        return UnexecutableCommand.INSTANCE;
    }

    public Command getOrphanChildrenCommand(List children) {
        RuledCommandBuilder compBldr = new RuledCommandBuilder(this.domain);
        compBldr.setApplyRules(false);
        ArrayList<EObject> constraints = new ArrayList<EObject>(children.size());
        Iterator itr = children.iterator();
        while (itr.hasNext()) {
            EObject component = (EObject)itr.next();
            EObject constraint = InverseMaintenanceAdapter.getIntermediateReference((EObject)((EObject)this.container), (EReference)this.sf_containerComponents, (EReference)this.sf_constraintComponent, (Notifier)component);
            if (constraint != null) {
                constraints.add(constraint);
                continue;
            }
            EReference containmentSF = this.containmentSF(component);
            if (containmentSF == null) continue;
            compBldr.cancelAttributeSetting((EObject)this.container, (EStructuralFeature)containmentSF);
        }
        if (!constraints.isEmpty()) {
            compBldr.setApplyRules(true);
            compBldr.cancelAttributeSettings((EObject)this.container, (EStructuralFeature)this.sf_containerComponents, constraints);
            compBldr.setApplyRules(false);
            compBldr.cancelGroupAttributeSetting(constraints, (EStructuralFeature)this.sf_constraintComponent);
        }
        return compBldr.getCommand();
    }

    protected boolean isValidChild(Object child, EStructuralFeature containmentSF) {
        return this.classComponent.isInstance(child) && (!((EObject)this.getContainer()).eIsSet((EStructuralFeature)this.sfLeftComponent) && !((EObject)this.getContainer()).eIsSet((EStructuralFeature)this.sfTopComponent) || !((EObject)this.getContainer()).eIsSet((EStructuralFeature)this.sfRightComponent) && !((EObject)this.getContainer()).eIsSet((EStructuralFeature)this.sfBottomComponent));
    }

    public boolean isRightComponentOccupiedAndOnlyComponent() {
        EObject[] components = this.determineSplitpaneOccupants();
        return components[2] == null && components[0] == null && (components[3] != null || components[1] != null);
    }
}

