/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import java.text.MessageFormat;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ve.internal.cde.emf.InverseMaintenanceAdapter;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.jfc.core.JFCConstants;
import org.eclipse.ve.internal.jfc.core.VisualMessages;

public class JTabbedPaneChildTreeLabelDecorator
implements ILabelDecorator {
    protected EReference sfTabTitle;
    protected EReference sfTabComponent;
    protected EReference sfTabs;
    private ListenerList listeners = new ListenerList(1);
    private Adapter tabcomponentAdapter;
    protected EObject tabComponent;

    public JTabbedPaneChildTreeLabelDecorator(EObject model) {
        this.initializeSFs(model);
        this.tabComponent = InverseMaintenanceAdapter.getFirstReferencedBy((Notifier)model, (EReference)this.sfTabComponent);
        if (this.tabComponent != null) {
            this.tabComponent.eAdapters().add((Object)this.getTabComponentAdapter());
        }
    }

    private Adapter getTabComponentAdapter() {
        if (this.tabcomponentAdapter == null) {
            this.tabcomponentAdapter = new Adapter(){

                public void notifyChanged(Notification notification) {
                    if (notification.getFeature() == JTabbedPaneChildTreeLabelDecorator.this.sfTabTitle) {
                        JTabbedPaneChildTreeLabelDecorator.this.fireLabelProviderChanged();
                    }
                }

                public Notifier getTarget() {
                    return null;
                }

                public void setTarget(Notifier newTarget) {
                }

                public boolean isAdapterForType(Object type) {
                    return false;
                }
            };
        }
        return this.tabcomponentAdapter;
    }

    protected void fireLabelProviderChanged() {
        Object[] listeners = this.listeners.getListeners();
        final LabelProviderChangedEvent labelProviderChangeEvent = new LabelProviderChangedEvent((IBaseLabelProvider)this);
        int i = 0;
        while (i < listeners.length) {
            final ILabelProviderListener l = (ILabelProviderListener)listeners[i];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.labelProviderChanged(labelProviderChangeEvent);
                }
            });
            ++i;
        }
    }

    public void initializeSFs(EObject component) {
        ResourceSet rset = component.eResource().getResourceSet();
        if (this.sfTabTitle == null) {
            this.sfTabTitle = JavaInstantiation.getReference((ResourceSet)rset, (URI)JFCConstants.SF_JTABCOMPONENT_TITLE);
        }
        if (this.sfTabComponent == null) {
            this.sfTabComponent = JavaInstantiation.getReference((ResourceSet)rset, (URI)JFCConstants.SF_JTABCOMPONENT_COMPONENT);
        }
        if (this.sfTabs == null) {
            this.sfTabs = JavaInstantiation.getReference((ResourceSet)rset, (URI)JFCConstants.SF_JTABBEDPANE_TABS);
        }
    }

    public Image decorateImage(Image image, Object element) {
        return image;
    }

    public String decorateText(String text, Object element) {
        String title;
        IJavaObjectInstance tabTitle;
        if (element == null) {
            return "";
        }
        if (!(element instanceof IJavaObjectInstance)) {
            return element.toString();
        }
        IJavaObjectInstance component = (IJavaObjectInstance)element;
        if (this.tabComponent != null && BeanProxyUtilities.getBeanProxyHost((IJavaInstance)component).getErrorStatus() != 3 && (tabTitle = (IJavaObjectInstance)this.tabComponent.eGet((EStructuralFeature)this.sfTabTitle)) != null && (title = BeanProxyUtilities.getBeanProxy((IJavaInstance)tabTitle).toBeanString()) != null) {
            text = MessageFormat.format(VisualMessages.getString("JTabbedPaneChildTreeLabelDecorator.Tab.Title"), text, title);
        }
        return text;
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add((Object)listener);
    }

    public void dispose() {
        if (this.tabComponent != null) {
            this.tabComponent.eAdapters().remove((Object)this.getTabComponentAdapter());
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove((Object)listener);
    }
}

