/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jem.internal.proxy.awt.IRectangleBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jem.internal.proxy.core.IInvokable;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.IStandardBeanProxyFactory;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.ve.internal.cde.core.CDEUtilities;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.core.IImageListener;
import org.eclipse.ve.internal.cde.emf.EditPartAdapterRunnable;
import org.eclipse.ve.internal.jfc.core.ComponentGraphicalEditPart;
import org.eclipse.ve.internal.jfc.core.FlowLayoutEditPolicy;
import org.eclipse.ve.internal.jfc.core.JFCConstants;
import org.eclipse.ve.internal.jfc.core.JScrollPaneGraphicalEditPart;
import org.eclipse.ve.internal.jfc.core.JTableContainerPolicy;
import org.eclipse.ve.internal.jfc.core.TableColumnGraphicalEditPart;

public class JTableGraphicalEditPart
extends ComponentGraphicalEditPart {
    private EStructuralFeature sfColumns;
    private IBeanProxy fHeaderProxy = null;
    private IMethodProxy fGetHeaderRect = null;
    private boolean isOnScrollPane = false;
    private JTableImageListener fImageListener;
    protected FigureListener hostFigureListener = new FigureListener(){

        public void figureMoved(IFigure source) {
            JTableGraphicalEditPart.this.refreshColumns();
            JTableGraphicalEditPart.this.shiftFigureForParent(JTableGraphicalEditPart.this.getFigure());
        }
    };
    private Adapter jTableAdapter = new EditPartAdapterRunnable(){

        public void run() {
            if (JTableGraphicalEditPart.this.isActive()) {
                JTableGraphicalEditPart.this.refreshChildren();
            }
            JTableGraphicalEditPart.this.refreshColumns();
        }

        public void notifyChanged(Notification notification) {
            if (notification.getFeature() == JTableGraphicalEditPart.this.sfColumns) {
                this.queueExec((EditPart)JTableGraphicalEditPart.this);
            }
        }
    };
    private Runnable fRefreshColumnsRunnable = new Runnable(){

        public void run() {
            List children = JTableGraphicalEditPart.this.getChildren();
            int i = 0;
            while (i < children.size()) {
                TableColumnGraphicalEditPart columnEP = (TableColumnGraphicalEditPart)children.get(i);
                columnEP.setBounds(JTableGraphicalEditPart.this.getColumnBounds(i));
                columnEP.refresh();
                ++i;
            }
        }
    };

    public JTableGraphicalEditPart(Object aModel) {
        super(aModel);
    }

    public IFigure createFigure() {
        IFigure figure = super.createFigure();
        this.shiftFigureForParent(figure);
        return figure;
    }

    private void shiftFigureForParent(IFigure figure) {
        if (this.getParent() instanceof JScrollPaneGraphicalEditPart) {
            this.isOnScrollPane = true;
            Rectangle parentBounds = ((JScrollPaneGraphicalEditPart)this.getParent()).getFigure().getBounds().getCopy();
            figure.setBounds(parentBounds);
        } else {
            this.isOnScrollPane = false;
        }
    }

    protected JTableImageListener getJTableImageListener() {
        if (this.fImageListener == null) {
            this.fImageListener = new JTableImageListener();
        }
        return this.fImageListener;
    }

    public void activate() {
        super.activate();
        ((EObject)this.getModel()).eAdapters().add((Object)this.jTableAdapter);
        this.getFigure().addFigureListener(this.hostFigureListener);
        this.getVisualComponent().addImageListener((IImageListener)this.getJTableImageListener());
    }

    public void deactivate() {
        super.deactivate();
        ((EObject)this.getModel()).eAdapters().remove((Object)this.jTableAdapter);
        this.getFigure().removeFigureListener(this.hostFigureListener);
        this.getVisualComponent().removeImageListener((IImageListener)this.getJTableImageListener());
        this.fHeaderProxy = null;
        this.fGetHeaderRect = null;
    }

    protected void createEditPolicies() {
        EditDomain domain = EditDomain.getEditDomain((EditPart)this);
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new FlowLayoutEditPolicy(new JTableContainerPolicy(domain)));
        super.createEditPolicies();
    }

    private void refreshColumns() {
        if (this.getChildren().size() == 0) {
            return;
        }
        CDEUtilities.displayExec((EditPart)this, (Runnable)this.fRefreshColumnsRunnable);
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshColumns();
    }

    protected List getModelChildren() {
        if (this.isOnScrollPane) {
            return this.getChildJavaBeans();
        }
        return Collections.EMPTY_LIST;
    }

    public List getChildJavaBeans() {
        return (List)((EObject)this.getModel()).eGet(this.sfColumns);
    }

    protected EditPart createChild(Object child) {
        if (this.isOnScrollPane) {
            TableColumnGraphicalEditPart result = new TableColumnGraphicalEditPart();
            result.setModel(child);
            result.setBounds(this.getColumnBounds(this.getChildren().size()));
            return result;
        }
        return null;
    }

    public void setModel(Object model) {
        super.setModel(model);
        this.sfColumns = JavaInstantiation.getSFeature((ResourceSet)((EObject)model).eClass().eResource().getResourceSet(), (URI)JFCConstants.SF_JTABLE_COLUMNS);
    }

    private IBeanProxy getHeaderProxy() {
        if (this.fHeaderProxy == null || !this.fHeaderProxy.isValid()) {
            IBeanProxy tableProxy = this.getComponentProxy().getBeanProxy();
            IInvokable getTableHeader = tableProxy.getTypeProxy().getInvokable("getTableHeader");
            this.fHeaderProxy = getTableHeader.invokeCatchThrowableExceptions(tableProxy);
        }
        return this.fHeaderProxy;
    }

    private IMethodProxy getGetHeaderRect() {
        if (this.fGetHeaderRect == null) {
            this.fGetHeaderRect = this.getHeaderProxy().getTypeProxy().getMethodProxy("getHeaderRect", new String[]{"int"});
        }
        return this.fGetHeaderRect;
    }

    private Rectangle getBounds() {
        return this.getFigure().getBounds().getCopy();
    }

    private Rectangle getColumnBounds(int index) {
        Rectangle result = null;
        if (index < 0) {
            return null;
        }
        try {
            IStandardBeanProxyFactory fac = this.getHeaderProxy().getProxyFactoryRegistry().getBeanProxyFactory();
            IIntegerBeanProxy indexProxy = fac.createBeanProxyWith(index);
            IRectangleBeanProxy rectProxy = (IRectangleBeanProxy)this.getGetHeaderRect().invoke(this.getHeaderProxy(), new IBeanProxy[]{indexProxy});
            result = new Rectangle();
            result.x = rectProxy.getX();
            result.width = rectProxy.getWidth();
            result.height = rectProxy.getHeight();
            Rectangle parentBounds = this.getBounds();
            result.x += parentBounds.x;
            result.y = parentBounds.y;
        }
        catch (ThrowableProxy throwableProxy) {
            result = null;
        }
        return result;
    }

    protected class JTableImageListener
    implements IImageListener {
        protected JTableImageListener() {
        }

        public void imageChanged(ImageData imageData) {
            JTableGraphicalEditPart.this.refreshColumns();
        }
    }
}

