/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.internal.beaninfo.core.Utilities;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.IBeanProxyDomain;
import org.eclipse.ve.internal.java.core.IBeanProxyHost;
import org.eclipse.ve.internal.java.core.IErrorHolder;
import org.eclipse.ve.internal.java.core.JavaEditDomainHelper;
import org.eclipse.ve.internal.jfc.core.BeanAwtUtilities;
import org.eclipse.ve.internal.jfc.core.ComponentProxyAdapter;
import org.eclipse.ve.internal.jfc.core.IComponentProxyHost;

public class JToolBarProxyAdapter
extends ComponentProxyAdapter {
    protected EStructuralFeature sfItems;
    protected JavaClass classComponent;
    protected JavaClass classAction;
    protected IMethodProxy fAddActionMethodProxy;
    protected IMethodProxy fRemoveAllMethodProxy;

    public JToolBarProxyAdapter(IBeanProxyDomain domain) {
        super(domain);
        ResourceSet rset = JavaEditDomainHelper.getResourceSet((EditDomain)domain.getEditDomain());
        this.classComponent = (JavaClass)Utilities.getJavaClass((String)"java.awt.Component", (ResourceSet)rset);
        this.classAction = (JavaClass)Utilities.getJavaClass((String)"javax.swing.Action", (ResourceSet)rset);
    }

    protected void applied(EStructuralFeature as, Object newValue, int position) {
        if (as == this.getSFItems()) {
            IJavaInstance item = (IJavaInstance)newValue;
            IBeanProxyHost itemBeanProxyHost = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)item);
            itemBeanProxyHost.instantiateBeanProxy();
            if (itemBeanProxyHost.getErrorStatus() == 3) {
                this.processError(this.getSFItems(), ((IErrorHolder.ExceptionError)itemBeanProxyHost.getErrors().get((int)0)).error, item);
            } else {
                this.removeItems();
                this.applyItems();
                this.revalidateBeanProxy();
            }
        } else {
            super.applied(as, newValue, position);
        }
    }

    protected void canceled(EStructuralFeature sf, Object oldValue, int position) {
        if (sf == this.getSFItems()) {
            this.removeComponent((EObject)oldValue);
        } else {
            super.canceled(sf, oldValue, position);
        }
    }

    protected void applyItems() {
        if (this.getErrorStatus() == 3) {
            return;
        }
        EStructuralFeature sfitems = this.getSFItems();
        List items = (List)((EObject)this.getTarget()).eGet(sfitems);
        Iterator iter = items.iterator();
        while (iter.hasNext()) {
            IBeanProxyHost itemBeanProxyHost;
            IJavaObjectInstance item = (IJavaObjectInstance)iter.next();
            if (!this.isValidFeature(sfitems, item) || !(itemBeanProxyHost = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)item)).isBeanProxyInstantiated() || itemBeanProxyHost.getErrorStatus() == 3) continue;
            try {
                IMethodProxy addActionMethodProxy;
                IBeanProxy itemBeanProxy = itemBeanProxyHost.getBeanProxy();
                if (this.classComponent.isInstance((Object)item)) {
                    BeanAwtUtilities.invoke_add_Component(this.getBeanProxy(), itemBeanProxy);
                    IComponentProxyHost componentAdapter = (IComponentProxyHost)itemBeanProxyHost;
                    componentAdapter.setParentComponentProxyHost(this);
                    continue;
                }
                if (!this.classAction.isInstance((Object)item) || (addActionMethodProxy = this.getAddActionMethodProxy()) == null) continue;
                addActionMethodProxy.invoke(this.getBeanProxy(), itemBeanProxy);
            }
            catch (ThrowableProxy e) {
                this.processError(this.getSFItems(), e, item);
            }
        }
    }

    protected IMethodProxy getAddActionMethodProxy() {
        if (this.fAddActionMethodProxy == null) {
            this.fAddActionMethodProxy = this.getBeanProxy().getTypeProxy().getMethodProxy("add", "javax.swing.Action");
        }
        return this.fAddActionMethodProxy;
    }

    protected EStructuralFeature getSFItems() {
        if (this.sfItems == null) {
            JavaClass modelType = (JavaClass)((EObject)this.getTarget()).eClass();
            this.sfItems = modelType.getEStructuralFeature("items");
        }
        return this.sfItems;
    }

    protected IMethodProxy removeAllMethodProxy() {
        if (this.fRemoveAllMethodProxy == null) {
            this.fRemoveAllMethodProxy = this.getBeanProxy().getTypeProxy().getMethodProxy("removeAll");
        }
        return this.fRemoveAllMethodProxy;
    }

    protected void removeComponent(EObject aComponent) {
        this.clearError(this.getSFItems(), aComponent);
        IBeanProxyHost aComponentBeanProxyHost = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)((IJavaInstance)aComponent));
        if (aComponentBeanProxyHost.getErrorStatus() != 3 && this.getErrorStatus() != 3) {
            if (this.classComponent.isInstance((Object)aComponent)) {
                BeanAwtUtilities.invoke_remove_Component(this.getBeanProxy(), aComponentBeanProxyHost.getBeanProxy());
            } else if (this.classAction.isInstance((Object)aComponent)) {
                BeanAwtUtilities.invoke_jtoolbar_remove_item_action(this.getBeanProxy(), aComponentBeanProxyHost.getBeanProxy());
            }
            aComponentBeanProxyHost.releaseBeanProxy();
            this.revalidateBeanProxy();
        }
    }

    protected void removeItems() {
        if (this.getErrorStatus() == 3) {
            return;
        }
        this.removeAllMethodProxy().invokeCatchThrowableExceptions(this.getBeanProxy());
    }

    public void releaseBeanProxy() {
        super.releaseBeanProxy();
        if (this.fRemoveAllMethodProxy != null) {
            this.fRemoveAllMethodProxy.getProxyFactoryRegistry().releaseProxy((IBeanProxy)this.fRemoveAllMethodProxy);
            this.fRemoveAllMethodProxy = null;
        }
        if (this.fAddActionMethodProxy != null) {
            this.fAddActionMethodProxy.getProxyFactoryRegistry().releaseProxy((IBeanProxy)this.fAddActionMethodProxy);
            this.fAddActionMethodProxy = null;
        }
    }
}

