/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gef.commands.Command;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.emf.InverseMaintenanceAdapter;
import org.eclipse.ve.internal.java.core.JavaEditDomainHelper;
import org.eclipse.ve.internal.java.rules.RuledCommandBuilder;
import org.eclipse.ve.internal.java.visual.ILayoutPolicyHelper;
import org.eclipse.ve.internal.java.visual.VisualContainerPolicy;
import org.eclipse.ve.internal.jfc.core.JFCConstants;

public abstract class LayoutPolicyHelper
implements ILayoutPolicyHelper {
    protected VisualContainerPolicy policy;
    protected EReference sfConstraintComponent;
    protected EReference sfConstraintConstraint;
    protected EReference sfComponents;
    protected EClass classConstraintComponent;
    protected EFactory visualFact;

    public LayoutPolicyHelper(VisualContainerPolicy ep) {
        this.setContainerPolicy(ep);
    }

    public LayoutPolicyHelper() {
    }

    public void setContainerPolicy(VisualContainerPolicy policy) {
        this.policy = policy;
        if (policy != null) {
            ResourceSet rset = JavaEditDomainHelper.getResourceSet((EditDomain)policy.getEditDomain());
            this.sfConstraintConstraint = JavaInstantiation.getReference((ResourceSet)rset, (URI)JFCConstants.SF_CONSTRAINT_CONSTRAINT);
            this.sfConstraintComponent = JavaInstantiation.getReference((ResourceSet)rset, (URI)JFCConstants.SF_CONSTRAINT_COMPONENT);
            this.sfComponents = JavaInstantiation.getReference((ResourceSet)rset, (URI)JFCConstants.SF_CONTAINER_COMPONENTS);
            this.classConstraintComponent = (EClass)rset.getEObject(JFCConstants.CLASS_CONTAINER_CONSTRAINTCOMPONENT, true);
            this.visualFact = JFCConstants.getFactory(this.classConstraintComponent);
        }
    }

    protected IJavaObjectInstance getContainer() {
        return (IJavaObjectInstance)this.policy.getContainer();
    }

    public Command getCreateChildCommand(Object childComponent, Object constraint, Object position) {
        EObject constraintComponent = this.visualFact.create(this.classConstraintComponent);
        if (constraint != ILayoutPolicyHelper.NO_CONSTRAINT_VALUE) {
            constraintComponent.eSet(JavaInstantiation.getSFeature((IJavaObjectInstance)this.getContainer(), (URI)JFCConstants.SF_CONSTRAINT_CONSTRAINT), constraint != null ? this.convertConstraint(constraint) : null);
        }
        return this.policy.getCreateCommand((Object)constraintComponent, childComponent, position);
    }

    public Command getAddChildrenCommand(List childrenComponents, List constraints, Object position) {
        ArrayList<EObject> componentConstraints = new ArrayList<EObject>(childrenComponents.size());
        Iterator itr = constraints.iterator();
        while (itr.hasNext()) {
            EObject constraintComponent = this.visualFact.create(this.classConstraintComponent);
            componentConstraints.add(constraintComponent);
            Object constraint = itr.next();
            if (constraint == ILayoutPolicyHelper.NO_CONSTRAINT_VALUE) continue;
            constraintComponent.eSet((EStructuralFeature)this.sfConstraintConstraint, constraint != null ? this.convertConstraint(constraint) : null);
        }
        return this.policy.getAddCommand(componentConstraints, childrenComponents, position);
    }

    public Command getOrphanChildrenCommand(List children) {
        return this.policy.getOrphanChildrenCommand(children);
    }

    public Command getChangeConstraintCommand(List children, List constraints) {
        RuledCommandBuilder cb = new RuledCommandBuilder(this.policy.getEditDomain());
        Iterator childs = children.iterator();
        Iterator consts = constraints.iterator();
        while (childs.hasNext()) {
            EObject constraintComponent = InverseMaintenanceAdapter.getIntermediateReference((EObject)((EObject)this.policy.getContainer()), (EReference)this.sfComponents, (EReference)this.sfConstraintComponent, (Notifier)((EObject)childs.next()));
            Object oconstraint = consts.next();
            if (oconstraint != ILayoutPolicyHelper.NO_CONSTRAINT_VALUE) {
                IJavaObjectInstance constraint = oconstraint != null ? this.convertConstraint(oconstraint) : null;
                cb.applyAttributeSetting(constraintComponent, (EStructuralFeature)this.sfConstraintConstraint, (Object)constraint);
                continue;
            }
            cb.cancelAttributeSetting(constraintComponent, (EStructuralFeature)this.sfConstraintConstraint);
        }
        return cb.getCommand();
    }

    protected abstract IJavaObjectInstance convertConstraint(Object var1);

    public Command getOrphanConstraintsCommand(List constraintComponents) {
        return null;
    }
}

