/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jem.internal.proxy.awt.IDimensionBeanProxy;
import org.eclipse.jem.internal.proxy.awt.IPointBeanProxy;
import org.eclipse.jem.internal.proxy.awt.IRectangleBeanProxy;
import org.eclipse.jem.internal.proxy.core.IArrayBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.ve.internal.cde.core.XYLayoutEditPolicy;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.visual.VisualContainerPolicy;
import org.eclipse.ve.internal.jfc.core.BeanAwtUtilities;
import org.eclipse.ve.internal.jfc.core.ContainerPolicy;
import org.eclipse.ve.internal.jfc.core.JFCConstants;
import org.eclipse.ve.internal.jfc.core.NullLayoutPolicyHelper;

public class NullLayoutEditPolicy
extends XYLayoutEditPolicy {
    protected VisualContainerPolicy containerPolicy;
    protected NullLayoutPolicyHelper helper = new NullLayoutPolicyHelper();

    public NullLayoutEditPolicy(VisualContainerPolicy containerPolicy) {
        this.containerPolicy = containerPolicy;
        this.helper.setContainerPolicy(containerPolicy);
    }

    public void activate() {
        super.activate();
        this.containerPolicy.setContainer(this.getHost().getModel());
    }

    public void deactivate() {
        super.deactivate();
        this.containerPolicy.setContainer(null);
    }

    protected Command createAddCommand(EditPart childEditPart, Object constraint) {
        Object child = childEditPart.getModel();
        NullLayoutPolicyHelper.NullConstraint nullconst = new NullLayoutPolicyHelper.NullConstraint((Rectangle)constraint, true, true);
        return this.helper.getAddChildrenCommand(Collections.singletonList(child), Collections.singletonList(nullconst), null);
    }

    protected Command getCreateCommand(CreateRequest aRequest) {
        Object child = aRequest.getNewObject();
        Object constraint = this.translateToModelConstraint(this.getConstraintFor(aRequest));
        NullLayoutPolicyHelper.NullConstraint nullconst = new NullLayoutPolicyHelper.NullConstraint((Rectangle)constraint, true, true);
        return this.helper.getCreateChildCommand(child, nullconst, null);
    }

    protected Command getDeleteDependantCommand(Request aRequest) {
        Command deleteContributionCmd = this.containerPolicy.getCommand(aRequest);
        if (deleteContributionCmd == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return deleteContributionCmd;
    }

    protected Command getOrphanChildrenCommand(Request aRequest) {
        return this.helper.getOrphanChildrenCommand(ContainerPolicy.getChildren((GroupRequest)((GroupRequest)aRequest)));
    }

    protected Command createChangeConstraintCommand(EditPart childEditPart, Object constraint, boolean moved, boolean resize) {
        return this.createChangeConstraintCommand(childEditPart.getModel(), constraint, moved, resize);
    }

    protected Object getChildConstraint(EditPart child) {
        IJavaObjectInstance size;
        IJavaObjectInstance childObject = (IJavaObjectInstance)child.getModel();
        IJavaObjectInstance constraint = (IJavaObjectInstance)childObject.eGet(JavaInstantiation.getSFeature((IJavaObjectInstance)childObject, (URI)JFCConstants.SF_COMPONENT_BOUNDS));
        if (constraint != null) {
            IRectangleBeanProxy rect = (IRectangleBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)constraint);
            return new Rectangle(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
        }
        Rectangle rect = new Rectangle();
        IJavaObjectInstance loc = (IJavaObjectInstance)childObject.eGet(JavaInstantiation.getSFeature((IJavaObjectInstance)childObject, (URI)JFCConstants.SF_COMPONENT_LOCATION));
        if (loc != null) {
            IPointBeanProxy point = (IPointBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)loc);
            rect.setLocation(point.getX(), point.getY());
        }
        if ((size = (IJavaObjectInstance)childObject.eGet(JavaInstantiation.getSFeature((IJavaObjectInstance)childObject, (URI)JFCConstants.SF_COMPONENT_LOCATION))) != null) {
            IDimensionBeanProxy sz = (IDimensionBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)size);
            rect.setSize(sz.getWidth(), sz.getHeight());
        }
        return rect;
    }

    protected Command createChangeConstraintCommand(Object child, Object constraint, boolean moved, boolean resize) {
        NullLayoutPolicyHelper.NullConstraint nullConstraint = new NullLayoutPolicyHelper.NullConstraint((Rectangle)constraint, moved, resize);
        return this.helper.getChangeConstraintCommand(Collections.singletonList(child), Collections.singletonList(nullConstraint));
    }

    protected Object translateToModelConstraint(Object figureConstraint) {
        return figureConstraint;
    }

    protected Object modelToFigureConstraint(Object modelConstraint) {
        IBeanProxy proxy;
        if (modelConstraint instanceof IJavaInstance && (proxy = BeanProxyUtilities.getBeanProxy((IJavaInstance)((IJavaInstance)modelConstraint))) instanceof IRectangleBeanProxy) {
            IRectangleBeanProxy rect = (IRectangleBeanProxy)modelConstraint;
            return new Rectangle(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
        }
        return null;
    }

    protected void setConstraintToFigure(EditPart child, Rectangle figureConstraint) {
    }

    protected boolean isChildResizeable(EditPart aChild) {
        return true;
    }

    public static boolean adjustForPreferredSizeAndPosition(IBeanProxy childProxy, Rectangle bounds, int marginWidth, int marginHeight) {
        boolean changedit = false;
        if (bounds.width == -1 || bounds.height == -1) {
            changedit = true;
            IDimensionBeanProxy preferredSize = BeanAwtUtilities.invoke_getPreferredSize(childProxy);
            if (bounds.width == -1) {
                bounds.width = Math.max(preferredSize.getWidth(), 10);
            }
            if (bounds.height == -1) {
                bounds.height = Math.max(preferredSize.getHeight(), 10);
            }
        }
        if (bounds.x == Integer.MIN_VALUE && bounds.y == Integer.MIN_VALUE) {
            changedit = true;
            IBeanProxy containerBeanProxy = BeanAwtUtilities.invoke_getParent(childProxy);
            Point position = NullLayoutEditPolicy.findNextAvailablePosition(bounds, containerBeanProxy, marginWidth, marginHeight);
            bounds.x = position.x;
            bounds.y = position.y;
        }
        return changedit;
    }

    public static boolean adjustForPreferredLocation(IBeanProxy childProxy, Point location, int marginWidth, int marginHeight) {
        boolean changedit = false;
        if (location.x == Integer.MIN_VALUE && location.y == Integer.MIN_VALUE) {
            changedit = true;
            IBeanProxy containerBeanProxy = BeanAwtUtilities.invoke_getParent(childProxy);
            IDimensionBeanProxy size = BeanAwtUtilities.invoke_getSize(childProxy);
            if (size == null) {
                return false;
            }
            Rectangle bounds = new Rectangle(location.x, location.y, size.getWidth(), size.getHeight());
            Point position = NullLayoutEditPolicy.findNextAvailablePosition(bounds, containerBeanProxy, marginWidth, marginHeight);
            location.x = position.x;
            location.y = position.y;
        }
        return changedit;
    }

    public static boolean adjustForPreferredSize(IBeanProxy childProxy, Dimension size) {
        boolean changedit = false;
        if (size.width == -1 || size.height == -1) {
            changedit = true;
            IDimensionBeanProxy preferredSize = BeanAwtUtilities.invoke_getPreferredSize(childProxy);
            if (size.width == -1) {
                size.width = Math.max(preferredSize.getWidth(), 10);
            }
            if (size.height == -1) {
                size.height = Math.max(preferredSize.getHeight(), 10);
            }
        }
        return changedit;
    }

    protected static Point findNextAvailablePosition(Rectangle bounds, IBeanProxy containerBeanProxy, int marginWidth, int marginHeight) {
        int requestedWidth = bounds.width + 2 * marginWidth;
        int requestedHeight = bounds.height + 2 * marginHeight;
        IRectangleBeanProxy boundingRect = BeanAwtUtilities.invoke_getBounds(containerBeanProxy);
        IArrayBeanProxy children = BeanAwtUtilities.invoke_getComponents(containerBeanProxy);
        ArrayList<Rectangle> rects = new ArrayList<Rectangle>(children.getLength());
        int i = 0;
        while (i < children.getLength()) {
            try {
                IRectangleBeanProxy cBounds = BeanAwtUtilities.invoke_getBounds(children.get(i));
                if (cBounds.getWidth() != -1 && cBounds.getHeight() != -1) {
                    Rectangle lBounds = new Rectangle(cBounds.getX(), cBounds.getY(), cBounds.getWidth(), cBounds.getHeight());
                    rects.add(lBounds);
                }
            }
            catch (ThrowableProxy exc) {
                exc.printProxyStackTrace();
            }
            ++i;
        }
        if (requestedWidth < boundingRect.getWidth()) {
            Rectangle tryRect;
            int highestBottom = 0;
            block3: while (true) {
                boolean intersects;
                int x = 0;
                int y = highestBottom;
                highestBottom = Integer.MAX_VALUE;
                do {
                    if (x + requestedWidth >= boundingRect.getWidth()) continue block3;
                    intersects = false;
                    tryRect = new Rectangle(x, y, requestedWidth, requestedHeight);
                    int i2 = 0;
                    while (i2 < rects.size()) {
                        Rectangle rect = (Rectangle)rects.get(i2);
                        if (rect.intersects(tryRect)) {
                            intersects = true;
                            x = Math.max(x, rect.x + rect.width);
                            highestBottom = Math.min(highestBottom, rect.y + rect.height);
                        }
                        ++i2;
                    }
                } while (intersects);
                break;
            }
            Point position = new Point(tryRect.x + marginWidth, tryRect.y + marginHeight);
            return position;
        }
        int y = 0;
        block6: while (true) {
            boolean intersects = false;
            Rectangle tryRect = new Rectangle(0, y, requestedWidth, requestedHeight);
            int i3 = 0;
            while (true) {
                if (i3 >= rects.size()) continue block6;
                Rectangle rect = (Rectangle)rects.get(i3);
                if (rect.intersects(tryRect)) {
                    intersects = true;
                    y = Math.max(y, rect.y + rect.height);
                }
                if (!intersects) {
                    Point position = new Point(tryRect.x + marginWidth, tryRect.y + marginHeight);
                    return position;
                }
                ++i3;
            }
            break;
        }
    }
}

