/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.jfc.core.IconController;
import org.eclipse.ve.internal.jfc.core.VisualMessages;

public class SingleImageDisplay
extends Canvas {
    private Image img;
    private String warningMsg = null;
    private int horizontalIncrement = 10;
    private int verticalIncrement = 10;
    private int horizontalPageIncrement;
    private int verticalPageIncrement;
    private int xOrigin = 0;
    private int yOrigin = 0;
    private final ScrollBar vBar = this.getVerticalBar();
    private final ScrollBar hBar = this.getHorizontalBar();

    public SingleImageDisplay(Composite shell, int style) {
        super(shell, style);
        this.addListeners();
    }

    public SingleImageDisplay(Composite shell, int style, int hi, int vi) {
        this(shell, style);
        this.horizontalIncrement = hi;
        this.verticalIncrement = vi;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int trim;
        int width = trim = 0;
        int height = trim;
        if (this.img != null) {
            width += this.img.getBounds().width + 4;
            height += this.img.getBounds().height + 4;
        } else {
            width += 200;
            height += 200;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    private void addListeners() {
        if (this.hBar != null) {
            this.hBar.setEnabled(false);
            this.hBar.setVisible(false);
            this.hBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SingleImageDisplay.this.horizontalScroll();
                }
            });
        }
        if (this.vBar != null) {
            this.vBar.setEnabled(false);
            this.vBar.setVisible(false);
            this.vBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SingleImageDisplay.this.verticalScroll();
                }
            });
        }
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                SingleImageDisplay.this.redraw();
            }

            public void focusLost(FocusEvent e) {
                SingleImageDisplay.this.redraw();
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent pe) {
                SingleImageDisplay.this.paintImage(pe.gc);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (SingleImageDisplay.this.img != null && SingleImageDisplay.this.img != IconController.warnIcon && SingleImageDisplay.this.img != IconController.errorIcon && SingleImageDisplay.this.img != IconController.noMemoryIcon) {
                    SingleImageDisplay.this.img.dispose();
                    SingleImageDisplay.this.img = null;
                }
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){
            private boolean inResize;

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void controlResized(ControlEvent e) {
                if (!this.inResize) {
                    this.inResize = true;
                    try {
                        SingleImageDisplay.this.resetHorizontalBar();
                        SingleImageDisplay.this.resetVerticalBar();
                    }
                    catch (Throwable throwable) {
                        Object var2_3 = null;
                        this.inResize = false;
                        throw throwable;
                    }
                    {
                        Object var2_4 = null;
                        this.inResize = false;
                    }
                    SingleImageDisplay.this.xOrigin = 0;
                    SingleImageDisplay.this.yOrigin = 0;
                    SingleImageDisplay.this.redraw();
                }
            }
        });
        this.addKeyListener(new KeyScrollListener());
        this.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4 || e.detail == 16 || e.detail == 8) {
                    e.doit = true;
                }
            }
        });
    }

    private void paintImage(GC gc) {
        int cw = this.getClientArea().width;
        int ch = this.getClientArea().height;
        if (this.img != null) {
            int w = this.img.getBounds().width;
            int h = this.img.getBounds().height;
            int width = cw > w ? w : cw - 4;
            int height = ch > h ? h : ch - 4;
            int cx = cw > w ? 2 + (cw - w - 4) / 2 : 2;
            int cy = ch > h ? 2 + (ch - h - 4) / 2 : 2;
            gc.drawImage(this.img, this.xOrigin, this.yOrigin, width, height, cx, cy, width, height);
        }
        if (this.isFocusControl()) {
            Color oldForeground = gc.getForeground();
            gc.setForeground(ColorConstants.gray);
            int oldLS = gc.getLineStyle();
            gc.setLineStyle(3);
            gc.drawRectangle(2, 2, cw - 4, ch - 4);
            gc.setForeground(oldForeground);
            gc.setLineStyle(oldLS);
        }
    }

    public String getImageMessage() {
        return this.warningMsg;
    }

    public void setImage(IPath path, IWorkspaceRoot wsroot) {
        this.warningMsg = null;
        if (this.img != null && this.img != IconController.noMemoryIcon && this.img != IconController.warnIcon && this.img != IconController.errorIcon) {
            this.img.dispose();
            this.img = null;
        }
        if (path == null) {
            this.redraw();
            return;
        }
        String filename = null;
        if (wsroot != null) {
            IResource res = wsroot.findMember(path);
            if (res != null) {
                filename = res.getLocation().toOSString();
            }
        } else {
            filename = path.toOSString();
        }
        if (filename != null) {
            try {
                this.img = new Image((Device)this.getDisplay(), filename);
            }
            catch (SWTException e) {
                this.warningMsg = e.getLocalizedMessage();
                if (this.warningMsg == null) {
                    this.warningMsg = VisualMessages.getString("SingleImageDisplay.ImageNotLoaded_WARN_");
                    JavaVEPlugin.log((Throwable)e);
                }
                this.img = IconController.warnIcon;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.warningMsg = VisualMessages.getString("SingleImageDisplay.OutOfMemory_WARN_");
                this.img = IconController.noMemoryIcon;
            }
        }
        this.resetHorizontalBar();
        this.resetVerticalBar();
        this.xOrigin = 0;
        this.yOrigin = 0;
        this.redraw();
    }

    private void resetHorizontalBar() {
        if (this.hBar != null) {
            if (this.img == null) {
                this.hBar.setEnabled(false);
                this.hBar.setVisible(false);
            } else {
                this.hBar.setSelection(0);
                int windowWidth = this.getClientArea().width;
                int imageWidth = this.img.getBounds().width;
                if (imageWidth > windowWidth) {
                    this.hBar.setEnabled(true);
                    this.hBar.setVisible(true);
                    this.hBar.setMaximum(imageWidth);
                    this.horizontalPageIncrement = windowWidth - this.horizontalIncrement;
                    this.hBar.setPageIncrement(this.horizontalPageIncrement);
                    this.hBar.setIncrement(this.horizontalIncrement);
                    this.hBar.setThumb(windowWidth);
                } else {
                    this.hBar.setEnabled(false);
                    this.hBar.setVisible(false);
                }
            }
        }
    }

    private void resetVerticalBar() {
        if (this.vBar != null) {
            if (this.img == null) {
                this.vBar.setEnabled(false);
                this.vBar.setVisible(false);
            } else {
                this.vBar.setSelection(0);
                int windowHeight = this.getClientArea().height;
                int imageHeight = this.img.getBounds().height;
                if (imageHeight > windowHeight) {
                    this.vBar.setEnabled(true);
                    this.vBar.setVisible(true);
                    this.vBar.setMaximum(imageHeight);
                    this.verticalPageIncrement = windowHeight - this.verticalIncrement;
                    this.vBar.setPageIncrement(this.verticalPageIncrement);
                    this.vBar.setIncrement(this.verticalIncrement);
                    this.vBar.setThumb(windowHeight);
                } else {
                    this.vBar.setEnabled(false);
                    this.vBar.setVisible(false);
                }
            }
        }
    }

    private void horizontalScroll() {
        int temp = this.hBar.getSelection();
        if (this.xOrigin != temp && this.hBar.isEnabled()) {
            this.xOrigin = temp;
            this.redraw();
        }
    }

    private void verticalScroll() {
        int temp = this.vBar.getSelection();
        if (temp != this.yOrigin && this.vBar.isEnabled()) {
            this.yOrigin = temp;
            this.redraw();
        }
    }

    private class KeyScrollListener
    implements KeyListener {
        KeyScrollListener() {
        }

        public void keyPressed(KeyEvent kee) {
            switch (kee.keyCode) {
                case 0x1000002: {
                    this.changeBarSelection(SingleImageDisplay.this.vBar, SingleImageDisplay.this.verticalIncrement);
                    break;
                }
                case 0x1000001: {
                    this.changeBarSelection(SingleImageDisplay.this.vBar, -SingleImageDisplay.this.verticalIncrement);
                    break;
                }
                case 0x1000004: {
                    this.changeBarSelection(SingleImageDisplay.this.hBar, SingleImageDisplay.this.horizontalIncrement);
                    break;
                }
                case 0x1000003: {
                    this.changeBarSelection(SingleImageDisplay.this.hBar, -SingleImageDisplay.this.horizontalIncrement);
                    break;
                }
                case 0x1000005: {
                    this.changeBarSelection(SingleImageDisplay.this.vBar, -SingleImageDisplay.this.verticalPageIncrement);
                    break;
                }
                case 0x1000006: {
                    this.changeBarSelection(SingleImageDisplay.this.vBar, SingleImageDisplay.this.verticalPageIncrement);
                    break;
                }
                case 0x1000007: {
                    if (kee.stateMask == 262144) {
                        this.scrollTo(SingleImageDisplay.this.hBar, 0);
                        this.scrollTo(SingleImageDisplay.this.vBar, 0);
                        break;
                    }
                    this.scrollTo(SingleImageDisplay.this.hBar, 0);
                    break;
                }
                case 0x1000008: {
                    if (kee.stateMask == 262144) {
                        this.scrollTo(SingleImageDisplay.this.hBar, SingleImageDisplay.this.hBar.getMaximum());
                        this.scrollTo(SingleImageDisplay.this.vBar, SingleImageDisplay.this.vBar.getMaximum());
                        break;
                    }
                    this.scrollTo(SingleImageDisplay.this.hBar, SingleImageDisplay.this.hBar.getMaximum());
                }
            }
        }

        public void keyReleased(KeyEvent kee) {
        }

        private void changeBarSelection(ScrollBar bar, int increment) {
            if (bar != null && bar.isEnabled()) {
                int selection = bar.getSelection() + increment;
                this.scrollTo(bar, selection);
            }
        }

        private void scrollTo(ScrollBar bar, int selection) {
            if (selection < 0) {
                selection = 0;
            }
            if (selection > bar.getMaximum()) {
                selection = bar.getMaximum();
            }
            bar.setSelection(selection);
            if (bar == SingleImageDisplay.this.vBar) {
                SingleImageDisplay.this.verticalScroll();
            } else if (bar == SingleImageDisplay.this.hBar) {
                SingleImageDisplay.this.horizontalScroll();
            }
        }
    }
}

