/* @(#) TimerSupport.java        Ver 1.0    01,April,1998
 *
 * Copyright (c) 1998 International Business Machines.
 * All Rights Reserved.
 *
 * Author : Sunanda Bera & P.Sushma
 * Last Modified : 01,April,1998
 *
 * Purpose : Defines class TimerSupport.
 *
 *
 * Revision History 
 * ======== ======= 
 *
 * Date        By            Description
 * ----        --            -----------
 *
 *
 */
package com.ibm.clock;

class TimerSupport
{
    private java.util.Vector listeners;
    private Object source;

/**
 * @source  The source for any events.
 */
    public TimerSupport(Object source) 
    {
        this.source = source;
    }

/**
 * Add a TimerListener to the listener list.
 *
 * @param listener  The TimerListener to be added
 */

    public synchronized void addTimerListener(
                TimerListener listener) 
    {
        if (listeners == null) 
        {
            listeners = new java.util.Vector();
        }
        else if( listeners.contains( listener ) )
        {
            return;
        }
        listeners.addElement(listener);
    }

/**
 * Remove a TimerListener from the listener list.
 *
 * @param listener  The TimerListener to be removed
 */

    public synchronized void removeTimerListener(
                TimerListener listener) 
    {
        if (listeners == null) 
        {
            return;
        }
        listeners.removeElement(listener);
    }

/**
 * Fire a timeChanged event to all the registered listeners.
 */
    public void fireTimeChangedEvent() 
    {
        TimerEvent evt = 
                        new TimerEvent( source ) ;
                        
        for (int i = 0; i < listeners.size(); i++)
        {
            TimerListener target = 
                            (TimerListener)listeners.elementAt(i);
            target.timeChanged(evt);
        }// end for
    } // end of firing. Bravo!
    

}//end of class TimerSupport
