package com.ibm.calendar;

/**************************************************************************
 * File: DayCircle.java
 * Version 2.0
 *
 *  Date               Author                  Changes
 *  Apr. 20, 2001      Lajos Kiskeri           Created
 *
 *
 * Copyright (c) 2001, IBM Corporation
 * All Rights Reserved
 ***************************************************************************/

/**
 *  DayCircle class handles (paints) the day rectangle with the given color circle in it
 *  independently from the whole calendar.
 */
class DayCircle extends java.awt.Component
{
	
	/**
	 * holds the color of the circle.
	 */
	private java.awt.Color circleColor;
	
/**
 * DayCircle constructor.
 * @param c java.awt.Color
 */
protected DayCircle(java.awt.Color c) {
	super();
	circleColor = c;
}

/**
 * Draws a circle on the day rectangle
 * @param g java.awt.Graphics
 */
public void paint(java.awt.Graphics g) 
{
	java.awt.Rectangle r = getBounds();
	setSize(r.width,r.height); // set size of the day rectangle
	g.setColor(circleColor);
	g.drawOval(0,0,r.width-1,r.height-1);
}

}