/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.vm.remote;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jem.internal.proxy.common.CommandException;
import org.eclipse.jem.internal.proxy.common.remote.Commands;
import org.eclipse.jem.internal.proxy.initParser.tree.NoExpressionValueException;
import org.eclipse.jem.internal.proxy.vm.remote.ConnectionHandler;
import org.eclipse.jem.internal.proxy.vm.remote.ExpressionProcesserController;
import org.eclipse.jem.internal.proxy.vm.remote.RemoteVMServerThread;

public class ConnectionHandler {
    protected Socket socket;
    protected final RemoteVMServerThread server;
    protected final Thread connectionThread;
    protected DataInputStream in;
    protected DataOutputStream out;
    static boolean LINUX_1_3 = "linux".equalsIgnoreCase(System.getProperty("os.name")) && System.getProperty("java.version", "").startsWith("1.3");
    private Map expressionProcessors = new HashMap();
    protected static final int NOT_A_PRIMITIVE = -1;
    protected static final int SEND_AS_IS = -2;
    public static final int CLASS_ADDED = 1;
    public static final int OBJECT_ADDED = 2;

    public ConnectionHandler(Socket sc, RemoteVMServerThread svr, Thread connectionThread) {
        this.socket = sc;
        this.server = svr;
        this.connectionThread = connectionThread;
        Integer bufSize = Integer.getInteger("proxyvm.bufsize");
        if (bufSize == null) {
            bufSize = new Integer(5000);
        }
        try {
            this.out = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream(), bufSize));
            this.in = new DataInputStream(new BufferedInputStream(this.socket.getInputStream(), bufSize));
        }
        catch (IOException iOException) {}
    }

    public boolean isConnected() {
        return this.socket != null;
    }

    public void close() {
        if (this.socket != null) {
            try {
                Socket s = this.socket;
                this.socket = null;
                s.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * Exception decompiling
     */
    public Object run() throws CommandException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [6 : 468->474)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void processExpressionCommand(Commands.ValueObject valueObject, InvokableValueSender valueSender) throws IOException, CommandException {
        Integer expressionID = new Integer(this.in.readInt());
        byte cmdType = this.in.readByte();
        ExpressionProcesserController exp = null;
        switch (cmdType) {
            case 0: {
                byte trace = this.in.readByte();
                exp = trace == -1 ? new ExpressionProcesserController(this.server, this) : new ExpressionProcesserController(this.server, this, trace == 1);
                this.expressionProcessors.put(expressionID, exp);
                break;
            }
            case 5: {
                exp = (ExpressionProcesserController)this.expressionProcessors.remove(expressionID);
                this.sendObject(exp, -1, valueObject, this.out, true);
                break;
            }
            case 6: {
                Commands.readValue((DataInputStream)this.in, (Commands.ValueObject)valueObject);
                exp = (ExpressionProcesserController)this.getInvokableObject(valueObject);
                this.expressionProcessors.put(expressionID, exp);
                break;
            }
            case 1: {
                exp = (ExpressionProcesserController)this.expressionProcessors.get(expressionID);
                exp.process(this.in);
                break;
            }
            case 3: {
                boolean haveProxies = this.in.readBoolean();
                if (haveProxies) {
                    Commands.readValue((DataInputStream)this.in, (Commands.ValueObject)valueObject);
                    valueSender.initialize(valueObject);
                    Commands.readArray((DataInputStream)this.in, (int)valueObject.anInt, (Commands.ValueSender)valueSender, (Commands.ValueObject)valueObject, (boolean)false);
                }
                exp = (ExpressionProcesserController)this.expressionProcessors.get(expressionID);
                if (haveProxies) {
                    this.sendExpressionProxyResolutions(valueObject, (int[])valueSender.getArray(), exp);
                }
                if (exp.noErrors()) {
                    valueObject.set(true);
                    Commands.writeValue((DataOutputStream)this.out, (Commands.ValueObject)valueObject, (boolean)true, (boolean)true);
                    break;
                }
                this.processExpressionError(exp, valueObject);
                break;
            }
            case 4: {
                boolean haveProxies = this.in.readBoolean();
                if (haveProxies) {
                    Commands.readValue((DataInputStream)this.in, (Commands.ValueObject)valueObject);
                    valueSender.initialize(valueObject);
                    Commands.readArray((DataInputStream)this.in, (int)valueObject.anInt, (Commands.ValueSender)valueSender, (Commands.ValueObject)valueObject, (boolean)false);
                }
                exp = (ExpressionProcesserController)this.expressionProcessors.get(expressionID);
                if (haveProxies) {
                    this.sendExpressionProxyResolutions(valueObject, (int[])valueSender.getArray(), exp);
                }
                if (exp.noErrors()) {
                    try {
                        Object[] pulledValue = exp.pullValue();
                        if (((Class)pulledValue[1]).isPrimitive()) {
                            int returnTypeID = this.server.getIdentityID(pulledValue[1]);
                            this.sendObject(pulledValue[0], returnTypeID, valueObject, this.out, true, true);
                            break;
                        }
                        this.sendObject(pulledValue[0], -1, valueObject, this.out, true, true);
                    }
                    catch (NoExpressionValueException noExpressionValueException) {
                        this.sendNoValueErrorCommand(exp, valueObject);
                    }
                    break;
                }
                this.processExpressionError(exp, valueObject);
                break;
            }
            case 2: {
                exp = (ExpressionProcesserController)this.expressionProcessors.remove(expressionID);
                exp.close();
            }
        }
    }

    private void sendExpressionProxyResolutions(Commands.ValueObject valueObject, int[] proxyIDs, ExpressionProcesserController exp) throws CommandException {
        class ExpressionProxyRetriever
        implements Commands.ValueRetrieve {
            int index;
            Object[] proxyResolution;
            Commands.ValueObject worker;
            final /* synthetic */ ConnectionHandler this$0;
            private final /* synthetic */ int[] val$proxyIDs;
            private final /* synthetic */ ExpressionProcesserController val$exp;

            ExpressionProxyRetriever(ConnectionHandler connectionHandler, int[] nArray, ExpressionProcesserController expressionProcesserController) {
                this.this$0 = connectionHandler;
                this.val$proxyIDs = nArray;
                this.val$exp = expressionProcesserController;
                this.index = 0;
                this.proxyResolution = new Object[2];
                this.worker = new Commands.ValueObject();
            }

            public Commands.ValueObject nextValue() {
                int proxyID;
                if (this.val$exp.pullExpressionProxyValue(proxyID = this.val$proxyIDs[this.index++], this.proxyResolution)) {
                    if (this.proxyResolution[1] != Void.TYPE) {
                        if (((Class)this.proxyResolution[1]).isPrimitive()) {
                            int returnTypeID = this.this$0.server.getIdentityID(this.proxyResolution[1]);
                            this.this$0.fillInValue(this.proxyResolution[0], returnTypeID, this.worker);
                        } else {
                            this.this$0.fillInValue(this.proxyResolution[0], -1, this.worker);
                        }
                    } else {
                        this.worker.setFlag(0);
                    }
                } else {
                    this.worker.setFlag(1);
                }
                return this.worker;
            }
        }
        valueObject.setArrayIDS((Commands.ValueRetrieve)new ExpressionProxyRetriever(this, proxyIDs, exp), proxyIDs.length, 23);
        Commands.writeValue((DataOutputStream)this.out, (Commands.ValueObject)valueObject, (boolean)true, (boolean)false);
    }

    private void processExpressionError(ExpressionProcesserController exp, Commands.ValueObject valueObject) throws CommandException {
        if (exp.isNoExpressionValue()) {
            this.sendNoValueErrorCommand(exp, valueObject);
        } else {
            this.sendException(exp.getErrorThrowable(), valueObject, this.out);
        }
    }

    private void sendNoValueErrorCommand(ExpressionProcesserController exp, Commands.ValueObject valueObject) throws CommandException {
        this.setExceptionIntoValue(exp.getErrorThrowable(), valueObject);
        Commands.sendErrorCommand((DataOutputStream)this.out, (int)9, (Commands.ValueObject)valueObject);
    }

    public int fillInValue(Object object, int primitiveTypeID, Commands.ValueObject valueObject) {
        int added = 0;
        if (object == null) {
            valueObject.set();
        } else {
            int classID = 0;
            if (primitiveTypeID != -1 && primitiveTypeID != -2) {
                classID = primitiveTypeID;
                switch (classID) {
                    case 1: {
                        valueObject.set(((Boolean)object).booleanValue());
                        break;
                    }
                    case 3: {
                        if (object instanceof Character) {
                            valueObject.set((int)((Character)object).charValue());
                            break;
                        }
                        valueObject.set(((Number)object).intValue());
                        break;
                    }
                    case 5: {
                        valueObject.set(((Number)object).byteValue());
                        break;
                    }
                    case 7: {
                        valueObject.set(((Character)object).charValue());
                        break;
                    }
                    case 9: {
                        if (object instanceof Character) {
                            valueObject.set((double)((Character)object).charValue());
                            break;
                        }
                        valueObject.set(((Number)object).doubleValue());
                        break;
                    }
                    case 11: {
                        if (object instanceof Character) {
                            valueObject.set((float)((Character)object).charValue());
                            break;
                        }
                        valueObject.set(((Number)object).floatValue());
                        break;
                    }
                    case 13: {
                        valueObject.set(((Number)object).shortValue());
                        break;
                    }
                    case 15: {
                        if (object instanceof Character) {
                            valueObject.set((long)((Character)object).charValue());
                            break;
                        }
                        valueObject.set(((Number)object).longValue());
                    }
                }
            } else {
                boolean addObject = false;
                boolean addClass = false;
                Class<?> objClass = object.getClass();
                classID = this.server.getIdentityID(objClass);
                if (classID == RemoteVMServerThread.ID_NOT_FOUND) {
                    Commands.ValueObject classValue = new Commands.ValueObject();
                    addClass = this.server.getIdentityID(objClass, classValue);
                    if (addClass) {
                        added |= 1;
                    }
                    classID = classValue.objectID;
                }
                switch (classID) {
                    case 6: {
                        valueObject.set((Byte)object);
                        break;
                    }
                    case 8: {
                        valueObject.set((Character)object);
                        break;
                    }
                    case 10: {
                        valueObject.set((Double)object);
                        break;
                    }
                    case 12: {
                        valueObject.set((Float)object);
                        break;
                    }
                    case 4: {
                        valueObject.set((Integer)object);
                        break;
                    }
                    case 16: {
                        valueObject.set((Long)object);
                        break;
                    }
                    case 14: {
                        valueObject.set((Short)object);
                        break;
                    }
                    case 2: {
                        valueObject.set((Boolean)object);
                        break;
                    }
                    case 17: {
                        valueObject.set((String)object);
                        break;
                    }
                    case 18: {
                        valueObject.set(object, 18);
                        break;
                    }
                    case 19: {
                        valueObject.set(object, 19);
                        break;
                    }
                    default: {
                        if (primitiveTypeID != -2) {
                            addObject = this.server.getIdentityID(object, valueObject);
                            if (addObject) {
                                added |= 2;
                                valueObject.setObjectID(valueObject.objectID, classID);
                                break;
                            }
                            valueObject.setObjectID(valueObject.objectID);
                            break;
                        }
                        valueObject.set(object, classID);
                    }
                }
            }
        }
        return added;
    }

    public void sendObject(Object object, int primitiveTypeID, Commands.ValueObject valueObject, DataOutputStream out, boolean writeAsCommand) throws CommandException {
        this.sendObject(object, primitiveTypeID, valueObject, out, writeAsCommand, writeAsCommand);
    }

    /*
     * Exception decompiling
     */
    public void sendObject(Object object, int primitiveTypeID, Commands.ValueObject valueObject, DataOutputStream out, boolean writeAsCommand, boolean flush) throws CommandException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 81->85)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void sendException(Throwable e, Commands.ValueObject value, DataOutputStream out) throws CommandException {
        this.setExceptionIntoValue(e, value);
        Commands.sendErrorCommand((DataOutputStream)out, (int)6, (Commands.ValueObject)value);
    }

    public void setExceptionIntoValue(Throwable e, Commands.ValueObject value) {
        this.server.getIdentityID(e, value);
        int eID = value.objectID;
        Class<?> eClass = e.getClass();
        this.server.getIdentityID(eClass, value);
        int eClassID = value.objectID;
        value.setException(eID, eClassID);
    }

    public Object getInvokableObject(Commands.ValueObject value) {
        switch (value.type) {
            case 50: 
            case 51: {
                return this.server.getObject(value.objectID);
            }
        }
        return value.getAsObject();
    }

    private class ArrayContentsRetriever
    implements Commands.ValueRetrieve {
        int index = 0;
        Object array;
        int length;
        int componentType;
        Commands.ValueObject worker = new Commands.ValueObject();

        public ArrayContentsRetriever(Object anArray) {
            this.array = anArray;
            this.length = Array.getLength(anArray);
            this.componentType = anArray.getClass().getComponentType().isPrimitive() ? ConnectionHandler.this.server.getIdentityID(anArray.getClass().getComponentType()) : -1;
        }

        public Commands.ValueObject nextValue() {
            ConnectionHandler.this.fillInValue(Array.get(this.array, this.index++), this.componentType, this.worker);
            return this.worker;
        }
    }

    private class InvokableValueSender
    implements Commands.ValueSender {
        int index = 0;
        Object array;

        public InvokableValueSender() {
        }

        public InvokableValueSender(Commands.ValueObject arrayHeader) {
            this.initialize(arrayHeader);
        }

        public void initialize(Commands.ValueObject arrayHeader) {
            this.index = 0;
            Class arrayType = (Class)ConnectionHandler.this.server.getObject(arrayHeader.classID);
            this.array = Array.newInstance(arrayType, arrayHeader.anInt);
        }

        public void clear() {
            this.array = null;
            this.index = 0;
        }

        public Object getArray() {
            return this.array;
        }

        public void sendValue(Commands.ValueObject value) {
            Array.set(this.array, this.index++, ConnectionHandler.this.getInvokableObject(value));
        }

        public Commands.ValueSender nestedArray(Commands.ValueObject arrayHeader) {
            InvokableValueSender sender = new InvokableValueSender(arrayHeader);
            Array.set(this.array, this.index++, sender.getArray());
            return sender;
        }
    }
}

