/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.internal.proxy.common.CommandException;
import org.eclipse.jem.internal.proxy.common.remote.Commands;
import org.eclipse.jem.internal.proxy.common.remote.IOCommandException;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;

public class REMCallbackInputStream
extends InputStream {
    protected DataInputStream fIn;
    protected DataOutputStream fOut;
    protected byte[] fBuffer;
    protected int fNextByte = 0;
    protected int fLastByte = 0;

    public REMCallbackInputStream(DataInputStream in, DataOutputStream out) {
        this.fIn = in;
        this.fOut = out;
        Integer bufSize = Integer.getInteger("proxyvm.bufsize");
        if (bufSize == null) {
            bufSize = new Integer(16000);
        }
        this.fBuffer = new byte[bufSize.intValue()];
    }

    protected void clearStream() {
        this.fIn = null;
        this.fOut = null;
        this.fBuffer = null;
    }

    protected void fillBuffer() throws IOException {
        if (this.fIn == null) {
            throw new InterruptedIOException();
        }
        try {
            if (this.fLastByte != -1) {
                this.fLastByte = Commands.readBytes((DataInputStream)this.fIn, (byte[])this.fBuffer);
                this.fNextByte = this.fLastByte != -1 ? 0 : -1;
            }
        }
        catch (CommandException e) {
            try {
                this.close(false);
            }
            catch (IOException e1) {
                ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e1));
            }
            throw new IOCommandException(e);
        }
    }

    public int read() throws IOException {
        if (this.fNextByte >= this.fLastByte) {
            this.fillBuffer();
        }
        if (this.fLastByte == -1) {
            return -1;
        }
        return this.fBuffer[this.fNextByte++] & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int read = 0;
        while (len > 0) {
            if (this.fNextByte >= this.fLastByte) {
                this.fillBuffer();
            }
            if (this.fLastByte == -1) {
                return read != 0 ? read : -1;
            }
            int move = this.fLastByte - this.fNextByte;
            if (move > len) {
                move = len;
            }
            System.arraycopy(this.fBuffer, this.fNextByte, b, off, move);
            read += move;
            this.fNextByte += move;
            off += move;
            len -= move;
        }
        return read;
    }

    public int available() throws IOException {
        return this.fLastByte != -1 ? this.fLastByte - this.fNextByte : 0;
    }

    public void close() throws IOException {
        this.close(true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void close(boolean wait) throws IOException {
        if (this.fOut == null) {
            return;
        }
        try {
            this.fOut.writeByte(-4);
            this.fOut.flush();
            this.fOut = null;
            if (wait) {
                while (this.read() != -1) {
                }
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.clearStream();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.clearStream();
            return;
        }
    }
}

