/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.instantiation.base;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.BasicEObjectImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.impl.EStructuralFeatureImpl;
import org.eclipse.jem.internal.instantiation.JavaAllocation;
import org.eclipse.jem.internal.instantiation.base.FeatureValueProvider;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jem.java.JavaHelpers;

public abstract class JavaInstance
extends EObjectImpl
implements IJavaInstance {
    private static final Object NIL = EStructuralFeatureImpl.InternalSettingDelegateSingle.NIL;

    public JavaHelpers getJavaType() {
        return (JavaHelpers)this.eClass();
    }

    public JavaAllocation getAllocation() {
        return this.isSetAllocation() ? (JavaAllocation)this.eGet((EStructuralFeature)JavaInstantiation.getAllocationFeature(this)) : null;
    }

    public Object visitSetFeatures(FeatureValueProvider.Visitor aVisitor) {
        JavaInstancePropertiesHolder settings;
        Object[] setPropertyValues;
        Object result = null;
        if (this.eHasSettings() && (setPropertyValues = (settings = (JavaInstancePropertiesHolder)this.eProperties()).eSettings()) != null) {
            EList allFeatures = settings.getAllStructuralFeatures();
            int i = 0;
            while (i < setPropertyValues.length) {
                Object propertyValue = setPropertyValues[i];
                if (propertyValue != null) {
                    if (propertyValue == NIL) {
                        propertyValue = null;
                    }
                    if ((result = aVisitor.isSet((EStructuralFeature)allFeatures.get(i), propertyValue)) != null) break;
                }
                ++i;
            }
        }
        return result;
    }

    public boolean isAnyFeatureSet() {
        JavaInstancePropertiesHolder settings;
        Object[] setPropertyValues;
        if (this.eHasSettings() && (setPropertyValues = (settings = (JavaInstancePropertiesHolder)this.eProperties()).eSettings()) != null) {
            int i = 0;
            while (i < setPropertyValues.length) {
                Object propertyValue = setPropertyValues[i];
                if (propertyValue != null) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean isSetAllocation() {
        EReference allocationFeature = JavaInstantiation.getAllocationFeature(this);
        return allocationFeature != null && this.eIsSet((EStructuralFeature)allocationFeature);
    }

    public void setAllocation(JavaAllocation allocation) {
        EReference allocationFeature = JavaInstantiation.getAllocationFeature(this);
        if (allocationFeature != null) {
            this.eSet((EStructuralFeature)allocationFeature, allocation);
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.getClass().getName());
        result.append('@');
        result.append(Integer.toHexString(this.hashCode()));
        if (this.eIsProxy()) {
            result.append(" (eProxyURI: ");
            result.append(this.eProxyURI());
            result.append(')');
        }
        if (this.getJavaType() != null) {
            result.append('{');
            result.append(this.getJavaType().getQualifiedName());
            result.append('}');
        }
        try {
            JavaAllocation allocation = this.getAllocation();
            if (allocation != null) {
                result.append(':');
                result.append(allocation.toString());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NullPointerException nullPointerException) {}
        return result.toString();
    }

    protected BasicEObjectImpl.EPropertiesHolder eProperties() {
        if (this.eProperties == null) {
            this.eProperties = new JavaInstancePropertiesHolder();
        }
        return this.eProperties;
    }

    public void eSetClass(EClass eClass) {
        super.eSetClass(eClass);
        this.migrate();
    }

    protected void migrate() {
        if (this.eProperties != null && (this.eProperties.hasSettings() || this.eProperties.getEContents() != null || this.eProperties.getECrossReferences() != null)) {
            JavaInstancePropertiesHolder properties = (JavaInstancePropertiesHolder)this.eProperties;
            EList oldAllFeatures = properties.getAllStructuralFeatures();
            if (properties.getEClass().getEAllStructuralFeatures() == oldAllFeatures) {
                return;
            }
            Object[] oldSettings = properties.eSettings();
            properties.clearCache();
            if (oldSettings == null) {
                return;
            }
            this.eSettings();
            Object[] newSettings = properties.eSettings();
            int staticFeatureCnt = this.eStaticFeatureCount();
            int oldIndex = 0;
            while (oldIndex < oldSettings.length) {
                if (oldSettings[oldIndex] != null) {
                    EStructuralFeature sf = (EStructuralFeature)oldAllFeatures.get(oldIndex + staticFeatureCnt);
                    int newIndex = super.eDynamicFeatureID(sf);
                    if (newIndex > -1) {
                        this.moveESetting(oldSettings, newSettings, oldIndex, sf, newIndex);
                    } else {
                        EStructuralFeature newSF = properties.getEClass().getEStructuralFeature(sf.getName());
                        if (newSF != null && newSF.getClass().equals(sf.getClass()) && newSF.isMany() == sf.isMany() && newSF.isChangeable() == sf.isChangeable()) {
                            boolean compatible;
                            boolean bl = compatible = newSF.isUnique() == sf.isUnique() || !newSF.isUnique();
                            if (newSF instanceof EReference) {
                                EReference newRef = (EReference)newSF;
                                EReference ref = (EReference)sf;
                                compatible = newRef.isContainment() == ref.isContainment() && newRef.getEReferenceType().isSuperTypeOf(ref.getEReferenceType());
                            } else {
                                compatible = newSF.getEType().equals(sf.getEType());
                            }
                            if (compatible) {
                                newIndex = this.eDynamicFeatureID(newSF);
                                this.moveESetting(oldSettings, newSettings, oldIndex, newSF, newIndex);
                            }
                        }
                    }
                }
                ++oldIndex;
            }
        }
    }

    private void moveESetting(Object[] oldSettings, Object[] newSettings, int oldIndex, EStructuralFeature sf, int newIndex) {
        if (!sf.isMany()) {
            newSettings[newIndex] = oldSettings[oldIndex];
        } else {
            BasicEList newMany = (BasicEList)this.eGet(sf);
            BasicEList oldMany = (BasicEList)oldSettings[oldIndex];
            newMany.setData(oldMany.size(), oldMany.data());
        }
    }

    protected int eDynamicFeatureID(EStructuralFeature eStructuralFeature) {
        this.migrate();
        return super.eDynamicFeatureID(eStructuralFeature);
    }

    public EList eContents() {
        this.migrate();
        return super.eContents();
    }

    public EList eCrossReferences() {
        this.migrate();
        return super.eCrossReferences();
    }

    protected static class JavaInstancePropertiesHolder
    extends BasicEObjectImpl.EPropertiesHolderImpl {
        private EList allStructuralFeatures;

        public Object[] eSettings() {
            return this.eSettings;
        }

        public EList getAllStructuralFeatures() {
            return this.allStructuralFeatures;
        }

        public void clearCache() {
            this.eSettings = null;
            this.setEContents(null);
            this.setECrossReferences(null);
            this.allStructuralFeatures = null;
        }

        public void allocateSettings(int maximumDynamicFeatureID) {
            if (this.allStructuralFeatures == null) {
                this.allStructuralFeatures = this.getEClass().getEAllStructuralFeatures();
            }
            super.allocateSettings(maximumDynamicFeatureID);
        }

        public void setEContents(EList eContents) {
            if (this.allStructuralFeatures == null) {
                this.allStructuralFeatures = this.getEClass().getEAllStructuralFeatures();
            }
            super.setEContents(eContents);
        }

        public void setECrossReferences(EList eCrossReferences) {
            if (this.allStructuralFeatures == null) {
                this.allStructuralFeatures = this.getEClass().getEAllStructuralFeatures();
            }
            super.setECrossReferences(eCrossReferences);
        }
    }
}

