/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.adapters.jdom;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jem.internal.adapters.jdom.JDOMAdaptor;
import org.eclipse.jem.internal.java.adapters.nls.ResourceHandler;

public class JDOMSearchHelper {
    private static final String RESOLVED_NAME = " :: RESOLVED_NAME :: ";
    private static final String PERIOD = ".";
    private static final String BOOLEAN = "boolean";
    private static final String BYTE = "byte";
    private static final String CHAR = "char";
    private static final String SHORT = "short";
    private static final String INT = "int";
    private static final String LONG = "long";
    private static final String FLOAT = "float";
    private static final String DOUBLE = "double";
    private static final String VOID = "void";

    private static String[][] getTypeNameInfo(IType type, String simpleName, boolean isForReflection) throws JavaModelException {
        String[][] result = null;
        String typeName = simpleName;
        if (type != null) {
            int index;
            if (isForReflection) {
                typeName = typeName.replace('.', '$');
            }
            if ((index = typeName.indexOf("$")) > 0) {
                String declaringName = typeName.substring(0, index);
                result = type.resolveType(declaringName);
                if (result != null) {
                    if (isForReflection) {
                        result[0][1] = result[0][1].replace('.', '$');
                    }
                    String[] stringArray = result[0];
                    stringArray[1] = String.valueOf(stringArray[1]) + typeName.substring(index, typeName.length());
                }
            } else {
                index = typeName.indexOf("[");
                if (index > 0) {
                    String declaringName = typeName.substring(0, index);
                    result = type.resolveType(declaringName);
                    if (result != null) {
                        result[0][1] = String.valueOf(result[0][1]) + typeName.substring(index);
                    }
                } else {
                    result = type.resolveType(typeName);
                }
            }
        }
        return result;
    }

    public static final boolean isPrimitive(String type) {
        return BOOLEAN.equals(type) || INT.equals(type) || CHAR.equals(type) || SHORT.equals(type) || LONG.equals(type) || FLOAT.equals(type) || DOUBLE.equals(type) || BYTE.equals(type);
    }

    public static final boolean isPrimitiveOrVoid(String type) {
        return JDOMSearchHelper.isPrimitive(type) || JDOMSearchHelper.isVoid(type);
    }

    public static final boolean isVoid(String type) {
        return VOID.equals(type);
    }

    public static boolean matchTypeSignatures(IType type, String signature1, String signature2) throws JavaModelException {
        return JDOMSearchHelper.matchTypeSignatures(type, signature1, signature2, null);
    }

    public static boolean matchTypeSignatures(IType type, String signature1, String signature2, Map resolvedNameCache) throws JavaModelException {
        boolean result = false;
        String sig1 = signature1;
        String sig2 = signature2;
        if (Signature.getArrayCount((String)sig1) == Signature.getArrayCount((String)sig2)) {
            sig1 = Signature.getElementType((String)sig1);
            sig2 = Signature.getElementType((String)sig2);
            if (!(sig1.indexOf(46) == -1 ^ sig2.indexOf(46) == -1)) {
                result = Signature.toString((String)sig1).equals(Signature.toString((String)sig2));
            } else if (!(sig1.charAt(0) != 'Q' && sig1.charAt(0) != 'L' || sig2.charAt(0) != 'Q' && sig2.charAt(0) != 'L')) {
                String qualifiedName = null;
                String simpleName = null;
                if (sig1.indexOf(46) == -1) {
                    qualifiedName = Signature.toString((String)sig2);
                    simpleName = Signature.toString((String)sig1);
                } else {
                    qualifiedName = Signature.toString((String)sig1);
                    simpleName = Signature.toString((String)sig2);
                }
                result = qualifiedName.equals(JDOMSearchHelper.resolveSimpleTypeName(type, simpleName, resolvedNameCache));
            }
        }
        return result;
    }

    private static boolean needsToResolveName(IType type, String simpleName, boolean isForReflection) {
        return !type.isBinary() && (isForReflection || simpleName.indexOf(PERIOD) <= -1) && !JDOMSearchHelper.isPrimitiveOrVoid(simpleName);
    }

    public static String resolveSimpleTypeName(IType type, String simpleName) throws JavaModelException {
        return JDOMSearchHelper.resolveSimpleTypeName(type, simpleName, null);
    }

    public static String resolveSimpleTypeName(IType type, String simpleName, Map resolvedNameCache) throws JavaModelException {
        return JDOMSearchHelper.resolveSimpleTypeName(type, simpleName, resolvedNameCache, false);
    }

    public static String resolveSimpleTypeName(IType type, String simpleName, Map resolvedNameCache, boolean isForReflection) throws JavaModelException {
        if (!JDOMSearchHelper.needsToResolveName(type, simpleName, isForReflection)) {
            return simpleName;
        }
        String key = null;
        String qualifiedName = null;
        if (resolvedNameCache != null) {
            key = String.valueOf(type.getFullyQualifiedName()) + RESOLVED_NAME + simpleName;
            qualifiedName = (String)resolvedNameCache.get(key);
        }
        if (qualifiedName == null) {
            String[][] result = JDOMSearchHelper.getTypeNameInfo(type, simpleName, isForReflection);
            if (result != null) {
                String packName = result[0][0];
                if (packName.length() == 0) {
                    qualifiedName = result[0][1];
                    if (isForReflection) {
                        qualifiedName = qualifiedName.replace('.', '$');
                    }
                } else {
                    StringBuffer b = new StringBuffer();
                    b.append(result[0][0]).append(PERIOD);
                    String typeName = result[0][1];
                    if (isForReflection) {
                        typeName = typeName.replace('.', '$');
                    }
                    b.append(typeName);
                    qualifiedName = b.toString();
                }
            } else {
                qualifiedName = simpleName;
            }
            if (resolvedNameCache != null) {
                resolvedNameCache.put(key, qualifiedName);
            }
        }
        return qualifiedName;
    }

    public static IMethod searchForMatchingMethod(IType type, String methodName, String[] parmSigs) throws JavaModelException {
        return JDOMSearchHelper.searchForMatchingMethod(type, methodName, parmSigs, null);
    }

    public static IMethod searchForMatchingMethod(IType type, String methodName, String[] parmSigs, Map resolvedNameCache) throws JavaModelException {
        IMethod[] allMethods = type.getMethods();
        ArrayList<IMethod> candidateMethods = new ArrayList<IMethod>();
        int i = 0;
        while (i < allMethods.length) {
            int parmSigsLength;
            int n = parmSigsLength = parmSigs != null ? parmSigs.length : 0;
            if (allMethods[i].getElementName().equals(methodName) && allMethods[i].getNumberOfParameters() == parmSigsLength) {
                candidateMethods.add(allMethods[i]);
            }
            ++i;
        }
        IMethod next = null;
        String[] nextParmSigs = null;
        boolean found = false;
        Iterator candidateIter = candidateMethods.iterator();
        while (!found && candidateIter.hasNext()) {
            next = (IMethod)candidateIter.next();
            nextParmSigs = next.getParameterTypes();
            found = true;
            int i2 = 0;
            while (found && i2 < nextParmSigs.length) {
                found &= JDOMSearchHelper.matchTypeSignatures(type, parmSigs[i2], nextParmSigs[i2], resolvedNameCache);
                ++i2;
            }
        }
        return found ? next : null;
    }

    protected static Object[] findActualJavaElement(String qualifiedName, IJavaProject javaProject, JDOMAdaptor adaptor) {
        Object[] result = new Object[2];
        result[1] = adaptor == null ? qualifiedName : JDOMSearchHelper.getResolvedTypeName(qualifiedName, adaptor.getType(), adaptor.getTypeResolutionCache());
        result[0] = JDOMSearchHelper.findJavaElement((String)result[1], javaProject, adaptor);
        if (result[0] == null) {
            JDOMSearchHelper.findInnerJavaElement(result, javaProject, adaptor);
        }
        return result;
    }

    protected static void findInnerJavaElement(Object[] info, IJavaProject javaProject, JDOMAdaptor adaptor) {
        String qualifiedName = (String)info[1];
        int index = qualifiedName.lastIndexOf(PERIOD);
        if (index > 0) {
            String innerName = qualifiedName.substring(0, index);
            innerName = String.valueOf(innerName) + "$";
            innerName = String.valueOf(innerName) + qualifiedName.substring(index + 1, qualifiedName.length());
            if (adaptor != null) {
                innerName = JDOMSearchHelper.getResolvedTypeName(innerName, adaptor.getType(), adaptor.getTypeResolutionCache());
            }
            info[1] = innerName;
            info[0] = JDOMSearchHelper.findJavaElement(innerName, javaProject, adaptor);
            if (info[0] == null) {
                JDOMSearchHelper.findInnerJavaElement(info, javaProject, adaptor);
            }
        }
    }

    protected static IJavaElement findJavaElement(String qualifiedName, IJavaProject javaProject, JDOMAdaptor adaptor) {
        try {
            if (javaProject != null) {
                return javaProject.findElement(JDOMSearchHelper.getPathFromQualifiedName(qualifiedName));
            }
        }
        catch (JavaModelException jme) {
            System.out.println(ResourceHandler.getString((String)"Error_Looking_Up_Type_ERROR_", (Object[])new Object[]{qualifiedName, jme.getMessage()}));
        }
        return null;
    }

    protected static IPath getPathFromQualifiedName(String qualifiedName) {
        return new Path(String.valueOf(qualifiedName.replace('.', File.separatorChar)) + ".java");
    }

    public static String getResolvedTypeName(String typeName, IType declaringType, Map typeCache) {
        String name = typeName;
        try {
            name = JDOMSearchHelper.resolveSimpleTypeName(declaringType, typeName, typeCache, true);
        }
        catch (JavaModelException javaModelException) {}
        return name;
    }

    public static IType findType(String qualifiedName, boolean useAdvancedForInners, IJavaProject javaProject, JDOMAdaptor adaptor) {
        try {
            IJavaElement found = null;
            String resolvedName = qualifiedName;
            if (useAdvancedForInners) {
                Object[] result = JDOMSearchHelper.findActualJavaElement(qualifiedName, javaProject, adaptor);
                found = (IJavaElement)result[0];
                resolvedName = (String)result[1];
            } else {
                found = JDOMSearchHelper.findJavaElement(qualifiedName, javaProject, adaptor);
            }
            if (found != null) {
                if (found instanceof IClassFile) {
                    return ((IClassFile)found).getType();
                }
                if (found instanceof ICompilationUnit) {
                    ICompilationUnit foundCU = (ICompilationUnit)found;
                    String cuMainTypeName = foundCU.getElementName();
                    cuMainTypeName = cuMainTypeName.substring(0, cuMainTypeName.length() - 5);
                    return foundCU.getType(cuMainTypeName);
                }
                if (found instanceof IType) {
                    int index = resolvedName.lastIndexOf(36);
                    if (index > -1) {
                        return ((IType)found).getType(resolvedName.substring(index + 1, resolvedName.length()));
                    }
                    return (IType)found;
                }
            }
        }
        catch (JavaModelException jme) {
            System.out.println(ResourceHandler.getString((String)"Error_Looking_Up_Type_ERROR_", (Object[])new Object[]{qualifiedName, jme.getMessage()}));
        }
        return null;
    }

    public static IType findType(String packageName, String qualifiedTypeName, IJavaProject javaProject) {
        try {
            if (javaProject != null) {
                return javaProject.findType(packageName, qualifiedTypeName.replace('$', '.'));
            }
        }
        catch (JavaModelException jme) {
            System.out.println(ResourceHandler.getString((String)"Error_Looking_Up_Type_ERROR_", (Object[])new Object[]{String.valueOf(packageName) + PERIOD + qualifiedTypeName, jme.getMessage()}));
        }
        return null;
    }
}

