/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.editorpart;

import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.java.codegen.editorpart.EditorSettings;
import org.eclipse.ve.internal.java.codegen.editorpart.JavaVisualEditorPart;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class PaletteDrawersSetting
implements EditorSettings.ISetting {
    public static final String id = "Settings.Paletted.Drawers";
    JavaVisualEditorPart editor;
    IResource resource;
    QualifiedName name;
    EditDomain domain;
    EditPart paletteRootEditPart = null;
    PaletteRoot paletteRootModel = null;

    public PaletteDrawersSetting(EditDomain d, PaletteRoot mr) {
        this.domain = d;
        this.paletteRootModel = mr;
    }

    protected EditPart getEditPartRoot() {
        if (this.paletteRootEditPart != null) {
            return this.paletteRootEditPart;
        }
        PaletteViewer v = this.domain.getPaletteViewer();
        if (v != null) {
            this.paletteRootEditPart = (EditPart)v.getEditPartRegistry().get(this.getModelRoot());
        }
        return this.paletteRootEditPart;
    }

    protected PaletteRoot getModelRoot() {
        if (this.paletteRootModel != null) {
            return this.paletteRootModel;
        }
        this.paletteRootModel = this.domain.getPaletteRoot();
        return this.paletteRootModel;
    }

    protected PaletteDrawer getDrawer(String idOrLabel) {
        Iterator iter = this.getModelRoot().getChildren().iterator();
        while (iter.hasNext()) {
            Object elm = iter.next();
            if (!(elm instanceof PaletteDrawer) || !((PaletteDrawer)elm).getLabel().equals(idOrLabel)) continue;
            return (PaletteDrawer)elm;
        }
        return null;
    }

    public void apply() {
        try {
            String val = this.resource.getPersistentProperty(this.name);
            boolean openedOne = false;
            if (val != null) {
                StringTokenizer st = new StringTokenizer(val, ";");
                while (st.hasMoreElements()) {
                    String idOrlabel = st.nextToken();
                    int state = Integer.parseInt(st.nextToken());
                    PaletteDrawer d = this.getDrawer(idOrlabel);
                    if (d == null) continue;
                    d.setInitialState(state);
                    if (state == 1) continue;
                    openedOne = true;
                }
            }
            if (!openedOne) {
                PaletteRoot root = this.getModelRoot();
                PaletteDrawer firstDrawer = null;
                boolean oneOpen = false;
                Iterator iter = root.getChildren().iterator();
                while (iter.hasNext()) {
                    PaletteEntry entry = (PaletteEntry)iter.next();
                    if (!(entry instanceof PaletteDrawer)) continue;
                    PaletteDrawer drawer = (PaletteDrawer)entry;
                    if (firstDrawer == null) {
                        firstDrawer = drawer;
                    }
                    if (drawer.getInitialState() == 1) continue;
                    oneOpen = true;
                    break;
                }
                if (!oneOpen && firstDrawer != null) {
                    firstDrawer.setInitialState(0);
                }
            }
        }
        catch (CoreException e) {
            JavaVEPlugin.log((Throwable)e);
        }
    }

    public void dispose() {
        if (this.getEditPartRoot() != null && this.resource.exists()) {
            StringBuffer sb = new StringBuffer();
            boolean first = true;
            PaletteViewer paletteViewer = (PaletteViewer)this.getEditPartRoot().getViewer();
            List drawers = this.getEditPartRoot().getChildren();
            if (drawers != null) {
                Iterator elements = drawers.iterator();
                while (elements.hasNext()) {
                    EditPart ep = (EditPart)elements.next();
                    Object model = ep.getModel();
                    if (!(model instanceof PaletteDrawer)) continue;
                    PaletteDrawer drawer = (PaletteDrawer)model;
                    if (!first) {
                        sb.append(";");
                    }
                    first = false;
                    if (drawer.getId().length() != 0) {
                        sb.append(drawer.getId());
                    } else {
                        sb.append(drawer.getLabel());
                    }
                    sb.append(";");
                    int state = 1;
                    if (paletteViewer.isExpanded(drawer)) {
                        state = 0;
                    }
                    if (paletteViewer.isPinned(drawer)) {
                        state = 2;
                    }
                    sb.append(state);
                }
            }
            try {
                this.resource.setPersistentProperty(this.name, sb.toString());
            }
            catch (CoreException e) {
                JavaVEPlugin.log((Throwable)e);
            }
        }
    }

    public void setQualifier(String q) {
        this.name = new QualifiedName(q, id);
    }

    public void setEditor(JavaVisualEditorPart e) {
        this.editor = e;
    }

    public void setResource(IResource r) {
        this.resource = r;
    }
}

