/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.editorpart;

import java.util.StringTokenizer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ve.internal.java.codegen.editorpart.EditorSettings;
import org.eclipse.ve.internal.java.codegen.editorpart.JavaVisualEditorPart;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class PropertySheetSetting
implements EditorSettings.ISetting {
    public static final String id = "Settings.PropertySheet";
    JavaVisualEditorPart editor;
    IResource resource;
    QualifiedName name;
    ControlListener listener = null;
    Tree tree;
    int[] width;

    protected void updateWidths() {
        this.width = new int[this.tree.getColumnCount()];
        TreeColumn[] col = this.tree.getColumns();
        int i = 0;
        while (i < col.length) {
            this.width[i] = col[i].getWidth();
            ++i;
        }
        StringBuffer sb = new StringBuffer();
        int i2 = 0;
        while (i2 < this.width.length) {
            if (i2 > 0) {
                sb.append(";");
            }
            sb.append(this.width[i2]);
            ++i2;
        }
        try {
            this.resource.setPersistentProperty(this.name, sb.toString());
        }
        catch (CoreException e) {
            JavaVEPlugin.log((Throwable)e);
        }
    }

    public PropertySheetSetting(Tree t) {
        this.tree = t;
    }

    protected void addListener() {
        if (this.listener == null && !this.tree.isDisposed()) {
            this.listener = new ControlListener(){

                public void controlResized(ControlEvent e) {
                    PropertySheetSetting.this.updateWidths();
                }

                public void controlMoved(ControlEvent e) {
                    PropertySheetSetting.this.updateWidths();
                }
            };
            TreeColumn[] ctls = this.tree.getColumns();
            int i = 0;
            while (i < ctls.length) {
                ctls[i].addControlListener(this.listener);
                ++i;
            }
        }
    }

    protected void removeListener() {
        if (this.listener != null && !this.tree.isDisposed()) {
            TreeColumn[] ctls = this.tree.getColumns();
            int i = 0;
            while (i < ctls.length) {
                ctls[i].removeControlListener(this.listener);
                ++i;
            }
            this.listener = null;
        }
    }

    public void apply() {
        try {
            String val = this.resource.getPersistentProperty(this.name);
            TreeColumn[] ctls = this.tree.getColumns();
            if (val != null) {
                StringTokenizer st = new StringTokenizer(val, ";");
                this.width = new int[st.countTokens()];
                int index = 0;
                while (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    this.width[index] = Integer.parseInt(s);
                    if (index < ctls.length) {
                        ctls[index].setWidth(this.width[index]);
                    }
                    ++index;
                }
            }
        }
        catch (CoreException e1) {
            JavaVEPlugin.log((Throwable)e1);
        }
        this.addListener();
    }

    public void dispose() {
        this.removeListener();
    }

    public void setQualifier(String q) {
        this.name = new QualifiedName(q, id);
    }

    public void setEditor(JavaVisualEditorPart e) {
        this.editor = e;
    }

    public void setResource(IResource r) {
        this.resource = r;
    }
}

