/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.editorpart;

import java.util.StringTokenizer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ve.internal.cde.core.CustomSashForm;
import org.eclipse.ve.internal.java.codegen.editorpart.EditorSettings;
import org.eclipse.ve.internal.java.codegen.editorpart.JavaVisualEditorPart;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class SashSetting
implements EditorSettings.ISetting {
    public static final String id = "Settings.Sash";
    JavaVisualEditorPart editor;
    IResource resource;
    QualifiedName name;
    CustomSashForm sash;
    ControlListener listener = null;
    Control listenedControl = null;
    int[] weights;

    protected void updateWeights() {
        this.weights = this.sash.getWeights();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.weights.length) {
            if (i > 0) {
                sb.append(";");
            }
            sb.append(this.weights[i]);
            ++i;
        }
        sb.append(";");
        sb.append(-1);
        sb.append(";");
        sb.append(this.sash.getSavedWeight());
        try {
            this.resource.setPersistentProperty(this.name, sb.toString());
        }
        catch (CoreException e) {
            JavaVEPlugin.log((Throwable)e);
        }
    }

    public SashSetting(CustomSashForm s) {
        this.sash = s;
    }

    protected void addListener() {
        if (this.listener == null && !this.sash.isDisposed()) {
            this.listener = new ControlListener(){

                public void controlResized(ControlEvent e) {
                    SashSetting.this.updateWeights();
                }

                public void controlMoved(ControlEvent e) {
                    SashSetting.this.updateWeights();
                }
            };
            this.listenedControl = this.sash.getChildren()[0];
            this.listenedControl.addControlListener(this.listener);
        }
    }

    protected void removeListener() {
        if (this.listenedControl != null && !this.listenedControl.isDisposed()) {
            this.listenedControl.removeControlListener(this.listener);
            this.listener = null;
            this.listenedControl = null;
        }
    }

    public void apply() {
        try {
            String val = this.resource.getPersistentProperty(this.name);
            if (val != null) {
                StringTokenizer st = new StringTokenizer(val, ";");
                this.weights = new int[st.countTokens()];
                int index = 0;
                while (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    this.weights[index++] = Integer.parseInt(s);
                }
                index = 0;
                while (index < this.weights.length) {
                    if (this.weights[index] < 0) break;
                    ++index;
                }
                int saved = -1;
                if (index < this.weights.length) {
                    int[] w = new int[index];
                    int i = 0;
                    while (i < w.length) {
                        w[i] = this.weights[i];
                        ++i;
                    }
                    saved = this.weights[index + 1];
                    this.weights = w;
                }
                this.sash.setWeights(this.weights);
                if (saved >= 0) {
                    this.sash.setCurrentSavedWeight(saved);
                }
            }
        }
        catch (CoreException e1) {
            JavaVEPlugin.log((Throwable)e1);
        }
        this.addListener();
    }

    public void dispose() {
        this.removeListener();
    }

    public void setQualifier(String q) {
        this.name = new QualifiedName(q, id);
    }

    public void setEditor(JavaVisualEditorPart e) {
        this.editor = e;
    }

    public void setResource(IResource r) {
        this.resource = r;
    }
}

